/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");


var aContenu = new Arbre("Facturation/Preparation_Expedition/list-contenuColis.tmpl", "tContenu");
var aRestant = new Arbre("Facturation/Preparation_Expedition/list-articlesNonColisesPE.tmpl", "tRestant");

var prepId;
var colisId;



function init() {
	try {

		prepId = window.arguments[0];
		colisId = window.arguments[1];
		var numIntraExp = window.arguments[2];

		document.getElementById('titre').value = "Colisage du colis N\u00B0 "+ numIntraExp;

		aContenu.setParam('Colis_Id', colisId);
		aRestant.setParam('Prep_Id', prepId);

		refreshListesGD();

	} catch (e) {
   	recup_erreur(e);
  }
}


function toutAjouter() {
  try {

		var qAdd = new QueryHttp("Facturation/Preparation_Expedition/addAllColis.tmpl");
		qAdd.setParam("Colis_Id", colisId);
		qAdd.setParam("Prep_Id", prepId);
		var result = qAdd.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}

		refreshListesGD();

	} catch (e) {
  	recup_erreur(e);
	}
}


function toutEnlever() {
  try {

		var qRemove = new QueryHttp('Facturation/Preparation_Expedition/removeAllColis.tmpl');
		qRemove.setParam("Colis_Id", colisId);
		var result = qRemove.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}

		refreshListesGD();

	} catch (e) {
  	recup_erreur(e);
	}
}


function ajouter() {
  try {

		if (aRestant.isSelected()) {
			var ligneBL = aRestant.getSelectedCellText('colLigneBLNC');
			var qteRestante = aRestant.getSelectedCellText('colQuantiteNC');
			var quantite = document.getElementById('quantite').value;

			if (isEmpty(quantite) || !checkQte(quantite)) {
				showWarning("Quantit\u00E9 incorrecte");
			}
			else if (parseFloat(qteRestante)-parseFloat(quantite)<0) {
				showWarning("La quantit\u00E9 \u00E0 ajouter d\u00E9passe la quantit\u00E9 non colis\u00E9e");
			}
			else {
				var qAdd = new QueryHttp('Facturation/Preparation_Expedition/addContenuColis.tmpl');
				qAdd.setParam("Colis_Id", colisId);
				qAdd.setParam("Ligne_BL", ligneBL);
				qAdd.setParam("Quantite", quantite);
				var result = qAdd.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}

				refreshListesGD();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function enlever() {
  try {

		if (aContenu.isSelected()) {
			var contenuId = aContenu.getSelectedCellText('colContenuIdCC');
			var qteColis = aContenu.getSelectedCellText('colQuantiteCC');
			var quantite = document.getElementById('quantite').value;

			if (isEmpty(quantite) || !checkQte(quantite)) {
				showWarning("Quantit\u00E9 incorrecte");
			}
			else if (parseFloat(qteColis)-parseFloat(quantite)<0) {
				showWarning("La quantit\u00E9 \u00E0 enlever ne peut d\u00E9passer la quantit\u00E9 pr\u00E9sente dans le colis");
			}
			else {
				var qRemove = new QueryHttp('Facturation/Preparation_Expedition/removeContenuColis.tmpl');
				qRemove.setParam("Colis_Id", colisId);
				qRemove.setParam("Contenu_Id", contenuId);
				qRemove.setParam("Quantite", quantite);
				var result = qRemove.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}

				refreshListesGD();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function selectOnRestant() {
	try {

		if (aRestant.isSelected()) {
			document.getElementById('quantite').value = aRestant.getSelectedCellText('colQuantiteNC');
			document.getElementById('quantite').disabled = false;
			document.getElementById('bAjouter').disabled = false;
			document.getElementById('bEnlever').disabled = true;
			aContenu.clearSelection();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function selectOnContenu()  {
	try {

		if (aContenu.isSelected()) {
			document.getElementById('quantite').value = aContenu.getSelectedCellText('colQuantiteCC');
			document.getElementById('quantite').disabled = false;
			document.getElementById('bAjouter').disabled = true;
			document.getElementById('bEnlever').disabled = false;
			aRestant.clearSelection();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function refreshListesGD() {
	try {

		document.getElementById('bAjouter').disabled = true;
		document.getElementById('bEnlever').disabled = true;
		document.getElementById('quantite').disabled = true;
		document.getElementById('quantite').value = "";

		aRestant.initTree();
		aContenu.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function editerEtiquetteColisage() {
	try {

		var qEdit = new QueryHttp("Facturation/Preparation_Expedition/pdfEtiquetteColisage.tmpl");
		qEdit.setParam("Colis_Id", colisId);

		document.getElementById('deck').selectedIndex = 1;

		var result = qEdit.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			document.getElementById('editionPDF').setAttribute("src", page);
		}

	} catch (e) {
		recup_erreur(e);
	}
}
