/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");


var aBP = new Arbre("Facturation/Preparation_Expedition/list-BPNonPrepa.tmpl", "treeBP");



function init() {
	try {

		var date = getDateCourante();
		document.getElementById("dateDebut").value = date;
		document.getElementById("dateFin").value = date;
		actualiser();

	} catch (e) {
		recup_erreur(e);
	}
}


function valider() {
	try {

		if (aBP.isSelected()) {
			var documentId = aBP.getSelectedCellText('colDocumentId');
			var typeDoc = aBP.getSelectedCellText('colTypeDoc');
			window.arguments[0](documentId, typeDoc);
			window.close();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function reinitialiser() {
	try {

		document.getElementById("dateDebut").value = "";
		document.getElementById("dateFin").value = "";

	} catch (e) {
		recup_erreur(e);
	}
}


function actualiser() {
	try {

		var dateDebut = document.getElementById("dateDebut").value;
		var dateFin = document.getElementById("dateFin").value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte"); }
		else {
			aBP.setParam("Date_Debut", dateDebut);
			aBP.setParam("Date_Fin", dateFin);
			aBP.initTree();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnCritere(ev) {
	try {

		if (ev.keyCode==13) {
			actualiser();
		}

	} catch (e) {
		recup_erreur(e);
	}
}
