/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");


var codeBarre;



function init() {
  try {

		codeBarre = window.arguments[0];
		document.getElementById('codeBarre').value = codeBarre;
		document.getElementById('reference').focus();

  } catch (e) {
    recup_erreur(e);
  }
}


function associerCodeBarre() {
  try {

		var reference = document.getElementById('reference').value;

		if (isEmpty(reference)) {
			showWarning("Veuillez saisir une r\u00E9f\u00E9rence");
		}
		else {
			var qAssign = new QueryHttp("Facturation/Reception/assignCodeBarre.tmpl");
			qAssign.setParam('Reference', reference);
			qAssign.setParam('Code_Barre', codeBarre);

			var result = qAssign.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("Le code barre a \u00E9t\u00E9 associ\u00E9 \u00E0 l'article");
				window.close();
			}
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function pressOnReference(ev) {
	try {

		if (ev.keyCode==13) {
			associerCodeBarre();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function rechercherArticle() {
	try {

		var reference = document.getElementById('reference').value;

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherArticle, "A", reference);

	} catch (e) {
    recup_erreur(e);
  }
}


function retourRechercherArticle(reference, articleId) {
	try {

		document.getElementById('reference').value = reference;

	} catch (e) {
    recup_erreur(e);
  }
}
