/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var orb_aBanques = new Arbre("ComboListe/combo-banques.tmpl", "orb-comboBanques");
var orb_aTypeReg = new Arbre("ComboListe/combo-typesReglement.tmpl", "orb-comboTypeReg");
var orb_aBanquesRemise = new Arbre('ComboListe/combo-banques.tmpl', 'orb-banqueRemise');
var orb_aModesReglement = new Arbre("ComboListe/combo-modesReglement.tmpl", "orb-modeReglement");
var orb_aReglements = new Arbre("Facturation/Remises_Banque/list-reglementARemettre.tmpl", "orb-listeReglements");
var orb_qListRC = new QueryHttp("Facturation/Remises_Banque/getDataListRC.tmpl");
var orb_qMontant = new QueryHttp("Facturation/Remises_Banque/getMontantARemettre.tmpl");

var orb_pageCourante;
var orb_nbPages;

var orb_nf = new NumberFormat("0.00", true);

var orb_tabPieces = new Array();
var orb_tabBillets = new Array();
var orb_listRegRemise = new Array();
var orb_listRemRemise = new Array();

var orb_dateCourante = getDateCourante();
var XUL_NS = "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul";


function orb_init() {
	try {

		document.getElementById('orb-typeRemise').value="A";
		orb_switchInterface();
		orb_aBanques.initTree(orb_initBanque);

	} catch (e) {
		recup_erreur(e);
	}
}


function orb_initBanque() {
	try {

		document.getElementById('orb-comboBanques').selectedIndex = 0;
		orb_aTypeReg.initTree(orb_initTypeReg);

	} catch (e) {
		recup_erreur(e);
	}
}


function orb_initTypeReg() {
	try {

		document.getElementById('orb-comboTypeReg').selectedIndex = 0;
		orb_chargerModesReglement();
		orb_aBanquesRemise.initTree(orb_initBanqueRemise);

	} catch (e) {
		recup_erreur(e);
	}
}


function orb_initBanqueRemise() {
	try {

    document.getElementById('orb-banqueRemise').selectedIndex = 0;
    orb_genererInterfaceEspeces();

	} catch (e) {
    recup_erreur(e);
  }
}


function orb_chargerModesReglement() {
	try {

		orb_aModesReglement.setParam("Type_Reglement", document.getElementById('orb-comboTypeReg').value);
		orb_aModesReglement.initTree(orb_initModeReglement);

	} catch (e) {
    recup_erreur(e);
  }
}


function orb_initModeReglement() {
	try {

		document.getElementById('orb-modeReglement').selectedIndex = 0;
		orb_listerReglements();

	} catch (e) {
		recup_erreur(e);
	}
}


function orb_pressOnCriteres(event) {
	try {

		if (event.keyCode==13) {
			orb_listerReglements();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orb_listerReglements() {
	try {

		var dateReglementDebut = document.getElementById('orb-dateDebutReg').value;
		var dateReglementFin = document.getElementById('orb-dateFinReg').value;
		var typeReglement = document.getElementById('orb-comboTypeReg').value;
		var modeReglement = document.getElementById('orb-modeReglement').value;
		var banqueRemise = document.getElementById('orb-comboBanques').value;
		var remiseAEchoir = document.getElementById('orb-chkAffRemisesAEchoir').checked;
		var nbLignesParPage = document.getElementById('orb-nbLignesParPage').value;

		if (!isEmpty(dateReglementDebut) && !isDate(dateReglementDebut)) { showWarning("Date de d\u00E9but de r\u00E8glement incorrecte"); }
		else if (!isEmpty(dateReglementFin) && !isDate(dateReglementFin)) { showWarning("Date de fin de r\u00E8glement incorrecte"); }
		else if (!isEmpty(dateReglementDebut) && !isEmpty(dateReglementFin) && !isDateInterval(dateReglementDebut, dateReglementFin)) { showWarning("Plage de dates incorrecte"); }
		else {

			orb_pageCourante = 1;
			orb_nbPages = 1;
			document.getElementById('orb-pageDeb').value = 1;
			document.getElementById('orb-pageFin').value = 1;
			document.getElementById('orb-bPrec').disabled = true;
			document.getElementById('orb-bSuiv').disabled = true;

			document.getElementById('orb-listeReglements').disabled = true;

			document.getElementById('orb-dateRemise').value = orb_dateCourante;
			document.getElementById('orb-bValiderRemise').disabled = true;
			document.getElementById("orb-totalRemise").value = "";

			orb_aReglements.deleteTree();

			orb_qListRC.setParam("Type_Reglement", typeReglement);
			orb_qListRC.setParam("Mode_Reglement", modeReglement);
			orb_qListRC.setParam("Banque_Remise", banqueRemise);
			orb_qListRC.setParam("Remise_A_Echoir", remiseAEchoir);
			orb_qListRC.setParam("Date_Reglement_Debut", dateReglementDebut);
			orb_qListRC.setParam("Date_Reglement_Fin", dateReglementFin);
			orb_qListRC.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			orb_qListRC.setParam("Current_Page", orb_pageCourante);

			var result = orb_qListRC.execute();

			var contenu = result.responseXML.documentElement;

			orb_nbPages = contenu.getAttribute("Nb_Pages");
			var listReglementId = contenu.getAttribute("List_Reglement_Id");
			var listRemboursementId = contenu.getAttribute("List_Remboursement_Id");

			orb_aReglements.setParam("List_Reglement_Id", listReglementId);
			orb_aReglements.setParam("List_Remboursement_Id", listRemboursementId);
			orb_aReglements.setParam("List_Reg_Remise", orb_listRegRemise);
			orb_aReglements.setParam("List_Rem_Remise", orb_listRemRemise);

			orb_aReglements.initTree(orb_initPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orb_initPagination() {
	try {

		document.getElementById('orb-pageDeb').value = orb_pageCourante;
		document.getElementById('orb-pageFin').value = (orb_nbPages>0?orb_nbPages:1);
		document.getElementById('orb-bPrec').disabled = (orb_pageCourante==1);
		document.getElementById('orb-bSuiv').disabled = (orb_pageCourante>=orb_nbPages); // peut se produire si orb_nbPages=0

		orb_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function orb_pressOnPagePrec() {
	try {

		orb_pageCourante--;
		orb_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function orb_pressOnPageSuiv() {
	try {

		orb_pageCourante++;
		orb_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function orb_majPagination() {
	try {

		document.getElementById('orb-pageDeb').value = orb_pageCourante;
		document.getElementById('orb-bPrec').disabled = (orb_pageCourante==1);
		document.getElementById('orb-bSuiv').disabled = (orb_pageCourante==orb_nbPages);

		document.getElementById('orb-listeReglements').disabled = true;

		orb_qListRC.setParam("Current_Page", orb_pageCourante);
		var result = orb_qListRC.execute();
		var listReglementId = result.responseXML.documentElement.getAttribute("List_Reglement_Id");
		var listRemboursementId = result.responseXML.documentElement.getAttribute("List_Remboursement_Id");

		orb_aReglements.setParam("List_Reglement_Id", listReglementId);
		orb_aReglements.setParam("List_Remboursement_Id", listRemboursementId);
		orb_aReglements.setParam("List_Reg_Remise", orb_listRegRemise);
		orb_aReglements.setParam("List_Rem_Remise", orb_listRemRemise);
		orb_aReglements.initTree(orb_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function orb_afterMajPagination() {
	try {

		document.getElementById('orb-listeReglements').disabled = false;
		orb_calculTotaux();

	} catch (e) {
		recup_erreur(e);
	}
}


function orb_calculTotaux() {
	try {

		var montantTotal = 0;

		if (orb_listRegRemise.length>0 || orb_listRemRemise.length>0) {
			orb_qMontant.setParam("List_Reg_Remise", orb_listRegRemise);
			orb_qMontant.setParam("List_Rem_Remise", orb_listRemRemise);
			var result = orb_qMontant.execute();

			montantTotal = result.responseXML.documentElement.getAttribute("Montant");
		}

		document.getElementById("orb-totalRemise").value = orb_nf.format(montantTotal);

		if (orb_aReglements.nbLignes()>0 && !isEmpty(document.getElementById('orb-comboBanques').value)) {
			document.getElementById('orb-bValiderRemise').disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orb_toutCocher(b) {
	try {

		for (var i=0; i<orb_aReglements.nbLignes(); i++) {
			orb_aReglements.setCellValue(i, "orb-colSelReglement", b);
			orb_manageListRemise(i);
		}

		orb_calculTotaux();

	} catch (e) {
		recup_erreur(e);
	}
}


function orb_clickOnListeReglements(ev) {
	try {

		var col = orb_aReglements.getClickedCol(ev);

		if (col!=null && col.id=="orb-colSelReglement") {
			var idx = orb_aReglements.getClickedRowIndex(ev);
			orb_manageListRemise(idx);

			// dbut contournement bug HM - Tache redmine 11172
			for (var i=idx-1; i>=idx-10 && i>=0; i--) {
				orb_manageListRemise(i);
			}
			for (var i=idx+1; i<=idx+10 && i<orb_aReglements.nbLignes(); i++) {
				orb_manageListRemise(i);
			}
			// fin contournement bug

			orb_calculTotaux();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orb_resetListRemise() {
	try {

		orb_listRegRemise = new Array();
		orb_listRemRemise = new Array();

	} catch (e) {
    recup_erreur(e);
  }
}


function orb_manageListRemise(idx) {
  try {

		var typeDoc = orb_aReglements.getCellText(idx, "orb-colTypeDoc");
		var documentId = orb_aReglements.getCellText(idx, "orb-colDocumentId");
		var coche = orb_aReglements.getCellValue(idx, "orb-colSelReglement")=="true";
		var list = (typeDoc=="RC"?orb_listRegRemise:orb_listRemRemise);

		var i = 0;
		var trouve = false;
  	while (i<list.length && !trouve) {
			if (list[i]==documentId) {
				trouve = true;
			}
			i++;
		}

		if (!coche && trouve) {
			list.splice(i-1,1);
		}
		else if (coche && !trouve) {
			list.push(documentId);
		}
		list.sort();

  } catch (e) {
    recup_erreur(e);
  }
}


function orb_validerRemise() {
	try {

		if (window.confirm("Confirmez-vous la validation la remise en banque ?")) {

			var dateRemise = document.getElementById('orb-dateRemise').value;
			var banqueRemise = document.getElementById('orb-comboBanques').value;
			var typeReglement = document.getElementById('orb-comboTypeReg').value;

			if (orb_listRegRemise.length==0 && orb_listRemRemise.length==0) { showWarning("Il n'y a aucun r\u00E8glement de cocher"); }
			else if (isEmpty(dateRemise) || !isDate(dateRemise)) { showWarning("Date de remise incorrecte"); }
			else {

				var qValider = new QueryHttp("Facturation/Remises_Banque/validRemiseBanqueStd.tmpl");
				qValider.setParam("List_Reglement_Id", orb_listRegRemise);
				qValider.setParam("List_Remboursement_Id", orb_listRemRemise);
				qValider.setParam("Banque_Remise", banqueRemise);
				qValider.setParam("Type_Reg_Id", typeReglement);
				qValider.setParam("Date_Remise", dateRemise);
				var result = qValider.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					var remiseId = result.responseXML.documentElement.getAttribute("Remise_Id");

					var qGenPdf = new QueryHttp("Facturation/Remises_Banque/pdfRemise.tmpl");
					qGenPdf.setParam('Remise_Id', remiseId);
					result = qGenPdf.execute();
					var page = getDirPdf() + result.responseXML.documentElement.getAttribute('fichier');
					switchPdf(page);

					orb_resetListRemise();
					orb_listerReglements();
					ohr_reinitialiser(); // on met  jour l'onglet des historiques
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orb_switchInterface() {
	try {

		var typeRemise = document.getElementById('orb-typeRemise').value;
		document.getElementById('orb-remiseEspeces').collapsed = (typeRemise!="E");
		document.getElementById('orb-remiseAutres').collapsed = (typeRemise!="A");

	} catch (e) {
		recup_erreur(e);
	}
}


function orb_genererInterfaceEspeces() {
	try {

		var qGet = new QueryHttp("Facturation/Remises_Banque/getMonnaieDevise.tmpl");

		var rowsBillets = document.getElementById('orb-rowsBillets');
		qGet.setParam("Type", "B");
		var result = qGet.execute();
		var lesBillets = result.responseXML.documentElement.getElementsByTagName("monnaie");
		for (var i=0;i<lesBillets.length;i++) {
			var row = orb_creerRow(lesBillets.item(i), 'B');
			rowsBillets.appendChild(row);
		}

		var rowsPieces = document.getElementById('orb-rowsPieces');
		qGet.setParam("Type", "P");
		result = qGet.execute();
		var lesPieces = result.responseXML.documentElement.getElementsByTagName("monnaie");
		for (var i=0;i<lesPieces.length;i++) {
			var row = orb_creerRow(lesPieces.item(i), 'P');
			rowsPieces.appendChild(row);
		}

		document.getElementById('orb-totalBillets').value = "0.00";
		document.getElementById('orb-totalPieces').value = "0.00";
		document.getElementById('orb-totalRemiseEspeces').value = "0.00";
		document.getElementById('orb-dateRemiseEspeces').value = orb_dateCourante;

	} catch (e) {
		recup_erreur(e);
	}
}


function orb_creerRow(result, type) {
	try {

		var monnaieId = result.getAttribute("Monnaie_Id");
		var valeur = result.getAttribute("Valeur");
		var symbole = result.getAttribute("Symbole");
    var qteRemise = result.getAttribute("Qte_Remise");
    var valeurTotale = valeur;

    var idQte = "orb-qte" + monnaieId;
    var idMontant = "orb-mt" + monnaieId;

		var dataEntryNode = document.createElementNS(XUL_NS, "xul:row");
		dataEntryNode.setAttribute("style", "height:30px");
		dataEntryNode.setAttribute("align", "center");
  	var hbox = document.createElementNS(XUL_NS, "xul:hbox");
  	hbox.setAttribute("pack", "center");
  	var label = document.createElementNS(XUL_NS, "xul:label");
  	label.setAttribute("value", nf.format(valeur));
  	hbox.appendChild(label);
  	label = document.createElementNS(XUL_NS, "xul:label");
  	label.setAttribute("value", symbole);
  	hbox.appendChild(label);
  	dataEntryNode.appendChild(hbox);

  	if (type=='P') {
  		valeurTotale *= qteRemise;

  		hbox = document.createElementNS(XUL_NS, "xul:hbox");
    	hbox.setAttribute("pack", "center");
    	label = document.createElementNS(XUL_NS, "xul:label");
    	label.setAttribute("value", qteRemise);
    	hbox.appendChild(label);
    	dataEntryNode.appendChild(hbox);

    	hbox = document.createElementNS(XUL_NS, "xul:hbox");
    	hbox.setAttribute("pack", "center");
    	label = document.createElementNS(XUL_NS, "xul:label");
    	label.setAttribute("value", nf.format(valeurTotale));
    	hbox.appendChild(label);
    	label = document.createElementNS(XUL_NS, "xul:label");
    	label.setAttribute("value", symbole);
    	hbox.appendChild(label);
    	dataEntryNode.appendChild(hbox);
  	}

  	hbox = document.createElementNS(XUL_NS, "xul:hbox");
  	hbox.setAttribute("pack", "center");
  	var textbox = document.createElementNS(XUL_NS, "xul:textbox");
  	textbox.setAttribute("class", "nombre");
  	textbox.setAttribute("maxlength", "4");
  	textbox.setAttribute("size", "15");
  	textbox.setAttribute("value", "0");
  	textbox.setAttribute("id", idQte);
  	textbox.setAttribute("timeout", "200");


  	textbox.setAttribute("oncommand", "orb_calculerMontant('"+ valeurTotale +"', '"+ idQte +"', '"+ idMontant +"')");
  	textbox.setAttribute("type", "timed");
  	hbox.appendChild(textbox);
  	dataEntryNode.appendChild(hbox);

  	hbox = document.createElementNS(XUL_NS, "xul:hbox");
  	hbox.setAttribute("pack", "center");
  	textbox = document.createElementNS(XUL_NS, "xul:textbox");
  	textbox.setAttribute("class", "nombre");
  	textbox.setAttribute("readonly", "true");
  	textbox.setAttribute("size", "15");
  	textbox.setAttribute("value", "0.00");
  	textbox.setAttribute("id", idMontant);
  	hbox.appendChild(textbox);
  	dataEntryNode.appendChild(hbox);

  	if (type=='P') { orb_tabPieces.push(new Array(qteRemise*valeur, monnaieId)); }
  	else { orb_tabBillets.push(new Array(valeur, monnaieId)); }

		return dataEntryNode;

  } catch (e) {
		recup_erreur(e);
  }
}


function orb_calculerMontant(valeur, idSource, idDest) {
	try {

		var qte = document.getElementById(idSource).value;
		var montant = (isPositiveOrNullInteger(qte)?parseIntBis(qte)*parseFloat(valeur):0);
		document.getElementById(idDest).value = orb_nf.format(montant);

		var montantBillets = 0;
		for (var i=0; i<orb_tabBillets.length; i++) {
			var valInter = orb_tabBillets[i][0];
			var qteInter = document.getElementById("orb-qte"+ orb_tabBillets[i][1]).value;
			montantBillets += (isPositiveOrNullInteger(qteInter)?parseIntBis(qteInter)*parseFloat(valInter):0);
		}

		var montantPieces = 0;
		for (var i=0; i<orb_tabPieces.length; i++) {
			var valInter = orb_tabPieces[i][0];
			var qteInter = document.getElementById("orb-qte"+ orb_tabPieces[i][1]).value;
			montantPieces += (isPositiveOrNullInteger(qteInter)?parseIntBis(qteInter)*parseFloat(valInter):0);
		}

		var montantTotal = montantBillets + montantPieces;

		document.getElementById('orb-totalBillets').value = orb_nf.format(montantBillets);
		document.getElementById('orb-totalPieces').value = orb_nf.format(montantPieces);
		document.getElementById('orb-totalRemiseEspeces').value = orb_nf.format(montantTotal);

	} catch (e) {
		recup_erreur(e);
	}
}


function orb_reinitialiserEspeces() {
	try {

		for (var i=0; i<orb_tabBillets.length; i++) {
			document.getElementById("orb-qte"+ orb_tabBillets[i][1]).value = "0";
			document.getElementById("orb-mt"+ orb_tabBillets[i][1]).value = "0.00";
		}
		for (var i=0; i<orb_tabPieces.length; i++) {
			document.getElementById("orb-qte"+ orb_tabPieces[i][1]).value = "0";
			document.getElementById("orb-mt"+ orb_tabPieces[i][1]).value = "0.00";
		}

		document.getElementById('orb-totalBillets').value = "0.00";
		document.getElementById('orb-totalPieces').value = "0.00";
		document.getElementById('orb-totalRemiseEspeces').value = "0.00";

		document.getElementById('orb-banqueRemise').selectedIndex = 0;
		document.getElementById('orb-dateRemiseEspeces').value = orb_dateCourante;
		document.getElementById('orb-bValiderRemiseEspeces').disabled = true;

	} catch (e) {
		recup_erreur(e);
	}
}


function orb_pressOnBanqueRemiseEspeces() {
	try {

		document.getElementById('orb-bValiderRemiseEspeces').disabled = (document.getElementById('orb-banqueRemise').selectedIndex == 0);

	} catch (e) {
		recup_erreur(e);
	}
}


function orb_validerRemiseEspeces() {
	try {

		if (window.confirm("Confirmez-vous la validation de la remise en banque ?")) {

			var banqueRemise = document.getElementById('orb-banqueRemise').value;
			var listeRemiseBillets = "";
			var listeRemisePieces = "";

			var ok = true;
			var totalQte = 0;
			var i=0;
			while (ok && i<orb_tabBillets.length) {
				var qte = document.getElementById("orb-qte"+ orb_tabBillets[i][1]).value;
				if (!isPositiveOrNullInteger(qte)) { ok = false; }
				else if (parseIntBis(qte)>0) {
					listeRemiseBillets += orb_tabBillets[i][1] +";";
					listeRemiseBillets += qte + ",";
					totalQte += parseIntBis(qte);
				}
				i++;
			}
			var i=0;
			while (ok && i<orb_tabPieces.length) {
				var qte = document.getElementById("orb-qte"+ orb_tabPieces[i][1]).value;
				if (!isPositiveOrNullInteger(qte)) { ok = false; }
				else if (parseIntBis(qte)>0) {
					listeRemisePieces += orb_tabPieces[i][1] +";";
					listeRemisePieces += qte + ",";
					totalQte += parseIntBis(qte);
				}
				i++;
			}

			if (!ok) { showWarning("Votre saisie est incorrecte !"); }
			else if (totalQte==0) { showWarning("Le total de la remise doit \u00EAtre sup\u00E9rieur \u00E0 0 !"); }
			else {

				var dateRemise = document.getElementById('orb-dateRemiseEspeces').value;
				if (isEmpty(dateRemise) || !isDate(dateRemise)) { showWarning("La date de remise est incorrecte."); }
				else {

					var qValider = new QueryHttp("Facturation/Remises_Banque/validRemiseBanqueEsp.tmpl");
					qValider.setParam("List_Remise_Billets", listeRemiseBillets);
					qValider.setParam("List_Remise_Pieces", listeRemisePieces);
					qValider.setParam("Banque_Remise", banqueRemise);
					qValider.setParam("Date_Remise", dateRemise);
					var result = qValider.execute();

					var errors = new Errors(result);
					if (errors.hasNext()) {
						errors.show();
					}
					else {
						var remiseId = result.responseXML.documentElement.getAttribute("Remise_Id");

						var qGenPdf = new QueryHttp("Facturation/Remises_Banque/pdfRemise.tmpl");
						qGenPdf.setParam('Especes', 'true');
						qGenPdf.setParam('Remise_Id', remiseId);
						var result = qGenPdf.execute();
						var page = getDirPdf() + result.responseXML.documentElement.getAttribute('fichier');
						switchPdf(page);

						orb_reinitialiserEspeces();
					}
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orb_pressOnListeReglements() {
	try {

		if (orb_aReglements.isSelected() && isEmpty(document.getElementById('orb-comboBanques').value)) {
			var reglementId = orb_aReglements.getSelectedCellText("orb-colDocumentId");
			var typeDoc = orb_aReglements.getSelectedCellText("orb-colTypeDoc");
			var url = "chrome://opensi/content/facturation/user/remises_banque/popup-affecterBanqueRemise.xul?"+ cookie();
			window.openDialog(url,'','chrome,modal,centerscreen', reglementId, (typeDoc=="RC"?"C":"F"), orb_listerReglements);
		}

	} catch (e) {
		recup_erreur(e);
	}
}

