/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var omr_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'omr-etablissement');
var omr_aDepots = new Arbre('ComboListe/combo-depotsStock.tmpl', 'omr-depot');
var omr_aRetours = new Arbre("Facturation/Retours_Clients/list-retourClient.tmpl", "omr-listeRetours");
var omr_aApercuRetour = new Arbre("Facturation/Retours_Clients/list-apercuRetourClient.tmpl", "omr-apercuRetour");
var omr_qListRC = new QueryHttp("Facturation/Retours_Clients/getDataListRC.tmpl");

var omr_pageCourante;
var omr_nbPages;



function omr_init() {
	try {

		omr_aEtablissements.setParam('Selection', etablissementDefaut);
		omr_aEtablissements.initTree(omr_initEtablissement);

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_initEtablissement() {
	try {
		omr_aDepots.setParam('Selection', depotRC);
		omr_aDepots.setParam('Depot_Quarantaine', false);
		omr_aDepots.initTree(omr_initCriteres);
	} catch (e) {
		recup_erreur(e);
	}
}


function omr_pressOnNouveauRetour() {
	try {
		document.getElementById("bMenuRetours").collapsed=false;
		document.getElementById("deck").selectedIndex=1;
		oebr_nouveauBon();
	} catch (e) {
		recup_erreur(e);
	}
}


function omr_initCriteres() {
	try {

		document.getElementById('omr-numRetour').value="";
		document.getElementById('omr-numClient').value="";
		document.getElementById('omr-nomClient').value="";
		document.getElementById('omr-etablissement').value = etablissementDefaut;
		document.getElementById('omr-depot').value = depotRC;
		document.getElementById('omr-dateBonDebut').value="";
		document.getElementById('omr-dateBonFin').value="";
		document.getElementById('omr-refArticle').value="";
		document.getElementById('omr-etatRetour').value = "";
		document.getElementById('omr-typeRetour').value = "";

		omr_listerRetours();

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_onKeyPress(event) {
	try {
		if (event.keyCode==13) {
			omr_listerRetours();
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function omr_listerRetours() {
	try {

		var numRetour = document.getElementById('omr-numRetour').value;
		var numClient = document.getElementById('omr-numClient').value;
		var nomClient = document.getElementById('omr-nomClient').value;
		var etablissement = document.getElementById('omr-etablissement').value;
		var depot = document.getElementById('omr-depot').value;
		var dateBonDebut = document.getElementById('omr-dateBonDebut').value;
		var dateBonFin = document.getElementById('omr-dateBonFin').value;
		var refArticle = document.getElementById('omr-refArticle').value;
		var etat = document.getElementById('omr-etatRetour').value;
		var typeRetour = document.getElementById('omr-typeRetour').value;
		var nbLignesParPage = document.getElementById('omr-nbLignesParPage').value;

		if (!isEmpty(dateBonDebut) && !isDate(dateBonDebut)) { showWarning("Date de d\u00E9but de p\u00E9riode incorrecte !"); }
		else if (!isEmpty(dateBonFin) && !isDate(dateBonFin)) { showWarning("Date de fin de p\u00E9riode incorrecte !"); }
		else if (!isEmpty(dateBonDebut) && !isEmpty(dateBonFin) && !isDateInterval(dateBonDebut, dateBonFin)) { showWarning("Plage de dates incorrecte !"); }
		else {
			document.getElementById('omr-listeRetours').disabled = true;
			document.getElementById('omr-bEditionCsv').disabled = true;

			document.getElementById('omr-numRetourSelect').value = "";
			omr_aApercuRetour.deleteTree();
			omr_aRetours.deleteTree();

			omr_pageCourante = 1;
			omr_nbPages = 1;
			document.getElementById('omr-pageDeb').value = 1;
			document.getElementById('omr-pageFin').value = 1;
			document.getElementById('omr-bPrec').disabled = true;
			document.getElementById('omr-bSuiv').disabled = true;

			omr_qListRC.setParam("Num_Retour", numRetour);
			omr_qListRC.setParam("Num_Client", numClient);
			omr_qListRC.setParam("Denomination", nomClient);
			omr_qListRC.setParam("Etablissement", etablissement);
			omr_qListRC.setParam("Depot", depot);
			omr_qListRC.setParam("Date_Debut", dateBonDebut);
			omr_qListRC.setParam("Date_Fin", dateBonFin);
			omr_qListRC.setParam("Ref_Article", refArticle);
			omr_qListRC.setParam("Etat", etat);
			omr_qListRC.setParam("Type_Retour", typeRetour);
			omr_qListRC.setParam("Provenance", "");
			omr_qListRC.setParam("Direct", true);
			omr_qListRC.setParam("Current_Page", omr_pageCourante);
			omr_qListRC.setParam("Nb_Lignes_Par_Page", nbLignesParPage);

			var result = omr_qListRC.execute();

			var contenu = result.responseXML.documentElement;

			omr_nbPages = contenu.getAttribute("Nb_Pages");
			var listRetourId = contenu.getAttribute("List_Retour_Id");

			omr_aRetours.setParam("List_Retour_Id", listRetourId);
			omr_aRetours.initTree(omr_initPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_initPagination() {
	try {

		document.getElementById('omr-pageDeb').value = omr_pageCourante;
		document.getElementById('omr-pageFin').value = (omr_nbPages>0?omr_nbPages:1);
		document.getElementById('omr-bPrec').disabled = (omr_pageCourante==1);
		document.getElementById('omr-bSuiv').disabled = (omr_pageCourante>=omr_nbPages); // peut se produire si omr_nbPages=0

		omr_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_pressOnPagePrec() {
	try {

		omr_pageCourante--;
		omr_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_pressOnPageSuiv() {
	try {

		omr_pageCourante++;
		omr_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_majPagination() {
	try {

		document.getElementById('omr-pageDeb').value = omr_pageCourante;
		document.getElementById('omr-bPrec').disabled = (omr_pageCourante==1);
		document.getElementById('omr-bSuiv').disabled = (omr_pageCourante==omr_nbPages);

		document.getElementById('omr-numRetourSelect').value = "";

		document.getElementById('omr-listeRetours').disabled = true;
		document.getElementById('omr-bEditionCsv').disabled = true;
		omr_aApercuRetour.deleteTree();

		omr_qListRC.setParam("Current_Page", omr_pageCourante);
		var result = omr_qListRC.execute();
		var listRetourId = result.responseXML.documentElement.getAttribute("List_Retour_Id");

		omr_aRetours.setParam("List_Retour_Id", listRetourId);
		omr_aRetours.initTree(omr_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_afterMajPagination() {
	try {

		document.getElementById('omr-listeRetours').disabled = false;
		document.getElementById('omr-bEditionCsv').disabled = (omr_aRetours.nbLignes()==0);
		document.getElementById('omr-numRetour').focus();

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_selectOnListeRetours() {
	try {

		if (omr_aRetours.isSelected()) {
			var i = omr_aRetours.getCurrentIndex();
			var retourId = omr_aRetours.getCellText(i, "omr-colRetourId");
			document.getElementById('omr-numRetourSelect').value = "Aper\u00E7u du retour N\u00B0 "+ omr_aRetours.getCellText(i, "omr-colNumRetour") +" :";
			omr_aApercuRetour.setParam("Retour_Id", retourId);
			omr_aApercuRetour.initTree();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_pressOnListeRetours() {
	try {
		if (omr_aRetours.isSelected()) {
			var i = omr_aRetours.getCurrentIndex();
			bonRetourId = omr_aRetours.getCellText(i, "omr-colRetourId");
			oebr_chargerBon();
			document.getElementById("deck").selectedIndex=1;
			document.getElementById("bMenuRetours").collapsed=false;
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function omr_pressOnEditionCsv() {
	try {

		var numRetour = document.getElementById('omr-numRetour').value;
		var numClient = document.getElementById('omr-numClient').value;
		var nomClient = document.getElementById('omr-nomClient').value;
		var etablissement = document.getElementById('omr-etablissement').value;
		var depot = document.getElementById('omr-depot').value;
		var dateBonDebut = document.getElementById('omr-dateBonDebut').value;
		var dateBonFin = document.getElementById('omr-dateBonFin').value;
		var refArticle = document.getElementById('omr-refArticle').value;
		var etat = document.getElementById('omr-etatRetour').value;
		var typeRetour = document.getElementById('omr-typeRetour').value;

		if (!isEmpty(dateBonDebut) && !isDate(dateBonDebut)) { showWarning("Date de d\u00E9but de p\u00E9riode incorrecte !"); }
		else if (!isEmpty(dateBonFin) && !isDate(dateBonFin)) { showWarning("Date de fin de p\u00E9riode incorrecte !"); }
		else if (!isEmpty(dateBonDebut) && !isEmpty(dateBonFin) && !isDateInterval(dateBonDebut, dateBonFin)) { showWarning("Plage de dates incorrecte !"); }
		else {

			var qEditionCsv = new QueryHttp("Facturation/Retours_Clients/csvRetourClient.tmpl");
			qEditionCsv.setParam("Num_Retour", numRetour);
			qEditionCsv.setParam("Num_Client", numClient);
			qEditionCsv.setParam("Denomination", nomClient);
			qEditionCsv.setParam("Etablissement", etablissement);
			qEditionCsv.setParam("Depot", depot);
			qEditionCsv.setParam("Date_Debut", dateBonDebut);
			qEditionCsv.setParam("Date_Fin", dateBonFin);
			qEditionCsv.setParam("Ref_Article", refArticle);
			qEditionCsv.setParam("Etat", etat);
			qEditionCsv.setParam("Type_Retour", typeRetour);
			qEditionCsv.setParam("Provenance", "");
			qEditionCsv.setParam("Direct", true);

			var result = qEditionCsv.execute();
			var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

			var file = fileChooser("save", fichier);
			if (file!=null) {
				downloadFile(getDirBuffer()+ fichier, file);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}
