/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var ooel_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'ooel-etablissement');
var ooel_aDepots = new Arbre('ComboListe/combo-depotsStock.tmpl', 'ooel-depot');
var ooel_aProvenances = new Arbre("ComboListe/combo-sitesWeb.tmpl","ooel-provenance");
var ooel_aExpeditions = new Arbre("Facturation/Suivi_Logistique/list-expeditionLot.tmpl", "ooel-listeExpeditions");
var ooel_aApercuPickingEL = new Arbre("Facturation/Suivi_Logistique/list-apercuPickingEL.tmpl", "ooel-apercuPickingEL");
var ooel_aApercuOrigineEL = new Arbre("Facturation/Suivi_Logistique/list-apercuOrigineEL.tmpl", "ooel-apercuOrigineEL");
var ooel_qListEL = new QueryHttp("Facturation/Suivi_Logistique/getDataListEL.tmpl");

var ooel_pageCourante;
var ooel_nbPages;

var ooel_currentExpeditionId = "";
var defautEtapePrepaBLCC;
var defautEtapePrepaBLTS;



function ooel_initOngletExpeditions() {
	try {

		defautEtapePrepaBLCC = gConfig.isEtapePrepaBLCC();
		defautEtapePrepaBLTS = gConfig.isEtapePrepaBLTS();

		ooel_aProvenances.initTree();

		ooel_aEtablissements.setParam('Selection', gEtablissementDefaut);
		ooel_aEtablissements.initTree(ooel_initEtablissement);

		document.getElementById('ooel-boxProvenance').collapsed = !gSiteWeb;

		if (!gEtapePicking) {
			document.getElementById('ooel-colEtatAP').collapsed = true;
		}

		document.getElementById('ooel-miProvenanceHL').collapsed = !gProfil.isProvenanceHL();

	} catch (e) {
		recup_erreur(e);
  }
}


function ooel_initEtablissement() {
	try {

		ooel_aDepots.setParam('Selection', gDepotDefaut);
		ooel_aDepots.initTree(ooel_initCriteres);

	} catch (e) {
		recup_erreur(e);
	}
}


function ooel_initCriteres() {
	try {

		document.getElementById('ooel-numExpedition').value = "";
		document.getElementById('ooel-numCommande').value = "";
		document.getElementById('ooel-numTransfert').value = "";
		document.getElementById('ooel-dateExpeditionDebut').value = "";
		document.getElementById('ooel-dateExpeditionFin').value = "";
		document.getElementById('ooel-numClient').value = "";
		document.getElementById('ooel-denomination').value = "";
		document.getElementById('ooel-etablissement').value = gEtablissementDefaut;
		document.getElementById('ooel-depot').value = gDepotDefaut;
		document.getElementById('ooel-refArticle').value = "";
		document.getElementById('ooel-typeExpedition').value = "C";
		document.getElementById('ooel-provenance').value = "";

	} catch (e) {
		recup_erreur(e);
	}
}


function ooel_listerExpeditions() {
	try {

		var numExpedition = document.getElementById('ooel-numExpedition').value;
		var numCommande = document.getElementById('ooel-numCommande').value;
		var numTransfert = document.getElementById('ooel-numTransfert').value;
		var numClient = document.getElementById('ooel-numClient').value;
		var denomination = document.getElementById('ooel-denomination').value;
		var typeExpedition = document.getElementById('ooel-typeExpedition').value;
		var refArticle = document.getElementById('ooel-refArticle').value;
		var etablissement = document.getElementById('ooel-etablissement').value;
		var depot = document.getElementById('ooel-depot').value;
		var provenance = document.getElementById('ooel-provenance').value;
		var dateExpeditionDebut = document.getElementById('ooel-dateExpeditionDebut').value;
		var dateExpeditionFin = document.getElementById('ooel-dateExpeditionFin').value;
		var nbLignesParPage = document.getElementById('ooel-nbLignesParPage').value;

		if (!isEmpty(dateExpeditionDebut) && !isDate(dateExpeditionDebut)) { showWarning("Date de d\u00E9but incorrecte"); }
		else if (!isEmpty(dateExpeditionFin) && !isDate(dateExpeditionFin)) { showWarning("Date de fin incorrecte"); }
		else if (!isEmpty(dateExpeditionDebut) && !isEmpty(dateExpeditionFin) && !isDateInterval(dateExpeditionDebut, dateExpeditionFin)) { showWarning("Plage de dates incorrecte"); }
		else {

			ooel_pageCourante = 1;
			ooel_nbPages = 1;
			document.getElementById('ooel-pageDeb').value = 1;
			document.getElementById('ooel-pageFin').value = 1;
			document.getElementById('ooel-bPrec').disabled = true;
			document.getElementById('ooel-bSuiv').disabled = true;

			document.getElementById('ooel-listeExpeditions').disabled = true;
			document.getElementById('ooel-numExpeditionSelect').value = "";
			document.getElementById('ooel-bEditionCSV').disabled = true;
			document.getElementById('ooel-bEditionEL').disabled = true;
			document.getElementById('ooel-bEtiquettesTransport').disabled = true;
			ooel_aApercuPickingEL.deleteTree();
			ooel_aApercuOrigineEL.deleteTree();
			ooel_aExpeditions.deleteTree();

			ooel_qListEL.setParam("Num_Expedition", numExpedition);
			ooel_qListEL.setParam("Num_Commande", numCommande);
			ooel_qListEL.setParam("Num_Transfert", numTransfert);
			ooel_qListEL.setParam("Num_Client", numClient);
			ooel_qListEL.setParam("Denomination", denomination);
			ooel_qListEL.setParam("Type_Expedition", typeExpedition);
			ooel_qListEL.setParam("Ref_Article", refArticle);
			ooel_qListEL.setParam("Etablissement", etablissement);
			ooel_qListEL.setParam("Depot", depot);
			ooel_qListEL.setParam("Provenance", provenance);
			ooel_qListEL.setParam("Date_Expedition_Debut", dateExpeditionDebut);
			ooel_qListEL.setParam("Date_Expedition_Fin", dateExpeditionFin);
			ooel_qListEL.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			ooel_qListEL.setParam("Current_Page", ooel_pageCourante);

			var result = ooel_qListEL.execute();

			var contenu = result.responseXML.documentElement;

			ooel_nbPages = contenu.getAttribute("Nb_Pages");
			var listExpeditionId = contenu.getAttribute("List_Expedition_Id");

			ooel_aExpeditions.setParam("List_Expedition_Id", listExpeditionId);
			ooel_aExpeditions.initTree(ooel_initPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ooel_initPagination() {
	try {

		document.getElementById('ooel-pageDeb').value = ooel_pageCourante;
		document.getElementById('ooel-pageFin').value = (ooel_nbPages>0?ooel_nbPages:1);
		document.getElementById('ooel-bPrec').disabled = (ooel_pageCourante==1);
		document.getElementById('ooel-bSuiv').disabled = (ooel_pageCourante>=ooel_nbPages); // peut se produire si ooel_nbPages=0

		ooel_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function ooel_pressOnPagePrec() {
	try {

		ooel_pageCourante--;
		ooel_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function ooel_pressOnPageSuiv() {
	try {

		ooel_pageCourante++;
		ooel_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function ooel_majPagination() {
	try {

		document.getElementById('ooel-pageDeb').value = ooel_pageCourante;
		document.getElementById('ooel-bPrec').disabled = (ooel_pageCourante==1);
		document.getElementById('ooel-bSuiv').disabled = (ooel_pageCourante==ooel_nbPages);

		document.getElementById('ooel-listeExpeditions').disabled = true;
		document.getElementById('ooel-numExpeditionSelect').value = "";
		document.getElementById('ooel-bEditionCSV').disabled = true;
		document.getElementById('ooel-bEditionEL').disabled = true;
		document.getElementById('ooel-bEtiquettesTransport').disabled = true;
		ooel_aApercuPickingEL.deleteTree();
		ooel_aApercuOrigineEL.deleteTree();

		ooel_qListEL.setParam("Current_Page", ooel_pageCourante);
		var result = ooel_qListEL.execute();
		var listExpeditionId = result.responseXML.documentElement.getAttribute("List_Expedition_Id");

		ooel_aExpeditions.setParam("List_Expedition_Id", listExpeditionId);
		ooel_aExpeditions.initTree(ooel_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function ooel_afterMajPagination() {
	try {

		document.getElementById('ooel-listeExpeditions').disabled = false;
		document.getElementById('ooel-bEditionCSV').disabled=(ooel_aExpeditions.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function ooel_selectOnListeExpeditions() {
	try {

		if (ooel_aExpeditions.isSelected()) {
			ooel_currentExpeditionId = ooel_aExpeditions.getSelectedCellText('ooel-colExpeditionId');
			document.getElementById('ooel-numExpeditionSelect').value = ooel_aExpeditions.getSelectedCellText("ooel-colNumExpedition");

			var typeExpedition = ooel_aExpeditions.getSelectedCellText('ooel-colTypeExpedition');
			document.getElementById('ooel-titreApercuOrigine').value = typeExpedition!="T"?"Commandes de l'exp\u00E9dition :":"Transferts de l'exp\u00E9dition :";
			document.getElementById('ooel-colNumCommandeAO').collapsed = typeExpedition=="T";
			document.getElementById('ooel-colNumTransfertAO').collapsed = typeExpedition!="T";
			document.getElementById('ooel-colRefCommandeAO').collapsed = typeExpedition=="T";
			document.getElementById('ooel-colIntituleAO').collapsed = typeExpedition!="T";

			ooel_aApercuPickingEL.setParam("Expedition_Id", ooel_currentExpeditionId);
			ooel_aApercuPickingEL.initTree();
			ooel_aApercuOrigineEL.setParam("Expedition_Id", ooel_currentExpeditionId);
			ooel_aApercuOrigineEL.initTree();

			document.getElementById('ooel-bEditionEL').disabled = false;
			document.getElementById('ooel-bEtiquettesTransport').disabled = typeExpedition!="C" && typeExpedition!="T";
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ooel_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			ooel_listerExpeditions();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function ooel_pressOnEditionCSV() {
	try {

		var numExpedition = document.getElementById('ooel-numExpedition').value;
		var numCommande = document.getElementById('ooel-numCommande').value;
		var numTransfert = document.getElementById('ooel-numTransfert').value;
		var numClient = document.getElementById('ooel-numClient').value;
		var denomination = document.getElementById('ooel-denomination').value;
		var typeExpedition = document.getElementById('ooel-typeExpedition').value;
		var refArticle = document.getElementById('ooel-refArticle').value;
		var etablissement = document.getElementById('ooel-etablissement').value;
		var depot = document.getElementById('ooel-depot').value;
		var provenance = document.getElementById('ooel-provenance').value;
		var dateExpeditionDebut = document.getElementById('ooel-dateExpeditionDebut').value;
		var dateExpeditionFin = document.getElementById('ooel-dateExpeditionFin').value;

		if (!isEmpty(dateExpeditionDebut) && !isDate(dateExpeditionDebut)) { showWarning("Date de d\u00E9but incorrecte"); }
		else if (!isEmpty(dateExpeditionFin) && !isDate(dateExpeditionFin)) { showWarning("Date de fin incorrecte"); }
		else if (!isEmpty(dateExpeditionDebut) && !isEmpty(dateExpeditionFin) && !isDateInterval(dateExpeditionDebut, dateExpeditionFin)) { showWarning("Plage de dates incorrecte"); }
		else {

			var qEditionCSV = new QueryHttp("Facturation/Suivi_Logistique/csvExpeditionLot.tmpl");

			qEditionCSV.setParam("Num_Expedition", numExpedition);
			qEditionCSV.setParam("Num_Commande", numCommande);
			qEditionCSV.setParam("Num_Transfert", numTransfert);
			qEditionCSV.setParam("Num_Client", numClient);
			qEditionCSV.setParam("Denomination", denomination);
			qEditionCSV.setParam("Type_Expedition", typeExpedition);
			qEditionCSV.setParam("Ref_Article", refArticle);
			qEditionCSV.setParam("Etablissement", etablissement);
			qEditionCSV.setParam("Depot", depot);
			qEditionCSV.setParam("Provenance", provenance);
			qEditionCSV.setParam("Date_Expedition_Debut", dateExpeditionDebut);
			qEditionCSV.setParam("Date_Expedition_Fin", dateExpeditionFin);

			var result = qEditionCSV.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ooel_editionEL() {
	try {

		if (ooel_aExpeditions.isSelected()) {
			var qEditionPDF = new QueryHttp("Facturation/Suivi_Logistique/pdfExpeditionLot.tmpl");
			qEditionPDF.setParam('Expedition_Id', ooel_currentExpeditionId);

			document.getElementById('pmbox').collapsed = false;
			document.getElementById('pm').setAttribute('mode', 'undetermined');
			document.getElementById('deck').selectedIndex = 1;

			qEditionPDF.execute(ooel_editionEL_2);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ooel_editionEL_2(result) {
	try {

		document.getElementById('pmbox').collapsed = true;
		document.getElementById('pm').setAttribute('mode', 'none');

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
			retourSuiviLogistique();
		}
		else {
			document.getElementById('rappelLoi').collapsed = result.responseXML.documentElement.getAttribute('Edit_FC')=="false";

			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			document.getElementById('pdf').setAttribute("src", page);

			document.getElementById('bRetourSuiviLogistique').collapsed = false;

			var typeExpedition = ooel_aExpeditions.getSelectedCellText("ooel-colTypeExpedition");

			if (ooel_aExpeditions.getSelectedCellText("ooel-colEditEC")=="true") {
				var qEtiq = new QueryHttp("Facturation/Affaires/pdfEtiquettes.tmpl");
				qEtiq.setParam("Expedition_Id", ooel_currentExpeditionId);

				qEtiq.execute(ooel_editionEL_3);
			}

			document.getElementById('Format_Id').value = "";
			document.getElementById('boxExpTrans').collapsed = (typeExpedition!="T" && defautEtapePrepaBLCC) || (typeExpedition=="T" && defautEtapePrepaBLTS);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ooel_editionEL_3(result) {
	try {

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			document.getElementById('boxEtiquettes').collapsed = false;
			document.getElementById('lblDocExpe').collapsed = false;
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('fichier');
			document.getElementById('pdfEtiquettes').setAttribute("src", page);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ooel_genererEtiquettesTransport() {
	try {

		if (ooel_aExpeditions.isSelected() && window.confirm("Confirmez-vous la reg\u00E9n\u00E9ration des \u00E9tiquettes transport de l'exp\u00E9dition s\u00E9lectionn\u00E9e ?")) {
			var qGen = new QueryHttp("Facturation/Suivi_Logistique/genEtiquetteTransportEL.tmpl");
			qGen.setParam("Expedition_Id", ooel_currentExpeditionId);
			var result = qGen.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("Une nouvelle demande d'\u00E9tiquettes transport a \u00E9t\u00E9 g\u00E9n\u00E9r\u00E9e");
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ooel_rechercherClient() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', ooel_retourRechercherClient);

	} catch (e) {
		recup_erreur(e);
	}
}


function ooel_retourRechercherClient(numClient) {
	try {

  	document.getElementById('ooel-numClient').value = numClient;
  	ooel_listerExpeditions();

	} catch (e) {
		recup_erreur(e);
	}
}


function ooel_rechercherArticle() {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', ooel_retourRechercherArticle);

	} catch (e) {
		recup_erreur(e);
	}
}


function ooel_retourRechercherArticle(reference, articleId) {
	try {

  	document.getElementById('ooel-refArticle').value = reference;
  	ooel_listerExpeditions();

	} catch (e) {
		recup_erreur(e);
	}
}


function ooel_exportTransporteur() {
	try {

		var formatId = document.getElementById('Format_Id').value;

		if (isEmpty(formatId)) {
			showWarning("Veuillez s\u00E9lectionner un format d'export transporteur");
		}
		else {
			document.getElementById('bExporter').disabled = true;

			var qExport = new QueryHttp("Facturation/Expedition_Lot/genExportTransporteur.tmpl");
			qExport.setParam('Export_Id', formatId);
			qExport.setParam('Expedition_Id', ooel_currentExpeditionId);
			var result = qExport.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;
				var fichierExport = contenu.getAttribute('FileName');
				var suggestedName = contenu.getAttribute('SuggestedName');

				document.getElementById('bExporter').disabled = false;

				var file = fileChooser("save", suggestedName);
				if (file!=null) {
					downloadFile(getDirBuffer() + fichierExport, file);
				}
			}
		}

	} catch (e) {
	  recup_erreur(e);
	}
}
