/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/formatter.js");


var etablissementDefaut;
var gReadOnly;



function init() {
  try {

		var profil = getProfil();

		gReadOnly = profil.isReadOnlyGC_DRegCli();

		document.getElementById('lblReadOnly').collapsed = !gReadOnly;

		etablissementDefaut = profil.getEtabId();

  	document.getElementById('deck').selectedIndex = 0;

		if (!isEmpty(ParamValeur('Relances'))) {
			document.getElementById('onglets').selectedIndex = 3;
			or_init();
		}
		else {
			document.getElementById('onglets').selectedIndex = 0;
			oe_init();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function switchPdf(page) {
	try {

		document.getElementById('pdf').setAttribute("src", "");

		document.getElementById('pdf').setAttribute('src', page);
		document.getElementById('deck').selectedIndex = 1;
		document.getElementById('bRetourReglementsClients').collapsed = false;

		if (document.getElementById('onglets').selectedIndex==0) {
			document.getElementById('boxEcheances').collapsed = false;
		}
		else if (document.getElementById('onglets').selectedIndex==1) {
			document.getElementById('boxReglements').collapsed = false;
		}
		else if (document.getElementById('onglets').selectedIndex==3) {
			document.getElementById('boxRelances').collapsed = false;
		}
		else if (document.getElementById('onglets').selectedIndex==5) {
			document.getElementById('boxReleves').collapsed = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function retourSuiviReglements() {
	try {

		if (document.getElementById('onglets').selectedIndex==3) {
			or_init();
		}

		document.getElementById('deck').selectedIndex = 0;
		document.getElementById('bRetourReglementsClients').collapsed = true;
		document.getElementById('pdf').setAttribute('src', '');
		document.getElementById('boxEcheances').collapsed = true;
		document.getElementById('boxReglements').collapsed = true;
		document.getElementById('boxRelances').collapsed = true;
		document.getElementById('boxReleves').collapsed = true;

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuPrincipal() {
	try {

		window.location = "chrome://opensi/content/facturation/user/menu_principal.xul";

	} catch (e) {
    recup_erreur(e);
  }
}
