/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var or_aRelancesAG = new Arbre("Facturation/Suivi_Reglements_Clients/list-relanceAGenerer.tmpl", "or-listeRelancesAG");
var or_aRelancesHR = new Arbre("Facturation/Suivi_Reglements_Clients/list-relanceClient.tmpl", "or-listeRelancesHR");
var or_aDetailRelance = new Arbre("Facturation/Suivi_Reglements_Clients/list-imputationRelanceEcheanceClient.tmpl", "or-listeDetailRelance");
var or_aDetailEcheance = new Arbre("Facturation/Suivi_Reglements_Clients/list-detailRelanceEcheanceClient.tmpl", "or-listeDetailEcheance");
var or_aHistorique = new Arbre("Facturation/Suivi_Reglements_Clients/combo-historiqueRelances.tmpl", "or-historiqueRelances");
var or_aFiltreModesReglementAG = new Arbre('ComboListe/combo-modesReglement.tmpl', 'or-filtreModeReglementAG');
var or_aFiltreEtablissementsAG = new Arbre('ComboListe/combo-etablissements.tmpl', 'or-filtreEtablissementAG');
var or_aFiltreModesReglementHR = new Arbre('ComboListe/combo-modesReglement.tmpl', 'or-filtreModeReglementHR');
var or_aFiltreEtablissementsHR = new Arbre('ComboListe/combo-etablissements.tmpl', 'or-filtreEtablissementHR');
var or_qListHR = new QueryHttp("Facturation/Suivi_Reglements_Clients/getDataListHR.tmpl");

var or_pageCouranteHR;
var or_nbPagesHR;

var or_tabLoaded = false;
var or_relanceId = "";



function or_init() {
	try {

		if (!or_tabLoaded) {
			or_tabLoaded = true;
 			or_aFiltreModesReglementAG.initTree(or_initFiltreModeReglementAG);
 			or_aFiltreModesReglementHR.initTree(or_initFiltreModeReglementHR);
			or_aHistorique.initTree();
		}
		else {
			or_listerRelancesAG();
		}

		if (gReadOnly) {
			document.getElementById('or-bGenererRelances').collapsed = true;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


// ONGLET RELANCES A GENERER


function or_initFiltreModeReglementAG() {
	try {

    or_aFiltreEtablissementsAG.initTree(or_initCriteresAG);

	} catch (e) {
    recup_erreur(e);
  }
}


function or_initCriteresAG() {
	try {

		document.getElementById('or-filtreEtablissementAG').value = etablissementDefaut;
		document.getElementById('or-filtreNumClientAG').value = "";
		document.getElementById('or-filtreDenominationAG').value = "";
		document.getElementById('or-filtreDateDebutAG').value = "";
		document.getElementById('or-filtreDateFinAG').value = "";
		document.getElementById('or-filtreModeReglementAG').value = "";
		document.getElementById('or-filtreNiveauAG').value = "";

		or_listerRelancesAG();

	} catch (e) {
		recup_erreur(e);
	}
}


function or_pressOnCritereAG(ev) {
  try {

		if (ev.keyCode==13) {
			or_listerRelancesAG();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function or_toutCocherAG(b) {
	try {

		document.getElementById("or-bGenererRelances").disabled = true;

		for (var i=0; i<or_aRelancesAG.nbLignes(); i++) {
			or_aRelancesAG.setCellValue(i, "or-colSelEcheanceAG", b);
		}

		or_refreshTotauxAG();
		document.getElementById("or-bGenererRelances").disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function or_listerRelancesAG() {
	try {

		var etablissement = document.getElementById('or-filtreEtablissementAG').value;
		var numClient = document.getElementById('or-filtreNumClientAG').value;
		var denomination = document.getElementById('or-filtreDenominationAG').value;
		var dateDebut = document.getElementById('or-filtreDateDebutAG').value;
		var dateFin = document.getElementById('or-filtreDateFinAG').value;
		var modeReglement = document.getElementById('or-filtreModeReglementAG').value;
		var niveau = document.getElementById('or-filtreNiveauAG').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte !"); }
		else {
			document.getElementById("or-listeRelancesAG").disabled = true;
			document.getElementById("or-bGenererRelances").disabled = true;
			or_aDetailEcheance.deleteTree();

			or_aRelancesAG.setParam("Etablissement", etablissement);
			or_aRelancesAG.setParam("Num_Client", numClient);
			or_aRelancesAG.setParam("Denomination", denomination);
			or_aRelancesAG.setParam("Date_Debut", dateDebut);
			or_aRelancesAG.setParam("Date_Fin", dateFin);
			or_aRelancesAG.setParam("Mode_Reglement", modeReglement);
			or_aRelancesAG.setParam("Niveau", niveau);

			or_aRelancesAG.initTree(or_afterRefreshRelancesAG);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function or_afterRefreshRelancesAG() {
	try {

		or_refreshTotauxAG();
		document.getElementById("or-bGenererRelances").disabled = false;
		document.getElementById("or-listeRelancesAG").disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function or_selectOnListeRelancesAG() {
	try {

		if (or_aRelancesAG.isSelected()) {
			var echeanceId = or_aRelancesAG.getSelectedCellText('or-colEcheanceIdAG');

			or_aDetailEcheance.setParam("Echeance_Id", echeanceId);
			or_aDetailEcheance.initTree();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function or_refreshTotauxAG() {
	try {

		var nbCoches = 0;
		var totalARelancer = 0;

		for (var i=0; i<or_aRelancesAG.nbLignes(); i++) {
			if (or_aRelancesAG.getCellValue(i, "or-colSelEcheanceAG")=="true") {
				nbCoches++;
				totalARelancer += parseFloat(or_aRelancesAG.getCellValue(i, "or-colMontantRestantAG"));
			}
		}

		var nf = new NumberFormat("0.00", true);

		document.getElementById('or-nbLignesCocheesAG').value = nbCoches;
		document.getElementById('or-totalARelancerAG').value = nf.format(totalARelancer);

	} catch (e) {
		recup_erreur(e);
	}
}


function or_pressOnListeRelancesAG(ev) {
	try {

		if (ev.keyCode==32 && or_aRelancesAG.isSelected()) {
			or_aRelancesAG.setSelectedCellValue("or-colSelEcheanceAG", or_aRelancesAG.getSelectedCellValue("or-colSelEcheanceAG")=="false");
			or_refreshTotauxAG();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function or_genererRelances() {
	try {

		var listEcheanceId = "";

		for (var i=0; i<or_aRelancesAG.nbLignes(); i++) {
			if (or_aRelancesAG.getCellValue(i, "or-colSelEcheanceAG")=="true") {
				listEcheanceId += or_aRelancesAG.getCellText(i, "or-colEcheanceIdAG") +",";
			}
  	}

		if (isEmpty(listEcheanceId)) {
			showWarning("Veuillez cocher au moins une \u00E9ch\u00E9ance");
		}
		else {
			var groupement = document.getElementById('or-groupement').checked;

			var qGenerate = new QueryHttp("Facturation/Suivi_Reglements_Clients/generateRelancesClient.tmpl");
			qGenerate.setParam('Groupement', groupement);
			qGenerate.setParam('List_Echeance_Id', listEcheanceId);

			var result = qGenerate.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				if (contenu.getAttribute("Has_Mail")=="true") {
					showMessage(contenu.getAttribute("Nb_Mail") +" relances ont \u00E9t\u00E9 envoy\u00E9es par e-mail");
				}

				if (contenu.getAttribute("Has_Courrier")=="true") {
					var vagueId = contenu.getAttribute("Vague_Id");
					or_editionRelances(vagueId);
				}

				if (contenu.getAttribute("Has_Mail")=="false" && contenu.getAttribute("Has_Courrier")=="false") {
					showMessage("Les relances ont \u00E9t\u00E9 g\u00E9n\u00E9r\u00E9es");
				}

				or_listerRelancesAG();
				or_aHistorique.initTree();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function or_reediterRelances() {
  try {

		var vagueId = document.getElementById('or-historiqueRelances').value;

		if (isEmpty(vagueId)) {
			showWarning("Veuillez choisir une r\u00E9\u00E9dition");
		}
		else {
			or_editionRelances(vagueId, null, null);
			document.getElementById('or-historiqueRelances').value = "";
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function or_editionRelances(vagueId, relanceId, listRelanceId) {
  try {

		var qEditionPdf = new QueryHttp("Facturation/Suivi_Reglements_Clients/pdfRelanceClient.tmpl");
		if (vagueId!=null) {
			qEditionPdf.setParam("Vague_Id", vagueId);
		}
		else if (relanceId!=null) {
			qEditionPdf.setParam("Relance_Id", relanceId);
		}
		else {
			qEditionPdf.setParam("List_Relance_Id", listRelanceId);
		}

		var result = qEditionPdf.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
      var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			switchPdf(page);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function or_rechercherClientAG() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', or_retourRechercherClientAG);

	} catch (e) {
		recup_erreur(e);
	}
}


function or_retourRechercherClientAG(numClient) {
	try {

  	document.getElementById('or-filtreNumClientAG').value = numClient;
  	or_listerRelancesAG();

	} catch (e) {
		recup_erreur(e);
	}
}


// ONGLET SUIVI/HISTORIQUE


function or_initFiltreModeReglementHR() {
	try {

    or_aFiltreEtablissementsHR.initTree(or_initCriteresHR);

	} catch (e) {
    recup_erreur(e);
  }
}


function or_initCriteresHR() {
	try {

		document.getElementById('or-filtreEtablissementHR').value = etablissementDefaut;
		document.getElementById('or-filtreNumClientHR').value = "";
		document.getElementById('or-filtreDenominationHR').value = "";
		document.getElementById('or-filtreDateDebutHR').value = "";
		document.getElementById('or-filtreDateFinHR').value = "";
		document.getElementById('or-filtreModeReglementHR').value = "";
		document.getElementById('or-filtreNiveauHR').value = "";
		document.getElementById('or-filtreEtatHR').value = "N";
		document.getElementById('or-filtreTypeRelanceHR').value = "";

		or_listerRelancesHR();

	} catch (e) {
		recup_erreur(e);
	}
}


function or_pressOnCritereHR(ev) {
  try {

		if (ev.keyCode==13) {
			or_listerRelancesHR();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function or_listerRelancesHR() {
	try {

		var etablissement = document.getElementById('or-filtreEtablissementHR').value;
		var numClient = document.getElementById('or-filtreNumClientHR').value;
		var denomination = document.getElementById('or-filtreDenominationHR').value;
		var dateDebut = document.getElementById('or-filtreDateDebutHR').value;
		var dateFin = document.getElementById('or-filtreDateFinHR').value;
		var modeReglement = document.getElementById('or-filtreModeReglementHR').value;
		var niveau = document.getElementById('or-filtreNiveauHR').value;
		var etat = document.getElementById('or-filtreEtatHR').value;
		var typeRelance = document.getElementById('or-filtreTypeRelanceHR').value;
		var nbLignesParPage = document.getElementById('or-nbLignesParPageHR').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte !"); }
		else {
			or_pageCouranteHR = 1;
			or_nbPagesHR = 1;
			document.getElementById('or-pageDebHR').value = 1;
			document.getElementById('or-pageFinHR').value = 1;
			document.getElementById('or-bPrecHR').disabled = true;
			document.getElementById('or-bSuivHR').disabled = true;

			document.getElementById('or-listeRelancesHR').disabled = true;
			document.getElementById('or-bEditionCsv').disabled = true;
			document.getElementById('or-bEditionDetailCsv').disabled = true;
			document.getElementById('or-bEditionPdf').disabled = true;
			or_aDetailRelance.deleteTree();
			or_aRelancesHR.deleteTree();
			or_initCommentaires();

			or_qListHR.setParam("Etablissement", etablissement);
			or_qListHR.setParam("Num_Client", numClient);
			or_qListHR.setParam("Denomination", denomination);
			or_qListHR.setParam("Date_Debut", dateDebut);
			or_qListHR.setParam("Date_Fin", dateFin);
			or_qListHR.setParam("Mode_Reglement", modeReglement);
			or_qListHR.setParam("Niveau", niveau);
			or_qListHR.setParam("Etat", etat);
			or_qListHR.setParam("Type_Relance", typeRelance);
			or_qListHR.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			or_qListHR.setParam("Current_Page", or_pageCouranteHR);

			var result = or_qListHR.execute();

			var contenu = result.responseXML.documentElement;

			or_nbPagesHR = contenu.getAttribute("Nb_Pages");
			var listRelanceId = contenu.getAttribute("List_Relance_Id");

			or_aRelancesHR.setParam("List_Relance_Id", listRelanceId);
			or_aRelancesHR.initTree(or_initPaginationHR);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function or_initPaginationHR() {
	try {

		document.getElementById('or-pageDebHR').value = or_pageCouranteHR;
		document.getElementById('or-pageFinHR').value = (or_nbPagesHR>0?or_nbPagesHR:1);
		document.getElementById('or-bPrecHR').disabled = (or_pageCouranteHR==1);
		document.getElementById('or-bSuivHR').disabled = (or_pageCouranteHR>=or_nbPagesHR); // peut se produire si or_nbPages=0

		or_afterMajPaginationHR();

	} catch (e) {
		recup_erreur(e);
	}
}


function or_pressOnPagePrecHR() {
	try {

		or_pageCouranteHR--;
		or_majPaginationHR();

	} catch (e) {
		recup_erreur(e);
	}
}


function or_pressOnPageSuivHR() {
	try {

		or_pageCouranteHR++;
		or_majPaginationHR();

	} catch (e) {
		recup_erreur(e);
	}
}


function or_majPaginationHR() {
	try {

		document.getElementById('or-pageDebHR').value = or_pageCouranteHR;
		document.getElementById('or-bPrecHR').disabled = (or_pageCouranteHR==1);
		document.getElementById('or-bSuivHR').disabled = (or_pageCouranteHR==or_nbPagesHR);

		document.getElementById('or-listeRelancesHR').disabled = true;
		document.getElementById('or-bEditionCsv').disabled = true;
		document.getElementById('or-bEditionDetailCsv').disabled = true;
		document.getElementById('or-bEditionPdf').disabled = true;
		or_aDetailRelance.deleteTree();
		or_initCommentaires();

		or_qListHR.setParam("Current_Page", or_pageCouranteHR);
		var result = or_qListHR.execute();
		var listRelanceId = result.responseXML.documentElement.getAttribute("List_Relance_Id");

		or_aRelancesHR.setParam("List_Relance_Id", listRelanceId);
		or_aRelancesHR.initTree(or_afterMajPaginationHR);

	} catch (e) {
		recup_erreur(e);
	}
}


function or_afterMajPaginationHR() {
	try {

		document.getElementById('or-listeRelancesHR').disabled = false;
		document.getElementById('or-bEditionCsv').disabled = (or_aRelancesHR.nbLignes()==0);
		document.getElementById('or-bEditionDetailCsv').disabled = (or_aRelancesHR.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function or_selectOnListeRelancesHR() {
	try {

		if (or_aRelancesHR.isSelected()) {
			or_relanceId = or_aRelancesHR.getSelectedCellText('or-colRelanceIdHR');

			document.getElementById('or-bEditionPdf').disabled = or_aRelancesHR.getSelectedCellValue('or-colTypeRelanceHR')!='C';

			or_chargerCommentaires();

			or_aDetailRelance.setParam("Relance_Id", or_relanceId);
			or_aDetailRelance.initTree();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function or_initCommentaires() {
	try {

		or_relanceId = "";

		document.getElementById('or-commentaires').value = "";
		document.getElementById('or-commentaires').disabled = true;
		document.getElementById('or-bEnregistrerCommentaires').disabled = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function or_chargerCommentaires() {
	try {

		var qLoad = new QueryHttp("Facturation/Suivi_Reglements_Clients/loadRelanceClient.tmpl");
		qLoad.setParam("Relance_Id", or_relanceId);
		var result = qLoad.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			document.getElementById('or-commentaires').value = result.responseXML.documentElement.getAttribute('Commentaires');
			document.getElementById('or-bEnregistrerCommentaires').disabled = false;
			document.getElementById('or-commentaires').disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function or_enregistrerCommentaires() {
	try {

		var commentaires = document.getElementById('or-commentaires').value;

		var qSave = new QueryHttp("Facturation/Suivi_Reglements_Clients/updateRelanceClient.tmpl");
		qSave.setParam("Relance_Id", or_relanceId);
		qSave.setParam("Commentaires", commentaires);

		var result = qSave.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			or_initCommentaires();
			or_majPaginationHR();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function or_rechercherClientHR() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', or_retourRechercherClientHR);

	} catch (e) {
		recup_erreur(e);
	}
}


function or_retourRechercherClientHR(numClient) {
	try {

  	document.getElementById('or-filtreNumClientHR').value = numClient;
  	or_listerRelancesHR();

	} catch (e) {
		recup_erreur(e);
	}
}


function or_pressOnEditionCsv(detail) {
	try {

		var etablissement = document.getElementById('or-filtreEtablissementHR').value;
		var numClient = document.getElementById('or-filtreNumClientHR').value;
		var denomination = document.getElementById('or-filtreDenominationHR').value;
		var dateDebut = document.getElementById('or-filtreDateDebutHR').value;
		var dateFin = document.getElementById('or-filtreDateFinHR').value;
		var modeReglement = document.getElementById('or-filtreModeReglementHR').value;
		var niveau = document.getElementById('or-filtreNiveauHR').value;
		var etat = document.getElementById('or-filtreEtatHR').value;
		var typeRelance = document.getElementById('or-filtreTypeRelanceHR').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte !"); }
		else {

			var qEditionCsv = new QueryHttp("Facturation/Suivi_Reglements_Clients/"+ (detail?"csvDetailRelanceClient.tmpl":"csvRelanceClient.tmpl"));

			qEditionCsv.setParam("Etablissement", etablissement);
			qEditionCsv.setParam("Num_Client", numClient);
			qEditionCsv.setParam("Denomination", denomination);
			qEditionCsv.setParam("Date_Debut", dateDebut);
			qEditionCsv.setParam("Date_Fin", dateFin);
			qEditionCsv.setParam("Mode_Reglement", modeReglement);
			qEditionCsv.setParam("Niveau", niveau);
			qEditionCsv.setParam("Etat", etat);
			qEditionCsv.setParam("Type_Relance", typeRelance);

			var result = qEditionCsv.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function or_pressOnRelancesEncoursCsv() {
	try {

		var qEditionCsv = new QueryHttp("Facturation/Suivi_Reglements_Clients/csvRelanceEncours.tmpl");

		var result = qEditionCsv.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

			var file = fileChooser("save", fichier);
			if (file!=null) {
				downloadFile(getDirBuffer()+ fichier, file);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function or_pressOnRelancesEncoursPdf() {
	try {

		var qEditionPdf = new QueryHttp("Facturation/Suivi_Reglements_Clients/pdfRelanceEncours.tmpl");

		var result = qEditionPdf.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			switchPdf(page);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function or_pressOnEditionPdf() {
	try {

		or_editionRelances(null, or_relanceId, null);

	} catch (e) {
		recup_erreur(e);
	}
}
