/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");


var aModesReglements = new Arbre('ComboListe/combo-modesReglement.tmpl', 'modeReglement');

var mono;
var selModeReg;
var listEcheanceId;



function init() {
  try {

		listEcheanceId = window.arguments[0];

		if (listEcheanceId.length==1) {
			window.resizeTo(370,290);
			document.getElementById('rowAncienneDateEch').collapsed = false;
			document.getElementById('rowModeReglement').collapsed = false;
			document.getElementById('rowCommentaires').collapsed = false;
			mono = true;
			var echeanceId = listEcheanceId[0];

  		var qGet = new QueryHttp("Facturation/Suivi_Reglements_Clients/getEcheanceClient.tmpl");
  		qGet.setParam("Echeance_Id", echeanceId);
			var result = qGet.execute();
			document.getElementById('lblAncienneDateEch').value = result.responseXML.documentElement.getAttribute("Echeance_Initiale");
			document.getElementById('dateEcheance').value = result.responseXML.documentElement.getAttribute("Date_Echeance");
			chargerModesReglements(result.responseXML.documentElement.getAttribute("Mode_Reg_Id"));
			document.getElementById('commentaires').value = result.responseXML.documentElement.getAttribute("Commentaires");
		}
		else {
			mono = false;
			document.getElementById('titre').value = "Modification des \u00E9ch\u00E9ances";
			chargerModesReglements("");
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function chargerModesReglements(selection) {
	try {

		selModeReg = selection;
		aModesReglements.setParam("Selection", selModeReg);
		aModesReglements.initTree(initModeReglement);

	} catch (e) {
		recup_erreur(e);
	}
}


function initModeReglement() {
	try {

    document.getElementById('modeReglement').value = selModeReg;

	} catch (e) {
    recup_erreur(e);
  }
}


function enregistrer() {
	try {

		var dateEcheance = document.getElementById('dateEcheance').value;
		var modeReglement = document.getElementById('modeReglement').value;
		var commentaires = document.getElementById('commentaires').value;

		if (isEmpty(dateEcheance) || !isDate(dateEcheance)) { showWarning("Date incorrecte"); }
		else if (mono && isEmpty(modeReglement)) { showWarning("Veuillez choisir un mode de r\u00E8glement"); }
		else if (commentaires.length>100) { showWarning("Le commentaire ne doit pas d\u00E9passer 100 caract\u00E8res"); }
		else {
			var qUpdate = new QueryHttp("Facturation/Suivi_Reglements_Clients/updateEcheanceClient.tmpl");
			qUpdate.setParam("List_Echeance_Id", listEcheanceId);
			qUpdate.setParam("Date_Echeance", dateEcheance);
			if (mono) qUpdate.setParam("Mode_Reg_Id", modeReglement);
			if (mono) qUpdate.setParam("Commentaires", commentaires);
			qUpdate.execute();

			window.arguments[1]();
			window.close();
		}

	} catch (e) {
		recup_erreur(e);
	}
}
