/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

/*
	Arguments du popup :
		- 0 : Fonction de retour (obligatoire)
		- 1 : Article_Id (obligatoire)
		- 2 : N Lot de recherche (obligatoire)
		- 3 : Depot_Id (recherche uniquement sur n lot situs dans le dpt)
		- 4 : Client_Id (recherche uniquement sur n lot situs chez le client)
*/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");


var aLots = new Arbre("Facturation/Tracabilite/list-numLot.tmpl", "listeLots");
var qListNL = new QueryHttp("Facturation/Tracabilite/getDataListNL.tmpl");

var pageCourante;
var nbPages;



function init() {
	try {

		document.getElementById("numero").value = window.arguments[2];

		qListNL.setParam("Article_Id", window.arguments[1]);
		qListNL.setParam("Like_Search", true);

		var argDepotId = window.arguments[3];
		var argClientId = window.arguments[4];

		if (argDepotId!=null) {
			qListNL.setParam("Depot_Id", argDepotId);
		}

		if (argClientId!=null) {
			qListNL.setParam("Client_Id", argClientId);
		}

		listerLots();

	}	catch (e) {
		recup_erreur(e);
	}
}


function pressOnCritere(ev) {
	try {

		if (ev.keyCode==13) {
			listerLots();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnTree(ev) {
  try {

    if (ev.keyCode==13) {
			valider();
  	}

  } catch (e) {
    recup_erreur(e);
  }
}


function valider() {
	try {

		if (aLots.isSelected()) {
			var numero = aLots.getSelectedCellText('colNumero');
			var datePeremption = aLots.getSelectedCellText('colDatePeremption');
			var bloque = aLots.getSelectedCellText('colBloque')=="true";

			if (bloque) {
				showWarning("N\u00B0 Lot bloqu\u00E9");
			}
			else {
				window.arguments[0](numero, datePeremption);
				window.close();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function initCriteres() {
	try {

		document.getElementById("numero").value = "";
		listerLots();

	}	catch (e) {
		recup_erreur(e);
	}
}


function listerLots() {
	try {

		var numero = document.getElementById("numero").value;
		var nbLignesParPage = document.getElementById('nbLignesParPage').value;

		pageCourante = 1;
		nbPages = 1;
		document.getElementById('pageDeb').value = 1;
		document.getElementById('pageFin').value = 1;
		document.getElementById('bPrec').disabled = true;
		document.getElementById('bSuiv').disabled = true;

		document.getElementById('listeLots').disabled = true;
		aLots.deleteTree();

		qListNL.setParam("Numero", numero);
		qListNL.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
		qListNL.setParam("Current_Page", pageCourante);

		var result = qListNL.execute();

		var contenu = result.responseXML.documentElement;

		nbPages = contenu.getAttribute("Nb_Pages");
		var listLotId = contenu.getAttribute("List_Lot_Id");

		aLots.setParam("List_Lot_Id", listLotId);
		aLots.initTree(initPagination);

	}	catch (e) {
		recup_erreur(e);
	}
}


function initPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('pageFin').value = (nbPages>0?nbPages:1);
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante>=nbPages); // peut se produire si nbPages=0

		afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPagePrec() {
	try {

		pageCourante--;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPageSuiv() {
	try {

		pageCourante++;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function majPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante==nbPages);

		document.getElementById('listeLots').disabled = true;

		qListNL.setParam("Current_Page", pageCourante);
		var result = qListNL.execute();
		var listLotId = result.responseXML.documentElement.getAttribute("List_Lot_Id");

		aLots.setParam("List_Lot_Id", listLotId);
		aLots.initTree(afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function afterMajPagination() {
	try {

		document.getElementById('listeLots').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}
