/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var ote_aPeriodes = new Arbre('ComboListe/combo-dernieresPeriodes.tmpl', 'ote-periode');
var ote_aModesReglements = new Arbre('ComboListe/combo-modesReglement.tmpl', 'ote-modeReglement');
var ote_aJournaux = new Arbre('ComboListe/combo-journaux.tmpl', 'ote-journal');
var ote_aEncaissements = new Arbre('Facturation/Transfert/list-transfertComptaEncaissement.tmpl', 'ote-encaissements');
var ote_aFormats = new Arbre('ComboListe/combo-formatsExportCompta.tmpl', 'ote-formatExport');


function ote_init() {
  try {

		document.getElementById('ote-typePeriode').value = 'P';
		document.getElementById('ote-dateDebut').disabled = true;
		document.getElementById('ote-dateFin').disabled = true;

		ote_aFormats.initTree(ote_initFormat);

	} catch (e) {
  	recup_erreur(e);
  }
}


function ote_initFormat() {
	try {
		document.getElementById('ote-formatExport').selectedIndex = 0;
		ote_aPeriodes.initTree(ote_initPeriode);
	} catch (e) {
		recup_erreur(e);
	}
}


function ote_initPeriode() {
  try {

		document.getElementById('ote-periode').selectedIndex = 0;
		ote_aModesReglements.setParam('Transfert_Enc', true);
		ote_aModesReglements.initTree(ote_initModeReglement);

	} catch (e) {
    recup_erreur(e);
  }
}


function ote_initModeReglement() {
  try {

  	document.getElementById('ote-modeReglement').selectedIndex=0;
  	ote_aJournaux.setParam('Type_Journal', 'TR');
  	ote_aJournaux.initTree(ote_initJournal);

	} catch (e) {
    recup_erreur(e);
  }
}


function ote_initJournal() {
  try {

		document.getElementById('ote-journal').selectedIndex = 0;
		document.getElementById('ote-journal').disabled = true;

		ote_aEncaissements.setParam('Comptabilise', false);
		ote_actualiserSelection();

	} catch (e) {
    recup_erreur(e);
  }
}


function ote_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			ote_actualiserSelection();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function ote_pressOnModeReglement() {
	try {

		var modeReglement = document.getElementById('ote-modeReglement').value;
		document.getElementById('ote-journal').disabled = isEmpty(modeReglement);

		if (isEmpty(modeReglement)) {
			document.getElementById('ote-journal').selectedIndex = 0;
		}
		else {
			var qGet = new QueryHttp("Facturation/Transfert/getJournalEncModeReglement.tmpl");
			qGet.setParam("Mode_Reg_Id", modeReglement);
			var result = qGet.execute();
			document.getElementById('ote-journal').value = result.responseXML.documentElement.getAttribute('Journal_Id');
		}

		ote_actualiserSelection();

	} catch (e) {
		recup_erreur(e);
	}
}


function ote_actualiserSelection() {
  try {

		var typePeriode = document.getElementById('ote-typePeriode').value;
		var periode = document.getElementById('ote-periode').value;
		var dateDebut = document.getElementById('ote-dateDebut').value;
		var dateFin = document.getElementById('ote-dateFin').value;
		var numClient = document.getElementById('ote-numClient').value;
		var numFournisseur = document.getElementById('ote-numFournisseur').value;
		var modeReglement = document.getElementById('ote-modeReglement').value;
		var nonTrans = document.getElementById('ote-chkAffEncTrans').checked;
		var statut = document.getElementById('ote-statut').value;

		if (typePeriode=="P" || (isDate(dateDebut) && isDate(dateFin) && isDateInterval(dateDebut, dateFin))) {
			ote_aEncaissements.clearParams();
			ote_aEncaissements.setParam('Type_Periode', typePeriode);
			ote_aEncaissements.setParam('Periode', periode);
			ote_aEncaissements.setParam('Date_Debut', dateDebut);
			ote_aEncaissements.setParam('Date_Fin', dateFin);
			ote_aEncaissements.setParam('Num_Client', numClient);
			ote_aEncaissements.setParam('Num_Fournisseur', numFournisseur);
			ote_aEncaissements.setParam('Mode_Reglement', modeReglement);
			ote_aEncaissements.setParam('Comptabilise', nonTrans?"":false);
			ote_aEncaissements.setParam('Statut', statut);
			ote_aEncaissements.initTree(ote_initListeEncaissements);
		}
		else {
			showWarning("Veuillez saisir un intervalle de dates valide !");
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ote_changerTypePeriode(tp) {
  try {

		var b = (tp=="P");
		document.getElementById('ote-dateDebut').disabled = b;
		document.getElementById('ote-dateFin').disabled = b;
		document.getElementById('ote-periode').disabled = !b;

	} catch (e) {
    recup_erreur(e);
  }
}


function ote_initListeEncaissements() {
	try {
		toutCocher('ote-encaissements', true);
	} catch (e) {
		recup_erreur(e);
	}
}


function ote_transferer() {
	try {
		ote_checkEncaissements("Transfert");
	} catch (e) {
		recup_erreur(e);
	}
}


function ote_checkEncaissements(type) {
  try {

  	var listboxEncaissements = document.getElementById("ote-encaissements");
		var listeEncaissementsClients="";
		var listeAnnulEncaissementsClients="";
		var listeEncaissementsFourn="";
		var listeAnnulEncaissementsFourn="";
		var nbLignes = listboxEncaissements.getRowCount();

		var i = 0;
		while (i<nbLignes) {
			var item = listboxEncaissements.getItemAtIndex(i);
			var cks = item.getElementsByTagName("listcell");
			if (cks.item(0).getAttribute("checked")=="true") {
				var typeTiers = cks.item(9).getAttribute("label");
				if (typeTiers=="C") {
					if (cks.item(8).getAttribute("label")=="V" || cks.item(8).getAttribute("label")=="C") { listeEncaissementsClients += item.value+","; }
					else { listeAnnulEncaissementsClients += item.value+","; }
				}
				else {
					if (cks.item(8).getAttribute("label")=="V") { listeEncaissementsFourn += item.value+","; }
					else { listeAnnulEncaissementsFourn += item.value+","; }
				}
			}
			i++;
		}

		if (!isEmpty(listeEncaissementsClients) || !isEmpty(listeAnnulEncaissementsClients) || !isEmpty(listeEncaissementsFourn) || !isEmpty(listeAnnulEncaissementsFourn)) {

			var journalId = document.getElementById('ote-journal').value;
			var modeReglement = document.getElementById('ote-modeReglement').value;

			if (modeReglement!="" && isEmpty(journalId)) { showWarning("Veuillez s\u00E9lectionner un code journal"); }
			else if (type=="Export" || window.confirm("Confirmez-vous le transfert en comptabilit\u00E9 des encaissements s\u00E9lectionn\u00E9s ?")) {
				if (type=="Transfert") { ote_transfererEncaissements(listeEncaissementsClients, listeAnnulEncaissementsClients, listeEncaissementsFourn, listeAnnulEncaissementsFourn, journalId); }
				else { ote_exporterEncaissements(listeEncaissementsClients, listeAnnulEncaissementsClients, listeEncaissementsFourn, listeAnnulEncaissementsFourn, journalId) }
			}

		} else {
			showWarning("Vous n'avez rien s\u00E9lectionn\u00E9 !");
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ote_transfererEncaissements(listeEncaissementsClients, listeAnnulEncaissementsClients, listeEncaissementsFourn, listeAnnulEncaissementsFourn, journalId) {
	try {

		document.getElementById('ote-bTransfert').disabled = true;
		document.getElementById('ote-bExporter').disabled = true;

		var qTrans = new QueryHttp("Facturation/Transfert/TransfertEncaissements.tmpl");
		qTrans.setParam('Journal_Id', journalId);
		qTrans.setParam('Liste_Encaissements_Clients', listeEncaissementsClients);
		qTrans.setParam('Liste_Annul_Encaissements_Clients', listeAnnulEncaissementsClients);
		qTrans.setParam('Liste_Encaissements_Fourn', listeEncaissementsFourn);
		qTrans.setParam('Liste_Annul_Encaissements_Fourn', listeAnnulEncaissementsFourn);
		var result = qTrans.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}

		ote_aEncaissements.initTree(ote_initListeEncaissements);

		document.getElementById('ote-bTransfert').disabled = false;
		document.getElementById('ote-bExporter').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function ote_rechercherClient() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', ote_retourRechercherClient);

	} catch (e) {
		recup_erreur(e);
	}
}

function ote_retourRechercherClient(codeClient) {
	try {
  	document.getElementById('ote-numClient').value = codeClient;
	} catch (e) {
		recup_erreur(e);
	}
}


function ote_rechercherFournisseur() {
	try {

		var url = "chrome://opensi/content/facturation/user/fournisseurs/popup-rechercheFournisseur.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', ote_retourRechercherFournisseur);

	} catch (e) {
		recup_erreur(e);
	}
}


function ote_retourRechercherFournisseur(codeFournisseur) {
	try {
  	document.getElementById('ote-numFournisseur').value = codeFournisseur;
	} catch (e) {
		recup_erreur(e);
	}
}


function ote_exporter() {
	try {
		formatExport = document.getElementById('ote-formatExport').value;
		if (isEmpty(formatExport)) { showWarning("Veuillez choisir un format d'export."); }
		else if (checkNomFichierExport(formatExport)) {
			ote_checkEncaissements("Export");
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function ote_exporterEncaissements(listeEncaissementsClients, listeAnnulEncaissementsClients, listeEncaissementsFourn, listeAnnulEncaissementsFourn, journalId) {
	try {

		document.getElementById('ote-bTransfert').disabled = true;
		document.getElementById('ote-bExporter').disabled = true;

		var qExport = new QueryHttp("Facturation/Transfert/exporterEcritures.tmpl");
		qExport.setParam('Type_Liste', "Encaissements");
		qExport.setParam('Format_Id', formatExport);
		qExport.setParam('Journal_Id', journalId);
		qExport.setParam('Liste_Encaissements_Clients', listeEncaissementsClients);
		qExport.setParam('Liste_Annul_Encaissements_Clients', listeAnnulEncaissementsClients);
		qExport.setParam('Liste_Encaissements_Fourn', listeEncaissementsFourn);
		qExport.setParam('Liste_Annul_Encaissements_Fourn', listeAnnulEncaissementsFourn);
		var result = qExport.execute();

		telechargerFichier(result);

		document.getElementById('ote-bTransfert').disabled = false;
		document.getElementById('ote-bExporter').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}

