/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var orts_aArticlesBR = new Arbre('Facturation/Transferts_Stocks/list-ligneBonReception.tmpl', 'orts-tArticlesBR');
var orts_aArticlesTS = new Arbre('Facturation/Transferts_Stocks/list-articlesNonReceptionnesTS.tmpl', 'orts-tArticlesTS');
var orts_aReceptions = new Arbre('Facturation/Transferts_Stocks/list-bonReception.tmpl', 'orts-tReceptions');
var orts_aDepotsReception = new Arbre('ComboListe/combo-depotsStock.tmpl', 'orts-depotReception');
var orts_aVersions = new Arbre('Facturation/Transferts_Stocks/list-versionBonReception.tmpl', 'orts-tVersions');
var orts_aRangement = new Arbre("Facturation/Transferts_Stocks/list-storeLigneBR.tmpl", "orts-tRangement");


var orts_modified = false;
var orts_actSuiviSerie;
var orts_actSuiviLot;
var orts_bonRecId;
var orts_transfertId;
var orts_etapeRangement;
var orts_currentDepotId;
var orts_statutReception;
var orts_mode;
var orts_etatBon;
var orts_etatTS;
var orts_soldeRec;
var orts_selectDepotReception;
var orts_modeSaisieNS;
var orts_actEmplacements;



function orts_init() {
  try {

		var config = getConfig();

		orts_actEmplacements = config.isActEmplacements();
		orts_actSuiviLot = config.isActSuiviLot();
		orts_actSuiviSerie = config.isActSuiviSerie();
		orts_modeSaisieNS = orts_actSuiviSerie;
		var actNbPieces = config.isActNbPieces();

		document.getElementById('orts-bConsultSerieLigne').collapsed = !orts_actSuiviSerie;
		document.getElementById('orts-boxSaisieSerie').collapsed = !orts_actSuiviSerie;
		document.getElementById('orts-bSwitchMode').collapsed = !orts_actSuiviSerie;
		document.getElementById('orts-boxSaisieCodeBarre').collapsed = orts_actSuiviSerie;

		if (!orts_actSuiviLot) {
			document.getElementById('orts-colNumLotBR').collapsed = true;
			document.getElementById('orts-colNumLotBR').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('orts-colDatePeremptionBR').collapsed = true;
			document.getElementById('orts-colDatePeremptionBR').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('orts-rowNumLot').collapsed = true;
			document.getElementById('orts-rowDLC').collapsed = true;
		}

		if (!actNbPieces) {
			document.getElementById('orts-colNbPiecesTS').collapsed = true;
			document.getElementById('orts-colNbPiecesTS').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('orts-colNbPiecesBR').collapsed = true;
			document.getElementById('orts-colNbPiecesBR').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('orts-rowNbPieces').collapsed = true;
		}

  } catch (e) {
  	recup_erreur(e);
  }
}


function orts_initDepotReception() {
	try {

		document.getElementById('orts-depotReception').value = orts_selectDepotReception;

	} catch (e) {
		recup_erreur(e);
	}
}


function orts_chargerDepotsReception(selection) {
	try {

		orts_selectDepotReception = selection;
		orts_aDepotsReception.setParam("Selection", selection);
		orts_aDepotsReception.initTree(orts_initDepotReception);

	} catch (e) {
		recup_erreur(e);
	}
}


function orts_start() {
	try {

		var qGet = new QueryHttp('Facturation/Transferts_Stocks/getFirstBRNonValide.tmpl');
		qGet.setParam("Transfert_Id", orts_transfertId);
		var result = qGet.execute();

		if (result.responseXML.documentElement.getAttribute("HasBRNonValide")=="true") {
			orts_bonRecId = result.responseXML.documentElement.getAttribute("Bon_Id");
			orts_chargerBon();
		}
		else {
			orts_nouveauBon();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orts_reinitialiser() {
	try {

		orts_mode = "C";
		orts_etatBon = "N";
		orts_modified = false;
		orts_etapeRangement = false;
		orts_currentDepotId = "";

		document.getElementById('orts-deckBonReception').selectedIndex = 0;
		document.getElementById('orts-tbBonReception').selectedIndex = 0;
		document.getElementById('orts-tabBon').setAttribute('image', null);
		document.getElementById('orts-numeroRG').value = "";
		document.getElementById('orts-numeroBR').value = "";
		document.getElementById('orts-tabVersions').collapsed = true;
		document.getElementById('orts-boxRangement').collapsed = true;

		orts_aVersions.deleteTree();
		orts_aReceptions.setParam("Transfert_Id", orts_transfertId);
		orts_aReceptions.initTree();

		document.getElementById('orts-numSerie').value = "";
		document.getElementById('orts-codeBarre').value = "";
		document.getElementById('orts-dateBR').value = "";
		document.getElementById('orts-dateRG').value = "";
		document.getElementById('orts-etat').value = "";
		document.getElementById('orts-commentairesFin').value = "";
		document.getElementById('orts-commentairesInt').value = "";
		document.getElementById('orts-numLot').value = "";
		document.getElementById('orts-datePeremption').value = "";
		document.getElementById('orts-nbPieces').value = "";
		document.getElementById('orts-quantite').value = "";
		document.getElementById('orts-creation').value = "";
		document.getElementById('orts-modification').value = "";
		document.getElementById('orts-document').value = "";

		document.getElementById('orts-bChoisirMentions').disabled = true;
		document.getElementById('orts-bAjouter').disabled = true;
		document.getElementById('orts-bToutAjouter').disabled = true;
		document.getElementById('orts-bEnlever').disabled = true;
		document.getElementById('orts-bToutEnlever').disabled = true;
		document.getElementById('orts-bEnregistrer').disabled = true;
		document.getElementById('orts-bGenererBR').disabled = true;
		document.getElementById('orts-bAnnuler').disabled = true;
		document.getElementById('orts-bSupprimer').disabled = true;
		document.getElementById('orts-bEditerBR').disabled = true;

		document.getElementById('orts-commentairesFin').disabled = true;
		document.getElementById('orts-commentairesInt').disabled = true;
		document.getElementById('orts-depotReception').disabled = true;
		document.getElementById('orts-numLot').disabled = true;
		document.getElementById('orts-datePeremption').disabled = true;
		document.getElementById('orts-nbPieces').disabled = true;
		document.getElementById('orts-quantite').disabled = true;
		document.getElementById('orts-bConsultSerieLigne').disabled = true;
		document.getElementById('orts-bOuvrirCommentairesCaches').disabled = true;

		document.getElementById('orts-bEditerBR').collapsed = true;
		document.getElementById('orts-boxSaisieSerie').collapsed = (!orts_modeSaisieNS || !orts_actSuiviSerie || orts_etatBon!="N");
		document.getElementById('orts-boxSaisieCodeBarre').collapsed = (orts_modeSaisieNS || orts_etatBon!="N");
		document.getElementById('orts-bSwitchMode').collapsed = (!orts_actSuiviSerie || orts_etatBon!="N");

		if (orts_etatBon=="N") {
			if (orts_modeSaisieNS) {
				document.getElementById('orts-numSerie').focus();
			}
			else {
				document.getElementById('orts-codeBarre').focus();
			}
		}

		orts_aArticlesBR.deleteTree();
		orts_aArticlesTS.deleteTree();
		orts_aRangement.deleteTree();

		// chargement des infos du transfert

		var qLoad = new QueryHttp('Facturation/Transferts_Stocks/loadTransfertStock.tmpl');
		qLoad.setParam('Transfert_Id', orts_transfertId);
		var result = qLoad.execute();
		orts_etatTS = result.responseXML.documentElement.getAttribute('Etat');
		orts_soldeRec = (result.responseXML.documentElement.getAttribute('Solde_Rec')=="true");
		document.getElementById('orts-numTransfert').value = result.responseXML.documentElement.getAttribute('Numero');

		document.getElementById('orts-bNouveau').disabled = (orts_etatTS=="C" || orts_etatTS=="A" || orts_soldeRec);

		orts_chargerDepotsReception(result.responseXML.documentElement.getAttribute('Depot_Arrivee'));

	} catch (e) {
		recup_erreur(e);
	}
}


function orts_debloquerChamps() {
	try {

		document.getElementById('orts-bChoisirMentions').disabled = false;
		document.getElementById('orts-bAjouter').disabled = false;
		document.getElementById('orts-bToutAjouter').disabled = false;
		document.getElementById('orts-bEnlever').disabled = false;

		document.getElementById('orts-commentairesFin').disabled = false;
		document.getElementById('orts-commentairesInt').disabled = false;
		document.getElementById('orts-depotReception').disabled = false;
		document.getElementById('orts-bEnregistrer').disabled = false;
		document.getElementById('orts-bSupprimer').disabled = false;

		document.getElementById('orts-bAjouter').disabled = true;
		document.getElementById('orts-bEnlever').disabled = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function orts_switchMode() {
	try {

		orts_modeSaisieNS = !orts_modeSaisieNS;
		document.getElementById('orts-boxSaisieSerie').collapsed = !orts_modeSaisieNS;
		document.getElementById('orts-boxSaisieCodeBarre').collapsed = orts_modeSaisieNS;
		if (orts_modeSaisieNS) {
			document.getElementById('orts-numSerie').focus();
		}
		else {
			document.getElementById('orts-codeBarre').focus();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function orts_nouveauBon() {
  try {

		orts_bonRecId = "";
		orts_reinitialiser();

		if (orts_etatTS!="C" && orts_etatTS!="A" && !orts_soldeRec) {
			orts_aArticlesTS.clearParams();
			orts_aArticlesTS.setParam('Transfert_Id', orts_transfertId);
			orts_aArticlesTS.initTree();

			document.getElementById('orts-bEditerBR').collapsed = false;
			document.getElementById('orts-bSupprimer').collapsed = true;
			document.getElementById('orts-bAnnuler').collapsed = true;
			orts_debloquerChamps();

			document.getElementById('orts-bEnregistrer').disabled = false;
			document.getElementById('orts-bGenererBR').disabled = true;
			document.getElementById('orts-bEditerBR').disabled = true;
			document.getElementById('orts-boxArticlesTS').collapsed = false;
			document.getElementById('orts-boxActions').collapsed = false;

			orts_setModified(false);
		}
		else {
			document.getElementById('orts-boxActions').collapsed = true;
			document.getElementById('orts-boxArticlesTS').collapsed = true;
			document.getElementById('orts-boxSaisieSerie').collapsed = true;
			document.getElementById('orts-boxSaisieCodeBarre').collapsed = true;
			document.getElementById('orts-bSwitchMode').collapsed = true;
			document.getElementById('orts-bGenererBR').collapsed = true;
			document.getElementById('orts-bSupprimer').collapsed = true;
			document.getElementById('orts-bAnnuler').collapsed = true;
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function orts_pressOnReceptions(ev) {
  try {

		if (ev.keyCode==13) {
			orts_bonRecId = orts_aReceptions.getSelectedCellText('orts-colBonId');
			orts_chargerBon();
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function orts_dblclickOnReceptions() {
  try {

		if (orts_aReceptions.isSelected()) {
			orts_bonRecId = orts_aReceptions.getSelectedCellText('orts-colBonId');
			orts_chargerBon();
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function orts_chargerBon() {
  try {

		orts_reinitialiser();
		orts_aArticlesBR.setParam('Bon_Id', orts_bonRecId);
		orts_aArticlesTS.setParam('Bon_Id', orts_bonRecId);

		document.getElementById('orts-bEditerBR').collapsed = false;

		orts_mode = "M";

		var qLoad = new QueryHttp('Facturation/Transferts_Stocks/loadBonReception.tmpl');
		qLoad.setParam("Bon_Rec_Id", orts_bonRecId);
		var result = qLoad.execute();
		var contenu = result.responseXML.documentElement;

		orts_etapeRangement = contenu.getAttribute("Etape_Rangement")=="true";
		orts_statutReception = contenu.getAttribute("Statut_Reception");
		orts_currentDepotId = contenu.getAttribute("Depot_Id");

		orts_etatBon = contenu.getAttribute("Etat");
		orts_chargerDepotsReception(contenu.getAttribute('Depot_Id'));

		if (orts_etatBon=="V") {
			document.getElementById('orts-etat').value = "Valid\u00E9";
			document.getElementById('orts-bSupprimer').collapsed = true;
			document.getElementById('orts-bAnnuler').collapsed = (orts_etatTS=="C");
			document.getElementById('orts-boxArticlesTS').collapsed = true;
			document.getElementById('orts-boxActions').collapsed = true;
			document.getElementById('orts-bAnnuler').disabled = (orts_etatTS=="C");
			if (orts_statutReception=="R" && orts_actEmplacements) {
				document.getElementById('orts-boxRangement').collapsed = false;
			}
		}
		else if (orts_etatBon=="A") {
			document.getElementById('orts-etat').value = "Annul\u00E9";
			document.getElementById('orts-bSupprimer').collapsed = true;
			document.getElementById('orts-bAnnuler').collapsed = true;
			document.getElementById('orts-boxArticlesTS').collapsed = true;
			document.getElementById('orts-boxActions').collapsed = true;
		}
		else {
			document.getElementById('orts-etat').value = "Non valid\u00E9";
			document.getElementById('orts-bAnnuler').collapsed = true;
			document.getElementById('orts-bSupprimer').collapsed = false;
			document.getElementById('orts-boxArticlesTS').collapsed = false;
			document.getElementById('orts-boxActions').collapsed = false;
			document.getElementById('orts-bNouveau').disabled = true;
		}

		if (orts_etatBon!="N") {
			document.getElementById('orts-tabVersions').collapsed = false;
			orts_initVersion();
		}
		else if (orts_modeSaisieNS) {
			document.getElementById('orts-numSerie').focus();
		}
		else {
			document.getElementById('orts-codeBarre').focus();
		}

		document.getElementById('orts-boxSaisieSerie').collapsed = (!orts_modeSaisieNS || !orts_actSuiviSerie || orts_etatBon!="N");
		document.getElementById('orts-boxSaisieCodeBarre').collapsed = (orts_modeSaisieNS || orts_etatBon!="N");
		document.getElementById('orts-bSwitchMode').collapsed = (!orts_actSuiviSerie || orts_etatBon!="N");

		document.getElementById('orts-dateRG').value = contenu.getAttribute("Date_RG");
		document.getElementById('orts-dateBR').value = contenu.getAttribute("Date_BR");
		document.getElementById('orts-commentairesFin').value = contenu.getAttribute("Commentaires_Fin");
		document.getElementById('orts-commentairesInt').value = contenu.getAttribute("Commentaires_Int");
		document.getElementById('orts-numeroRG').value = contenu.getAttribute("Numero_RG");
		document.getElementById('orts-numeroBR').value = contenu.getAttribute("Numero_BR");

		document.getElementById('orts-creation').setAttribute("label", "R\u00E9ception cr\u00E9\u00E9e le "+ contenu.getAttribute('Date_Creation') +" par "+ contenu.getAttribute('Login_Createur'));
		document.getElementById('orts-modification').setAttribute("label", "Derni\u00E8re modification le "+ contenu.getAttribute('Date_Maj') +" par "+ contenu.getAttribute('Login_Maj'));
		document.getElementById('orts-document').setAttribute("label", "Bon de r\u00E9ception N\u00B0 "+ contenu.getAttribute('Numero_BR'));
		document.getElementById('orts-creation').collapsed = false;
		document.getElementById('orts-modification').collapsed = false;

		document.getElementById('orts-bOuvrirCommentairesCaches').disabled = false;

		orts_aArticlesBR.initTree();

		orts_setModified(false);

		if (orts_etatBon!='V' && orts_etatBon!='A') {
			orts_aArticlesTS.setParam('Transfert_Id', orts_transfertId);
			orts_aArticlesTS.initTree();
			orts_debloquerChamps();
			document.getElementById('orts-bToutEnlever').disabled = false;
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function orts_editerCommentairesInternes()  {
  try {

  	var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesInternes.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', "BRT", orts_bonRecId, false);

	} catch (e) {
  	recup_erreur(e);
  }
}


function orts_editerCommentairesDocument() {
  try {

		var commentairesFin = document.getElementById('orts-commentairesFin').value;
		var commentairesInt = document.getElementById('orts-commentairesInt').value;
		var readOnly = (orts_etatBon!="N");

		var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesDocument.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', orts_retourEditerCommentaires, "BRT", orts_bonRecId, commentairesFin, commentairesInt, readOnly);

	} catch (e) {
    recup_erreur(e);
  }
}


function orts_retourEditerCommentaires(commentairesFin, commentairesInt) {
  try {

		document.getElementById('orts-commentairesFin').value = commentairesFin;
		document.getElementById('orts-commentairesInt').value = commentairesInt;

	} catch (e) {
    recup_erreur(e);
  }
}


function orts_enregistrerBon(rafraichir) {
  try {

		var ok = false;

		var commentairesFin = document.getElementById('orts-commentairesFin').value;
		var commentairesInt = document.getElementById('orts-commentairesInt').value;
		var depotId = document.getElementById('orts-depotReception').value;

		var qSave;

		if (orts_mode=="C") {
			qSave = new QueryHttp("Facturation/Transferts_Stocks/createBonReception.tmpl");
			qSave.setParam("Transfert_Id", orts_transfertId);
		}
		else {
			qSave = new QueryHttp("Facturation/Transferts_Stocks/updateBonReception.tmpl");
			qSave.setParam("Bon_Id", orts_bonRecId);
		}

		qSave.setParam("Depot_Id", depotId);
		qSave.setParam("Commentaires_Fin", commentairesFin);
		qSave.setParam("Commentaires_Int", commentairesInt);

		var result = qSave.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			if (orts_mode=="C") {
				orts_bonRecId = result.responseXML.documentElement.getAttribute("Bon_Id");

				if (rafraichir) {
					orts_chargerBon();
				}
			}
			orts_aReceptions.initTree();

			orts_setModified(false);
			ok = true;
		}

		return ok;

	} catch (e) {
  	recup_erreur(e);
  }
}


function orts_supprimerBon() {
  try {

		if (window.confirm("Confirmez-vous la suppression de la r\u00E9ception ?")) {

			var qDelete = new QueryHttp("Facturation/Transferts_Stocks/deleteBonReception.tmpl");
			qDelete.setParam("Bon_Id", orts_bonRecId);
			qDelete.execute();

			showMessage("La r\u00E9ception a \u00E9t\u00E9 supprim\u00E9e avec succ\u00E8s");
			orts_nouveauBon();
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function orts_toutTransferer() {
  try {

  	var ok = true;
		if (orts_mode=="C") {
			ok = orts_enregistrerBon(true);
		}
		if (ok) {
			var qAdd = new QueryHttp('Facturation/Transferts_Stocks/addAllBR.tmpl');
			qAdd.setParam("Bon_Id", orts_bonRecId);
			qAdd.setParam("Transfert_Id", orts_transfertId);
			qAdd.execute();

			orts_aArticlesTS.initTree();
			orts_aArticlesBR.initTree();

			document.getElementById('orts-nbPieces').value = "";
			document.getElementById('orts-quantite').value = "";
			document.getElementById('orts-numLot').value = "";
			document.getElementById('orts-datePeremption').value = "";

			document.getElementById('orts-bAjouter').disabled = true;
			document.getElementById('orts-bEnlever').disabled = true;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function orts_toutEnlever() {
  try {

		var qRemove = new QueryHttp('Facturation/Transferts_Stocks/removeAllBR.tmpl');
		qRemove.setParam("Bon_Id", orts_bonRecId);
		qRemove.execute();

		orts_aArticlesTS.initTree();
		orts_aArticlesBR.initTree();

		document.getElementById('orts-nbPieces').value = "";
		document.getElementById('orts-quantite').value = "";
		document.getElementById('orts-numLot').value = "";
		document.getElementById('orts-datePeremption').value = "";

		document.getElementById('orts-bAjouter').disabled = true;
		document.getElementById('orts-bEnlever').disabled = true;

		document.getElementById("orts-bConsultSerieLigne").disabled = true;

	} catch (e) {
  	recup_erreur(e);
	}
}


function orts_ajouter() {
  try {

		if (orts_aArticlesTS.isSelected()) {

			if (orts_aArticlesTS.nbSelection()==1) {

				var articleId = orts_aArticlesTS.getSelectedCellText('orts-colArticleIdTS');
				var ligneTS = orts_aArticlesTS.getSelectedCellText('orts-colLigneIdTS');
				var isSuiviLot = orts_aArticlesTS.getSelectedCellText('orts-colSuiviLotTS')=="true";
				var isSuiviDLC = orts_aArticlesTS.getSelectedCellText('orts-colSuiviDLCTS')=="true";
				var isSuiviSerie = orts_aArticlesTS.getSelectedCellText('orts-colSuiviSerieTS')=="true";
				var qteRestante = orts_aArticlesTS.getSelectedCellText('orts-colQuantiteTS');
				var nbPiecesRestant = orts_aArticlesTS.getSelectedCellText('orts-colNbPiecesTS');
				if (isEmpty(nbPiecesRestant)) { nbPiecesRestant = 0; }

				var quantite = document.getElementById('orts-quantite').value;
				var numLot = document.getElementById('orts-numLot').value;
				var datePeremption = document.getElementById('orts-datePeremption').value;
				var nbPieces = document.getElementById('orts-nbPieces').value;
				if (isEmpty(nbPieces)) { nbPieces = 0; }

				if (isEmpty(quantite)) { showWarning("Veuillez entrer une quantit\u00E9 \u00E0 transf\u00E9rer"); }
				else if (!checkQte(quantite)) { showWarning("Quantit\u00E9 incorrecte"); }
				else if (!isPositiveOrNullInteger(nbPieces)) { showWarning("Nombre de pi\u00E8ces incorrect");	}
				else if (parseFloat(qteRestante)-parseFloat(quantite)<0) { showWarning("La quantit\u00E9 \u00E0 transf\u00E9rer d\u00E9passe la quantit\u00E9 restant \u00E0 r\u00E9ceptionner"); }
				else if (parseFloat(nbPiecesRestant)-parseFloat(nbPieces)<0) { showWarning("Le nb de pi\u00E8ces \u00E0 transf\u00E9rer d\u00E9passe le nb de pi\u00E8ces restant \u00E0 r\u00E9ceptionner");	}
				else if (orts_checkNumLotLigne(numLot, datePeremption, articleId, isSuiviLot, isSuiviDLC)) {

					var ok = true;

					if (orts_mode=="C") {
						ok = orts_enregistrerBon(true);
					}

					if (ok) {
						var qAdd = new QueryHttp('Facturation/Transferts_Stocks/addLigneBR.tmpl');
						qAdd.setParam("Bon_Id", orts_bonRecId);
						qAdd.setParam("Ligne_TS", ligneTS);
						qAdd.setParam("Quantite", quantite);
						qAdd.setParam("Num_Lot", numLot);
						qAdd.setParam("Nb_Pieces", nbPieces);
						qAdd.setParam("Date_Peremption", datePeremption);
						var result = qAdd.execute();

						var ligneBR = result.responseXML.documentElement.getAttribute('Ligne_Id');
						var quantiteBR = parseIntBis(result.responseXML.documentElement.getAttribute('Quantite'));

						orts_aArticlesTS.initTree();
						orts_aArticlesBR.initTree();

						document.getElementById('orts-nbPieces').value = "";
						document.getElementById('orts-quantite').value = "";
						document.getElementById('orts-numLot').value = "";
						document.getElementById('orts-datePeremption').value = "";

						document.getElementById('orts-bAjouter').disabled = true;

						orts_checkNumSerieLigne(ligneBR, isSuiviSerie, quantiteBR);
					}
				}
			}
			else {
				var listLigneId = "";
				var rangeCount = orts_aArticlesTS.getRangeCount();

				for (var j=0; j<rangeCount; j++) {
					var start = {};
					var end = {};
					orts_aArticlesTS.getRangeAt(j,start,end);

					for (var c=start.value; c<=end.value; c++) {
						listLigneId += orts_aArticlesTS.getCellText(c, "orts-colLigneIdTS") +",";
					}
				}

				var ok = true;
				if (orts_mode=="C") {
					ok = orts_enregistrerBon(true);
				}
				if (ok) {
					var qAdd = new QueryHttp('Facturation/Transferts_Stocks/addAllBR.tmpl');
					qAdd.setParam("Bon_Id", orts_bonRecId);
					qAdd.setParam("Transfert_Id", orts_transfertId);
					qAdd.setParam("List_Ligne_Id", listLigneId);
					var result = qAdd.execute();

					var errors = new Errors(result);
					if (errors.hasNext()) {
						errors.show();
					}

					orts_aArticlesTS.initTree();
					orts_aArticlesBR.initTree();
					document.getElementById('orts-bAjouter').disabled = true;
				}
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function orts_enlever() {
  try {

		if (orts_aArticlesBR.isSelected()) {

			var ligneId = orts_aArticlesBR.getSelectedCellText('orts-colLigneIdBR');
			var qteInit = orts_aArticlesBR.getSelectedCellText('orts-colQuantiteBR');
			var quantite = document.getElementById('orts-quantite').value;
			var nbPiecesInit = orts_aArticlesBR.getSelectedCellText('orts-colNbPiecesBR');
			if (isEmpty(nbPiecesInit)) {
				nbPiecesInit = 0;
			}
			var nbPieces = document.getElementById('orts-nbPieces').value;
			if (isEmpty(nbPieces)) {
				nbPieces = 0;
			}

			if (isEmpty(quantite)) {
				showWarning("Veuillez entrer une quantit\u00E9 \u00E0 enlever");
			}
			else if (!checkQte(quantite)) {
				showWarning("Quantit\u00E9 incorrecte !");
			}
			else if (parseFloat(qteInit)-parseFloat(quantite)<0) {
				showWarning("La quantit\u00E9 \u00E0 enlever ne peut d\u00E9passer la quantit\u00E9 pr\u00E9sente dans le bon de r\u00E9ception !");
			}
			else if (!isPositiveOrNullInteger(nbPieces)) {
				showWarning("Nombre de pi\u00E8ces incorrect !");
			}
			else if (parseFloat(nbPiecesInit)-parseFloat(nbPieces)<0) {
				showWarning("Le nb de pi\u00E8ces \u00E0 enlever ne peut d\u00E9passer le nb de pi\u00E8ces pr\u00E9sent dans le bon de r\u00E9ception !");
			}
			else {
				var qRemove = new QueryHttp('Facturation/Transferts_Stocks/removeLigneBR.tmpl');
				qRemove.setParam("Ligne_Id", ligneId);
				qRemove.setParam("Quantite", quantite);
				qRemove.setParam("Nb_Pieces", nbPieces);
				qRemove.execute();

				orts_aArticlesTS.initTree();
				orts_aArticlesBR.initTree();

				document.getElementById('orts-nbPieces').value = "";
				document.getElementById('orts-quantite').value = "";
				document.getElementById('orts-numLot').value = "";
				document.getElementById('orts-datePeremption').value = "";

				document.getElementById('orts-bEnlever').disabled = true;

				document.getElementById("orts-bConsultSerieLigne").disabled = true;
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function orts_demandeEnregistrement() {
  try {

		if (orts_modified) {
			if (window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es au bon de r\u00E9ception ?")) {
				orts_enregistrerBon(false);
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function orts_setModified(modified) {
  try {

		orts_modified = modified;

		if (modified) {
			document.getElementById('orts-tabBon').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
			document.getElementById('orts-bGenererBR').disabled = true;
			document.getElementById('orts-bGenererRG').disabled = true;
			document.getElementById('orts-bEditerBR').disabled = true;
			document.getElementById('orts-bEditerRG').disabled = true;
		}
		else {
			document.getElementById('orts-tabBon').setAttribute('image', null);
			document.getElementById('orts-bGenererRG').disabled = orts_etatBon!='N';
			document.getElementById('orts-bGenererRG').collapsed = orts_mode=='C' || orts_etatBon!='N' || !orts_etapeRangement;
			document.getElementById('orts-bGenererBR').disabled = false;
			document.getElementById('orts-bGenererBR').collapsed = orts_mode=='C' || (orts_statutReception!='R' && (orts_etapeRangement || orts_etatBon!='N'));
			document.getElementById('orts-bEditerRG').disabled = false;
			document.getElementById('orts-bEditerRG').collapsed = orts_etatBon=='N';
			document.getElementById('orts-bEditerBR').disabled = false;
			document.getElementById('orts-bEditerBR').collapsed = orts_etatBon=='N' || orts_statutReception=='R' || isEmpty(document.getElementById('orts-dateBR').value);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function orts_initLangue() {
	try {

		document.getElementById('orts-langueDefaut').value = orts_langueDefaut;
		orts_editerBonReception();

	} catch (e) {
		recup_erreur(e);
	}
}


function orts_editerBonRangement() {
	try {

		document.getElementById('orts-pdfBonReception').setAttribute("src", "");
		document.getElementById("bRetourBR").collapsed = false;
		document.getElementById("orts-deckBonReception").selectedIndex = 1;
		document.getElementById('orts-bEnvoyer').collapsed = true;

		var qGenPdf = new QueryHttp("Facturation/Transferts_Stocks/pdfBonRangement.tmpl");
		qGenPdf.setParam('Bon_Rec_Id', orts_bonRecId);

		var result = qGenPdf.execute();
		var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');

		document.getElementById('orts-pdfBonReception').setAttribute("src", page);

	} catch (e) {
		recup_erreur(e);
	}
}


function orts_editerBonReception() {
	try {

		document.getElementById('orts-pdfBonReception').setAttribute("src", "");
		document.getElementById("bRetourBR").collapsed = false;
		document.getElementById("orts-deckBonReception").selectedIndex = 1;
		document.getElementById('orts-bEnvoyer').collapsed = false;

		var qGenPdf = new QueryHttp("Facturation/Transferts_Stocks/pdfBonReception.tmpl");
		qGenPdf.setParam('Bon_Id', orts_bonRecId);

		var result = qGenPdf.execute();
		var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');

		document.getElementById('orts-pdfBonReception').setAttribute("src", page);

	} catch (e) {
		recup_erreur(e);
	}
}


function orts_checkNumSerie() {
	try {

		var ok = true;

		var qCheck = new QueryHttp("Facturation/Transferts_Stocks/checkNumSerieBR.tmpl");
		qCheck.setParam("Bon_Id", orts_bonRecId);
		var result = qCheck.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			ok = false;
			errors.show();
		}

		return ok;

	} catch (e) {
		recup_erreur(e);
	}
}


function orts_checkNumLot() {
	try {

		var ok = true;

		var qCheck = new QueryHttp("Facturation/Transferts_Stocks/checkNumLotBR.tmpl");
		qCheck.setParam("Bon_Id", orts_bonRecId);
		var result = qCheck.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			ok = false;
			errors.show();
		}

		return ok;

	} catch (e) {
		recup_erreur(e);
	}
}


function orts_genererRG() {
  try {

		if (orts_aArticlesBR.nbLignes()<=0) {
			showWarning("La r\u00E9ception ne contient aucune ligne");
		}
		else if ((!orts_actSuiviSerie || orts_checkNumSerie()) && (!orts_actSuiviLot || orts_checkNumLot())
							&& window.confirm("Confirmez-vous la g\u00E9n\u00E9ration du bon de rangement ?")) {

			var qValid = new QueryHttp("Facturation/Transferts_Stocks/generateBonRangement.tmpl");
			qValid.setParam('Bon_Rec_Id', orts_bonRecId);
			var result = qValid.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				orts_editerBonRangement();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orts_genererBR() {
  try {

		if (orts_aArticlesBR.nbLignes()<=0) {
			showWarning("La r\u00E9ception ne contient aucune ligne");
		}
		else if ((!orts_actSuiviSerie || orts_checkNumSerie()) && (orts_statutReception=='R' || !orts_actSuiviLot || orts_checkNumLot())
							&& window.confirm("Confirmez-vous la g\u00E9n\u00E9ration du bon de r\u00E9ception ?\n(Attention le bon de r\u00E9ception valid\u00E9 ne pourra plus \u00EAtre modifi\u00E9 !)")) {

			var ok = true;

			if (orts_statutReception!='R') {
				var qValid = new QueryHttp("Facturation/Transferts_Stocks/generateBonRangement.tmpl");
				qValid.setParam('Bon_Rec_Id', orts_bonRecId);
				var result = qValid.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					ok = false;
					errors.show();
				}
			}

			if (ok) {
				var qValid = new QueryHttp("Facturation/Transferts_Stocks/generateBonReception.tmpl");
				qValid.setParam('Bon_Rec_Id', orts_bonRecId);
				var result = qValid.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					orts_editerBonReception();
				}
			}
  	}

	} catch (e) {
    recup_erreur(e);
  }
}


function orts_annulerBon() {
  try {

		if (window.confirm("Confirmez-vous l'annulation de la r\u00E9ception ?")) {

			var qCancel = new QueryHttp("Facturation/Transferts_Stocks/cancelBonReception.tmpl");
			qCancel.setParam('Bon_Id', orts_bonRecId);
			qCancel.execute();

			showMessage("La r\u00E9ception a \u00E9t\u00E9 annul\u00E9e");

			orts_chargerBon();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function orts_choisirMentions() {
  try {

  	var ok = true;

  	if (orts_mode=="C") {
			ok = orts_enregistrerBon(true);
		}

		if (ok) {
			var url = "chrome://opensi/content/facturation/user/commun/popup-mentionsDocument.xul";
	    window.openDialog(url,'','chrome,modal,centerscreen', "BRT", orts_bonRecId, false);
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function orts_initVersion() {
	try {

		orts_aVersions.setParam("Bon_Id", orts_bonRecId);
		orts_aVersions.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function orts_selectLigneBR()  {
	try {

		if (orts_aArticlesBR.isSelected()) {
			document.getElementById('orts-nbPieces').value = orts_aArticlesBR.getSelectedCellText('orts-colNbPiecesBR');
			document.getElementById('orts-quantite').value = orts_aArticlesBR.getSelectedCellText('orts-colQuantiteBR');
			document.getElementById('orts-numLot').value = "";
			document.getElementById('orts-datePeremption').value = "";
			document.getElementById('orts-nbPieces').disabled = false;
			document.getElementById('orts-quantite').disabled = false;
			document.getElementById('orts-numLot').disabled = true;
			document.getElementById('orts-datePeremption').disabled = true;
			document.getElementById('orts-bEnlever').disabled = false;
			document.getElementById('orts-bAjouter').disabled = true;
			document.getElementById('orts-bConsultSerieLigne').disabled = false;
			orts_aArticlesTS.clearSelection();

			if (orts_etatBon=="V" && orts_statutReception=="R") {
				orts_aRangement.setParam("Ligne_Id", orts_aArticlesBR.getSelectedCellText('orts-colLigneIdBR'));
				orts_aRangement.initTree();
				orts_resetTransfertRangement();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orts_selectLigneTS() {
	try {

		if (orts_aArticlesTS.isSelected()) {
			if (orts_aArticlesTS.nbSelection()==1) {
				document.getElementById('orts-nbPieces').value = orts_aArticlesTS.getSelectedCellText('orts-colNbPiecesTS');
				document.getElementById('orts-quantite').value = orts_aArticlesTS.getSelectedCellText('orts-colQuantiteTS');
				document.getElementById('orts-nbPieces').disabled = false;
				document.getElementById('orts-quantite').disabled = false;
				document.getElementById('orts-numLot').disabled = false;
				document.getElementById('orts-datePeremption').disabled = false;
			}
			else {
				document.getElementById('orts-nbPieces').value = "";
				document.getElementById('orts-quantite').value = "";
				document.getElementById('orts-nbPieces').disabled = true;
				document.getElementById('orts-quantite').disabled = true;
				document.getElementById('orts-numLot').disabled = true;
				document.getElementById('orts-datePeremption').disabled = true;
			}

			document.getElementById('orts-numLot').value = "";
			document.getElementById('orts-datePeremption').value = "";
			document.getElementById('orts-bAjouter').disabled = false;
			document.getElementById('orts-bEnlever').disabled = true;
			orts_aArticlesBR.clearSelection();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orts_checkNumSerieLigne(ligneId, isSuiviSerie, quantite) {
	try {

		if (orts_actSuiviSerie) {
			var qNbSerie = new QueryHttp("Facturation/Transferts_Stocks/getNbNumSerieLigneBR.tmpl");
			qNbSerie.setParam("Ligne_Id", ligneId);
			var resNS = qNbSerie.execute();
			var nb = parseIntBis(resNS.responseXML.documentElement.getAttribute("Nombre"));
			if ((isSuiviSerie && nb!=quantite) || nb>quantite) {
				var depotId = document.getElementById('orts-depotReception').value;
				var url = "chrome://opensi/content/facturation/user/commun/popup-numSerie.xul";
		    window.openDialog(url,'','chrome,modal,centerscreen', "S", "BRT", ligneId, depotId);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orts_consulterNumSerie()  {
	try {

		if (orts_aArticlesBR.isSelected()) {
			var ligneId = orts_aArticlesBR.getSelectedCellText('orts-colLigneIdBR');
			var depotId = document.getElementById('orts-depotReception').value;
			var url = "chrome://opensi/content/facturation/user/commun/popup-numSerie.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', (orts_etatBon=="A" || orts_statutReception=="C"?"C":"S"), "BRT", ligneId, depotId);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orts_checkNumLotLigne(numero, datePeremption, articleId, isSuiviLot, isSuiviDLC) {
	try {

		var ok = true;

		if (orts_actSuiviLot && !isEmpty(articleId)) {

			if ((isSuiviLot || !isEmpty(datePeremption)) && isEmpty(numero)) {
				ok = false;
				showWarning("N\u00B0 Lot manquant");
			}
			else if (isSuiviDLC && isEmpty(datePeremption)) {
				ok = false;
				showWarning("Date de p\u00E9remption manquante");
			}
			else if (!isEmpty(datePeremption) && !isDate(datePeremption)) {
				ok = false;
				showWarning("Date de p\u00E9remption incorrecte");
			}
		}

		return ok;

	} catch (e) {
		recup_erreur(e);
	}
}


function orts_pressOnNumLot(ev) {
	try {

		if (ev.keyCode==13 && orts_aArticlesTS.isSelected()) {
			var articleId = orts_aArticlesTS.getSelectedCellText('orts-colArticleIdTS');
			var numero = document.getElementById("orts-numLot").value;
			var depotId = document.getElementById('orts-depotReception').value;

			var url = "chrome://opensi/content/facturation/user/tracabilite_articles/popup-rechercheLot.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', orts_retourRechercherLot, articleId, numero, depotId, null);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orts_retourRechercherLot(numero, datePeremption) {
	try {

		document.getElementById("orts-numLot").value = numero;
		document.getElementById("orts-datePeremption").value = datePeremption;

	} catch (e) {
		recup_erreur(e);
	}
}


function orts_updateDLC() {
	try {

		if (orts_aArticlesTS.isSelected()) {
			var numero = document.getElementById("orts-numLot").value;
			var articleId = orts_aArticlesTS.getSelectedCellText('orts-colArticleIdTS');

			if (!isEmpty(numero) && !isEmpty(articleId)) {
				var qGetDLC = new QueryHttp("Facturation/Tracabilite/getDLCNumLot.tmpl");
				qGetDLC.setParam("Article_Id", articleId);
				qGetDLC.setParam("Numero", numero);
				var result = qGetDLC.execute();
				var datePeremption = result.responseXML.documentElement.getAttribute("Date_Peremption");
				if (!isEmpty(datePeremption)) {
					document.getElementById("orts-datePeremption").value = datePeremption;
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orts_pressOnNumSerie(ev) {
	try {

		if (ev.keyCode==13) {
			orts_validerSaisieBySerie();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orts_validerSaisieBySerie(ligneId) {
	try {

		var listLigneTS = ligneId;

		if (listLigneTS==null) {
			listLigneTS = "";
			var nbLignes = orts_aArticlesTS.nbLignes();
			for (i=0; i<nbLignes; i++) {
				if (parseFloat(orts_aArticlesTS.getCellText(i, 'orts-colQuantiteTS'))>0) {
					listLigneTS += orts_aArticlesTS.getCellText(i, 'orts-colLigneIdTS') +",";
				}
			}
		}

		var numSerie = document.getElementById("orts-numSerie").value;

		if (!isEmpty(numSerie)) {

			var ok = true;
			if (orts_mode=="C") {
				ok = orts_enregistrerBon(true);
			}
			if (ok) {
				var qAjouterNumSerie = new QueryHttp('Facturation/Transferts_Stocks/addNumSerieBR.tmpl');
				qAjouterNumSerie.setParam("Bon_Id", orts_bonRecId);
				qAjouterNumSerie.setParam("Num_Serie", numSerie);
				qAjouterNumSerie.setParam("List_Ligne_TS", listLigneTS);
				var result = qAjouterNumSerie.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					var conflit = (result.responseXML.documentElement.getAttribute("Conflit")=="true");
					if (conflit) {
						var listConflit = result.responseXML.documentElement.getAttribute("List_Conflit");
						var url = "chrome://opensi/content/facturation/user/transferts_stocks/popup-conflitNumSerieTS.xul";
			      window.openDialog(url,'','chrome,modal,centerscreen', listConflit, orts_retourChoixConflit);
					}
					else {
						orts_aArticlesTS.initTree();
						orts_aArticlesBR.initTree();
						document.getElementById("orts-numSerie").value = "";
					}
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orts_retourChoixConflit(ligneId) {
	try {

		orts_validerSaisieBySerie(ligneId);

	} catch (e) {
		recup_erreur(e);
	}
}


function orts_pressOnCodeBarre(ev) {
	try {

		if (ev.keyCode==13) {
			orts_validerSaisieByCodeBarre();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orts_validerSaisieByCodeBarre() {
	try {

		var listLigneTS = "";
		var nbLignes = orts_aArticlesTS.nbLignes();
		for (i=0; i<nbLignes; i++) {
			if (parseFloat(orts_aArticlesTS.getCellText(i, 'orts-colQuantiteTS'))>0) {
				listLigneTS += orts_aArticlesTS.getCellText(i, 'orts-colLigneIdTS') +",";
			}
		}

		var codeBarre = document.getElementById("orts-codeBarre").value;

		if (!isEmpty(codeBarre)) {

			var ok = true;
			if (orts_mode=="C") {
				ok = orts_enregistrerBon(true);
			}
			if (ok) {
				var qAjouterCodeBarre = new QueryHttp('Facturation/Transferts_Stocks/addCodeBarreBR.tmpl');
				qAjouterCodeBarre.setParam("Bon_Id", orts_bonRecId);
				qAjouterCodeBarre.setParam("Code_Barre", codeBarre);
				qAjouterCodeBarre.setParam("List_Ligne_TS", listLigneTS);
				var result = qAjouterCodeBarre.execute();

				var errors = new Errors(result);

				if (errors.hasNext()) {
					errors.show();
				}
				else {
					orts_aArticlesTS.initTree();
					orts_aArticlesBR.initTree();
					document.getElementById("orts-codeBarre").value = "";
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orts_envoyerMail() {
	try {

		var url = "chrome://opensi/content/popup/popup-envoyerMail.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', "BRT", orts_bonRecId);

	} catch (e) {
		recup_erreur(e);
	}
}


// RANGEMENT


function orts_pressOnRangement() {
	try {

		if (orts_aRangement.isSelected()) {
			document.getElementById("orts-quantiteRG").value = orts_aRangement.getSelectedCellText("orts-colQuantiteRG");
			document.getElementById("orts-emplacementInitRG").value = orts_aRangement.getSelectedCellText("orts-colCodeEmplacementRG");
			document.getElementById("orts-bValiderRG").disabled = false;
			document.getElementById("orts-codeEmplacementRG").disabled = false;
			document.getElementById("orts-quantiteRG").disabled = false;
			document.getElementById("orts-bRechercherEmplacementRG").disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orts_resetTransfertRangement() {
	try {

		document.getElementById("orts-emplacementInitRG").value = "";
		document.getElementById("orts-codeEmplacementRG").value = "";
		document.getElementById("orts-quantiteRG").value = "";

		document.getElementById("orts-bValiderRG").disabled = true;
		document.getElementById("orts-codeEmplacementRG").disabled = true;
		document.getElementById("orts-quantiteRG").disabled = true;
		document.getElementById("orts-bRechercherEmplacementRG").disabled = true;

	} catch (e) {
		recup_erreur(e);
	}
}


function orts_validerTransfertRangement() {
	try {

		if (orts_aRangement.isSelected()) {
			var storeId = orts_aRangement.getSelectedCellText("orts-colStoreIdRG");
			var qteInit = orts_aRangement.getSelectedCellText("orts-colQuantiteRG");
			var emplacementInit = document.getElementById("orts-emplacementInitRG").value;
			var codeEmplacement = document.getElementById("orts-codeEmplacementRG").value;
			var quantite = document.getElementById("orts-quantiteRG").value;

			if (isEmpty(codeEmplacement)) {
				showWarning("Emplacement incorrect");
			}
			else if (codeEmplacement==emplacementInit) {
				showWarning("Emplacement incorrect");
			}
			else if (!isPositive(quantite)) {
				showWarning("Quantit\u00E9 incorrecte");
			}
			else if (parseFloat(quantite)>parseFloat(qteInit)) {
				showWarning("Quantit\u00E9 incorrecte");
			}
			else {
				var emplacementId = orts_getEmplacementId(codeEmplacement);

				if (isEmpty(emplacementId)) {
					showWarning("Emplacement inexistant");
				}
				else {
					var qTransfer = new QueryHttp("Facturation/Transferts_Stocks/transferStoreLigneBR.tmpl");
					qTransfer.setParam("Store_Id", storeId);
					qTransfer.setParam("Emplacement_Id", emplacementId);
					qTransfer.setParam("Quantite", quantite);

					var result = qTransfer.execute();

					var errors = new Errors(result);
					if (errors.hasNext()) {
						errors.show();
					}

					orts_aRangement.initTree();
					orts_resetTransfertRangement();
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orts_getEmplacementId(codeEmplacement) {
	try {

		var qGet = new QueryHttp("Facturation/Emplacements/getEmplacementId.tmpl");
		qGet.setParam("Depot_Id", orts_currentDepotId);
		qGet.setParam("Code_Emplacement", codeEmplacement);

		var result = qGet.execute();

		return result.responseXML.documentElement.getAttribute('Emplacement_Id');

	} catch (e) {
		recup_erreur(e);
	}
}


function orts_rechercherEmplacement() {
	try {

		var reference = null;

		if (orts_aArticlesBR.isSelected()) {
			reference = orts_aArticlesBR.getSelectedCellText('orts-colReferenceBR');
		}

		var url = "chrome://opensi/content/facturation/user/emplacements/popup-rechercheEmplacement.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', orts_retourRechercherEmplacement, orts_currentDepotId, reference);

	} catch (e) {
		recup_erreur(e);
	}
}


function orts_retourRechercherEmplacement(codeEmplacement, emplacementId) {
	try {

  	document.getElementById('orts-codeEmplacementRG').value = codeEmplacement;

	} catch (e) {
		recup_erreur(e);
	}
}


