/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

/*
 * bibliothque de fonctions pour la gestion d'arbres RDF.
 *
 * charger util.js pralablement
 */


jsLoader.loadSubScript("chrome://opensi/content/libs/load_rdf.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/param.js");


function Arbre(tmpl, id) {

	this.urlRdf = getUrlOpeneas("&Page="+ tmpl +"&ContentType=xml");
	this.treeId = id;
	this.params = "";
	this.plist = new Array();
}


Arbre.prototype.initTree = function(callBackFunction, callBackParams) {

	this.deleteTree();

	this.buildUrlParam();

	if (callBackFunction==undefined) {
  	load_rdf(this.treeId, this.urlRdf + this.params);
	}
	else {
		load_rdf_async(this.treeId, this.urlRdf + this.params, callBackFunction, callBackParams);
	}
}


Arbre.prototype.deleteTree = function() {

	if (this.isSelected()) {
		this.select(-1);
	}

	var database = document.getElementById(this.treeId).database;
  var datasources = database.GetDataSources();
  while (datasources.hasMoreElements()) {
  	var ds = datasources.getNext();
    database.RemoveDataSource(ds);
  }
	document.getElementById(this.treeId).builder.rebuild();
}


Arbre.prototype.setParam = function(pname, pvalue) {

	var param = this.getParam(pname);

	if (param==undefined) {
		this.addParam(pname, pvalue);
	}
	else {
		param.setValue(pvalue);
	}
}


Arbre.prototype.addParam = function(pname, pvalue) {

	this.plist.push(new Param(pname, pvalue));
}


Arbre.prototype.removeParam = function(pname) {

	var trouve = false;
	var i = 0;

	while (!trouve && i<this.plist.length) {

		trouve = (this.plist[i].pname==pname);
		i++;
	}

	if (trouve) {
		this.plist.splice(i-1,1);
	}
}


Arbre.prototype.getParam = function(pname) {

	var trouve = false;
	var i = 0;

	while (!trouve && i<this.plist.length) {
		trouve = this.plist[i].pname==pname;
		i++;
	}

	return (trouve?this.plist[i-1]:undefined);
}


Arbre.prototype.clearParams = function() {

	this.plist.length = 0;
}


Arbre.prototype.nbParams = function() {

	return this.plist.length;
}


Arbre.prototype.buildUrlParam = function() {

	this.params = "";

	for (var i=0; i<this.plist.length; i++)
		this.params += this.plist[i].getUrlParam();
}


Arbre.prototype.select = function(numline) {
	if (this.isNotNull()) {
		document.getElementById(this.treeId).view.selection.select(numline);
	}
}

Arbre.prototype.selectAll = function() {
	if (this.isNotNull()) {
		document.getElementById(this.treeId).view.selection.selectAll();
	}
}

Arbre.prototype.clearSelection = function() {
	if (this.isNotNull()) {
		this.select(-1);
	}
}

Arbre.prototype.getRangeCount = function() {
	return (this.isNotNull()?document.getElementById(this.treeId).view.selection.getRangeCount():0);
}

Arbre.prototype.getRangeAt = function(i, start, end) {
	return document.getElementById(this.treeId).view.selection.getRangeAt(i, start, end);
}

Arbre.prototype.nbSelection = function() {
	return (this.isNotNull()?document.getElementById(this.treeId).view.selection.count:0);
}

Arbre.prototype.isNotNull = function() {
	return (document.getElementById(this.treeId)!=null && document.getElementById(this.treeId).view!=null);
}

Arbre.prototype.getCurrentIndex = function() {
	return (this.isSelected()?document.getElementById(this.treeId).currentIndex:-1);
}

Arbre.prototype.isSelected = function() {
	return (this.isNotNull() && document.getElementById(this.treeId).currentIndex!=-1);
}

Arbre.prototype.nbLignes = function() {
	return (this.isNotNull()?document.getElementById(this.treeId).view.rowCount:0);
}

Arbre.prototype.getSelectedCellText = function(idcolumn) {
	return this.getCellText(document.getElementById(this.treeId).currentIndex,idcolumn);
}

Arbre.prototype.getSelectedCellValue = function(idcolumn) {
	return this.getCellValue(document.getElementById(this.treeId).currentIndex,idcolumn);
}

Arbre.prototype.getCellText = function(idligne,idcolumn) {
	return (this.isNotNull() && idligne!=-1?document.getElementById(this.treeId).view.getCellText(idligne,document.getElementById(this.treeId).columns.getNamedColumn(idcolumn)):"");
}

Arbre.prototype.getCellValue = function(idligne,idcolumn) {
	return (this.isNotNull() && idligne!=-1?document.getElementById(this.treeId).view.getCellValue(idligne,document.getElementById(this.treeId).columns.getNamedColumn(idcolumn)):"");
}

Arbre.prototype.getItem = function(idligne) {
	return (idligne!=-1?document.getElementById(this.treeId).view.getItemAtIndex(idligne):null);
}

Arbre.prototype.getCell = function(idligne,idcolumn) {
	return document.getElementById(this.treeId).view.getItemAtIndex(idligne).firstChild.childNodes[document.getElementById(this.treeId).columns.getNamedColumn(idcolumn).index];
}

Arbre.prototype.setCellSrc = function(idligne,idcolumn,val) {
	if (this.isNotNull() && idligne!=-1 && idligne<this.nbLignes()) {
		document.getElementById(this.treeId).view.getItemAtIndex(idligne).firstChild.childNodes[document.getElementById(this.treeId).columns.getNamedColumn(idcolumn).index].setAttribute("src", val);
	}
}

Arbre.prototype.setCellValue = function(idligne,idcolumn,val) {
	if (this.isNotNull()) {
		document.getElementById(this.treeId).view.setCellValue(idligne, document.getElementById(this.treeId).columns.getNamedColumn(idcolumn), val);
	}
}

Arbre.prototype.setCellText = function(idligne,idcolumn,val) {
	if (this.isNotNull()) {
		document.getElementById(this.treeId).view.setCellText(idligne, document.getElementById(this.treeId).columns.getNamedColumn(idcolumn), val);
	}
}

Arbre.prototype.setSelectedCellText = function(idcolumn,val) {
	this.setCellText(document.getElementById(this.treeId).currentIndex,idcolumn,val);
}

Arbre.prototype.setSelectedCellValue = function(idcolumn,val) {
	this.setCellValue(document.getElementById(this.treeId).currentIndex,idcolumn,val);
}

Arbre.prototype.isEditable = function(idligne,idcolumn) {
	return (idligne!=-1?document.getElementById(this.treeId).view.isEditable(idligne, document.getElementById(this.treeId).columns.getNamedColumn(idcolumn)):false);
}

Arbre.prototype.ensureRowIsVisible = function(idligne) {
	if (this.isNotNull() && idligne>=0) {
		document.getElementById(this.treeId).treeBoxObject.ensureRowIsVisible(idligne);
	}
}

Arbre.prototype.toggleOpenState = function(idligne) {
	if (idligne!=-1) {
		document.getElementById(this.treeId).view.toggleOpenState(idligne);
	}
}

Arbre.prototype.isSorted = function() {
	var columnSorted = document.getElementById(this.treeId).columns.getSortedColumn();
	return columnSorted!=null && columnSorted.element.getAttribute('sortDirection')!="natural" && columnSorted.element.getAttribute('sortDirection')!="";
}

Arbre.prototype.isSeparator = function(idligne) {
	return (this.isNotNull() && idligne>=0?document.getElementById(this.treeId).view.isSeparator(idligne):false);
}

Arbre.prototype.getClickedCol = function(ev) {
	var colObj = new Object();
	document.getElementById(this.treeId).treeBoxObject.getCellAt(ev.clientX, ev.clientY, new Object(), colObj, new Object());
	return colObj.value;
}

Arbre.prototype.getClickedRowIndex = function(ev) {
	var rowObj = new Object();
	document.getElementById(this.treeId).treeBoxObject.getCellAt(ev.clientX, ev.clientY, rowObj, new Object(), new Object());
	return rowObj.value;
}
