
var OpenDownloadDialog = {

  QueryInterface: function(iid) {
     if (!iid.equals(Components.interfaces.nsITimerCallback) &&
         !iid.equals(Components.interfaces.nsISupports)) {
       throw Components.results.NS_ERROR_NO_INTERFACE;
     }
     return this;
  },

  // Init Dialog
  initDialog: function(event) {
	  // Most likely an executable
    if (dialog.dialogElement("normalBox").collapsed) {
		  // Add 'Run' button
		  var acceptBtn = dialog.mDialog.document.documentElement.getButton("accept");
		  var btn = dialog.mDialog.document.createElement("button");
		  btn.setAttribute("class", "dialog-button");
      btn.setAttribute("id", "open-download");
		  btn.setAttribute("label", "Executer");
      btn.setAttribute("disabled", "true");
		  btn.setAttribute("oncommand", "OpenDownloadDialog.onCommand()");
		  acceptBtn.parentNode.insertBefore(btn, acceptBtn);
      var label = dialog.dialogElement("basicBox").getElementsByTagName('label')[0];
      if (label.getAttribute("value") == "Would you like to save this file?")
        label.setAttribute("value", "Would you like to open or save this file?");
      this._showTimer = Components.classes["@mozilla.org/timer;1"]
                                  .createInstance(Components.interfaces.nsITimer);
      this._showTimer.initWithCallback(this, 250, Components.interfaces.nsITimer.TYPE_ONE_SHOT);
    }
  },

  // Do the download work
  openDownload: function() {
    // Remove the web progress listener (this must be done before the download starts)
    dialog.mLauncher.setWebProgressListener(null);
    var listener = Components.classes["@mozmonkey.com/opendownload/listeners;1"].getService().wrappedJSObject;
    // Local File
	  if (dialog.mLauncher.source instanceof Components.interfaces.nsIFileURL) {
		  // Open
		  var localFile = Components.classes["@mozilla.org/file/local;1"].getService(Components.interfaces.nsILocalFile);
		  localFile.initWithPath(dialog.mLauncher.source.file.path);
      listener.launchFile(localFile);
	  }
    else {
	    // Create Temp file that does not currently exists
	    var props = Components.classes["@mozilla.org/file/directory_service;1"].getService(Components.interfaces.nsIProperties);
	    var file	= (props.get("TmpD", Components.interfaces.nsIFile));
      file.append(dialog.mLauncher.suggestedFileName);

      if (!file.exists()) {
	      listener.addDownload(file.path);
        // Save
        dialog.mLauncher.saveToDisk(file, false);

        var externalAppLauncher = Components.classes["@mozilla.org/uriloader/external-helper-app-service;1"].getService(Components.interfaces.nsPIExternalAppLauncher);
        externalAppLauncher.deleteTemporaryFileOnExit(file);
      }
      else {
        listener.launchFile(file);
      }
    }
    dialog.mDialog.dialog = null;
    // Close up dialog by returning true.
    return true;
  },

  notify: function(timer) {
    if (timer == this._showTimer) {
      // The user may have already canceled the dialog.
      try {
        if (!dialog._blurred) {
          dialog.dialogElement("open-download").disabled = false;
        }
      } catch (e) {}
      // The timer won't release us, so we have to release it.
      this._showTimer = null;
    }
  },

  onCommand: function() {
    dialog.mDialog.document.documentElement.setAttribute("ondialogaccept", "return OpenDownloadDialog.openDownload()");
    dialog.mDialog.document.documentElement.acceptDialog();
  },

  onBlur: function(event) {
	if(dialog && dialog.dialogElement("open-download")) {
		dialog.dialogElement("open-download").disabled = true;
	}
  },

  onFocus: function(event) {
    if (dialog._delayExpired) {
      var script = "document.getElementById('open-download').disabled = false";
      dialog.mDialog.setTimeout(script, 250);
    }
  }
};

dialog.mDialog.addEventListener("blur", function(event) { OpenDownloadDialog.onBlur(event); }, false);
dialog.mDialog.addEventListener("focus", function(event) { OpenDownloadDialog.onFocus(event); }, false);
dialog.mDialog.addEventListener("load", function(event) { OpenDownloadDialog.initDialog(event); }, false);
