/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var ofd_dossierId;
var ofd_modified = false;
var ofd_mode;
var ofd_precDateDebut = "";



function ofd_init() {
  try {


	} catch (e) {
  	recup_erreur(e);
	}
}


function ofd_initIHM() {
	try {

		document.getElementById('ofd-panneau').selectedIndex = 0;

		document.getElementById("ofd-codeDossier").disabled = ofd_mode=="M";

		document.getElementById('ofd-tabInit').collapsed = true;
		document.getElementById('ofd-tabFiche').collapsed = false;

		document.getElementById('ofd-bSupprimer').collapsed = ofd_mode=="C";
		document.getElementById('ofd-rowSuppression').collapsed = ofd_mode=="C";
		document.getElementById('ofd-rowDebutExercice').collapsed = ofd_mode=="M";
		document.getElementById('ofd-rowFinExercice').collapsed = ofd_mode=="M";

		ofd_setModified(false);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofd_nouveauDossier() {
  try {

		ofd_mode = "C";
		ofd_dossierId = "";
		ofd_precDateDebut = "";

		document.getElementById('ofd-lblDossier').value = "Fiche dossier";

		document.getElementById("ofd-codeDossier").value = "";
		document.getElementById("ofd-actif").checked = true;
		document.getElementById("ofd-nom").value = "";
		document.getElementById("ofd-type").value = "P";
		document.getElementById("ofd-numClient").value = "";
		document.getElementById("ofd-commentaires").value = "";
		document.getElementById("ofd-debutExercice").value = "";
		document.getElementById("ofd-finExercice").value = "";

		document.getElementById('ofd-codeDossier').focus();

		ofd_initIHM();

	} catch (e) {
  	recup_erreur(e);
  }
}


function ofd_chargerDossier() {
  try {

		ofd_mode = "M";

		var qLoad = new QueryHttp("Superviseur/dossiers/loadDossier.tmpl");
		qLoad.setParam('Dossier_Id', ofd_dossierId);
		var result = qLoad.execute();

		var contenu = result.responseXML.documentElement;

		document.getElementById('ofd-lblDossier').value = "Fiche dossier "+ contenu.getAttribute('Code_Dossier');

		document.getElementById("ofd-codeDossier").value = contenu.getAttribute('Code_Dossier');
		document.getElementById("ofd-actif").checked = contenu.getAttribute("Actif")=="true";
		document.getElementById("ofd-nom").value = contenu.getAttribute('Nom');
		document.getElementById("ofd-type").value = contenu.getAttribute('Type');
		document.getElementById("ofd-numClient").value = contenu.getAttribute('Num_Client');
		document.getElementById("ofd-commentaires").value = contenu.getAttribute('Commentaires');

		ofd_initIHM();

	} catch (e) {
  	recup_erreur(e);
  }
}


function ofd_enregistrerDossier() {
	try {

		var codeDossier = document.getElementById('ofd-codeDossier').value;
		var actif = document.getElementById("ofd-actif").checked;
		var nom = document.getElementById('ofd-nom').value;
		var type = document.getElementById('ofd-type').value;
		var numClient = document.getElementById('ofd-numClient').value;
		var commentaires = document.getElementById('ofd-commentaires').value;
		var debutExercice = document.getElementById('ofd-debutExercice').value;
		var finExercice = document.getElementById('ofd-finExercice').value;

		var regex = /^[A-Z][A-Z0-9_]+[A-Z0-9]$/;

		if (ofd_mode=="C" && isEmpty(codeDossier)) { showWarning("Veuillez saisir un code dossier"); }
		else if (ofd_mode=="C" && !regex.test(codeDossier)) { showWarning("Code dossier incorrect (A-Z,0-9,_)"); }
		else if (isEmpty(nom)) { showWarning("Veuillez saisir un nom de dossier"); }
		else if (isEmpty(numClient)) { showWarning("Veuillez saisir un n\u00B0 client"); }
		else if (ofd_mode=="C" && (isEmpty(debutExercice) || !isDate(debutExercice))) { showWarning("La date de d\u00E9but d'exercice est incorrecte"); }
		else if (ofd_mode=="C" && (isEmpty(finExercice) || !isDate(finExercice))) { showWarning("La date de fin d'exercice est incorrecte"); }
		else if (ofd_mode=="C" && !isDateInterval(debutExercice, finExercice)) { showWarning("La date de fin d'exercice doit \u00EAtre sup\u00E9rieure \u00E0 la date de d\u00E9but"); }
		else if (ofd_mode=="M" || ofd_verifierDates(debutExercice, finExercice)) {

			var qSave;

			if (ofd_mode=="C") {
				ofd_disableNavigation(true);

				qSave = new QueryHttp("Superviseur/dossiers/createDossier.tmpl");
				qSave.setParam("Code_Dossier", codeDossier);
				qSave.setParam("Debut_Exercice", debutExercice);
				qSave.setParam("Fin_Exercice", finExercice);
			}
			else {
				qSave = new QueryHttp("Superviseur/dossiers/updateDossier.tmpl");
				qSave.setParam("Dossier_Id", ofd_dossierId);
			}

			qSave.setParam("Actif", actif);
			qSave.setParam("Nom", nom);
			qSave.setParam("Type", type);
			qSave.setParam("Num_Client", numClient);
			qSave.setParam("Commentaires", commentaires);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
				ofd_disableNavigation(false);
			}
			else {
				if (ofd_mode=="C") {
					ofd_dossierId = result.responseXML.documentElement.getAttribute("Dossier_Id");
					ofd_chargerDossier();
					ofd_nouvelleInitialisation();
				}
				else {
					ofd_setModified(false);
				}
			}
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function ofd_disableNavigation(b) {
	try {

		document.getElementById('ofd-bEnregistrer').disabled = b;
		document.getElementById("bMenuDossiers").disabled = b;
		document.getElementById("bMenuPrincipal").disabled = b;
		document.getElementById("bDeconnexionConf").disabled = b;

	} catch (e) {
		recup_erreur(e);
	}
}


function ofd_supprimerDossier() {
	try {

		var url = "chrome://opensi/content/superviseur/dossiers/popup-suppressionDossier.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', retourMenuDossiers, ofd_dossierId);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofd_demandeEnregistrement() {
  try {

		if (ofd_modified) {
			if (ofd_mode=="M" && window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es \u00E0 la fiche dossier ?")) {
				ofd_enregistrerDossier();
			}
			else if (ofd_mode=="C") {
				showWarning("Attention, le dossier en cours de cr\u00E9ation ne sera pas enregistr\u00E9");
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function ofd_setModified(m) {
  try {

  	ofd_modified = m;
		if (m) {
			document.getElementById('ofd-tabFiche').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
		}
		else {
			document.getElementById('ofd-tabFiche').setAttribute('image', null);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function ofd_verifierDates(dateDeb, dateFin) {
	try {

		var ok = false;

		var maintenant = new Date();
		var debAnnee = parseIntBis(dateDeb.substring(6,10));
		var debMois = parseIntBis(dateDeb.substring(3,5));
		var debJour = parseIntBis(dateDeb.substring(0,2));
		var finAnnee = parseIntBis(dateFin.substring(6,10));
		var finMois = parseIntBis(dateFin.substring(3,5));
		var finJour = parseIntBis(dateFin.substring(0,2));
		if (debAnnee<1970) {
			showWarning("Les dates inf\u00E9rieures \u00E0 1970 ne sont pas accept\u00E9es !");
		}
		else if (debAnnee<maintenant.getFullYear() || debAnnee>maintenant.getFullYear()+1) {
			ok = window.confirm("L'ann\u00E9e du d\u00E9but de l'exercice est probablement incorrecte : "+debAnnee+"\nEtes vous s\u00FBr de vouloir continuer ?");
		}
		else if (finAnnee-debAnnee>1 || (finAnnee-debAnnee==1 && finMois>debMois) || (finAnnee-debAnnee==1 && finMois==debMois && finJour>=debJour)) {
			ok = window.confirm("La dur\u00E9e de l'exercice est sup\u00E9rieure \u00E0 une ann\u00E9e\nEtes vous s\u00FBr de vouloir continuer ?");
		}
		else if ((finAnnee-debAnnee==0 && (finMois-debMois!=11 || finJour-debJour!=30)) || ((finAnnee-debAnnee==1 && finMois<debMois))) {
			ok = window.confirm("La dur\u00E9e de l'exercice est inf\u00E9rieure \u00E0 une ann\u00E9e\nEtes vous s\u00FBr de vouloir continuer ?");
		}
		else {
			ok = true;
		}

		return ok;

	} catch (e) {
		recup_erreur(e);
	}
}


function ofd_calculerDateFinExercice() {
  try {

		var dateDebut = document.getElementById('ofd-debutExercice').value;

		if (!isEmpty(dateDebut) && isDate(dateDebut) && ofd_precDateDebut!=dateDebut && dateDebut.length==10) {

			var annee = parseIntBis(dateDebut.substring(6,10));
			var jour = parseIntBis(dateDebut.substring(0,2));
			var mois = parseIntBis(dateDebut.substring(3,5));
			var separ1 = dateDebut.substring(2,3);
			var separ2 = dateDebut.substring(5,6);
			ofd_precDateDebut = dateDebut;

			if (jour!=1) {
				jour = jour-1;
			}
			else {
				mois = mois-1;
				switch(mois) {
		  		case 1:case 3:case 5:case 7: case 8:case 10:case 0:
			  		jour = 31;
				  	break;
	  			case 4:case 6:case 9:case 11:
		  			jour = 30;
			  		break;
	  			case 2:
		  			jour = isBissextile(annee)?29:28;
			  		break;
				}
	  	}
			if (mois!=0) {
	     	annee = annee+1;
			}
			else {
	    	mois = 12;
	   	}

			if (jour>=1 && jour<=9) jour = "0"+ jour;
			if (mois>=1 && mois<=9) mois = "0"+ mois;

			document.getElementById('ofd-finExercice').value = jour+separ1+mois+separ2+annee;
			document.getElementById('ofd-finExercice').select();
		}

  } catch (e) {
    recup_erreur(e);
  }
}


// ETAPE D'INITIALISATION


var ofd_aPlan = new Arbre('ComboListe/combo-plansComptables.tmpl', 'ofd-planComptable');
var ofd_aPays = new Arbre("ComboListe/combo-pays.tmpl", "ofd-codePays");
var ofd_aFormesJuridiques = new Arbre("ComboListe/combo-formesJuridiques.tmpl","ofd-formeJuridique");
var ofd_aDevises = new Arbre('ComboListe/combo-devises.tmpl', 'ofd-devise');
var ofd_aEntAff = new Arbre("Superviseur/dossiers/list-entrepriseAffectable.tmpl", "ofd-listeEntrepriseAffectable");
var ofd_aUtiAff = new Arbre("Superviseur/dossiers/list-utilisateurAffectable.tmpl", "ofd-listeUtilisateurAffectable");

var ofd_deviseDefaut;


function ofd_nouvelleInitialisation() {
	try {

		var qInit = new QueryHttp("Superviseur/dossiers/getInitDossier.tmpl");
		var result = qInit.execute();
		ofd_deviseDefaut = result.responseXML.documentElement.getAttribute("Devise_Id");

		ofd_aDevises.initTree(ofd_initDevise);
		ofd_aPays.initTree(ofd_initPays);
		ofd_aPlan.initTree(ofd_initPlan);
		ofd_aFormesJuridiques.setParam("Dossier_Id", ofd_dossierId);
		ofd_aFormesJuridiques.initTree(ofd_initFormeJuridique);

		document.getElementById("ofd-denomination").value = document.getElementById("ofd-nom").value;

		document.getElementById("ofd-adresse1").value = "";
		document.getElementById("ofd-adresse2").value = "";
		document.getElementById("ofd-adresse3").value = "";
		document.getElementById("ofd-codePostal").value = "";
		document.getElementById("ofd-ville").value = "";
		document.getElementById("ofd-telephone").value = "";
		document.getElementById("ofd-fax").value = "";
		document.getElementById("ofd-email").value = "";
		document.getElementById("ofd-siteWeb").value = "";

		document.getElementById("ofd-numSIRET").value = "";
		document.getElementById("ofd-codeNAF").value = "";
		document.getElementById("ofd-numeroTVA").value = "";
		document.getElementById("ofd-villeRCS").value = "";

		document.getElementById("ofd-dateCreation").value = "";
		document.getElementById("ofd-dureeSociete").value = "";
		document.getElementById("ofd-montantCapital").value = "";
		document.getElementById("ofd-nbParts").value = "";

		document.getElementById("ofd-typeActivite").selectedIndex = 0;
		document.getElementById("ofd-expertComptable").value = "";
		document.getElementById("ofd-regimeFiscal").value = "IS";
		document.getElementById("ofd-regimeGroupe").checked = false;
		document.getElementById("ofd-centreImpots").value = "";
		document.getElementById("ofd-tresorerie").value = "";
		document.getElementById("ofd-centreGestion").value = "";

		document.getElementById('ofd-planComptable').selectedIndex = 0;
		document.getElementById('ofd-BQ').checked = true;
		document.getElementById('ofd-CS').checked = true;
		document.getElementById('ofd-OD').checked = true;

		ofd_aEntAff.initTree();
		ofd_aUtiAff.deleteTree();

		document.getElementById('ofd-tabInit').collapsed = false;
		document.getElementById('ofd-panneau').selectedIndex = 1;
		document.getElementById('ofd-tabFiche').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function ofd_initPlan() {
	try {

		document.getElementById('ofd-planComptable').selectedIndex = 0;

	} catch (e) {
    recup_erreur(e);
  }
}


function ofd_initPays() {
	try {

		document.getElementById("ofd-codePays").value = "FR";

	} catch (e) {
		recup_erreur(e);
	}
}


function ofd_initDevise() {
	try {

		document.getElementById('ofd-devise').value = ofd_deviseDefaut;

	} catch (e) {
		recup_erreur(e);
	}
}


function ofd_initFormeJuridique() {
	try {

		document.getElementById('ofd-formeJuridique').selectedIndex = 0;

	} catch (e) {
		recup_erreur(e);
	}
}


function ofd_clickOnEntrepriseAffectable() {
	try {

		ofd_aUtiAff.setParam("List_Entreprise_Id", ofd_getListEntrepriseId());
		ofd_aUtiAff.setParam("List_Utilisateur_Id", ofd_getListUtilisateurId());
		ofd_aUtiAff.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function ofd_getListEntrepriseId() {
	try {

		var listEntrepriseId = "";

		for (var i=0; i<ofd_aEntAff.nbLignes(); i++) {
			if (ofd_aEntAff.getCellValue(i, "ofd-colSelEntreprise")=="true") {
				listEntrepriseId += ofd_aEntAff.getCellText(i, "ofd-colEntrepriseId") +",";
			}
		}

		return listEntrepriseId;

	} catch (e) {
		recup_erreur(e);
	}
}


function ofd_getListUtilisateurId() {
	try {

		var listUtilisateurId = "";

		for (var i=0; i<ofd_aUtiAff.nbLignes(); i++) {
			if (ofd_aUtiAff.getCellValue(i, "ofd-colSelUtilisateur")=="true") {
				listUtilisateurId += ofd_aUtiAff.getCellText(i, "ofd-colUtilisateurId") +",";
			}
		}

		return listUtilisateurId;

	} catch (e) {
		recup_erreur(e);
	}
}


function ofd_enregisterInitialisation() {
	try {

		var denomination = document.getElementById("ofd-denomination").value;
		var adresse1 = document.getElementById("ofd-adresse1").value;
		var adresse2 = document.getElementById("ofd-adresse2").value;
		var adresse3 = document.getElementById("ofd-adresse3").value;
		var codePostal = document.getElementById("ofd-codePostal").value;
		var ville = document.getElementById("ofd-ville").value;
		var codePays = document.getElementById("ofd-codePays").value;
		var telephone = document.getElementById("ofd-telephone").value;
		var fax = document.getElementById("ofd-fax").value;
		var email = document.getElementById("ofd-email").value;
		var siteWeb = document.getElementById("ofd-siteWeb").value;

		var formeJuridique = document.getElementById("ofd-formeJuridique").value;
		var numSIRET = document.getElementById("ofd-numSIRET").value;
		var codeNAF = document.getElementById("ofd-codeNAF").value;
		var numeroTVA = document.getElementById("ofd-numeroTVA").value;
		var villeRCS = document.getElementById("ofd-villeRCS").value;
		var dateCreation = document.getElementById("ofd-dateCreation").value;
		var dureeSociete = document.getElementById("ofd-dureeSociete").value;
		var montantCapital = document.getElementById("ofd-montantCapital").value;
		var nbParts = document.getElementById("ofd-nbParts").value;

		var devise = document.getElementById("ofd-devise").value;
		var typeActivite = document.getElementById("ofd-typeActivite").value;
		var expertComptable = document.getElementById("ofd-expertComptable").value;
		var regimeFiscal = document.getElementById("ofd-regimeFiscal").value;
		var regimeGroupe = document.getElementById("ofd-regimeGroupe").checked;
		var centreImpots = document.getElementById("ofd-centreImpots").value;
		var tresorerie = document.getElementById("ofd-tresorerie").value;
		var centreGestion = document.getElementById("ofd-centreGestion").value;

		var planComptable = document.getElementById('ofd-planComptable').value;
		var bq = document.getElementById('ofd-BQ').checked;
		var cs = document.getElementById('ofd-CS').checked;
		var od = document.getElementById('ofd-OD').checked;

		var listEntrepriseId = ofd_getListEntrepriseId();
		var listUtilisateurId = ofd_getListUtilisateurId();

		if (isEmpty(denomination)) { showWarning("Veuillez saisir la d\u00E9nomination."); }
		else if (isEmpty(adresse1)) { showWarning("Veuillez saisir l'adresse."); }
		else if (isEmpty(ville)) { showWarning("Veuillez saisir la ville."); }
		else if (!isEmpty(telephone) && !isPhone(telephone)) { showWarning("Le t\u00E9l\u00E9phone est incorrect."); }
		else if (!isEmpty(fax) && !isPhone(fax)) { showWarning("Le fax est incorrect."); }
		else if (!isEmpty(email) && !isEmail(email)) { showWarning("L'e-mail est incorrect."); }
		else if (isEmpty(formeJuridique)) { showWarning("Veuillez choisir une forme juridique"); }
		else if (isEmpty(numSIRET)) { showWarning("Veuillez saisir un num\u00E9ro de SIRET."); }
		else if (isEmpty(codeNAF)) { showWarning("Veuillez saisir un code NAF."); }
		else if (!isEmpty(dateCreation) && !isDate(dateCreation)) { showWarning("La date de cr\u00E9ation de la soci\u00E9t\u00E9 est incorrecte (format : jj/mm/aaaa)."); }
		else if (!isEmpty(dureeSociete) && !isPositiveInteger(dureeSociete)) { showWarning("La dur\u00E9e de la soci\u00E9t\u00E9 est incorrecte."); }
		else if (!isEmpty(montantCapital) && !isPositive(montantCapital)) { showWarning("Le montant du capital est incorrect."); }
		else if (!isEmpty(nbParts) && !isPositiveInteger(nbParts)) { showWarning("Le nombre de parts est incorrect."); }
		else if (isEmpty(listEntrepriseId)) { showWarning("Veuillez s\u00E9lectionner au moins une entreprise"); }
		else {

			var qSave = new QueryHttp("Superviseur/dossiers/finalizeDossier.tmpl");

			qSave.setParam("Dossier_Id", ofd_dossierId);
			qSave.setParam("Denomination", denomination);
			qSave.setParam("Adresse_1", adresse1);
			qSave.setParam("Adresse_2", adresse2);
			qSave.setParam("Adresse_3", adresse3);
			qSave.setParam("Code_Postal", codePostal);
			qSave.setParam("Ville", ville);
			qSave.setParam("Code_Pays", codePays);
			qSave.setParam("Telephone", telephone);
			qSave.setParam("Fax", fax);
			qSave.setParam("Email", email);
			qSave.setParam("Site_Web", siteWeb);
			qSave.setParam("Forme_Juridique", formeJuridique);
			qSave.setParam("Num_SIRET", numSIRET);
			qSave.setParam("Code_NAF", codeNAF);
			qSave.setParam("Numero_TVA", numeroTVA);
			qSave.setParam("Ville_RCS", villeRCS);
			qSave.setParam("Date_Creation", dateCreation);
			qSave.setParam("Duree_Societe", dureeSociete);
			qSave.setParam("Montant_Capital", montantCapital);
			qSave.setParam("Nb_Parts", nbParts);
			qSave.setParam("Monnaie_Tenue", devise);
			qSave.setParam("Typologie", typeActivite);
			qSave.setParam("Expert", expertComptable);
			qSave.setParam("Regime_Fiscal", regimeFiscal);
			qSave.setParam("Regime_Groupe", regimeGroupe);
			qSave.setParam("Centre_Impot", centreImpots);
			qSave.setParam("Tresorerie", tresorerie);
			qSave.setParam("Centre_Gestion", centreGestion);
			qSave.setParam("Plan_Comptable", planComptable);
			qSave.setParam("BQ", bq);
			qSave.setParam("CS", cs);
			qSave.setParam("OD", od);
			qSave.setParam("List_Entreprise_Id", listEntrepriseId);
			qSave.setParam("List_Utilisateur_Id", listUtilisateurId);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				ofd_disableNavigation(false);
				retourMenuDossiers();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}

