/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oem_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'oem-etablissement');
var oem_aPays = new Arbre("ComboListe/combo-pays.tmpl", "oem-codePays");
var oem_aVersions = new Arbre('TB/Mandats/list-versionMandat.tmpl', 'oem-tVersions');

var oem_mandatId;
var oem_mode;
var oem_etatMandat;
var oem_modified = false;
var oem_curEtablissement;
var oem_clientId;



function oem_init() {
	try {

		oem_aPays.initTree(oem_initPays);

	} catch (e) {
		recup_erreur(e);
	}
}


function oem_chargerEtablissement(selection) {
	try {

		oem_curEtablissement = selection;
		oem_aEtablissements.setParam("Selection", selection);
		oem_aEtablissements.initTree(oem_initEtablissement);

	} catch (e) {
		recup_erreur(e);
	}
}


function oem_initEtablissement() {
	try {

		document.getElementById('oem-etablissement').value = oem_curEtablissement;

	} catch (e) {
		recup_erreur(e);
	}
}


function oem_initPays() {
	try {

    document.getElementById('oem-codePays').value = "FR";

	} catch (e) {
    recup_erreur(e);
  }
}


function oem_initIHM() {
	try {

		document.getElementById('oem-bEnregistrer').collapsed = oem_etatMandat=="A";
		document.getElementById('oem-bSupprimer').collapsed = oem_mode!="M";
		document.getElementById('oem-bAnnuler').collapsed = oem_mode!="V" || oem_etatMandat=="A";
		document.getElementById('oem-bVisualiser').collapsed = oem_mode=="C";
		document.getElementById('oem-bValider').collapsed = oem_mode!="M";

		document.getElementById('oem-chercherClient').collapsed = oem_mode=="V";
		document.getElementById('oem-chercherAdresse').collapsed = oem_mode=="V";
		document.getElementById('oem-gbVersions').collapsed = oem_mode=="C";

		var origineMandat = document.getElementById('oem-origineMandat').value;
		document.getElementById('oem-etablissement').disabled = oem_etatMandat=="A";
		document.getElementById('oem-numeroRUM').disabled = oem_mode!="C" || origineMandat!="R";
		document.getElementById('oem-typePaiement').disabled = oem_mode=="V";
		document.getElementById('oem-typeMandat').disabled = oem_mode=="V";
		document.getElementById('oem-origineMandat').disabled = oem_mode!="C";
		document.getElementById('oem-lieuSignature').disabled = oem_mode=="V" || origineMandat=="A";
		document.getElementById('oem-dateSignature').disabled = oem_mode=="V" || origineMandat=="A";
		document.getElementById('oem-denomination').disabled = oem_mode=="V";
		document.getElementById('oem-adresse1').disabled = oem_mode=="V";
		document.getElementById('oem-adresse2').disabled = oem_mode=="V";
		document.getElementById('oem-adresse3').disabled = oem_mode=="V";
		document.getElementById('oem-codePostal').disabled = oem_mode=="V";
		document.getElementById('oem-ville').disabled = oem_mode=="V";
		document.getElementById('oem-codePays').disabled = oem_mode=="V";
		document.getElementById('oem-iban').disabled = oem_etatMandat=="A";
		document.getElementById('oem-bic').disabled = oem_etatMandat=="A";
		document.getElementById('oem-zoneCreancier').disabled = oem_mode=="V";
		document.getElementById('oem-commentaires').disabled = oem_etatMandat=="A";

		oem_setModified(false);

	} catch (e) {
		recup_erreur(e);
	}
}


function oem_nouveauMandat() {
  try {

		document.getElementById('oem-deckMandat').selectedIndex = 0;

		oem_clientId = "";
		oem_mode = "C";
		oem_etatMandat = "N";
		oem_chargerEtablissement(etablissementDefaut);
		oem_aVersions.deleteTree();

		document.getElementById('oem-etat').value = "Nouveau";
		document.getElementById('oem-numeroRUM').value = "";
		document.getElementById('oem-typePaiement').value = "R";
		document.getElementById('oem-typeMandat').value = "C";
		document.getElementById('oem-origineMandat').value = "C";
		document.getElementById('oem-lieuSignature').value = "";
		document.getElementById('oem-dateSignature').value = "";
		document.getElementById('oem-numClient').value = "";
		document.getElementById('oem-denomination').value = "";
		document.getElementById('oem-adresse1').value = "";
		document.getElementById('oem-adresse2').value = "";
		document.getElementById('oem-adresse3').value = "";
		document.getElementById('oem-codePostal').value = "";
		document.getElementById('oem-ville').value = "";
		document.getElementById('oem-codePays').value = "FR";
		document.getElementById('oem-iban').value = "";
		document.getElementById('oem-bic').value = "";
		document.getElementById('oem-zoneCreancier').value = "";
		document.getElementById('oem-commentaires').value = "";

		document.getElementById('oem-creation').setAttribute("label", "");
		document.getElementById('oem-modification').setAttribute("label", "");
		document.getElementById('oem-document').setAttribute("label", "");

		oem_initIHM();

	} catch (e) {
  	recup_erreur(e);
  }
}


function oem_chargerMandat() {
  try {

		document.getElementById('oem-deckMandat').selectedIndex = 0;

		var qLoad = new QueryHttp('TB/Mandats/loadMandat.tmpl');
		qLoad.setParam("Mandat_Id", oem_mandatId);
		var result = qLoad.execute();
		var contenu = result.responseXML.documentElement;

		oem_etatMandat = contenu.getAttribute("Etat");
		oem_mode = (oem_etatMandat=="N"?"M":"V");

		oem_chargerEtablissement(contenu.getAttribute('Etab_Id'));

		oem_aVersions.setParam("Mandat_Id", oem_mandatId);
		oem_aVersions.initTree();

		oem_clientId = contenu.getAttribute("Client_Id");

		document.getElementById('oem-etat').value = contenu.getAttribute("Libelle_Etat");
		document.getElementById('oem-numeroRUM').value = contenu.getAttribute("Numero_RUM");
		document.getElementById('oem-typePaiement').value = contenu.getAttribute("Type_Paiement");
		document.getElementById('oem-typeMandat').value = contenu.getAttribute("Type_Mandat");
		document.getElementById('oem-origineMandat').value = contenu.getAttribute("Origine_Mandat");
		document.getElementById('oem-lieuSignature').value = contenu.getAttribute("Lieu_Signature");
		document.getElementById('oem-dateSignature').value = contenu.getAttribute("Date_Signature");
		document.getElementById('oem-numClient').value = contenu.getAttribute("Num_Client");
		document.getElementById('oem-denomination').value = contenu.getAttribute("Denomination");
		document.getElementById('oem-adresse1').value = contenu.getAttribute("Adresse_1");
		document.getElementById('oem-adresse2').value = contenu.getAttribute("Adresse_2");
		document.getElementById('oem-adresse3').value = contenu.getAttribute("Adresse_3");
		document.getElementById('oem-codePostal').value = contenu.getAttribute("Code_Postal");
		document.getElementById('oem-ville').value = contenu.getAttribute("Ville");
		document.getElementById('oem-codePays').value = contenu.getAttribute("Code_Pays");
		document.getElementById('oem-iban').value = contenu.getAttribute("IBAN");
		document.getElementById('oem-bic').value = contenu.getAttribute("BIC");
		document.getElementById('oem-zoneCreancier').value = contenu.getAttribute("Zone_Creancier");
		document.getElementById('oem-commentaires').value = contenu.getAttribute("Commentaires");

		document.getElementById('oem-creation').setAttribute("label","Mandat cr\u00E9\u00E9 le "+ contenu.getAttribute('Date_Creation') +" par "+ contenu.getAttribute('Login_Creation'));
		document.getElementById('oem-modification').setAttribute("label","Derni\u00E8re modification le "+ contenu.getAttribute('Date_Maj') +" par "+ contenu.getAttribute('Login_Maj'));
		document.getElementById('oem-document').setAttribute("label","Mandat N\u00B0 "+ contenu.getAttribute('Numero_RUM'));

		oem_initIHM();

	} catch (e) {
  	recup_erreur(e);
  }
}


function oem_enregistrerMandat(rafraichir) {
  try {

  	var ok = false;

		var qSave;

		if (oem_mode=="C") {
			qSave = new QueryHttp("TB/Mandats/createMandat.tmpl");
		}
		else {
			qSave = new QueryHttp("TB/Mandats/updateMandat.tmpl");
			qSave.setParam("Mandat_Id", oem_mandatId);
		}

		var numeroRUM = document.getElementById('oem-numeroRUM').value;
		var typePaiement = document.getElementById('oem-typePaiement').value;
		var typeMandat = document.getElementById('oem-typeMandat').value;
		var origineMandat = document.getElementById('oem-origineMandat').value;
		var lieuSignature = document.getElementById('oem-lieuSignature').value;
		var dateSignature	 = document.getElementById('oem-dateSignature').value;
		var etabId = document.getElementById('oem-etablissement').value;
		var denomination = document.getElementById('oem-denomination').value;
		var adresse1 = document.getElementById('oem-adresse1').value;
		var adresse2 = document.getElementById('oem-adresse2').value;
		var adresse3 = document.getElementById('oem-adresse3').value;
		var codePostal = document.getElementById('oem-codePostal').value;
		var ville = document.getElementById('oem-ville').value;
		var codePays = document.getElementById('oem-codePays').value;
		var iban = document.getElementById('oem-iban').value;
		var bic = document.getElementById('oem-bic').value;
		var zoneCreancier = document.getElementById('oem-zoneCreancier').value;
		var commentaires = document.getElementById('oem-commentaires').value;

		if (isEmpty(etabId)) { showWarning("Veuillez s\u00E9lectionner l'\u00E9tablissement \u00E9metteur du mandat"); }
		else if (!isEmpty(dateSignature) && !isDate(dateSignature)) { showWarning("Date de signature du mandat incorrecte"); }
		else if (isEmpty(bic)) { showWarning("Veuillez saisir le code BIC"); }
		else if (isEmpty(iban)) { showWarning("Veuillez saisir le num\u00E9ro IBAN"); }
		else if (!isBIC(bic)) { showWarning("BIC incorrect"); }
		else if (iban.length<5 || !verifCleIBAN(iban.substring(2,4), iban.substring(0,4), iban.substring(4))) { showWarning("Num\u00E9ro IBAN incorrect"); }
		else if (isEmpty(denomination)) { showWarning("Veuillez saisir la d\u00E9nomination du d\u00E9biteur"); }
		else if (isEmpty(adresse1)) { showWarning("Veuillez saisir l'adresse du d\u00E9biteur"); }
		else if (isEmpty(ville)) { showWarning("Veuillez saisir la ville du d\u00E9biteur"); }
		else if (origineMandat=="R" && isEmpty(numeroRUM)) { showWarning("Veuillez saisir la r\u00E9f\u00E9rence du mandat"); }
		else if (oem_mode!="V" || window.confirm("Attention le mandat est valid\u00E9, confirmez-vous la modification des informations du mandat ?")) {

			qSave.setParam("Numero_RUM", numeroRUM);
			qSave.setParam("Type_Paiement", typePaiement);
			qSave.setParam("Type_Mandat", typeMandat);
			qSave.setParam("Origine_Mandat", origineMandat);
			qSave.setParam("Lieu_Signature", lieuSignature);
			qSave.setParam("Date_Signature", dateSignature);
			qSave.setParam("Etab_Id", etabId);
			qSave.setParam("Client_Id", oem_clientId);
			qSave.setParam("Denomination", denomination);
			qSave.setParam("Adresse_1", adresse1);
			qSave.setParam("Adresse_2", adresse2);
			qSave.setParam("Adresse_3", adresse3);
			qSave.setParam("Code_Postal", codePostal);
			qSave.setParam("Ville", ville);
			qSave.setParam("Code_Pays", codePays);
			qSave.setParam("IBAN", iban);
			qSave.setParam("BIC", bic);
			qSave.setParam("Zone_Creancier", zoneCreancier);
			qSave.setParam("Commentaires", commentaires);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				if (oem_mode=="C") {
					oem_mandatId = result.responseXML.documentElement.getAttribute("Mandat_Id");
					if (rafraichir) {
						oem_chargerMandat();
					}
				}

				oem_setModified(false);
				ok = true;
			}
		}

		return ok;

	} catch (e) {
  	recup_erreur(e);
  }
}


function oem_supprimerMandat() {
  try {

		if (window.confirm("Confirmez-vous la suppression du mandat ?")) {

			var qSup = new QueryHttp("TB/Mandats/deleteMandat.tmpl");
			qSup.setParam("Mandat_Id", oem_mandatId);
			var result = qSup.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("Le mandat a \u00E9t\u00E9 supprim\u00E9.");
				retourMenuMandats();
			}
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oem_demandeEnregistrement() {
  try {

		if (oem_modified) {
			if (window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es au mandat ?")) {
				oem_enregistrerMandat(false);
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oem_setModified(m) {
  try {

  	oem_modified = m;
		if (m) {
			document.getElementById('oem-capMandat').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
			document.getElementById('oem-bValider').disabled = true;
			document.getElementById('oem-bVisualiser').disabled = true;
		}
		else {
			document.getElementById('oem-capMandat').setAttribute('image', null);
			document.getElementById('oem-bValider').disabled = false;
			document.getElementById('oem-bVisualiser').disabled = false;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oem_changeOrigineMandat() {
	try {

		var origineMandat = document.getElementById('oem-origineMandat').value;
		document.getElementById('oem-numeroRUM').disabled = oem_mode!="C" || origineMandat!="R";
		document.getElementById('oem-lieuSignature').disabled = oem_mode=="V" || origineMandat=="A";
		document.getElementById('oem-dateSignature').disabled = oem_mode=="V" || origineMandat=="A";

		if (oem_mode=="C" && origineMandat=="A") {
			document.getElementById('oem-lieuSignature').value = "";
			document.getElementById('oem-dateSignature').value = "";
		}

		if (oem_mode=="C" && origineMandat!="R") {
			document.getElementById('oem-numeroRUM').value = "";
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oem_editerMandat() {
	try {

		document.getElementById('oem-pdfMandat').setAttribute("src", "");
		document.getElementById("bRetourMandat").collapsed = false;
		document.getElementById("oem-deckMandat").selectedIndex = 1;

		var qGenPdf = new QueryHttp("TB/Mandats/pdfMandat.tmpl");
		qGenPdf.setParam('Mandat_Id', oem_mandatId);
		var result = qGenPdf.execute();
		var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
		document.getElementById('oem-pdfMandat').setAttribute("src", page);

	} catch (e) {
		recup_erreur(e);
	}
}


function oem_validerMandat() {
  try {

		if (window.confirm("Confirmez-vous la validation du mandat ?")) {

			var qValider = new QueryHttp("TB/Mandats/validMandat.tmpl");
			qValider.setParam('Mandat_Id', oem_mandatId);
			var result = qValider.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oem_chargerMandat();
			}
  	}

	} catch (e) {
    recup_erreur(e);
  }
}


function oem_annulerMandat() {
	try {

		if (window.confirm("Confirmez-vous l'annulation du mandat ?")) {
			var qAnnuler = new QueryHttp("TB/Mandats/cancelMandat.tmpl");
			qAnnuler.setParam('Mandat_Id', oem_mandatId);
			var result = qAnnuler.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("Le mandat a \u00E9t\u00E9 annul\u00E9.");
				oem_chargerMandat();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oem_rechercherClient() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oem_reporterClient);

	} catch (e) {
		recup_erreur(e);
	}
}


function oem_reporterClient(numClient, clientId) {
	try {

		oem_clientId = clientId;
  	document.getElementById('oem-numClient').value = numClient;

		var qInf = new QueryHttp("TB/Mandats/getInfosClient.tmpl");
		qInf.setParam("Client_Id", clientId);

		var result = qInf.execute();
		var contenu = result.responseXML.documentElement;

		document.getElementById('oem-denomination').value = contenu.getAttribute('Denomination');
		document.getElementById('oem-adresse1').value = contenu.getAttribute('Adresse_1');
		document.getElementById('oem-adresse2').value = contenu.getAttribute('Adresse_2');
		document.getElementById('oem-adresse3').value = contenu.getAttribute('Adresse_3');
		document.getElementById('oem-codePostal').value = contenu.getAttribute('Code_Postal');
		document.getElementById('oem-ville').value = contenu.getAttribute('Ville');
    document.getElementById('oem-codePays').value = contenu.getAttribute('Code_Pays');

		document.getElementById('oem-iban').value = contenu.getAttribute('IBAN');
		document.getElementById('oem-bic').value = contenu.getAttribute('BIC');

		oem_setModified(true);

	} catch (e) {
		recup_erreur(e);
	}
}


function oem_rechercherAdresse() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixAdresse.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oem_reporterAdresse, oem_clientId, false);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oem_reporterAdresse(denomination, adr1, adr2, adr3, cp, ville, pays, code_pays) {
  try {

		document.getElementById("oem-denomination").value = denomination;
		document.getElementById("oem-adresse1").value = adr1;
		document.getElementById("oem-adresse2").value = adr2;
		document.getElementById("oem-adresse3").value = adr3;
		document.getElementById("oem-codePostal").value = cp;
		document.getElementById("oem-ville").value = ville;
	  document.getElementById("oem-codePays").value = code_pays;

	} catch (e) {
  	recup_erreur(e);
  }
}


function oem_envoyerMail() {
  try {

		var url = "chrome://opensi/content/popup/popup-envoyerMail.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', "MP", oem_mandatId);

	} catch (e) {
  	recup_erreur(e);
  }
}
