/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/banques.js");


var etablissementDefaut;



function init() {
	try {

  	window.parent.addEventListener("close", demandeEnregistrement, false);

  	document.getElementById('deck').selectedIndex = 0;

		etablissementDefaut = getProfil().getEtabId();

		omp_init();
  	oerp_init();

	} catch (e) {
    recup_erreur(e);
  }
}


function retourMenuPrelevements() {
	try {

		document.getElementById('oerp-pdfRemise').setAttribute("src", "");
		document.getElementById('deck').selectedIndex = 0;
		document.getElementById('bMenuPrelevements').collapsed = true;
		document.getElementById('bRetourRemisePrelevements').collapsed = true;

		omp_listerRemises();

	} catch (e) {
		recup_erreur(e);
	}
}


function retourRemisePrelevements() {
  try {

		document.getElementById('oerp-pdfRemise').setAttribute("src", "");
		document.getElementById('deck').selectedIndex = 1;
		document.getElementById('oerp-deckRemise').selectedIndex = 0;
		document.getElementById('bRetourRemisePrelevements').collapsed = true;
		oerp_chargerRemise();

	} catch (e) {
    recup_erreur(e);
  }
}


function desinit() {
	try {

		window.parent.removeEventListener("close", demandeEnregistrement, false);

	} catch (e) {
    recup_erreur(e);
  }
}


function demandeEnregistrement() {
	try {

		var currentDeck = parseIntBis(document.getElementById('deck').selectedIndex);

		switch (currentDeck) {
			case 1: oerp_demandeEnregistrement(); break;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuPrincipal() {
	try {

		window.location = "chrome://opensi/content/tb/menu_principal.xul";

	} catch (e) {
    recup_erreur(e);
  }
}
