/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oerv_aBanques = new Arbre('ComboListe/combo-banques.tmpl', 'oerv-banque');
var oerv_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'oerv-etablissement');
var oerv_aVirements = new Arbre('TB/Virements/list-virement.tmpl', 'oerv-tVirements');

var oerv_remiseId;
var oerv_mode;
var oerv_etatRemise;
var oerv_modified = false;
var oerv_curBanque;
var oerv_curEtablissement;
var oerv_defautComptaGlobale;
var oerv_curTypeTiers = "";
var oerv_curTiersId = "";


function oerv_init() {
	try {

		oerv_defautComptaGlobale = getConfig().isTBComptaLotVir();

	} catch (e) {
		recup_erreur(e);
	}
}


function oerv_chargerBanque(selection) {
	try {

		oerv_curBanque = selection;
		oerv_aBanques.setParam("Selection", selection);
		oerv_aBanques.initTree(oerv_initBanque);

	} catch (e) {
		recup_erreur(e);
	}
}


function oerv_initBanque() {
	try {

		document.getElementById('oerv-banque').value = oerv_curBanque;

	} catch (e) {
		recup_erreur(e);
	}
}


function oerv_chargerEtablissement(selection) {
	try {

		oerv_curEtablissement = selection;
		oerv_aEtablissements.setParam("Selection", selection);
		oerv_aEtablissements.initTree(oerv_initEtablissement);

	} catch (e) {
		recup_erreur(e);
	}
}


function oerv_initEtablissement() {
	try {

		document.getElementById('oerv-etablissement').value = oerv_curEtablissement;

	} catch (e) {
		recup_erreur(e);
	}
}


function oerv_initIHM() {
	try {

		document.getElementById('oerv-bEnregistrerRV').collapsed = oerv_mode=="V";
		document.getElementById('oerv-bSupprimerRV').collapsed = oerv_mode!="M";
		document.getElementById('oerv-bAnnulerRV').collapsed = oerv_mode!="V" || oerv_etatRemise=="A";
		document.getElementById('oerv-bVisualiserRV').collapsed = oerv_mode!="V";
		document.getElementById('oerv-bValiderRV').collapsed = oerv_mode!="M";
		document.getElementById('oerv-bExportSepaRV').collapsed = oerv_mode!="V";

		document.getElementById('oerv-ligneVirement').collapsed = oerv_mode=="V" || oerv_etatRemise=="P";
		oerv_annulerLigne();

		document.getElementById('oerv-dateExecution').disabled = oerv_mode=="V";
		document.getElementById('oerv-refLot').disabled = oerv_mode=="V";
		document.getElementById('oerv-comptaGlobale').disabled = oerv_mode=="V";
		document.getElementById('oerv-commentaires').disabled = oerv_mode=="V";
		document.getElementById('oerv-banque').disabled = oerv_mode=="V";
		document.getElementById('oerv-etablissement').disabled = oerv_mode=="V";

		document.getElementById('oerv-tVirements').disabled = false;

		oerv_setModified(false);

	} catch (e) {
		recup_erreur(e);
	}
}


function oerv_nouvelleRemise() {
  try {

		document.getElementById('oerv-deckRemise').selectedIndex = 0;
		document.getElementById('oerv-tVirements').disabled = true;

		oerv_mode = "C";
		oerv_etatRemise = "N";
  	oerv_chargerBanque("");
		oerv_chargerEtablissement(etablissementDefaut);
		oerv_aVirements.deleteTree();

		document.getElementById('oerv-numRemise').value = "";
		document.getElementById('oerv-dateRemise').value = "";
		document.getElementById('oerv-etat').value = "Nouveau";
		document.getElementById('oerv-nbTransactions').value = "0";
		document.getElementById('oerv-montantTotal').value = "0.00";
		document.getElementById('oerv-dateExecution').value = "";
		document.getElementById('oerv-refLot').value = "";
		document.getElementById('oerv-comptaGlobale').checked = oerv_defautComptaGlobale;
		document.getElementById('oerv-commentaires').value = "";

		document.getElementById('oerv-creation').setAttribute("label", "");
		document.getElementById('oerv-modification').setAttribute("label", "");
		document.getElementById('oerv-document').setAttribute("label", "");

		oerv_initIHM();

	} catch (e) {
  	recup_erreur(e);
  }
}


function oerv_chargerRemise() {
  try {

		document.getElementById('oerv-deckRemise').selectedIndex = 0;
		document.getElementById('oerv-tVirements').disabled = true;

		var qLoad = new QueryHttp('TB/Virements/loadRemise.tmpl');
		qLoad.setParam("Remise_Id", oerv_remiseId);
		var result = qLoad.execute();
		var contenu = result.responseXML.documentElement;

		oerv_etatRemise = contenu.getAttribute("Etat");
		oerv_mode = (oerv_etatRemise=="N" || oerv_etatRemise=="P"?"M":"V");

		oerv_chargerBanque(contenu.getAttribute('Banque_Id'));
		oerv_chargerEtablissement(contenu.getAttribute('Etab_Id'));

		document.getElementById('oerv-numRemise').value = contenu.getAttribute("Num_Remise");
		document.getElementById('oerv-dateRemise').value = contenu.getAttribute("Date_Remise");
		document.getElementById('oerv-etat').value = contenu.getAttribute("Libelle_Etat");
		document.getElementById('oerv-montantTotal').value = contenu.getAttribute("Total");
		document.getElementById('oerv-nbTransactions').value = contenu.getAttribute("Nb_Transactions");
		document.getElementById('oerv-dateExecution').value = contenu.getAttribute("Date_Execution");
		document.getElementById('oerv-refLot').value = contenu.getAttribute("Ref_Lot");
		document.getElementById('oerv-comptaGlobale').checked = contenu.getAttribute("Compta_Globale")=="true";
		document.getElementById('oerv-commentaires').value = contenu.getAttribute("Commentaires");

		document.getElementById('oerv-creation').setAttribute("label","Remise cr\u00E9\u00E9e le "+ contenu.getAttribute('Date_Creation') +" par "+ contenu.getAttribute('Login_Creation'));
		document.getElementById('oerv-modification').setAttribute("label","Derni\u00E8re modification le "+ contenu.getAttribute('Date_Maj') +" par "+ contenu.getAttribute('Login_Maj'));
		document.getElementById('oerv-document').setAttribute("label","Remise N\u00B0 "+ contenu.getAttribute('Num_Remise'));

		oerv_aVirements.setParam('Remise_Id', oerv_remiseId);
		oerv_aVirements.initTree();

		oerv_initIHM();

	} catch (e) {
  	recup_erreur(e);
  }
}


function oerv_refreshTotaux() {
	try {

		var qTotaux = new QueryHttp('TB/Virements/getTotauxRemise.tmpl');
		qTotaux.setParam("Remise_Id", oerv_remiseId);
		var result = qTotaux.execute();
		var contenu = result.responseXML.documentElement;

		document.getElementById('oerv-nbTransactions').value = contenu.getAttribute("Nb_Transactions");
		document.getElementById('oerv-montantTotal').value = contenu.getAttribute("Total");

	} catch (e) {
		recup_erreur(e);
	}
}


function oerv_enregistrerRemise(rafraichir) {
  try {

  	var ok = false;

		var qSave;

		if (oerv_mode=="C") {
			qSave = new QueryHttp("TB/Virements/createRemise.tmpl");
		}
		else {
			qSave = new QueryHttp("TB/Virements/updateRemise.tmpl");
			qSave.setParam("Remise_Id", oerv_remiseId);
		}

		var banqueId = document.getElementById('oerv-banque').value;
		var dateExecution = document.getElementById('oerv-dateExecution').value;
		var refLot = document.getElementById('oerv-refLot').value;
		var comptaGlobale = document.getElementById('oerv-comptaGlobale').checked;
		var etabId = document.getElementById('oerv-etablissement').value;
		var commentaires = document.getElementById('oerv-commentaires').value;
		var dateJour = parseDate(getDateCourante());

		if (isEmpty(dateExecution)) { showWarning("Veuillez saisir une date d'ex\u00E9cution des virements"); }
		else if (isEmpty(etabId)) { showWarning("Veuillez s\u00E9lectionner l'\u00E9tablissement \u00E9metteur des virements"); }
		else if (isEmpty(banqueId)) { showWarning("Veuillez s\u00E9lectionner la banque \u00E9mettrice des virements"); }
		else if (!isDate(dateExecution)) { showWarning("Date d'ex\u00E9cution des virements incorrecte"); }
		else if (parseDate(dateExecution)<dateJour) { showWarning("La date d'ex\u00E9cution doit \u00EAtre sup\u00E9rieure ou \u00E9gale \u00E0 la date du jour"); }
		else {

			qSave.setParam("Banque_Id", banqueId);
			qSave.setParam("Date_Execution", dateExecution);
			qSave.setParam("Ref_Lot", refLot);
			qSave.setParam("Compta_Globale", comptaGlobale);
			qSave.setParam("Etab_Id", etabId);
			qSave.setParam("Commentaires", commentaires);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				if (oerv_mode=="C") {
					oerv_remiseId = result.responseXML.documentElement.getAttribute("Remise_Id");
					if (rafraichir) {
						oerv_chargerRemise();
					}
				}

				oerv_setModified(false);
				ok = true;
			}
		}

		return ok;

	} catch (e) {
  	recup_erreur(e);
  }
}


function oerv_supprimerRemise() {
  try {

		if (window.confirm("Confirmez-vous la suppression de la remise ?")) {

			var qSup = new QueryHttp("TB/Virements/deleteRemise.tmpl");
			qSup.setParam("Remise_Id", oerv_remiseId);
			var result = qSup.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("La remise a \u00E9t\u00E9 supprim\u00E9e.");
				retourMenuVirements();
			}
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oerv_annulerLigne() {
	try {

		if (oerv_aVirements.isSelected()) {
			oerv_aVirements.clearSelection();
		}

		oerv_curTypeTiers = "";
		oerv_curTiersId = "";
		document.getElementById('oerv-refVirement').value = "";
		document.getElementById('oerv-motifPaiement').value = "";
		document.getElementById('oerv-beneficiaire').value = "";
		document.getElementById('oerv-iban').value = "";
		document.getElementById('oerv-bic').value = "";
		document.getElementById('oerv-montant').value = "";
		document.getElementById('oerv-bBeneficiaire').disabled = false;
		document.getElementById('oerv-bSupprimer').disabled = true;
		document.getElementById('oerv-beneficiaire').disabled = false;
		document.getElementById('oerv-iban').disabled = false;
		document.getElementById('oerv-bic').disabled = false;
		document.getElementById('oerv-motifPaiement').focus();

	} catch (e) {
		recup_erreur(e);
	}
}


function oerv_validerLigne() {
	try {

		var refVirement = document.getElementById('oerv-refVirement').value;
		var motifPaiement = document.getElementById('oerv-motifPaiement').value;
		var beneficiaire = document.getElementById('oerv-beneficiaire').value;
		var iban = document.getElementById('oerv-iban').value;
		var bic = document.getElementById('oerv-bic').value;
		var montant = document.getElementById('oerv-montant').value;

		if (isEmpty(beneficiaire)) { showWarning("Veuillez saisir le b\u00E9n\u00E9ficiaire du virement"); }
		else if (isEmpty(montant)) { showWarning("Veuillez saisir le montant du virement"); }
		else if (!isPositive(montant)) { showWarning("Montant du virement incorrect"); }
		else if (isEmpty(bic)) { showWarning("Veuillez saisir le code BIC"); }
		else if (isEmpty(iban)) { showWarning("Veuillez saisir le num\u00E9ro IBAN"); }
		else if (!isBIC(bic)) { showWarning("BIC incorrect"); }
		else if (iban.length<5 || !verifCleIBAN(iban.substring(2,4), iban.substring(0,4), iban.substring(4))) { showWarning("Num\u00E9ro IBAN incorrect"); }
		else {

			var saved = true;
			if (oerv_mode=="C") {
				saved = oerv_enregistrerRemise(true);
			}

			if (saved) {
				var qValider;

				if (oerv_aVirements.isSelected()) {
					var virementId = oerv_aVirements.getSelectedCellText('oerv-colVirementId');
					qValider = new QueryHttp("TB/Virements/updateVirement.tmpl");
					qValider.setParam("Virement_Id", virementId);
				}
				else {
					qValider = new QueryHttp("TB/Virements/createVirement.tmpl");
					qValider.setParam("Remise_Id", oerv_remiseId);
					qValider.setParam("Tiers_Id", oerv_curTiersId);
					qValider.setParam("Type_Tiers", oerv_curTypeTiers);
				}

				qValider.setParam("Ref_Virement", refVirement);
				qValider.setParam("Motif_Paiement", motifPaiement);
				qValider.setParam("Beneficiaire", beneficiaire);
				qValider.setParam("IBAN", iban);
				qValider.setParam("BIC", bic);
				qValider.setParam("Montant", montant);

				var result = qValider.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					oerv_aVirements.initTree(oerv_annulerLigne);
					oerv_refreshTotaux();
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oerv_supprimerLigne() {
	try {

		if (oerv_aVirements.isSelected()) {
			var virementId = oerv_aVirements.getSelectedCellText('oerv-colVirementId');

			var qSup = new QueryHttp("TB/Virements/deleteVirement.tmpl");
			qSup.setParam("Virement_Id", virementId);
			var result = qSup.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oerv_aVirements.initTree(oerv_annulerLigne);
				oerv_refreshTotaux();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oerv_selectOnVirements() {
	try {

		if (oerv_mode!="V" && oerv_aVirements.isSelected()) {
			var i = oerv_aVirements.getCurrentIndex();
			document.getElementById('oerv-refVirement').value = oerv_aVirements.getCellText(i,'oerv-colRefVirement');
			document.getElementById('oerv-motifPaiement').value = oerv_aVirements.getCellText(i,'oerv-colMotifPaiement');
			document.getElementById('oerv-beneficiaire').value = oerv_aVirements.getCellText(i,'oerv-colBeneficiaire');
			document.getElementById('oerv-iban').value = oerv_aVirements.getCellText(i,'oerv-colIBAN');
			document.getElementById('oerv-bic').value = oerv_aVirements.getCellText(i,'oerv-colBIC');
			document.getElementById('oerv-montant').value = oerv_aVirements.getCellText(i,'oerv-colMontant');
			document.getElementById('oerv-bBeneficiaire').disabled = true;
			document.getElementById('oerv-bSupprimer').disabled = false;

			var isTiers = (!isEmpty(oerv_aVirements.getCellText(i,'oerv-colNumTiers')));
			document.getElementById('oerv-beneficiaire').disabled = isTiers;
			document.getElementById('oerv-iban').disabled = isTiers;
			document.getElementById('oerv-bic').disabled = isTiers;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oerv_pressOnMontant(ev) {
	try {

		if (ev.keyCode==13) {
			oerv_validerLigne();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oerv_demandeEnregistrement() {
  try {

		if (oerv_modified) {
			if (window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es \u00E0 la remise ?")) {
				oerv_enregistrerRemise(false);
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oerv_setModified(m) {
  try {

  	oerv_modified = m;
		if (m) {
			document.getElementById('oerv-capRemise').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
			document.getElementById('oerv-bValiderRV').disabled = true;
		}
		else {
			document.getElementById('oerv-capRemise').setAttribute('image', null);
			document.getElementById('oerv-bValiderRV').disabled = false;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oerv_editerRemise() {
	try {

		document.getElementById('oerv-pdfRemise').setAttribute("src", "");
		document.getElementById("bRetourRemiseVirements").collapsed = false;
		document.getElementById("oerv-deckRemise").selectedIndex = 1;

		var qGenPdf = new QueryHttp("TB/Virements/pdfRemise.tmpl");
		qGenPdf.setParam('Remise_Id', oerv_remiseId);
		var result = qGenPdf.execute();
		var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
		document.getElementById('oerv-pdfRemise').setAttribute("src", page);

	} catch (e) {
		recup_erreur(e);
	}
}


function oerv_validerRemise() {
  try {

		var dateExecution = document.getElementById('oerv-dateExecution').value;
		var dateJour = parseDate(getDateCourante());

		if (oerv_aVirements.nbLignes()==0) {
			showWarning("La remise ne contient aucune ligne.");
		}
		else if (parseDate(dateExecution)<dateJour) { showWarning("La date d'ex\u00E9cution doit \u00EAtre sup\u00E9rieure ou \u00E9gale \u00E0 la date du jour"); }
  	else if (window.confirm("Confirmez-vous la validation de la remise ?")) {

			var qValider = new QueryHttp("TB/Virements/validRemise.tmpl");
			qValider.setParam('Remise_Id', oerv_remiseId);
			var result = qValider.execute();
			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oerv_chargerRemise();
			}
  	}

	} catch (e) {
    recup_erreur(e);
  }
}


function oerv_annulerRemise() {
	try {

		if (window.confirm("Confirmez-vous l'annulation de la remise ?")) {
			var qAnnuler = new QueryHttp("TB/Virements/cancelRemise.tmpl");
			qAnnuler.setParam('Remise_Id', oerv_remiseId);
			var result = qAnnuler.execute();
			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("La remise a \u00E9t\u00E9 annul\u00E9e.");
				oerv_chargerRemise();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oerv_downloadSepa() {
	try {

		var qSepa = new QueryHttp("TB/Virements/xmlRemiseVirementSEPA.tmpl");
		qSepa.setParam("Remise_Id", oerv_remiseId);

		var result = qSepa.execute();
		var fichier = result.responseXML.documentElement.getAttribute('FichierXML');

		var file = fileChooser("save", fichier);
		if (file!=null) {
			downloadFile(getDirBuffer()+ fichier, file);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oerv_rechercherBeneficiaire() {
	try {

		var url = "chrome://opensi/content/tb/virements/popup-rechercheBeneficiaire.xul?"+ cookie();
    window.openDialog(url,'','chrome,modal,centerscreen', oerv_retourRechercherBeneficiaire);

	} catch (e) {
		recup_erreur(e);
	}
}


function oerv_retourRechercherBeneficiaire(typeTiers, tiersId, denomination, iban, bic) {
	try {

		document.getElementById('oerv-beneficiaire').value = denomination;
		document.getElementById('oerv-iban').value = iban;
		document.getElementById('oerv-bic').value = bic;

		oerv_curTypeTiers = typeTiers;
		oerv_curTiersId = tiersId;

		if (!isEmpty(iban)) {
			document.getElementById('oerv-montant').focus();
		}
		else {
			document.getElementById('oerv-iban').focus();
		}

	} catch (e) {
    recup_erreur(e);
  }
}
