/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");


var modified = false;



function init() {
  try {

		window.addEventListener("close", demandeEnregistrement, false);
		loadPreferences();

	} catch (e) {
    recup_erreur(e);
  }
}


function desinit() {
	try {

		window.removeEventListener("close", demandeEnregistrement, false);

	} catch (e) {
    recup_erreur(e);
  }
}


function loadPreferences() {
	try {

		var qLoad = new QueryHttp("Utilisateurs/Acces/loadPreferencesAcces.tmpl");
		var result = qLoad.execute();
		var contenu = result.responseXML.documentElement;

		document.getElementById('authConsPassword').checked = contenu.getAttribute("Auth_Cons_Password")=="true";

		var delaiPassword = contenu.getAttribute("Delai_Password");
		var expirationPassword = isPositiveInteger(delaiPassword);
		document.getElementById('expirationPassword').checked = expirationPassword;
		document.getElementById('delaiPassword').value = expirationPassword?delaiPassword:"";

		pressOnExpirationPassword();

		document.getElementById("bEnregistrer").disabled = false;
		setModified(false);

	} catch (e) {
    recup_erreur(e);
  }
}


function enregistrerPreferences() {
	try {

		var authConsPassword = document.getElementById('authConsPassword').checked;
		var expirationPassword = document.getElementById('expirationPassword').checked;
		var delaiPassword = expirationPassword?document.getElementById('delaiPassword').value:0;

		if (expirationPassword && !isPositiveInteger(delaiPassword)) {
			showWarning("Dur\u00E9e de validit\u00E9 du mot de passe incorrecte");
		}
		else {
			var qUpdate = new QueryHttp("Utilisateurs/Acces/updatePreferencesAcces.tmpl");

			qUpdate.setParam("Auth_Cons_Password", authConsPassword);
			qUpdate.setParam("Delai_Password", delaiPassword);

			var result = qUpdate.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				setModified(false);
				showMessage("Pr\u00E9f\u00E9rences d'acc\u00E8s sauvegard\u00E9es");
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function pressOnExpirationPassword() {
	try {

		var expirationPassword = document.getElementById('expirationPassword').checked;

		document.getElementById('delaiPassword').disabled = !expirationPassword;

		if (!expirationPassword) {
			document.getElementById('delaiPassword').value = "";
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function setModified(modified) {
	try {

		this.modified = modified;
		document.getElementById('imgModified').collapsed = !modified;

	} catch (e) {
		recup_erreur(e);
	}
}


function demandeEnregistrement() {
	try {

		if (modified && window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es ?")) {
			enregistrerPreferences();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuPrincipal() {
	try {

		demandeEnregistrement();
		window.location = "chrome://opensi/content/utilisateurs/menu_utilisateurs.xul";

	} catch (e) {
    recup_erreur(e);
  }
}
