/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var aProfils = new Arbre('Utilisateurs/Profils/list-profilType.tmpl', 'liste-profils');

var currentProfilId = "";

var ofu_accFlash;
var ofu_accBAM;
var ofu_accMWMExpMonoBL;
var ofu_accMWMExpMultiBL;
var ofu_accMWMCdeClient;
var ofu_specLHGDV;
var ofu_specLHGRV;
var ofu_specLHGPV;
var ofu_specLHCFF;
var ofu_specLCARAP;
var ofu_specTNMPA;
var ofu_specLVPBFC;
var ofu_specLCAGEV;
var ofu_accCrossDock;
var ofu_specLHELE;
var ofu_actReassortCC;
var ofu_specSMEAR;
var ofu_actCodeStats;
var ofu_specEDEFV;
var ofu_specREERC;
var ofu_specLMECR;
var ofu_specKEESK;
var ofu_specLHFNP;
var ofu_specHMDNP;
var ofu_gacCoutTrans;


function init() {
	try {

		var qEntMWM = new QueryHttp("Utilisateurs/getEntrepriseAccMWM.tmpl");
		var result = qEntMWM.execute();
		var contenu = result.responseXML.documentElement;

		ofu_accFlash = contenu.getAttribute("Acc_MWM")=="true";
		ofu_accBAM = contenu.getAttribute("Acc_BAM")=="true";
	  ofu_accMWMExpMonoBL = contenu.getAttribute("Acc_MWM_ExpMonoBL")=="true";
	  ofu_accMWMExpMultiBL = contenu.getAttribute("Acc_MWM_ExpMultiBL")=="true";
	  ofu_accMWMCdeClient = contenu.getAttribute("Acc_MWM_CdeClient")=="true";
	  ofu_specLHGDV = contenu.getAttribute("Spec_LH_GDV")=="true";
	  ofu_specLHGRV = contenu.getAttribute("Spec_LH_GRV")=="true";
	  ofu_specLHGPV = contenu.getAttribute("Spec_LH_GPV")=="true";
	  ofu_specLHCFF = contenu.getAttribute("Spec_LH_CFF")=="true";
	  ofu_specLCARAP = contenu.getAttribute("Spec_LCA_RAP")=="true";
	  ofu_specTNMPA = contenu.getAttribute("Spec_TN_MPA")=="true";
	  ofu_specLVPBFC = contenu.getAttribute("Spec_LVP_BFC")=="true";
	  ofu_specLCAGEV = contenu.getAttribute("Spec_LCA_GEV")=="true";
	  ofu_accCrossDock = contenu.getAttribute("Acc_Cross_Dock")=="true";

		document.getElementById("cFlash").collapsed = !ofu_accFlash;
		document.getElementById("cAccBAM").collapsed = !ofu_accBAM;
		document.getElementById("tabFlash").collapsed = !ofu_accFlash;
		document.getElementById("cMWM_ExpMonoBL").collapsed = !ofu_accMWMExpMonoBL;
		document.getElementById("cMWM_ExpMultiBL").collapsed = !ofu_accMWMExpMultiBL;
		document.getElementById("cMWM_CdeClient").collapsed = !ofu_accMWMCdeClient;
		document.getElementById("cGestionIntiVente").collapsed = !ofu_specLHGDV;
		document.getElementById("rowGestionIntiVente").collapsed = !ofu_specLHGDV;
		document.getElementById("cGestionRespVente").collapsed = !ofu_specLHGRV;
		document.getElementById("rowGestionRespVente").collapsed = !ofu_specLHGRV;
		document.getElementById("cGestionPoleVente").collapsed = !ofu_specLHGPV;
		document.getElementById("rowGestionPoleVente").collapsed = !ofu_specLHGPV;
		document.getElementById("cGC_AControle").collapsed = !ofu_specLHCFF;
		document.getElementById("rowRestricAccCDVPA").collapsed = !ofu_specLCARAP;
		document.getElementById("cModifPrixFA").collapsed = !ofu_specTNMPA;
		document.getElementById("rowModifPrixFA").collapsed = !ofu_specTNMPA;
		document.getElementById("cMWM_LocCrossDock").collapsed = !ofu_accCrossDock;
		document.getElementById("cMWM_ExpCrossDock").collapsed = !ofu_accCrossDock;
		document.getElementById("cGC_EExpCrossDock").collapsed = !ofu_accCrossDock;
		document.getElementById("cGestionBloqueCli").collapsed = !ofu_specLVPBFC;
		document.getElementById("rowGestionBloqueCli").collapsed = !ofu_specLVPBFC;
		document.getElementById("cGestionEtabVente").collapsed = !ofu_specLCAGEV;
		document.getElementById("rowGestionEtabVente").collapsed = !ofu_specLCAGEV;

		ofu_specLHELE = contenu.getAttribute("Spec_LH_ELE")=="true";
		ofu_actReassortCC = contenu.getAttribute("Act_Reassort_CC")=="true";
		ofu_specSMEAR = contenu.getAttribute("Spec_SM_EAR")=="true";
		ofu_actCodeStats = contenu.getAttribute("Act_Code_Stats")=="true";
		ofu_specEDEFV = contenu.getAttribute("Spec_ED_EFV")=="true";
		ofu_specREERC = contenu.getAttribute("Spec_RE_ERC")=="true";
		ofu_specLMECR = contenu.getAttribute("Spec_LM_ECR")=="true";
		ofu_specKEESK = contenu.getAttribute("Spec_KE_ESK")=="true";
		ofu_specLHFNP = contenu.getAttribute("Spec_LH_FNP")=="true";
		ofu_specHMDNP = contenu.getAttribute("Spec_HM_DNP")=="true";
		ofu_gacCoutTrans = contenu.getAttribute("GAC_Cout_Trans")=="true";

		document.getElementById('cEditionDES_VLE').collapsed = !ofu_specLHELE;
		document.getElementById('cEditionDES_VRC').collapsed = !ofu_actReassortCC;
		document.getElementById('cEditionDES_VAR').collapsed = !ofu_specSMEAR;
		document.getElementById('cEditionDES_VCS').collapsed = !ofu_actCodeStats;
		document.getElementById('cEditionDES_VFV').collapsed = !ofu_specEDEFV;
		document.getElementById('cEditionDES_VRE').collapsed = !ofu_specREERC;
		document.getElementById('cEditionDES_VCR').collapsed = !ofu_specLMECR;
		document.getElementById('cEditionDES_VHP').collapsed = !ofu_specKEESK;
		document.getElementById('cEditionDES_ASF').collapsed = !ofu_specLHFNP;
		document.getElementById('cEditionDES_ASD').collapsed = !ofu_specHMDNP;
		document.getElementById('cEditionDES_VCT').collapsed = !ofu_gacCoutTrans;

		nouveauProfil();

	} catch (e) {
    recup_erreur(e);
  }
}


function nouveauProfil() {
	try {

		aProfils.initTree();

		document.getElementById("Intitule").value = "";
		document.getElementById("Commentaires").value = "";
		document.getElementById("cMaxValidationDC").value = "";
		document.getElementById("cModifElemFinFCA").disabled = true;

		cocherDG(false);
		cocherGC(false);
		cocherCompta(false);
		cocherStats(false);
		cocherMWM(false);

		document.getElementById("cReadOnlyGC_SArticles").checked = false;
		document.getElementById("cReadOnlyGC_VDevis").checked = false;
		document.getElementById("cReadOnlyGC_VAffaires").checked = false;
		document.getElementById("cReadOnlyGC_TClients").checked = false;
		document.getElementById("cReadOnlyGC_SIOStocks").checked = false;
		document.getElementById("cReadOnlyGC_DRegCli").checked = false;

		currentProfilId = "";

		document.getElementById("bSupprimer").disabled = true;
		document.getElementById("onglets").selectedIndex = 0;

	} catch (e) {
    recup_erreur(e);
  }
}


function dblClickOnProfil() {
	try {

		if (aProfils.isSelected()) {
			currentProfilId = aProfils.getSelectedCellText('ColProfilId');

			var qGetProfil = new QueryHttp("Utilisateurs/Profils/loadProfilType.tmpl")
			qGetProfil.setParam("Profil_Id", currentProfilId);

			var result = qGetProfil.execute();
			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				document.getElementById('Intitule').value = contenu.getAttribute("Intitule");
				document.getElementById('Commentaires').value = contenu.getAttribute("Commentaires");

				// Droits gnraux
				document.getElementById("cConfig").checked = contenu.getAttribute("Acc_Config")=="true";
				document.getElementById("cGestionCo").checked = contenu.getAttribute("Acc_Gest_Com")=="true";
				document.getElementById("cCompta").checked = contenu.getAttribute("Acc_Compta")=="true";
				document.getElementById("cContact").checked = contenu.getAttribute("Acc_CRM")=="true";
				document.getElementById("cTransac").checked = contenu.getAttribute("Acc_TB")=="true";
				document.getElementById("cFlash").checked = contenu.getAttribute("Acc_MWM")=="true";
				document.getElementById("cAccBAM").checked = contenu.getAttribute("Acc_BAM")=="true";
				document.getElementById("cDirection").checked = contenu.getAttribute("Direction")=="true";
				document.getElementById("cValidationCF").checked = contenu.getAttribute("Validation_CF")=="true";
				document.getElementById("cValidationCC").checked = contenu.getAttribute("Validation_CC")=="true";
				document.getElementById("cValidationCCZero").checked = contenu.getAttribute("Validation_CC_Zero")=="true";
				document.getElementById("cAnnulationCC").checked = contenu.getAttribute("Annulation_CC")=="true";
				document.getElementById("cValidationTS").checked = contenu.getAttribute("Validation_TS")=="true";
				document.getElementById("cValidationIS").checked = contenu.getAttribute("Validation_IS")=="true";
				document.getElementById("cValidationRG").checked = contenu.getAttribute("Validation_RG")=="true";
				document.getElementById("cValidationBR").checked = contenu.getAttribute("Validation_BR")=="true";
				document.getElementById("cValidationAF").checked = contenu.getAttribute("Validation_AF")=="true";
				document.getElementById("cValidationAC").checked = contenu.getAttribute("Validation_AC")=="true";
				document.getElementById("cValidationBP").checked = contenu.getAttribute("Validation_BP")=="true";
				document.getElementById("cAnnulationBP").checked = contenu.getAttribute("Annulation_BP")=="true";
				document.getElementById("cValidationBL").checked = contenu.getAttribute("Validation_BL")=="true";
				document.getElementById("cAnnulationBL").checked = contenu.getAttribute("Annulation_BL")=="true";
				document.getElementById("cValidationDC").checked = contenu.getAttribute("Validation_DC")=="true";
				document.getElementById("cMaxValidationDC").value = contenu.getAttribute("Max_Validation_DC");
				document.getElementById("cClotureFact").checked = contenu.getAttribute("Cloture_Fact")=="true";
				document.getElementById("cModifElemFinDV").checked = contenu.getAttribute("Modif_Elem_Fin_DV")=="true";
				document.getElementById("cModifElemFinFCA").checked = contenu.getAttribute("Modif_Elem_Fin_FCA")=="true";
				document.getElementById("cIgnorePVPlancher").checked = contenu.getAttribute("Ignore_PV_Plancher")=="true";
				document.getElementById("cEditionListeDL").checked = contenu.getAttribute("Edition_Liste_DL")=="true";
				document.getElementById("cEditionListeDA").checked = contenu.getAttribute("Edition_Liste_DA")=="true";
				document.getElementById("cEditionListeDV").checked = contenu.getAttribute("Edition_Liste_DV")=="true";
				document.getElementById("cShowTotauxDV").checked = contenu.getAttribute("Show_Totaux_DV")=="true";
				document.getElementById("cAccesCoutAchat").checked = contenu.getAttribute("Acces_Cout_Achat")=="true";
				document.getElementById("cAccesBanqueCli").checked = contenu.getAttribute("Acces_Banque_Cli")=="true";
				document.getElementById("cAccesBanqueFou").checked = contenu.getAttribute("Acces_Banque_Fou")=="true";
				document.getElementById("cRestricAccCDVPA").checked = contenu.getAttribute("Restric_Acc_CDV_PA")=="true";
				document.getElementById("cGestionDevisType").checked = contenu.getAttribute("Gestion_Devis_Type")=="true";
				document.getElementById("cShowElemFour").checked = contenu.getAttribute("Show_Elem_Four")=="true";
				document.getElementById("cGestionRespVente").checked = contenu.getAttribute("Gestion_Resp_Vente")=="true";
				document.getElementById("cGestionEtabVente").checked = contenu.getAttribute("Gestion_Etab_Vente")=="true";
				document.getElementById("cGestionPoleVente").checked = contenu.getAttribute("Gestion_Pole_Vente")=="true";
				document.getElementById("cGestionIntiVente").checked = contenu.getAttribute("Gestion_Inti_Vente")=="true";
				document.getElementById("cGestionBloqueCli").checked = contenu.getAttribute("Gestion_Bloque_Cli")=="true";
				document.getElementById("cModifStockES").checked = contenu.getAttribute("Modif_Stock_ES")=="true";
				document.getElementById("cModifPrixFA").checked = contenu.getAttribute("Modif_Prix_FA")=="true";
				document.getElementById("cModifPADV").checked = contenu.getAttribute("Modif_PA_DV")=="true";
				document.getElementById("cAnonymisationFC").checked = contenu.getAttribute("Anonymisation_FC")=="true";
				document.getElementById("cGCBrightColor").checked = contenu.getAttribute("GC_Bright_Color")=="true";

				// Accs menus gestion commerciale
				document.getElementById("cGC_TClients").checked = contenu.getAttribute("MenuGC_TClients")=="true";
				document.getElementById("cReadOnlyGC_TClients").checked = contenu.getAttribute("ReadOnlyGC_TClients")=="true";
				document.getElementById("cGC_VDevis").checked = contenu.getAttribute("MenuGC_VDevis")=="true";
				document.getElementById("cGC_ACommandes").checked = contenu.getAttribute("MenuGC_ACommandes")=="true";
				document.getElementById("cGC_SArticles").checked = contenu.getAttribute("MenuGC_SArticles")=="true";
				document.getElementById("cReadOnlyGC_SArticles").checked = contenu.getAttribute("ReadOnlyGC_SArticles")=="true";
				document.getElementById("cGC_DRegFour").checked = contenu.getAttribute("MenuGC_DRegFour")=="true";
				document.getElementById("cGC_TFournisseurs").checked = contenu.getAttribute("MenuGC_TFournisseurs")=="true";
				document.getElementById("cGC_VAffaires").checked = contenu.getAttribute("MenuGC_VAffaires")=="true";
				document.getElementById("cReadOnlyGC_VDevis").checked = contenu.getAttribute("ReadOnlyGC_VDevis")=="true";
				document.getElementById("cReadOnlyGC_VAffaires").checked = contenu.getAttribute("ReadOnlyGC_VAffaires")=="true";
				document.getElementById("cGC_APrepaCom").checked = contenu.getAttribute("MenuGC_APrepaCom")=="true";
				document.getElementById("cGC_STarifs").checked = contenu.getAttribute("MenuGC_STarifs")=="true";
				document.getElementById("cGC_DRegCli").checked = contenu.getAttribute("MenuGC_DRegCli")=="true";
				document.getElementById("cReadOnlyGC_DRegCli").checked = contenu.getAttribute("ReadOnlyGC_DRegCli")=="true";
				document.getElementById("cGC_TCommerciaux").checked = contenu.getAttribute("MenuGC_TCommerciaux")=="true";
				document.getElementById("cGC_ARecepCom").checked = contenu.getAttribute("MenuGC_ARecepCom")=="true";
				document.getElementById("cGC_SFabrication").checked = contenu.getAttribute("MenuGC_SFabrication")=="true";
				document.getElementById("cGC_DRemises").checked = contenu.getAttribute("MenuGC_DRemises")=="true";
				document.getElementById("cGC_ARetours").checked = contenu.getAttribute("MenuGC_ARetours")=="true";
				document.getElementById("cGC_SInventaire").checked = contenu.getAttribute("MenuGC_SInventaire")=="true";
				document.getElementById("cGC_DEditions").checked = contenu.getAttribute("MenuGC_DEditions")=="true";
				document.getElementById("cGC_AFactures").checked = contenu.getAttribute("MenuGC_AFactures")=="true";
				document.getElementById("cGC_AControle").checked = contenu.getAttribute("MenuGC_AControle")=="true";
				document.getElementById("cGC_STracabilite").checked = contenu.getAttribute("MenuGC_STracabilite")=="true";
				document.getElementById("cGC_DTabBord").checked = contenu.getAttribute("MenuGC_DTabBord")=="true";
				document.getElementById("cGC_VFactures").checked = contenu.getAttribute("MenuGC_VFactures")=="true";
				document.getElementById("cGC_VRetours").checked = contenu.getAttribute("MenuGC_VRetours")=="true";
				document.getElementById("cGC_STransferts").checked = contenu.getAttribute("MenuGC_STransferts")=="true";
				document.getElementById("cGC_DTransCpta").checked = contenu.getAttribute("MenuGC_DTransCpta")=="true";
				document.getElementById("cGC_VFactuAuto").checked = contenu.getAttribute("MenuGC_VFactuAuto")=="true";
				document.getElementById("cGC_SMouvements").checked = contenu.getAttribute("MenuGC_SMouvements")=="true";
				document.getElementById("cGC_SEmplacements").checked = contenu.getAttribute("MenuGC_SEmplacements")=="true";
				document.getElementById("cGC_STransEmp").checked = contenu.getAttribute("MenuGC_STransEmp")=="true";
				document.getElementById("cGC_SIOStocks").checked = contenu.getAttribute("MenuGC_SIOStocks")=="true";
				document.getElementById("cReadOnlyGC_SIOStocks").checked = contenu.getAttribute("ReadOnlyGC_SIOStocks")=="true";
				document.getElementById("cGC_SParamStocks").checked = contenu.getAttribute("MenuGC_SParamStocks")=="true";
				document.getElementById("cGC_DExportIdep").checked = contenu.getAttribute("MenuGC_DExportIdep")=="true";
				document.getElementById("cGC_DDeclEcoPart").checked = contenu.getAttribute("MenuGC_DDeclEcoPart")=="true";
				document.getElementById("cGC_VEnvoiFact").checked = contenu.getAttribute("MenuGC_VEnvoiFact")=="true";
				document.getElementById("cGC_DImpExpCsv").checked = contenu.getAttribute("MenuGC_DImpExpCsv")=="true";
				document.getElementById("cGC_VAbonnements").checked = contenu.getAttribute("MenuGC_VAbonnements")=="true";
				document.getElementById("cGC_DPassword").checked = contenu.getAttribute("MenuGC_DPassword")=="true";
				document.getElementById("cGC_EExpesCC").checked = contenu.getAttribute("MenuGC_EExpesCC")=="true";
				document.getElementById("cGC_EExpesTS").checked = contenu.getAttribute("MenuGC_EExpesTS")=="true";
				document.getElementById("cGC_EPrepaExpes").checked = contenu.getAttribute("MenuGC_EPrepaExpes")=="true";
				document.getElementById("cGC_EExpCrossDock").checked = contenu.getAttribute("MenuGC_EExpCrossDock")=="true";
				document.getElementById("cGC_ESuiviLog").checked = contenu.getAttribute("MenuGC_ESuiviLog")=="true";
				document.getElementById("cGC_ESuiviTrans").checked = contenu.getAttribute("MenuGC_ESuiviTrans")=="true";

				// Accs menus comptabilit
				document.getElementById("cCG_CSaisie").checked = contenu.getAttribute("MenuCG_CSaisie")=="true";
				document.getElementById("cCG_EBalance").checked = contenu.getAttribute("MenuCG_EBalance")=="true";
				document.getElementById("cCG_SBordGest").checked = contenu.getAttribute("MenuCG_SBordGest")=="true";
				document.getElementById("cCG_AComptes").checked = contenu.getAttribute("MenuCG_AComptes")=="true";
				document.getElementById("cCG_DComptes").checked = contenu.getAttribute("MenuCG_DComptes")=="true";
				document.getElementById("cCG_CRevision").checked = contenu.getAttribute("MenuCG_CRevision")=="true";
				document.getElementById("cCG_ECentral").checked = contenu.getAttribute("MenuCG_ECentral")=="true";
				document.getElementById("cCG_SBordTres").checked = contenu.getAttribute("MenuCG_SBordTres")=="true";
				document.getElementById("cCG_AGdLivre").checked = contenu.getAttribute("MenuCG_AGdLivre")=="true";
				document.getElementById("cCG_DAboEcr").checked = contenu.getAttribute("MenuCG_DAboEcr")=="true";
				document.getElementById("cCG_CTransCop").checked = contenu.getAttribute("MenuCG_CTransCop")=="true";
				document.getElementById("cCG_EGdLivre").checked = contenu.getAttribute("MenuCG_EGdLivre")=="true";
				document.getElementById("cCG_AParametrages").checked = contenu.getAttribute("MenuCG_AParametrages")=="true";
				document.getElementById("cCG_DModeles").checked = contenu.getAttribute("MenuCG_DModeles")=="true";
				document.getElementById("cCG_CRappro").checked = contenu.getAttribute("MenuCG_CRappro")=="true";
				document.getElementById("cCG_EJournaux").checked = contenu.getAttribute("MenuCG_EJournaux")=="true";
				document.getElementById("cCG_DImpBanque").checked = contenu.getAttribute("MenuCG_DImpBanque")=="true";
				document.getElementById("cCG_CClotMens").checked = contenu.getAttribute("MenuCG_CClotMens")=="true";
				document.getElementById("cCG_EBalAgee").checked = contenu.getAttribute("MenuCG_EBalAgee")=="true";
				document.getElementById("cCG_DImpExpEcr").checked = contenu.getAttribute("MenuCG_DImpExpEcr")=="true";
				document.getElementById("cCG_CClotExo").checked = contenu.getAttribute("MenuCG_CClotExo")=="true";
				document.getElementById("cCG_EBilan").checked = contenu.getAttribute("MenuCG_EBilan")=="true";
				document.getElementById("cCG_DPassword").checked = contenu.getAttribute("MenuCG_DPassword")=="true";
				document.getElementById("cCG_EResultat").checked = contenu.getAttribute("MenuCG_EResultat")=="true";
				document.getElementById("cCG_ESoldes").checked = contenu.getAttribute("MenuCG_ESoldes")=="true";
				document.getElementById("cCG_EPlanCpte").checked = contenu.getAttribute("MenuCG_EPlanCpte")=="true";

				// Accs statistiques
				document.getElementById("cEditionDES_CPC").checked = contenu.getAttribute("Edition_DES_CPC")=="true";
				document.getElementById("cEditionDES_CLC").checked = contenu.getAttribute("Edition_DES_CLC")=="true";
				document.getElementById("cEditionDES_FPF").checked = contenu.getAttribute("Edition_DES_FPF")=="true";
				document.getElementById("cEditionDES_FLF").checked = contenu.getAttribute("Edition_DES_FLF")=="true";
				document.getElementById("cEditionDES_SPA").checked = contenu.getAttribute("Edition_DES_SPA")=="true";
				document.getElementById("cEditionDES_SFA").checked = contenu.getAttribute("Edition_DES_SFA")=="true";
				document.getElementById("cEditionDES_SMS").checked = contenu.getAttribute("Edition_DES_SMS")=="true";
				document.getElementById("cEditionDES_SES").checked = contenu.getAttribute("Edition_DES_SES")=="true";
				document.getElementById("cEditionDES_SRS").checked = contenu.getAttribute("Edition_DES_SRS")=="true";
				document.getElementById("cEditionDES_SPF").checked = contenu.getAttribute("Edition_DES_SPF")=="true";
				document.getElementById("cEditionDES_SMA").checked = contenu.getAttribute("Edition_DES_SMA")=="true";
				document.getElementById("cEditionDES_VJV").checked = contenu.getAttribute("Edition_DES_VJV")=="true";
				document.getElementById("cEditionDES_VJA").checked = contenu.getAttribute("Edition_DES_VJA")=="true";
				document.getElementById("cEditionDES_VVA").checked = contenu.getAttribute("Edition_DES_VVA")=="true";
				document.getElementById("cEditionDES_VFA").checked = contenu.getAttribute("Edition_DES_VFA")=="true";
				document.getElementById("cEditionDES_VFC").checked = contenu.getAttribute("Edition_DES_VFC")=="true";
				document.getElementById("cEditionDES_VFD").checked = contenu.getAttribute("Edition_DES_VFD")=="true";
				document.getElementById("cEditionDES_VSC").checked = contenu.getAttribute("Edition_DES_VSC")=="true";
				document.getElementById("cEditionDES_VLE").checked = contenu.getAttribute("Edition_DES_VLE")=="true";
				document.getElementById("cEditionDES_VLC").checked = contenu.getAttribute("Edition_DES_VLC")=="true";
				document.getElementById("cEditionDES_VEC").checked = contenu.getAttribute("Edition_DES_VEC")=="true";
				document.getElementById("cEditionDES_VCT").checked = contenu.getAttribute("Edition_DES_VCT")=="true";
				document.getElementById("cEditionDES_VRC").checked = contenu.getAttribute("Edition_DES_VRC")=="true";
				document.getElementById("cEditionDES_VAR").checked = contenu.getAttribute("Edition_DES_VAR")=="true";
				document.getElementById("cEditionDES_VCS").checked = contenu.getAttribute("Edition_DES_VCS")=="true";
				document.getElementById("cEditionDES_VFV").checked = contenu.getAttribute("Edition_DES_VFV")=="true";
				document.getElementById("cEditionDES_VRE").checked = contenu.getAttribute("Edition_DES_VRE")=="true";
				document.getElementById("cEditionDES_VCR").checked = contenu.getAttribute("Edition_DES_VCR")=="true";
				document.getElementById("cEditionDES_VHP").checked = contenu.getAttribute("Edition_DES_VHP")=="true";
				document.getElementById("cEditionDES_AJA").checked = contenu.getAttribute("Edition_DES_AJA")=="true";
				document.getElementById("cEditionDES_AAC").checked = contenu.getAttribute("Edition_DES_AAC")=="true";
				document.getElementById("cEditionDES_AAA").checked = contenu.getAttribute("Edition_DES_AAA")=="true";
				document.getElementById("cEditionDES_AEF").checked = contenu.getAttribute("Edition_DES_AEF")=="true";
				document.getElementById("cEditionDES_ARF").checked = contenu.getAttribute("Edition_DES_ARF")=="true";
				document.getElementById("cEditionDES_ASF").checked = contenu.getAttribute("Edition_DES_ASF")=="true";
				document.getElementById("cEditionDES_ASD").checked = contenu.getAttribute("Edition_DES_ASD")=="true";

				// Accs menus module flash
				document.getElementById("cMWM_ExpMonoBL").checked = contenu.getAttribute("MenuMWM_ExpMonoBL")=="true";
				document.getElementById("cMWM_ExpMultiBL").checked = contenu.getAttribute("MenuMWM_ExpMultiBL")=="true";
				document.getElementById("cMWM_CdeClient").checked = contenu.getAttribute("MenuMWM_CdeClient")=="true";
				document.getElementById("cMWM_PrepExpedition").checked = contenu.getAttribute("MenuMWM_PrepExpedition")=="true";
				document.getElementById("cMWM_InfoArticle").checked = contenu.getAttribute("MenuMWM_InfoArticle")=="true";
				document.getElementById("cMWM_Inventaire").checked = contenu.getAttribute("MenuMWM_Inventaire")=="true";
				document.getElementById("cMWM_Inv_Show_SI").checked = contenu.getAttribute("MWM_Inv_Show_SI")=="true";
				document.getElementById("cMWM_Reception").checked = contenu.getAttribute("MenuMWM_Reception")=="true";
				document.getElementById("cMWM_Rangement").checked = contenu.getAttribute("MenuMWM_Rangement")=="true";
				document.getElementById("cMWM_LocCrossDock").checked = contenu.getAttribute("MenuMWM_LocCrossDock")=="true";
				document.getElementById("cMWM_ExpCrossDock").checked = contenu.getAttribute("MenuMWM_ExpCrossDock")=="true";
				document.getElementById("cMWM_EntSortStk").checked = contenu.getAttribute("MenuMWM_EntSortStk")=="true";
				document.getElementById("cMWM_ChangeEmp").checked = contenu.getAttribute("MenuMWM_ChangeEmp")=="true";
				document.getElementById("cMWM_TransEmp").checked = contenu.getAttribute("MenuMWM_TransEmp")=="true";
				document.getElementById("cMWM_ConsultEmp").checked = contenu.getAttribute("MenuMWM_ConsultEmp")=="true";
				document.getElementById("cMWM_RecepRetCli").checked = contenu.getAttribute("MenuMWM_RecepRetCli")=="true";
				document.getElementById("cMWM_Picking").checked = contenu.getAttribute("MenuMWM_Picking")=="true";
				document.getElementById("cMWM_Controle_Picking").checked = contenu.getAttribute("MWM_Controle_Picking")=="true";
				document.getElementById("cMWM_PrepExpress").checked = contenu.getAttribute("MenuMWM_PrepExpress")=="true";
				document.getElementById("cMWM_Controle").checked = contenu.getAttribute("MenuMWM_Controle")=="true";
				document.getElementById("cMWM_Impression").checked = contenu.getAttribute("MenuMWM_Impression")=="true";
				document.getElementById("cMWM_Localisation").checked = contenu.getAttribute("MenuMWM_Localisation")=="true";
				document.getElementById("cMWM_PEX_Quantite").checked = contenu.getAttribute("MWM_PEX_Quantite")=="true";
				document.getElementById("cMWM_PEX_Qte_Manquante").checked = contenu.getAttribute("MWM_PEX_Qte_Manquante")=="true";
				document.getElementById("cMWM_Scan_Borne").checked = contenu.getAttribute("MWM_Scan_Borne")=="true";
				document.getElementById("cMWM_Info_Art_Chg_Emp").checked = contenu.getAttribute("MWM_Info_Art_Chg_Emp")=="true";

				document.getElementById("bSupprimer").disabled = false;

				document.getElementById("cMaxValidationDC").disabled = !document.getElementById("cValidationDC").checked;
				document.getElementById("cModifElemFinFCA").disabled = !document.getElementById("cModifElemFinDV").checked;
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function supprimerProfil() {
	try {

		if (!isEmpty(currentProfilId) && window.confirm("Confirmez-vous la suppression de ce profil ?")) {

			var qDelete = new QueryHttp("Utilisateurs/Profils/deleteProfilType.tmpl");
			qDelete.setParam("Profil_Id", currentProfilId);
			qDelete.execute();

			nouveauProfil();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function enregistrerProfil() {
	try {

		var intitule = document.getElementById('Intitule').value;
		var commentaires = document.getElementById('Commentaires').value;

		// droits gnraux
		var acc_compta = document.getElementById("cCompta").checked;
		var acc_contact = document.getElementById("cContact").checked;
		var acc_transac = document.getElementById("cTransac").checked;
		var acc_gest_com = document.getElementById("cGestionCo").checked;
		var acc_config = document.getElementById("cConfig").checked;
		var acc_flash = document.getElementById("cFlash").checked;
		var accBAM = document.getElementById("cAccBAM").checked;
		var direction = document.getElementById("cDirection").checked;
		var validationCF = document.getElementById("cValidationCF").checked;
		var validationCC = document.getElementById("cValidationCC").checked;
		var validationCCZero = document.getElementById("cValidationCCZero").checked;
		var annulationCC = document.getElementById("cAnnulationCC").checked;
		var validationTS = document.getElementById("cValidationTS").checked;
		var validationIS = document.getElementById("cValidationIS").checked;
		var validationRG = document.getElementById("cValidationRG").checked;
		var validationBR = document.getElementById("cValidationBR").checked;
		var validationAF = document.getElementById("cValidationAF").checked;
		var validationAC = document.getElementById("cValidationAC").checked;
		var validationBP = document.getElementById("cValidationBP").checked;
		var annulationBP = document.getElementById("cAnnulationBP").checked;
		var validationBL = document.getElementById("cValidationBL").checked;
		var annulationBL = document.getElementById("cAnnulationBL").checked;
		var validationDC = document.getElementById("cValidationDC").checked;
		var maxValidationDC = validationDC?document.getElementById("cMaxValidationDC").value:"";
		var clotureFact = document.getElementById("cClotureFact").checked;
		var modifElemFinDV = document.getElementById("cModifElemFinDV").checked;
		var modifElemFinFCA = document.getElementById("cModifElemFinFCA").checked;
		var ignorePVPlancher = document.getElementById("cIgnorePVPlancher").checked;
		var editionListeDL = document.getElementById("cEditionListeDL").checked;
		var editionListeDA = document.getElementById("cEditionListeDA").checked;
		var editionListeDV = document.getElementById("cEditionListeDV").checked;
		var showTotauxDV = document.getElementById("cShowTotauxDV").checked;
		var accesCoutAchat = document.getElementById("cAccesCoutAchat").checked;
		var accesBanqueCli = document.getElementById("cAccesBanqueCli").checked;
		var accesBanqueFou = document.getElementById("cAccesBanqueFou").checked;
		var restricAccCDVPA = document.getElementById("cRestricAccCDVPA").checked;
		var gestionDevisType = document.getElementById("cGestionDevisType").checked;
		var showElemFour = document.getElementById("cShowElemFour").checked;
		var gestionRespVente = document.getElementById("cGestionRespVente").checked;
		var gestionEtabVente = document.getElementById("cGestionEtabVente").checked;
		var gestionPoleVente = document.getElementById("cGestionPoleVente").checked;
		var gestionIntiVente = document.getElementById("cGestionIntiVente").checked;
		var gestionBloqueCli = document.getElementById("cGestionBloqueCli").checked;
		var modifStockES = document.getElementById("cModifStockES").checked;
		var modifPrixFA = document.getElementById("cModifPrixFA").checked;
		var modifPADV = document.getElementById("cModifPADV").checked;
		var anonymisationFC = document.getElementById("cAnonymisationFC").checked;
		var gcBrightColor = document.getElementById("cGCBrightColor").checked;

		// accs aux menus de gestion commerciale
		var MenuGC_TClients = document.getElementById("cGC_TClients").checked;
		var ReadOnlyGC_TClients = document.getElementById("cReadOnlyGC_TClients").checked;
		var MenuGC_TFournisseurs = document.getElementById("cGC_TFournisseurs").checked;
		var MenuGC_TCommerciaux = document.getElementById("cGC_TCommerciaux").checked;

		var MenuGC_VDevis = document.getElementById("cGC_VDevis").checked;
		var MenuGC_VAffaires = document.getElementById("cGC_VAffaires").checked;
		var ReadOnlyGC_VDevis = document.getElementById("cReadOnlyGC_VDevis").checked;
		var ReadOnlyGC_VAffaires = document.getElementById("cReadOnlyGC_VAffaires").checked;
		var MenuGC_VRetours = document.getElementById("cGC_VRetours").checked;
		var MenuGC_VFactures = document.getElementById("cGC_VFactures").checked;
		var MenuGC_VFactuAuto = document.getElementById("cGC_VFactuAuto").checked;
		var MenuGC_VEnvoiFact = document.getElementById("cGC_VEnvoiFact").checked;
		var MenuGC_VAbonnements = document.getElementById("cGC_VAbonnements").checked;

		var MenuGC_EExpesCC = document.getElementById("cGC_EExpesCC").checked;
		var MenuGC_EExpesTS = document.getElementById("cGC_EExpesTS").checked;
		var MenuGC_EPrepaExpes = document.getElementById("cGC_EPrepaExpes").checked;
		var MenuGC_EExpCrossDock = document.getElementById("cGC_EExpCrossDock").checked;
		var MenuGC_ESuiviLog = document.getElementById("cGC_ESuiviLog").checked;
		var MenuGC_ESuiviTrans = document.getElementById("cGC_ESuiviTrans").checked;

		var MenuGC_ACommandes = document.getElementById("cGC_ACommandes").checked;
		var MenuGC_APrepaCom = document.getElementById("cGC_APrepaCom").checked;
		var MenuGC_ARecepCom = document.getElementById("cGC_ARecepCom").checked;
		var MenuGC_ARetours = document.getElementById("cGC_ARetours").checked;
		var MenuGC_AFactures = document.getElementById("cGC_AFactures").checked;
		var MenuGC_AControle = document.getElementById("cGC_AControle").checked;

		var MenuGC_SArticles = document.getElementById("cGC_SArticles").checked;
		var ReadOnlyGC_SArticles = document.getElementById("cReadOnlyGC_SArticles").checked;
		var MenuGC_STarifs = document.getElementById("cGC_STarifs").checked;
		var MenuGC_SFabrication = document.getElementById("cGC_SFabrication").checked;
		var MenuGC_SInventaire = document.getElementById("cGC_SInventaire").checked;
		var MenuGC_STracabilite = document.getElementById("cGC_STracabilite").checked;
		var MenuGC_STransferts = document.getElementById("cGC_STransferts").checked;
		var MenuGC_SMouvements = document.getElementById("cGC_SMouvements").checked;
		var MenuGC_SEmplacements = document.getElementById("cGC_SEmplacements").checked;
		var MenuGC_STransEmp = document.getElementById("cGC_STransEmp").checked;
		var MenuGC_SIOStocks = document.getElementById("cGC_SIOStocks").checked;
		var ReadOnlyGC_SIOStocks = document.getElementById("cReadOnlyGC_SIOStocks").checked;
		var MenuGC_SParamStocks = document.getElementById("cGC_SParamStocks").checked;

		var MenuGC_DRegFour =  document.getElementById("cGC_DRegFour").checked;
		var MenuGC_DRegCli = document.getElementById("cGC_DRegCli").checked;
		var ReadOnlyGC_DRegCli = document.getElementById("cReadOnlyGC_DRegCli").checked;
		var MenuGC_DRemises = document.getElementById("cGC_DRemises").checked;
		var MenuGC_DEditions = document.getElementById("cGC_DEditions").checked;
		var MenuGC_DTabBord = document.getElementById("cGC_DTabBord").checked;
		var MenuGC_DTransCpta = document.getElementById("cGC_DTransCpta").checked;
		var MenuGC_DExportIdep = document.getElementById("cGC_DExportIdep").checked;
		var MenuGC_DDeclEcoPart = document.getElementById("cGC_DDeclEcoPart").checked;
		var MenuGC_DImpExpCsv = document.getElementById("cGC_DImpExpCsv").checked;
		var MenuGC_DPassword = document.getElementById("cGC_DPassword").checked;

		// accs menus comptabilit
		var MenuCG_CSaisie = document.getElementById("cCG_CSaisie").checked;
		var MenuCG_CRevision = document.getElementById("cCG_CRevision").checked;
		var MenuCG_CTransCop = document.getElementById("cCG_CTransCop").checked;
		var MenuCG_CRappro = document.getElementById("cCG_CRappro").checked;
		var MenuCG_CClotMens = document.getElementById("cCG_CClotMens").checked;
		var MenuCG_CClotExo = document.getElementById("cCG_CClotExo").checked;

		var MenuCG_EBalance = document.getElementById("cCG_EBalance").checked;
		var MenuCG_ECentral = document.getElementById("cCG_ECentral").checked;
		var MenuCG_EGdLivre = document.getElementById("cCG_EGdLivre").checked;
		var MenuCG_EJournaux = document.getElementById("cCG_EJournaux").checked;
		var MenuCG_EBalAgee = document.getElementById("cCG_EBalAgee").checked;
		var MenuCG_EBilan = document.getElementById("cCG_EBilan").checked;
		var MenuCG_EResultat = document.getElementById("cCG_EResultat").checked;
		var MenuCG_ESoldes = document.getElementById("cCG_ESoldes").checked;
		var MenuCG_EPlanCpte = document.getElementById("cCG_EPlanCpte").checked;

		var MenuCG_SBordGest = document.getElementById("cCG_SBordGest").checked;
		var MenuCG_SBordTres = document.getElementById("cCG_SBordTres").checked;

		var MenuCG_AComptes = document.getElementById("cCG_AComptes").checked;
		var MenuCG_AGdLivre = document.getElementById("cCG_AGdLivre").checked;
		var MenuCG_AParametrages = document.getElementById("cCG_AParametrages").checked;

		var MenuCG_DComptes = document.getElementById("cCG_DComptes").checked;
		var MenuCG_DAboEcr = document.getElementById("cCG_DAboEcr").checked;
		var MenuCG_DModeles = document.getElementById("cCG_DModeles").checked;
		var MenuCG_DImpBanque = document.getElementById("cCG_DImpBanque").checked;
		var MenuCG_DImpExpEcr = document.getElementById("cCG_DImpExpEcr").checked;
		var MenuCG_DPassword = document.getElementById("cCG_DPassword").checked;

		// accs statistiques
		var editionDES_CPC = document.getElementById("cEditionDES_CPC").checked;
		var editionDES_CLC = document.getElementById("cEditionDES_CLC").checked;
		var editionDES_FPF = document.getElementById("cEditionDES_FPF").checked;
		var editionDES_FLF = document.getElementById("cEditionDES_FLF").checked;
		var editionDES_SPA = document.getElementById("cEditionDES_SPA").checked;
		var editionDES_SFA = document.getElementById("cEditionDES_SFA").checked;
		var editionDES_SMS = document.getElementById("cEditionDES_SMS").checked;
		var editionDES_SES = document.getElementById("cEditionDES_SES").checked;
		var editionDES_SRS = document.getElementById("cEditionDES_SRS").checked;
		var editionDES_SPF = document.getElementById("cEditionDES_SPF").checked;
		var editionDES_SMA = document.getElementById("cEditionDES_SMA").checked;
		var editionDES_VJV = document.getElementById("cEditionDES_VJV").checked;
		var editionDES_VJA = document.getElementById("cEditionDES_VJA").checked;
		var editionDES_VVA = document.getElementById("cEditionDES_VVA").checked;
		var editionDES_VFA = document.getElementById("cEditionDES_VFA").checked;
		var editionDES_VFC = document.getElementById("cEditionDES_VFC").checked;
		var editionDES_VFD = document.getElementById("cEditionDES_VFD").checked;
		var editionDES_VSC = document.getElementById("cEditionDES_VSC").checked;
		var editionDES_VLE = document.getElementById("cEditionDES_VLE").checked;
		var editionDES_VLC = document.getElementById("cEditionDES_VLC").checked;
		var editionDES_VEC = document.getElementById("cEditionDES_VEC").checked;
		var editionDES_VCT = document.getElementById("cEditionDES_VCT").checked;
		var editionDES_VRC = document.getElementById("cEditionDES_VRC").checked;
		var editionDES_VAR = document.getElementById("cEditionDES_VAR").checked;
		var editionDES_VCS = document.getElementById("cEditionDES_VCS").checked;
		var editionDES_VFV = document.getElementById("cEditionDES_VFV").checked;
		var editionDES_VRE = document.getElementById("cEditionDES_VRE").checked;
		var editionDES_VCR = document.getElementById("cEditionDES_VCR").checked;
		var editionDES_VHP = document.getElementById("cEditionDES_VHP").checked;
		var editionDES_AJA = document.getElementById("cEditionDES_AJA").checked;
		var editionDES_AAC = document.getElementById("cEditionDES_AAC").checked;
		var editionDES_AAA = document.getElementById("cEditionDES_AAA").checked;
		var editionDES_AEF = document.getElementById("cEditionDES_AEF").checked;
		var editionDES_ARF = document.getElementById("cEditionDES_ARF").checked;
		var editionDES_ASF = document.getElementById("cEditionDES_ASF").checked;
		var editionDES_ASD = document.getElementById("cEditionDES_ASD").checked;

		// accs menus module flash
		var MenuMWM_ExpMonoBL = document.getElementById("cMWM_ExpMonoBL").checked;
		var MenuMWM_ExpMultiBL = document.getElementById("cMWM_ExpMultiBL").checked;
		var MenuMWM_CdeClient = document.getElementById("cMWM_CdeClient").checked;
		var MenuMWM_PrepExpedition = document.getElementById("cMWM_PrepExpedition").checked;
		var MenuMWM_InfoArticle = document.getElementById("cMWM_InfoArticle").checked;
		var MenuMWM_Inventaire = document.getElementById("cMWM_Inventaire").checked;
		var MWM_Inv_Show_SI = document.getElementById("cMWM_Inv_Show_SI").checked;
		var MenuMWM_Reception = document.getElementById("cMWM_Reception").checked;
		var MenuMWM_Rangement = document.getElementById("cMWM_Rangement").checked;
		var MenuMWM_LocCrossDock = document.getElementById("cMWM_LocCrossDock").checked;
		var MenuMWM_ExpCrossDock = document.getElementById("cMWM_ExpCrossDock").checked;
		var MenuMWM_EntSortStk = document.getElementById("cMWM_EntSortStk").checked;
		var MenuMWM_ChangeEmp = document.getElementById("cMWM_ChangeEmp").checked;
		var MenuMWM_TransEmp = document.getElementById("cMWM_TransEmp").checked;
		var MenuMWM_ConsultEmp = document.getElementById("cMWM_ConsultEmp").checked;
		var MenuMWM_RecepRetCli = document.getElementById("cMWM_RecepRetCli").checked;
		var MenuMWM_Picking = document.getElementById("cMWM_Picking").checked;
		var MWM_Controle_Picking = document.getElementById("cMWM_Controle_Picking").checked;
		var MenuMWM_PrepExpress = document.getElementById("cMWM_PrepExpress").checked;
		var MenuMWM_Controle = document.getElementById("cMWM_Controle").checked;
		var MenuMWM_Impression = document.getElementById("cMWM_Impression").checked;
		var MenuMWM_Localisation = document.getElementById("cMWM_Localisation").checked;
		var MWM_PEX_Quantite = document.getElementById("cMWM_PEX_Quantite").checked;
		var MWM_PEX_Qte_Manquante = document.getElementById("cMWM_PEX_Qte_Manquante").checked;
		var MWM_Scan_Borne = document.getElementById("cMWM_Scan_Borne").checked;
		var MWM_Info_Art_Chg_Emp = document.getElementById("cMWM_Info_Art_Chg_Emp").checked;

		if (intitule=="") {
			showWarning("Veuillez saisir un intitul\u00E9");
		}
		else if (!isEmpty(maxValidationDC) && !isPositiveOrNull(maxValidationDC)) {
			showWarning("Montant maximum de validation d'un devis incorrect");
		}
		else {

			var qSave;

			if(currentProfilId != "") {
				qSave = new QueryHttp("Utilisateurs/Profils/updateProfilType.tmpl");
				qSave.setParam("Profil_Id", currentProfilId);
			}
			else {
				qSave = new QueryHttp("Utilisateurs/Profils/createProfilType.tmpl");
			}

			qSave.setParam("Intitule", intitule);
			qSave.setParam("Commentaires", commentaires);

			// droits gnraux
			qSave.setParam("Acc_Compta", acc_compta);
			qSave.setParam("Acc_CRM", acc_contact);
			qSave.setParam("Acc_Gest_Com", acc_gest_com);
			qSave.setParam("Acc_TB", acc_transac);
			qSave.setParam("Acc_Config", acc_config);
			qSave.setParam("Acc_MWM", acc_flash);
			qSave.setParam("Acc_BAM", accBAM);
			qSave.setParam("Direction", direction);
			qSave.setParam("Validation_CF", validationCF);
			qSave.setParam("Validation_CC", validationCC);
			qSave.setParam("Validation_CC_Zero", validationCCZero);
			qSave.setParam("Annulation_CC", annulationCC);
			qSave.setParam("Validation_TS", validationTS);
			qSave.setParam("Validation_IS", validationIS);
			qSave.setParam("Validation_RG", validationRG);
			qSave.setParam("Validation_BR", validationBR);
			qSave.setParam("Validation_AF", validationAF);
			qSave.setParam("Validation_AC", validationAC);
			qSave.setParam("Validation_BP", validationBP);
			qSave.setParam("Annulation_BP", annulationBP);
			qSave.setParam("Validation_BL", validationBL);
			qSave.setParam("Annulation_BL", annulationBL);
			qSave.setParam("Validation_DC", validationDC);
			qSave.setParam("Max_Validation_DC", maxValidationDC);
			qSave.setParam("Cloture_Fact", clotureFact);
			qSave.setParam("Modif_Elem_Fin_DV", modifElemFinDV);
			qSave.setParam("Modif_Elem_Fin_FCA", modifElemFinFCA);
			qSave.setParam("Ignore_PV_Plancher", ignorePVPlancher);
			qSave.setParam("Edition_Liste_DL", editionListeDL);
			qSave.setParam("Edition_Liste_DA", editionListeDA);
			qSave.setParam("Edition_Liste_DV", editionListeDV);
			qSave.setParam("Show_Totaux_DV", showTotauxDV);
			qSave.setParam("Acces_Cout_Achat", accesCoutAchat);
			qSave.setParam("Acces_Banque_Cli", accesBanqueCli);
			qSave.setParam("Acces_Banque_Fou", accesBanqueFou);
			qSave.setParam("Restric_Acc_CDV_PA", restricAccCDVPA);
			qSave.setParam("Gestion_Devis_Type", gestionDevisType);
			qSave.setParam("Show_Elem_Four", showElemFour);
			qSave.setParam("Gestion_Resp_Vente", gestionRespVente);
			qSave.setParam("Gestion_Etab_Vente", gestionEtabVente);
			qSave.setParam("Gestion_Pole_Vente", gestionPoleVente);
			qSave.setParam("Gestion_Inti_Vente", gestionIntiVente);
			qSave.setParam("Gestion_Bloque_Cli", gestionBloqueCli);
			qSave.setParam("Modif_Stock_ES", modifStockES);
			qSave.setParam("Modif_Prix_FA", modifPrixFA);
			qSave.setParam("Modif_PA_DV", modifPADV);
			qSave.setParam("Anonymisation_FC", anonymisationFC);
			qSave.setParam("GC_Bright_Color", gcBrightColor);

			// acces aux menus de gestion commerciale
			qSave.setParam("MenuGC_TClients", MenuGC_TClients);
			qSave.setParam("ReadOnlyGC_TClients", ReadOnlyGC_TClients);
			qSave.setParam("MenuGC_TFournisseurs", MenuGC_TFournisseurs);
			qSave.setParam("MenuGC_TCommerciaux", MenuGC_TCommerciaux);

			qSave.setParam("MenuGC_VDevis", MenuGC_VDevis);
			qSave.setParam("MenuGC_VAffaires", MenuGC_VAffaires);
			qSave.setParam("ReadOnlyGC_VDevis", ReadOnlyGC_VDevis);
			qSave.setParam("ReadOnlyGC_VAffaires", ReadOnlyGC_VAffaires);
			qSave.setParam("MenuGC_VRetours", MenuGC_VRetours);
			qSave.setParam("MenuGC_VFactures", MenuGC_VFactures);
			qSave.setParam("MenuGC_VFactuAuto", MenuGC_VFactuAuto);
			qSave.setParam("MenuGC_VEnvoiFact", MenuGC_VEnvoiFact);
			qSave.setParam("MenuGC_VAbonnements", MenuGC_VAbonnements);

			qSave.setParam("MenuGC_EExpesCC", MenuGC_EExpesCC);
			qSave.setParam("MenuGC_EExpesTS", MenuGC_EExpesTS);
			qSave.setParam("MenuGC_EPrepaExpes", MenuGC_EPrepaExpes);
			qSave.setParam("MenuGC_EExpCrossDock", MenuGC_EExpCrossDock);
			qSave.setParam("MenuGC_ESuiviLog", MenuGC_ESuiviLog);
			qSave.setParam("MenuGC_ESuiviTrans", MenuGC_ESuiviTrans);

			qSave.setParam("MenuGC_ACommandes", MenuGC_ACommandes);
			qSave.setParam("MenuGC_APrepaCom", MenuGC_APrepaCom);
			qSave.setParam("MenuGC_ARecepCom", MenuGC_ARecepCom);
			qSave.setParam("MenuGC_ARetours", MenuGC_ARetours);
			qSave.setParam("MenuGC_AFactures", MenuGC_AFactures);
			qSave.setParam("MenuGC_AControle", MenuGC_AControle);

			qSave.setParam("MenuGC_SArticles", MenuGC_SArticles);
			qSave.setParam("ReadOnlyGC_SArticles", ReadOnlyGC_SArticles);
			qSave.setParam("MenuGC_STarifs", MenuGC_STarifs);
			qSave.setParam("MenuGC_SFabrication", MenuGC_SFabrication);
			qSave.setParam("MenuGC_SInventaire", MenuGC_SInventaire);
			qSave.setParam("MenuGC_STracabilite", MenuGC_STracabilite);
			qSave.setParam("MenuGC_STransferts", MenuGC_STransferts);
			qSave.setParam("MenuGC_SMouvements", MenuGC_SMouvements);
			qSave.setParam("MenuGC_SEmplacements", MenuGC_SEmplacements);
			qSave.setParam("MenuGC_STransEmp", MenuGC_STransEmp);
			qSave.setParam("MenuGC_SIOStocks", MenuGC_SIOStocks);
			qSave.setParam("ReadOnlyGC_SIOStocks", ReadOnlyGC_SIOStocks);
			qSave.setParam("MenuGC_SParamStocks", MenuGC_SParamStocks);

			qSave.setParam("MenuGC_DRegFour", MenuGC_DRegFour);
			qSave.setParam("MenuGC_DRegCli", MenuGC_DRegCli);
			qSave.setParam("ReadOnlyGC_DRegCli", ReadOnlyGC_DRegCli);
			qSave.setParam("MenuGC_DRemises", MenuGC_DRemises);
			qSave.setParam("MenuGC_DEditions", MenuGC_DEditions);
			qSave.setParam("MenuGC_DTabBord", MenuGC_DTabBord);
			qSave.setParam("MenuGC_DTransCpta", MenuGC_DTransCpta);
			qSave.setParam("MenuGC_DExportIdep", MenuGC_DExportIdep);
			qSave.setParam("MenuGC_DDeclEcoPart", MenuGC_DDeclEcoPart);
			qSave.setParam("MenuGC_DImpExpCsv", MenuGC_DImpExpCsv);
			qSave.setParam("MenuGC_DPassword", MenuGC_DPassword);

			// accs menus comptabilit
			qSave.setParam("MenuCG_CSaisie", MenuCG_CSaisie);
			qSave.setParam("MenuCG_CRevision", MenuCG_CRevision);
			qSave.setParam("MenuCG_CTransCop", MenuCG_CTransCop);
			qSave.setParam("MenuCG_CRappro", MenuCG_CRappro);
			qSave.setParam("MenuCG_CClotMens", MenuCG_CClotMens);
			qSave.setParam("MenuCG_CClotExo", MenuCG_CClotExo);

			qSave.setParam("MenuCG_EBalance", MenuCG_EBalance);
			qSave.setParam("MenuCG_ECentral", MenuCG_ECentral);
			qSave.setParam("MenuCG_EGdLivre", MenuCG_EGdLivre);
			qSave.setParam("MenuCG_EJournaux", MenuCG_EJournaux);
			qSave.setParam("MenuCG_EBalAgee", MenuCG_EBalAgee);
			qSave.setParam("MenuCG_EBilan", MenuCG_EBilan);
			qSave.setParam("MenuCG_EResultat", MenuCG_EResultat);
			qSave.setParam("MenuCG_ESoldes", MenuCG_ESoldes);
			qSave.setParam("MenuCG_EPlanCpte", MenuCG_EPlanCpte);

			qSave.setParam("MenuCG_SBordGest", MenuCG_SBordGest);
			qSave.setParam("MenuCG_SBordTres", MenuCG_SBordTres);

			qSave.setParam("MenuCG_AComptes", MenuCG_AComptes);
			qSave.setParam("MenuCG_AGdLivre", MenuCG_AGdLivre);
			qSave.setParam("MenuCG_AParametrages", MenuCG_AParametrages);

			qSave.setParam("MenuCG_DComptes", MenuCG_DComptes);
			qSave.setParam("MenuCG_DAboEcr", MenuCG_DAboEcr);
			qSave.setParam("MenuCG_DModeles", MenuCG_DModeles);
			qSave.setParam("MenuCG_DImpBanque", MenuCG_DImpBanque);
			qSave.setParam("MenuCG_DImpExpEcr", MenuCG_DImpExpEcr);
			qSave.setParam("MenuCG_DPassword", MenuCG_DPassword);

			// accs statistiques
			qSave.setParam("Edition_DES_CPC", editionDES_CPC);
			qSave.setParam("Edition_DES_CLC", editionDES_CLC);
			qSave.setParam("Edition_DES_FPF", editionDES_FPF);
			qSave.setParam("Edition_DES_FLF", editionDES_FLF);
			qSave.setParam("Edition_DES_SPA", editionDES_SPA);
			qSave.setParam("Edition_DES_SFA", editionDES_SFA);
			qSave.setParam("Edition_DES_SMS", editionDES_SMS);
			qSave.setParam("Edition_DES_SES", editionDES_SES);
			qSave.setParam("Edition_DES_SRS", editionDES_SRS);
			qSave.setParam("Edition_DES_SPF", editionDES_SPF);
			qSave.setParam("Edition_DES_SMA", editionDES_SMA);
			qSave.setParam("Edition_DES_VJV", editionDES_VJV);
			qSave.setParam("Edition_DES_VJA", editionDES_VJA);
			qSave.setParam("Edition_DES_VVA", editionDES_VVA);
			qSave.setParam("Edition_DES_VFA", editionDES_VFA);
			qSave.setParam("Edition_DES_VFC", editionDES_VFC);
			qSave.setParam("Edition_DES_VFD", editionDES_VFD);
			qSave.setParam("Edition_DES_VSC", editionDES_VSC);
			qSave.setParam("Edition_DES_VLE", editionDES_VLE);
			qSave.setParam("Edition_DES_VLC", editionDES_VLC);
			qSave.setParam("Edition_DES_VEC", editionDES_VEC);
			qSave.setParam("Edition_DES_VCT", editionDES_VCT);
			qSave.setParam("Edition_DES_VRC", editionDES_VRC);
			qSave.setParam("Edition_DES_VAR", editionDES_VAR);
			qSave.setParam("Edition_DES_VCS", editionDES_VCS);
			qSave.setParam("Edition_DES_VFV", editionDES_VFV);
			qSave.setParam("Edition_DES_VRE", editionDES_VRE);
			qSave.setParam("Edition_DES_VCR", editionDES_VCR);
			qSave.setParam("Edition_DES_VHP", editionDES_VHP);
			qSave.setParam("Edition_DES_AJA", editionDES_AJA);
			qSave.setParam("Edition_DES_AAC", editionDES_AAC);
			qSave.setParam("Edition_DES_AAA", editionDES_AAA);
			qSave.setParam("Edition_DES_AEF", editionDES_AEF);
			qSave.setParam("Edition_DES_ARF", editionDES_ARF);
			qSave.setParam("Edition_DES_ASF", editionDES_ASF);
			qSave.setParam("Edition_DES_ASD", editionDES_ASD);

			// accs menus module flash
			qSave.setParam("MenuMWM_ExpMonoBL", MenuMWM_ExpMonoBL);
			qSave.setParam("MenuMWM_ExpMultiBL", MenuMWM_ExpMultiBL);
			qSave.setParam("MenuMWM_CdeClient", MenuMWM_CdeClient);
			qSave.setParam("MenuMWM_PrepExpedition", MenuMWM_PrepExpedition);
			qSave.setParam("MenuMWM_InfoArticle", MenuMWM_InfoArticle);
			qSave.setParam("MenuMWM_Inventaire", MenuMWM_Inventaire);
			qSave.setParam("MWM_Inv_Show_SI", MWM_Inv_Show_SI);
			qSave.setParam("MenuMWM_Reception", MenuMWM_Reception);
			qSave.setParam("MenuMWM_Rangement", MenuMWM_Rangement);
			qSave.setParam("MenuMWM_LocCrossDock", MenuMWM_LocCrossDock);
			qSave.setParam("MenuMWM_ExpCrossDock", MenuMWM_ExpCrossDock);
			qSave.setParam("MenuMWM_EntSortStk", MenuMWM_EntSortStk);
			qSave.setParam("MenuMWM_ChangeEmp", MenuMWM_ChangeEmp);
			qSave.setParam("MenuMWM_TransEmp", MenuMWM_TransEmp);
			qSave.setParam("MenuMWM_ConsultEmp", MenuMWM_ConsultEmp);
			qSave.setParam("MenuMWM_RecepRetCli", MenuMWM_RecepRetCli);
			qSave.setParam("MenuMWM_Picking", MenuMWM_Picking);
			qSave.setParam("MWM_Controle_Picking", MWM_Controle_Picking);
			qSave.setParam("MenuMWM_PrepExpress", MenuMWM_PrepExpress);
			qSave.setParam("MenuMWM_Controle", MenuMWM_Controle);
			qSave.setParam("MenuMWM_Impression", MenuMWM_Impression);
			qSave.setParam("MenuMWM_Localisation", MenuMWM_Localisation);
			qSave.setParam("MWM_PEX_Quantite", MWM_PEX_Quantite);
			qSave.setParam("MWM_PEX_Qte_Manquante", MWM_PEX_Qte_Manquante);
			qSave.setParam("MWM_Scan_Borne", MWM_Scan_Borne);
			qSave.setParam("MWM_Info_Art_Chg_Emp", MWM_Info_Art_Chg_Emp);

			var result = qSave.execute();
			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
			}
			else {
				if (currentProfilId == "") {
					currentProfilId = result.responseXML.documentElement.getAttribute("Profil_Id");
				}

				aProfils.initTree();

				document.getElementById("bSupprimer").disabled = false;
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function cocherCompta(b) {
	try {

		document.getElementById("cCG_CSaisie").checked = b;
		document.getElementById("cCG_EBalance").checked = b;
		document.getElementById("cCG_SBordGest").checked = b;
		document.getElementById("cCG_AComptes").checked = b;
		document.getElementById("cCG_DComptes").checked = b;
		document.getElementById("cCG_CRevision").checked = b;
		document.getElementById("cCG_ECentral").checked = b;
		document.getElementById("cCG_SBordTres").checked = b;
		document.getElementById("cCG_AGdLivre").checked = b;
		document.getElementById("cCG_DAboEcr").checked = b;
		document.getElementById("cCG_CTransCop").checked = b;
		document.getElementById("cCG_EGdLivre").checked = b;
		document.getElementById("cCG_AParametrages").checked = b;
		document.getElementById("cCG_DModeles").checked = b;
		document.getElementById("cCG_CRappro").checked = b;
		document.getElementById("cCG_EJournaux").checked = b;
		document.getElementById("cCG_DImpBanque").checked = b;
		document.getElementById("cCG_CClotMens").checked = b;
		document.getElementById("cCG_EBalAgee").checked = b;
		document.getElementById("cCG_DImpExpEcr").checked = b;
		document.getElementById("cCG_CClotExo").checked = b;
		document.getElementById("cCG_EBilan").checked = b;
		document.getElementById("cCG_DPassword").checked = b;
		document.getElementById("cCG_EResultat").checked = b;
		document.getElementById("cCG_ESoldes").checked = b;
		document.getElementById("cCG_EPlanCpte").checked = b;

  } catch (e) {
    recup_erreur(e);
  }
}


function cocherStats(b) {
	try {

		document.getElementById("cEditionDES_CPC").checked = b;
		document.getElementById("cEditionDES_CLC").checked = b;
		document.getElementById("cEditionDES_FPF").checked = b;
		document.getElementById("cEditionDES_FLF").checked = b;
		document.getElementById("cEditionDES_SPA").checked = b;
		document.getElementById("cEditionDES_SFA").checked = b;
		document.getElementById("cEditionDES_SMS").checked = b;
		document.getElementById("cEditionDES_SES").checked = b;
		document.getElementById("cEditionDES_SRS").checked = b;
		document.getElementById("cEditionDES_SPF").checked = b;
		document.getElementById("cEditionDES_SMA").checked = b;
		document.getElementById("cEditionDES_VJV").checked = b;
		document.getElementById("cEditionDES_VJA").checked = b;
		document.getElementById("cEditionDES_VVA").checked = b;
		document.getElementById("cEditionDES_VFA").checked = b;
		document.getElementById("cEditionDES_VFC").checked = b;
		document.getElementById("cEditionDES_VFD").checked = b;
		document.getElementById("cEditionDES_VSC").checked = b;
		document.getElementById("cEditionDES_VLE").checked = b || !ofu_specLHELE;
		document.getElementById("cEditionDES_VLC").checked = b;
		document.getElementById("cEditionDES_VEC").checked = b;
		document.getElementById("cEditionDES_VCT").checked = b || !ofu_gacCoutTrans;
		document.getElementById("cEditionDES_VRC").checked = b || !ofu_actReassortCC;
		document.getElementById("cEditionDES_VAR").checked = b || !ofu_specSMEAR;
		document.getElementById("cEditionDES_VCS").checked = b || !ofu_actCodeStats;
		document.getElementById("cEditionDES_VFV").checked = b || !ofu_specEDEFV;
		document.getElementById("cEditionDES_VRE").checked = b || !ofu_specREERC;
		document.getElementById("cEditionDES_VCR").checked = b || !ofu_specLMECR;
		document.getElementById("cEditionDES_VHP").checked = b || !ofu_specKEESK;
		document.getElementById("cEditionDES_AJA").checked = b;
		document.getElementById("cEditionDES_AAC").checked = b;
		document.getElementById("cEditionDES_AAA").checked = b;
		document.getElementById("cEditionDES_AEF").checked = b;
		document.getElementById("cEditionDES_ARF").checked = b;
		document.getElementById("cEditionDES_ASF").checked = b || !ofu_specLHFNP;
		document.getElementById("cEditionDES_ASD").checked = b || !ofu_specHMDNP;

  } catch (e) {
    recup_erreur(e);
  }
}


function cocherGC(b) {
	try {

		document.getElementById("cGC_TClients").checked = b;
		document.getElementById("cGC_VDevis").checked = b;
		document.getElementById("cGC_ACommandes").checked = b;
		document.getElementById("cGC_SArticles").checked = b;
		document.getElementById("cGC_DRegFour").checked = b;
		document.getElementById("cGC_TFournisseurs").checked = b;
		document.getElementById("cGC_VAffaires").checked = b;
		document.getElementById("cGC_APrepaCom").checked = b;
		document.getElementById("cGC_STarifs").checked = b;
		document.getElementById("cGC_DRegCli").checked = b;
		document.getElementById("cGC_TCommerciaux").checked = b;
		document.getElementById("cGC_ARecepCom").checked = b;
		document.getElementById("cGC_SFabrication").checked = b;
		document.getElementById("cGC_DRemises").checked = b;
		document.getElementById("cGC_ARetours").checked = b;
		document.getElementById("cGC_SInventaire").checked = b;
		document.getElementById("cGC_DEditions").checked = b;
		document.getElementById("cGC_AFactures").checked = b;
		document.getElementById("cGC_AControle").checked = b || !ofu_specLHCFF;
		document.getElementById("cGC_STracabilite").checked = b;
		document.getElementById("cGC_DTabBord").checked = b;
		document.getElementById("cGC_VFactures").checked = b;
		document.getElementById("cGC_VRetours").checked = b;
		document.getElementById("cGC_STransferts").checked = b;
		document.getElementById("cGC_DTransCpta").checked = b;
		document.getElementById("cGC_VFactuAuto").checked = b;
		document.getElementById("cGC_SMouvements").checked = b;
		document.getElementById("cGC_SEmplacements").checked = b;
		document.getElementById("cGC_STransEmp").checked = b;
		document.getElementById("cGC_SIOStocks").checked = b;
		document.getElementById("cGC_SParamStocks").checked = b;
		document.getElementById("cGC_DExportIdep").checked = b;
		document.getElementById("cGC_DDeclEcoPart").checked = b;
		document.getElementById("cGC_VEnvoiFact").checked = b;
		document.getElementById("cGC_DImpExpCsv").checked = b;
		document.getElementById("cGC_VAbonnements").checked = b;
		document.getElementById("cGC_DPassword").checked = b;
		document.getElementById("cGC_EExpesCC").checked = b;
		document.getElementById("cGC_EExpesTS").checked = b;
		document.getElementById("cGC_EPrepaExpes").checked = b;
		document.getElementById("cGC_EExpCrossDock").checked = b || !ofu_accCrossDock;
		document.getElementById("cGC_ESuiviLog").checked = b;
		document.getElementById("cGC_ESuiviTrans").checked = b;

  } catch (e) {
    recup_erreur(e);
  }
}


function cocherDG(b) {
	try {

		document.getElementById("cGestionCo").checked = b;
		document.getElementById("cCompta").checked = b;
		document.getElementById("cContact").checked = b;
		document.getElementById("cTransac").checked = b;
		document.getElementById("cConfig").checked = b;
		document.getElementById("cFlash").checked = b && ofu_accFlash;
		document.getElementById("cAccBAM").checked = b && ofu_accBAM;
		document.getElementById("cDirection").checked = b;
		document.getElementById("cValidationCF").checked = b;
		document.getElementById("cValidationCC").checked = b;
		document.getElementById("cValidationCCZero").checked = b;
		document.getElementById("cAnnulationCC").checked = b;
		document.getElementById("cValidationTS").checked = b;
		document.getElementById("cValidationIS").checked = b;
		document.getElementById("cValidationRG").checked = b;
		document.getElementById("cValidationBR").checked = b;
		document.getElementById("cValidationAF").checked = b;
		document.getElementById("cValidationAC").checked = b;
		document.getElementById("cValidationBP").checked = b;
		document.getElementById("cAnnulationBP").checked = b;
		document.getElementById("cValidationBL").checked = b;
		document.getElementById("cAnnulationBL").checked = b;
		document.getElementById("cValidationDC").checked = b;
		document.getElementById("cMaxValidationDC").disabled = !b;
		document.getElementById("cClotureFact").checked = b;
		document.getElementById("cModifElemFinDV").checked = b;
		document.getElementById("cModifElemFinFCA").checked = b;
		document.getElementById("cIgnorePVPlancher").checked = b;
		document.getElementById("cEditionListeDL").checked = b;
		document.getElementById("cEditionListeDA").checked = b;
		document.getElementById("cEditionListeDV").checked = b;
		document.getElementById("cShowTotauxDV").checked = b;
		document.getElementById("cAccesCoutAchat").checked = b;
		document.getElementById("cAccesBanqueCli").checked = b;
		document.getElementById("cAccesBanqueFou").checked = b;
		document.getElementById("cRestricAccCDVPA").checked = b && ofu_specLCARAP;
		document.getElementById("cGestionDevisType").checked = b;
		document.getElementById("cShowElemFour").checked = b;
		document.getElementById("cGestionRespVente").checked = b || !ofu_specLHGRV;
		document.getElementById("cGestionEtabVente").checked = b || !ofu_specLCAGEV;
		document.getElementById("cGestionPoleVente").checked = b || !ofu_specLHGPV;
		document.getElementById("cGestionIntiVente").checked = b || !ofu_specLHGDV;
		document.getElementById("cGestionBloqueCli").checked = b || !ofu_specLVPBFC;
		document.getElementById("cModifStockES").checked = b;
		document.getElementById("cModifPrixFA").checked = b || !ofu_specTNMPA;
		document.getElementById("cModifPADV").checked = b;
		document.getElementById("cAnonymisationFC").checked = b;
		document.getElementById("cGCBrightColor").checked = b;

  } catch (e) {
    recup_erreur(e);
  }
}


function cocherMWM(b) {
	try {

		document.getElementById("cMWM_ExpMonoBL").checked = b && ofu_accMWMExpMonoBL;
		document.getElementById("cMWM_ExpMultiBL").checked = b && ofu_accMWMExpMultiBL;
		document.getElementById("cMWM_CdeClient").checked = b && ofu_accMWMCdeClient;
		document.getElementById("cMWM_PrepExpedition").checked = b;
		document.getElementById("cMWM_InfoArticle").checked = b;
		document.getElementById("cMWM_Inventaire").checked = b;
		document.getElementById("cMWM_Inv_Show_SI").checked = b;
		document.getElementById("cMWM_Reception").checked = b;
		document.getElementById("cMWM_Rangement").checked = b;
		document.getElementById("cMWM_LocCrossDock").checked = b && ofu_accCrossDock;
		document.getElementById("cMWM_ExpCrossDock").checked = b && ofu_accCrossDock;
		document.getElementById("cMWM_EntSortStk").checked = b;
		document.getElementById("cMWM_ChangeEmp").checked = b;
		document.getElementById("cMWM_TransEmp").checked = b;
		document.getElementById("cMWM_ConsultEmp").checked = b;
		document.getElementById("cMWM_RecepRetCli").checked = b;
		document.getElementById("cMWM_Picking").checked = b;
		document.getElementById("cMWM_Controle_Picking").checked = b;
		document.getElementById("cMWM_PrepExpress").checked = b;
		document.getElementById("cMWM_Controle").checked = b;
		document.getElementById("cMWM_Impression").checked = b;
		document.getElementById("cMWM_Localisation").checked = b;
		document.getElementById("cMWM_PEX_Quantite").checked = b;
		document.getElementById("cMWM_PEX_Qte_Manquante").checked = b;
		document.getElementById("cMWM_Scan_Borne").checked = b;
		document.getElementById("cMWM_Info_Art_Chg_Emp").checked = b;

  } catch (e) {
    recup_erreur(e);
  }
}


function clickOnValidationDC() {
	try {

		if (document.getElementById("cValidationDC").checked) {
			document.getElementById("cMaxValidationDC").disabled = false;
		}
		else {
			document.getElementById("cMaxValidationDC").disabled = true;
			document.getElementById("cMaxValidationDC").value = "";
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function clickOnModifElemFinDV() {
	try {

		document.getElementById("cModifElemFinFCA").disabled = !document.getElementById("cModifElemFinDV").checked;

	} catch (e) {
    recup_erreur(e);
  }
}


function retour_menuGestionDroit() {
	try {

  	window.location = "chrome://opensi/content/utilisateurs/menu_utilisateurs.xul";

	} catch (e) {
    recup_erreur(e);
  }
}
