/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oma_aApercuAbonnement = new Arbre('Compta/AbonnementsEcriture/list-apercuAbonnementEcriture.tmpl', 'oma-apercu');
var oma_aAbonnements = new Arbre('Compta/AbonnementsEcriture/list-abonnementEcriture.tmpl', 'oma-listeAbonnements');
var oma_qListAE = new QueryHttp("Compta/AbonnementsEcriture/getDataListAE.tmpl");

var oma_pageCourante;
var oma_nbPages;



function oma_init() {
  try {

		var aJournaux = new Arbre('ComboListe/combo-journaux.tmpl', 'oma-journal');
		aJournaux.setParam("Sans_AN", true);
		aJournaux.initTree();

  } catch (e) {
  	recup_erreur(e);
  }
}


function oma_initCriteres() {
	try {

		document.getElementById('oma-libelle').value = "";
		document.getElementById('oma-etat').value = "N";
		document.getElementById('oma-periodicite').value = "";
		document.getElementById('oma-journal').value = "";
		document.getElementById('oma-dateAbonnementDebut').value = "";
		document.getElementById('oma-dateAbonnementFin').value = "";

		oma_listerAbonnements();

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_listerAbonnements() {
	try {

		var libelle = document.getElementById('oma-libelle').value;
		var etat = document.getElementById('oma-etat').value;
		var periodicite = document.getElementById('oma-periodicite').value;
		var journal = document.getElementById('oma-journal').value;
		var dateAbonnementDebut = document.getElementById('oma-dateAbonnementDebut').value;
		var dateAbonnementFin = document.getElementById('oma-dateAbonnementFin').value;
		var nbLignesParPage = document.getElementById('oma-nbLignesParPage').value;

		if (!isEmpty(dateAbonnementDebut) && !isDate(dateAbonnementDebut)) { showWarning("Date de d\u00E9but incorrecte"); }
		else if (!isEmpty(dateAbonnementFin) && !isDate(dateAbonnementFin)) { showWarning("Date de fin incorrecte"); }
		else if (!isEmpty(dateAbonnementDebut) && !isEmpty(dateAbonnementFin) && !isDateInterval(dateAbonnementDebut, dateAbonnementFin)) { showWarning("Plage de dates incorrecte"); }
		else {

			oma_pageCourante = 1;
			oma_nbPages = 1;
			document.getElementById('oma-pageDeb').value = 1;
			document.getElementById('oma-pageFin').value = 1;
			document.getElementById('oma-bPrec').disabled = true;
			document.getElementById('oma-bSuiv').disabled = true;

			document.getElementById('oma-listeAbonnements').disabled = true;
			document.getElementById('oma-bEditionCsv').disabled = true;
			oma_aApercuAbonnement.deleteTree();
			oma_aAbonnements.deleteTree();

			oma_qListAE.setParam("Libelle", libelle);
			oma_qListAE.setParam("Etat", etat);
			oma_qListAE.setParam("Periodicite", periodicite);
			oma_qListAE.setParam("Journal", journal);
			oma_qListAE.setParam("Date_Abonnement_Debut", dateAbonnementDebut);
			oma_qListAE.setParam("Date_Abonnement_Fin", dateAbonnementFin);
			oma_qListAE.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			oma_qListAE.setParam("Current_Page", oma_pageCourante);

			var result = oma_qListAE.execute();

			var contenu = result.responseXML.documentElement;

			oma_nbPages = contenu.getAttribute("Nb_Pages");
			var listAbonnementId = contenu.getAttribute("List_Abonnement_Id");

			oma_aAbonnements.setParam("List_Abonnement_Id", listAbonnementId);
			oma_aAbonnements.initTree(oma_initPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_initPagination() {
	try {

		document.getElementById('oma-pageDeb').value = oma_pageCourante;
		document.getElementById('oma-pageFin').value = (oma_nbPages>0?oma_nbPages:1);
		document.getElementById('oma-bPrec').disabled = (oma_pageCourante==1);
		document.getElementById('oma-bSuiv').disabled = (oma_pageCourante>=oma_nbPages); // peut se produire si oma_nbPages=0

		document.getElementById('oma-listeAbonnements').disabled = false;
		document.getElementById('oma-bEditionCsv').disabled=(oma_aAbonnements.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_pressOnPagePrec() {
	try {

		oma_pageCourante--;
		oma_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_pressOnPageSuiv() {
	try {

		oma_pageCourante++;
		oma_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_majPagination() {
	try {

		document.getElementById('oma-pageDeb').value = oma_pageCourante;
		document.getElementById('oma-bPrec').disabled = (oma_pageCourante==1);
		document.getElementById('oma-bSuiv').disabled = (oma_pageCourante==oma_nbPages);

		document.getElementById('oma-listeAbonnements').disabled = true;
		document.getElementById('oma-bEditionCsv').disabled = true;
		oma_aApercuAbonnement.deleteTree();

		oma_qListAE.setParam("Current_Page", oma_pageCourante);
		var result = oma_qListAE.execute();
		var listAbonnementId = result.responseXML.documentElement.getAttribute("List_Abonnement_Id");

		oma_aAbonnements.setParam("List_Abonnement_Id", listAbonnementId);
		oma_aAbonnements.initTree(oma_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_afterMajPagination() {
	try {

		document.getElementById('oma-listeAbonnements').disabled = false;
		document.getElementById('oma-bEditionCsv').disabled = (oma_aAbonnements.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_selectOnListeAbonnements() {
	try {

		if (oma_aAbonnements.isSelected()) {
			var abonnementId = oma_aAbonnements.getSelectedCellText('oma-colAbonnementId');

			oma_aApercuAbonnement.setParam("Abonnement_Id", abonnementId);
			oma_aApercuAbonnement.initTree();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_pressOnNouveauAbonnement() {
	try {

		document.getElementById('deck').selectedIndex = 2;
		document.getElementById('bMenuAbonnements').collapsed = false;
		oea_nouveauAbonnement();

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			oma_listerAbonnements();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function oma_pressOnListeAbonnements(ev) {
  try {

		if (ev.keyCode==13) {
			oma_ouvrirAbonnement();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function oma_ouvrirAbonnement() {
  try {

  	if (oma_aAbonnements.isSelected()) {
			oea_abonnementId = oma_aAbonnements.getSelectedCellText('oma-colAbonnementId');
			oea_chargerAbonnement();
			document.getElementById('deck').selectedIndex = 2;
			document.getElementById('bMenuAbonnements').collapsed = false;
  	}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oma_pressOnEditionCsv() {
	try {

		var libelle = document.getElementById('oma-libelle').value;
		var etat = document.getElementById('oma-etat').value;
		var periodicite = document.getElementById('oma-periodicite').value;
		var journal = document.getElementById('oma-journal').value;
		var dateAbonnementDebut = document.getElementById('oma-dateAbonnementDebut').value;
		var dateAbonnementFin = document.getElementById('oma-dateAbonnementFin').value;

		if (!isEmpty(dateAbonnementDebut) && !isDate(dateAbonnementDebut)) { showWarning("Date de d\u00E9but incorrecte"); }
		else if (!isEmpty(dateAbonnementFin) && !isDate(dateAbonnementFin)) { showWarning("Date de fin incorrecte"); }
		else if (!isEmpty(dateAbonnementDebut) && !isEmpty(dateAbonnementFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte"); }
		else {
			var qEditionCsv = new QueryHttp("Compta/AbonnementsEcriture/csvAbonnementEcriture.tmpl");

			qEditionCsv.setParam("Libelle", libelle);
			qEditionCsv.setParam("Etat", etat);
			qEditionCsv.setParam("Periodicite", periodicite);
			qEditionCsv.setParam("Journal", journal);
			qEditionCsv.setParam("Date_Abonnement_Debut", dateAbonnementDebut);
			qEditionCsv.setParam("Date_Abonnement_Fin", dateAbonnementFin);

			var result = qEditionCsv.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}
