/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");


var aComptes = new Arbre("Compta/Analytique/Comptes/list-compteAnalytique.tmpl", "listeComptes");
var qListCA = new QueryHttp("Compta/Analytique/Comptes/getDataListCA.tmpl");

var pageCourante;
var nbPages;

var formatId = 0;
var typeDirect = false;
var compteId = 0;

var centreId1;
var centreId2;
var centreId3;
var centreId4;
var centreId5;



function init() {
	try {

 		var qGet = new QueryHttp("Compta/Analytique/Format/getFormat.tmpl");
		var result = qGet.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			formatId = result.responseXML.documentElement.getAttribute('Format_Id');

			if (formatId!=0) {
				var critereId1 = result.responseXML.documentElement.getAttribute('Critere_Id1');
				var critereId2 = result.responseXML.documentElement.getAttribute('Critere_Id2');
				var critereId3 = result.responseXML.documentElement.getAttribute('Critere_Id3');
				var critereId4 = result.responseXML.documentElement.getAttribute('Critere_Id4');
				var critereId5 = result.responseXML.documentElement.getAttribute('Critere_Id5');

				var aListeCriteres1 = new Arbre("Compta/Analytique/Criteres/list-centreProfit.tmpl", "listeCentre1");
				aListeCriteres1.setParam("Critere_Id", critereId1);
				aListeCriteres1.initTree();

				if (critereId2==null) {
					document.getElementById('ligneListe2').collapsed = true;
				}
				else {
					var aListeCriteres2 = new Arbre("Compta/Analytique/Criteres/list-centreProfit.tmpl", "listeCentre2");
					aListeCriteres2.setParam("Critere_Id", critereId2);
					aListeCriteres2.initTree();
				}
				if (critereId3==null) {
					document.getElementById('ligneListe3').collapsed = true;
				}
				else {
					var aListeCriteres3 = new Arbre("Compta/Analytique/Criteres/list-centreProfit.tmpl", "listeCentre3");
					aListeCriteres3.setParam("Critere_Id", critereId3);
					aListeCriteres3.initTree();
				}
				if (critereId4==null) {
					document.getElementById('ligneListe4').collapsed = true;
				}
				else {
					var aListeCriteres4 = new Arbre("Compta/Analytique/Criteres/list-centreProfit.tmpl", "listeCentre4");
					aListeCriteres4.setParam("Critere_Id", critereId4);
					aListeCriteres4.initTree();
				}
				if (critereId5==null) {
					document.getElementById('ligneListe5').collapsed = true;
				}
				else {
					var aListeCriteres5 = new Arbre("Compta/Analytique/Criteres/list-centreProfit.tmpl", "listeCentre5");
					aListeCriteres5.setParam("Critere_Id", critereId5);
					aListeCriteres5.initTree();
				}
			}
			else {
				document.getElementById('ligneListe1').collapsed = true;
				document.getElementById('ligneListe2').collapsed = true;
				document.getElementById('ligneListe3').collapsed = true;
				document.getElementById('ligneListe4').collapsed = true;
				document.getElementById('ligneListe5').collapsed = true;
				document.getElementById('type').value = "false";
				document.getElementById('typeDirect').disabled = true;
			}
		}

		nouveauCompte();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			listerComptes();
    }

  } catch (e) {
    recup_erreur(e);
  }
}


function initCriteres() {
	try {

		document.getElementById('filtreNumCompte').value = "";
		document.getElementById('filtreIntitule').value = "";
		document.getElementById('filtreTypeCompte').value = "";
		document.getElementById('filtreActif').checked = true;

		listerComptes();

	} catch (e) {
    recup_erreur(e);
  }
}


function listerComptes() {
	try {

		var numCompte = document.getElementById('filtreNumCompte').value;
		var intitule = document.getElementById('filtreIntitule').value;
		var typeCompte = document.getElementById('filtreTypeCompte').value;
		var actif = document.getElementById('filtreActif').checked;
		var nbLignesParPage = document.getElementById('nbLignesParPage').value;

		pageCourante = 1;
		nbPages = 1;
		document.getElementById('pageDeb').value = 1;
		document.getElementById('pageFin').value = 1;
		document.getElementById('bPrec').disabled = true;
		document.getElementById('bSuiv').disabled = true;

		document.getElementById('listeComptes').disabled = true;
		aComptes.deleteTree();

		qListCA.setParam("Num_Compte", numCompte);
		qListCA.setParam("Intitule", intitule);
		qListCA.setParam("Type_Compte", typeCompte);
		qListCA.setParam("Actif", actif);
		qListCA.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
		qListCA.setParam("Current_Page", pageCourante);

		var result = qListCA.execute();

		var contenu = result.responseXML.documentElement;

		nbPages = contenu.getAttribute("Nb_Pages");
		var listCompteId = contenu.getAttribute("List_Compte_Id");

		aComptes.setParam("List_Compte_Id", listCompteId);
		aComptes.initTree(initPagination);

	} catch (e) {
    recup_erreur(e);
  }
}


function initPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('pageFin').value = (nbPages>0?nbPages:1);
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante>=nbPages); // peut se produire si nbPages=0

		afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPagePrec() {
	try {

		pageCourante--;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPageSuiv() {
	try {

		pageCourante++;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function majPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante==nbPages);

		document.getElementById('listeComptes').disabled = true;

		qListCA.setParam("Current_Page", pageCourante);
		var result = qListCA.execute();
		var listCompteId = result.responseXML.documentElement.getAttribute("List_Compte_Id");

		aComptes.setParam("List_Compte_Id", listCompteId);
		aComptes.initTree(afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function afterMajPagination() {
	try {

		document.getElementById('listeComptes').disabled = false;
		activeMenu(true);

	} catch (e) {
		recup_erreur(e);
	}
}


function resetCentres() {
	try {

  	document.getElementById('numero').value = "";

		centreId1 = 0;
		centreId2 = 0;
		centreId3 = 0;
		centreId4 = 0;
		centreId5 = 0;

		document.getElementById('listeCentre1').value = centreId1;
		document.getElementById('listeCentre2').value = centreId2;
		document.getElementById('listeCentre3').value = centreId3;
		document.getElementById('listeCentre4').value = centreId4;
		document.getElementById('listeCentre5').value = centreId5;

	} catch (e) {
		recup_erreur(e);
	}
}


function activeMenu(boolean) {
	try {
		// activation des filtres de recherche
		document.getElementById('filtreNumCompte').disabled = !boolean;
		document.getElementById('filtreIntitule').disabled = !boolean;
		document.getElementById('filtreTypeCompte').disabled = !boolean;
		document.getElementById('filtreActif').disabled = !boolean;
		document.getElementById('bActualiser').disabled = !boolean;
		document.getElementById('bReinitialiser').disabled = !boolean;

		// activation de l'arbre
		document.getElementById('listeComptes').disabled = !boolean;

		// activation de la fiche de compte
		document.getElementById('labelNumero').disabled = (compteId!=0 || typeDirect || !boolean);
		document.getElementById('numero').disabled = (compteId!=0 || typeDirect || !boolean);
		document.getElementById('type').disabled = (!typeDirect || compteId!=0 || !boolean);
		document.getElementById('intitule').disabled = !boolean;
		document.getElementById('chkActif').disabled = !boolean;

		// activation de la liste de centres
		document.getElementById('labelCentre1').disabled = (compteId!=0 || !typeDirect || !boolean);
		document.getElementById('labelCentre2').disabled = (centreId1==0 || compteId!=0 || !typeDirect || !boolean);
		document.getElementById('labelCentre3').disabled = (centreId1==0 || centreId2==0 || compteId!=0 || !typeDirect || !boolean);
		document.getElementById('labelCentre4').disabled = (centreId1==0 || centreId2==0 || centreId3==0 || compteId!=0 || !typeDirect || !boolean);
		document.getElementById('labelCentre5').disabled = (centreId1==0 || centreId2==0 || centreId3==0 || centreId4==0 || compteId!=0 || !typeDirect || !boolean);
		document.getElementById('listeCentre1').disabled = (compteId!=0 || !typeDirect || !boolean);
		document.getElementById('listeCentre2').disabled = (centreId1==0 || compteId!=0 || !typeDirect || !boolean);
		document.getElementById('listeCentre3').disabled = (centreId1==0 || centreId2==0 || compteId!=0 || !typeDirect || !boolean);
		document.getElementById('listeCentre4').disabled = (centreId1==0 || centreId2==0 || centreId3==0 || compteId!=0 || !typeDirect || !boolean);
		document.getElementById('listeCentre5').disabled = (centreId1==0 || centreId2==0 || centreId3==0 || centreId4==0 || compteId!=0 || !typeDirect || !boolean);

		// activation des actions de la fiche de comptes
		document.getElementById('bNouveau').disabled = !boolean;
		document.getElementById('bSupprimer').disabled = (compteId==0 || !boolean);
		document.getElementById('bEnregistrer').disabled = !boolean;

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnActualiser() {
	try {

		activeMenu(false);
		listerComptes();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnReinitialiser() {
	try {

		activeMenu(false);
		initCriteres();
		listerComptes();

	} catch (e) {
		recup_erreur(e);
	}
}


function selectOnTreeComptes() {
	try {

 		if (aComptes.isSelected()) {
 			activeMenu(false);
			compteId = aComptes.getSelectedCellText('colCompteId');
			ouvrir();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ouvrir() {
	try {

		var qLoad = new QueryHttp("Compta/Analytique/Comptes/loadCompteAnalytique.tmpl");
		qLoad.setParam("Compte_Id", compteId);
		var result = qLoad.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var contenu = result.responseXML.documentElement;

			typeDirect = contenu.getAttribute('Direct')=="true";

			centreId1 = contenu.getAttribute('Centre_Id1');
			centreId2 = contenu.getAttribute('Centre_Id2');
			centreId3 = contenu.getAttribute('Centre_Id3');
			centreId4 = contenu.getAttribute('Centre_Id4');
			centreId5 = contenu.getAttribute('Centre_Id5');

			centreId1 = (centreId1!=null?centreId1:0);
			centreId2 = (centreId2!=null?centreId2:0);
			centreId3 = (centreId3!=null?centreId3:0);
			centreId4 = (centreId4!=null?centreId4:0);
			centreId5 = (centreId5!=null?centreId5:0);

			document.getElementById('numero').value = contenu.getAttribute('Numero');
			document.getElementById('intitule').value = contenu.getAttribute('Intitule');
			document.getElementById('type').value = typeDirect?"true":"false";
			document.getElementById('chkActif').checked = contenu.getAttribute('Actif')=="true";

			document.getElementById('listeCentre1').value = centreId1;
			document.getElementById('listeCentre2').value = centreId2;
			document.getElementById('listeCentre3').value = centreId3;
			document.getElementById('listeCentre4').value = centreId4;
			document.getElementById('listeCentre5').value = centreId5;

			activeMenu(true);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnCsv() {
	try {

		activeMenu(false);

		var numCompte = document.getElementById('filtreNumCompte').value;
		var intitule = document.getElementById('filtreIntitule').value;
		var typeCompte = document.getElementById('filtreTypeCompte').value;
		var actif = document.getElementById('filtreActif').checked;

 		var qEdit = new QueryHttp("Compta/Analytique/Comptes/csvCompteAnalytique.tmpl");
 		qEdit.setParam("Num_Compte", numCompte);
 		qEdit.setParam("Intitule", intitule);
		qEdit.setParam("Type_Compte", typeCompte);
 		qEdit.setParam("Actif", actif);

 		var result = qEdit.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

			var file = fileChooser("save", fichier);
			if (file!=null) {
				downloadFile(getDirBuffer() + fichier, file);
			}
		}

 		activeMenu(true);

	} catch (e) {
  	recup_erreur(e);
	}
}


function selectOnType() {
	try {

		activeMenu(false);
		typeDirect = (document.getElementById('type').value=="true");
		resetCentres();
		activeMenu(true);

	} catch (e) {
		recup_erreur(e);
	}
}


function selectOnListeCentre1() {
	try {

		activeMenu(false);
		if (document.getElementById('listeCentre1').value==0) {
			document.getElementById('listeCentre2').value = 0;
			document.getElementById('listeCentre3').value = 0;
			document.getElementById('listeCentre4').value = 0;
			document.getElementById('listeCentre5').value = 0;
		}
		majNumero();

	} catch (e) {
		recup_erreur(e);
	}
}


function selectOnListeCentre2() {
	try {

		activeMenu(false);
		if (document.getElementById('listeCentre2').value==0) {
			document.getElementById('listeCentre3').value = 0;
			document.getElementById('listeCentre4').value = 0;
			document.getElementById('listeCentre5').value = 0;
		}
		majNumero();

	} catch (e) {
		recup_erreur(e);
	}
}


function selectOnListeCentre3() {
	try {

		activeMenu(false);
		if (document.getElementById('listeCentre3').value==0) {
			document.getElementById('listeCentre4').value = 0;
			document.getElementById('listeCentre5').value = 0;
		}
		majNumero();

	} catch (e) {
		recup_erreur(e);
	}
}


function selectOnListeCentre4() {
	try {

		activeMenu(false);
		if (document.getElementById('listeCentre4').value==0) {
			document.getElementById('listeCentre5').value = 0;
		}
		majNumero();

	} catch (e) {
		recup_erreur(e);
	}
}


function selectOnListeCentre5() {
	try {

		activeMenu(false);
		majNumero();

	} catch (e) {
		recup_erreur(e);
	}
}


function majNumero() {
	try {

		centreId1 = document.getElementById('listeCentre1').value;
		centreId2 = document.getElementById('listeCentre2').value;
		centreId3 = document.getElementById('listeCentre3').value;
		centreId4 = document.getElementById('listeCentre4').value;
		centreId5 = document.getElementById('listeCentre5').value;

		document.getElementById('numero').value = "";
		var numero = "";
		var ok = true;

		// construction du numro
		if (centreId1!=0) {
			var qGet = new QueryHttp("Compta/Analytique/Criteres/getCentre.tmpl");
			qGet.setParam("Centre_Id", centreId1);
			var result = qGet.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
				ok = false;
			} else {
				numero += result.responseXML.documentElement.getAttribute('Code');
			}
		}

		if (ok && centreId1!=0 && centreId2!=0) {
			var qGet = new QueryHttp("Compta/Analytique/Criteres/getCentre.tmpl");
			qGet.setParam("Centre_Id", centreId2);
			var result = qGet.execute();
			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
				ok = false;
			} else {
				numero += result.responseXML.documentElement.getAttribute('Code');
			}
		}

		if (ok && centreId1!=0 && centreId2!=0 && centreId3!=0) {
			var qGet = new QueryHttp("Compta/Analytique/Criteres/getCentre.tmpl");
			qGet.setParam("Centre_Id", centreId3);
			var result = qGet.execute();
			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
				ok = false;
			} else {
				numero += result.responseXML.documentElement.getAttribute('Code');
			}
		}

		if (ok && centreId1!=0 && centreId2!=0 && centreId3!=0 && centreId4!=0) {
			var qGet = new QueryHttp("Compta/Analytique/Criteres/getCentre.tmpl");
			qGet.setParam("Centre_Id", centreId4);
			var result = qGet.execute();
			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
				ok = false;
			} else {
				numero += result.responseXML.documentElement.getAttribute('Code');
			}
		}

		if (ok && centreId1!=0 && centreId2!=0 && centreId3!=0 && centreId4!=0 && centreId5!=0) {
			var qGet = new QueryHttp("Compta/Analytique/Criteres/getCentre.tmpl");
			qGet.setParam("Centre_Id", centreId5);
			var result = qGet.execute();
			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
				ok = false;
			}
			else {
				numero += result.responseXML.documentElement.getAttribute('Code');
			}
		}

		document.getElementById('numero').value = numero;
		activeMenu(true);

	} catch (e) {
		recup_erreur(e);
	}
}


function nouveauCompte() {
	try {

		activeMenu(false);

		resetCentres();
		compteId = 0;
  	aComptes.clearSelection();

		typeDirect = formatId!=0;

		document.getElementById('intitule').value = "";
		document.getElementById('type').value = typeDirect?"true":"false";
		document.getElementById('chkActif').checked = true;

		activeMenu(true);

	} catch (e) {
		recup_erreur(e);
	}
}


function isNumeroCorrect(val) {
	try {

		var str = val.toString();
		var ok = str.length<=10;

		if (ok) {
			for (var i=0;i<str.length && ok;i++) {
				var c = str.charAt(i);
				ok = ((c<='z' && c>='a') || (c<='Z' && c>='A') || (c<='9' && c>='0') || (c=='_'));
			}
		}
		return ok;

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnSupprimer() {
	try {

		if (compteId!=0) {
			activeMenu(false);

			var qDelete = new QueryHttp("Compta/Analytique/Comptes/deleteCompte.tmpl");
			qDelete.setParam("Compte_Id", compteId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
				activeMenu(true);
			}
			else {
				listerComptes();
				nouveauCompte();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnEnregistrer() {
	try {

		if (isEmpty(document.getElementById('numero').value) || !isNumeroCorrect(document.getElementById('numero').value)) { showWarning("Num\u00E9ro de compte incorrect"); }
		else if (isEmpty(document.getElementById('intitule').value)) { showWarning("Intitul\u00E9 incorrect"); }
		else {
			activeMenu(false);

			var qSave = new QueryHttp("Compta/Analytique/Comptes/saveCompte.tmpl");

			qSave.setParam("Compte_Id", compteId);
			qSave.setParam("Numero", document.getElementById('numero').value);
			qSave.setParam("Intitule", document.getElementById('intitule').value);
			qSave.setParam("Actif", document.getElementById('chkActif').checked);
			qSave.setParam("Direct", document.getElementById('type').value);
			qSave.setParam("Centre_Id1", centreId1);
			qSave.setParam("Centre_Id2", centreId2);
			qSave.setParam("Centre_Id3", centreId3);
			qSave.setParam("Centre_Id4", centreId4);
			qSave.setParam("Centre_Id5", centreId5);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
				activeMenu(true);
			}
			else {
				compteId = result.responseXML.documentElement.getAttribute('Compte_Id');
				listerComptes();
				ouvrir();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuPrincipal() {
	try {

    window.location = "chrome://opensi/content/compta/user/menu_exercice.xul";

	} catch (e) {
		recup_erreur(e);
	}
}
