/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var oca_aCriteres = new Arbre("Compta/Analytique/Criteres/list-critereAnalytique.tmpl",'oca-treeCriteres');
var oca_aCentres = new Arbre("Compta/Analytique/Criteres/list-centreProfit.tmpl",'oca-treeCentres');

var oca_critereId = 0;
var oca_centreId = 0;
var oca_change = false;
var oca_hasCentre = false;
var oca_selCentre = false;



function oca_init() {
	try {

 		oca_aCriteres.initTree();

 		oca_activeMenu();

	} catch (e) {
		recup_erreur(e);
	}
}


function oca_selectOnTreeCriteres() {
	try {

 		if (oca_aCriteres.isSelected()) {
			var id = oca_aCriteres.getSelectedCellText('oca-colCritereId');
			oca_ouvrir(id);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oca_ouvrir(id) {
	try {

		oca_critereId = id;

		var qLoad = new QueryHttp("Compta/Analytique/Criteres/getCritere.tmpl");
		if (oca_critereId!=0) {
			qLoad.setParam("Critere_Id", oca_critereId);
		}
		var result = qLoad.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
			oca_nouveau();
		}
		else {
			var intitule = result.responseXML.documentElement.getAttribute('Intitule');
			var formatCode = result.responseXML.documentElement.getAttribute('Format_Code');
			var newId = result.responseXML.documentElement.getAttribute('Critere_Id');
			var codeActif = result.responseXML.documentElement.getAttribute('Modifiable');

			document.getElementById('oca-intitule').value = intitule;
			document.getElementById('oca-formatCode').value = formatCode;

			oca_centreId = 0;
			oca_change = false;
			oca_critereId = newId;
			oca_hasCentre = (codeActif=="false");

			oca_aCentres.clearParams();
			oca_aCentres.setParam('Critere_Id', oca_critereId);
			oca_aCentres.initTree(oca_annulerCentre);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oca_activeMenu() {
	try {

		document.getElementById('oca-intitule').disabled = false;
		document.getElementById('oca-formatCode').disabled = oca_hasCentre;

		document.getElementById('oca-bNouveau').disabled = false;
		document.getElementById('oca-bEnregistrer').disabled = !oca_change;
		document.getElementById('oca-bSupprimer').disabled = (oca_critereId==0);

		document.getElementById('oca-codeCentre').disabled = (oca_critereId==0);
		document.getElementById('oca-libelleCentre').disabled = (oca_critereId==0);

		document.getElementById('oca-bAnnulerCentre').disabled = (oca_critereId==0);
		document.getElementById('oca-bValiderCentre').disabled = (oca_critereId==0);
		document.getElementById('oca-bSupprimerCentre').disabled = !oca_selCentre || (oca_critereId==0);

	} catch (e) {
  	recup_erreur(e);
	}
}


function oca_desactiveMenu() {
	try {

		document.getElementById('oca-intitule').disabled = true;
		document.getElementById('oca-formatCode').disabled = true;

		document.getElementById('oca-bNouveau').disabled = true;
		document.getElementById('oca-bEnregistrer').disabled = true;
		document.getElementById('oca-bSupprimer').disabled = true;

		document.getElementById('oca-codeCentre').disabled = true;
		document.getElementById('oca-libelleCentre').disabled = true;

		document.getElementById('oca-bAnnulerCentre').disabled = true;
		document.getElementById('oca-bValiderCentre').disabled = true;
		document.getElementById('oca-bSupprimerCentre').disabled = true;

	} catch (e) {
 		recup_erreur(e);
	}
}


function oca_keyPressOnIntitule(event) {
	try {

		oca_change = true;
		oca_activeMenu();

	} catch (e) {
		recup_erreur(e);
	}
}


function oca_keyPressOnFormatCode(event) {
	try {

		oca_change = true;
		oca_activeMenu();

	} catch (e) {
		recup_erreur(e);
	}
}


function oca_pressOnNouveau() {
	try {

		if (!oca_change || window.confirm("Voulez-vous saisir un nouveau crit\u00E8re d'analyse ?\nVous allez perdre les informations non enregistr\u00E9es.")) {
			oca_desactiveMenu();
			oca_nouveau();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oca_pressOnSupprimer() {
	try {

		if (oca_critereId!=0 && window.confirm("Voulez-vous supprimer ce crit\u00E8re ?"+ (oca_hasCentre?"\nCela entrainera la suppression de tous les centres de profit associ\u00E9s.":""))) {
			oca_desactiveMenu();
			oca_supprimer();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oca_isFormatCorrect(val) {
	try {

		var str = val.toString();
		var ok = !isEmpty(str) && str.length<=4;

		if (ok) {
			for (var i=0;i<str.length && ok;i++) {
				var c = str.charAt(i);
				ok = ((c=='A') || (c=='9'));
			}
		}

		return ok;

	} catch (e) {
		recup_erreur(e);
	}
}


function oca_pressOnEnregistrer() {
	try {

		if (isEmpty(document.getElementById('oca-intitule').value)) { showWarning("Intitul\u00E9 incorrect"); }
		else if (!oca_isFormatCorrect(document.getElementById('oca-formatCode').value)) { showWarning("Format de code incorrect"); }
		else {
			oca_desactiveMenu();
			oca_enregistrer();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oca_nouveau() {
	try {

  	oca_critereId = 0;
  	oca_aCriteres.clearSelection();
  	oca_change = false;
  	oca_hasCentre = false;

  	oca_aCentres.deleteTree();

  	document.getElementById('oca-intitule').value = "";
  	document.getElementById('oca-formatCode').value = "";

  	oca_annulerCentre();

	} catch (e) {
		recup_erreur(e);
	}
}


function oca_supprimer() {
	try {

		var qDelete = new QueryHttp("Compta/Analytique/Criteres/deleteCritere.tmpl");
		qDelete.setParam("Critere_Id", oca_critereId);
		var result = qDelete.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
			oca_activeMenu();
		}
		else {
			oca_aCriteres.deleteTree();
			oca_aCriteres.initTree();
			oca_nouveau();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oca_enregistrer() {
	try {

		var qSave = new QueryHttp("Compta/Analytique/Criteres/saveCritere.tmpl");

		qSave.setParam("Critere_Id", oca_critereId);
		qSave.setParam("Intitule", document.getElementById('oca-intitule').value);
		qSave.setParam("Format_Code", document.getElementById('oca-formatCode').value);

		var result = qSave.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
			oca_activeMenu();
		}
		else {
			oca_critereId = result.responseXML.documentElement.getAttribute('Critere_Id');
			oca_aCriteres.deleteTree();
			oca_aCriteres.initTree();
			oca_change = false;
			oca_activeMenu();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oca_selectOnTreeCentres() {
	try {

		oca_loadCentre();

	} catch (e) {
		recup_erreur(e);
	}
}


function oca_loadCentre() {
	try {

		if (oca_aCentres.isSelected()) {
			var index = oca_aCentres.getCurrentIndex();
			oca_centreId = oca_aCentres.getCellText(index,'oca-colCentreId');
 			document.getElementById('oca-codeCentre').value = oca_aCentres.getCellText(index,'oca-colCode');
			document.getElementById('oca-libelleCentre').value = oca_aCentres.getCellText(index,'oca-colLibelle');
			oca_selCentre = true;
			oca_activeMenu();
 		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oca_pressOnAnnulerCentre() {
	try {

		oca_desactiveMenu();
		oca_annulerCentre();

	} catch (e) {
		recup_erreur(e);
	}
}


function oca_isCodeCorrect(val) {
	try {

		var str = val.toString();
		var ok = str.length<=4;

		if (ok) {
			for (var i=0; i<str.length && ok; i++) {
				var c = str.charAt(i);
				ok = ((c<='z' && c>='a') || (c<='Z' && c>='A') || (c<='9' && c>='0') || (c=='_'));
			}
		}

		return ok;

	} catch (e) {
		recup_erreur(e);
	}
}


function oca_pressOnValiderCentre() {
	try {

		if (!oca_isCodeCorrect(document.getElementById('oca-codeCentre').value)) { showWarning("Code incorrect"); }
		else if (isEmpty(document.getElementById('oca-libelleCentre').value)) { showWarning("Libell\u00E9 incorrect"); }
		else {
			oca_desactiveMenu();
			oca_saveCentre();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oca_pressOnSupprimerCentre() {
	try {

		if (oca_centreId!=0) {
			oca_desactiveMenu();
			oca_supprimerCentre();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oca_annulerCentre() {
	try {

		oca_centreId = 0;
		oca_aCentres.clearSelection();

		document.getElementById('oca-codeCentre').value = "";
		document.getElementById('oca-libelleCentre').value = "";
		oca_selCentre = false;

		oca_activeMenu();

	} catch (e) {
		recup_erreur(e);
	}
}


function oca_saveCentre() {
	try {

		var qSave = new QueryHttp("Compta/Analytique/Criteres/saveCentre.tmpl");

		qSave.setParam("Centre_Id", oca_centreId);
		qSave.setParam("Critere_Id", oca_critereId);
		qSave.setParam("Code", document.getElementById('oca-codeCentre').value);
		qSave.setParam("Libelle", document.getElementById('oca-libelleCentre').value);

		var result = qSave.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
			oca_activeMenu();
		}
		else {
	  	oca_ouvrir(oca_critereId);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oca_supprimerCentre() {
	try {

		var qDelete = new QueryHttp("Compta/Analytique/Criteres/deleteCentre.tmpl");
		qDelete.setParam("Centre_Id", oca_centreId);
		var result = qDelete.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
			oca_activeMenu();
		}
		else {
	  	oca_ouvrir(oca_critereId);
		}

	} catch (e) {
		recup_erreur(e);
	}
}
