/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var org_aRubriques = new Arbre("Compta/Analytique/Rubriques/list-rubriqueComptaGenerale.tmpl", "org-treeRubriques");
var org_aPlages = new Arbre("Compta/Analytique/Rubriques/list-plageCompteRubriqueGenerale.tmpl", 'org-treePlages');

var org_rubriqueId = 0;
var org_plageId = 0;
var org_change = false;



function org_init() {
	try {

		org_aRubriques.initTree();

		org_activeMenu(true);

	} catch (e) {
		recup_erreur(e);
	}
}


function org_selectOnTreeRubriques() {
	try {

 		if (org_aRubriques.isSelected()) {
			var id = org_aRubriques.getSelectedCellText('org-colRubriqueId');
			org_ouvrir(id);
			org_activeMenu(true);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function org_ouvrir(id) {
	try {

		org_rubriqueId = id;

		var qLoad = new QueryHttp("Compta/Analytique/Rubriques/getRubrique.tmpl");
		if (org_rubriqueId!=0) {
			qLoad.setParam("Rubrique_Id", org_rubriqueId);
		}
		var result = qLoad.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
			org_nouveau();
		}
		else {
			document.getElementById('org-intitule').value = result.responseXML.documentElement.getAttribute('Intitule');

			org_aPlages.setParam('Rubrique_Id', org_rubriqueId);
			org_aPlages.initTree();
			org_annulerPlage();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function org_activeMenu(boolean) {
	try {

		document.getElementById('org-bNouveau').disabled = !boolean || false;
		document.getElementById('org-bEnregistrer').disabled = !boolean || !org_change;
		document.getElementById('org-bSupprimer').disabled = !boolean || (org_rubriqueId==0);

		document.getElementById('org-debut').disabled = !boolean || (org_rubriqueId==0);
		document.getElementById('org-fin').disabled = !boolean || (org_rubriqueId==0);

		document.getElementById('org-bAnnulerPlage').disabled = !boolean || (org_rubriqueId==0);
		document.getElementById('org-bValiderPlage').disabled = !boolean || (org_rubriqueId==0);
		document.getElementById('org-bSupprimerPlage').disabled = !boolean || (org_rubriqueId==0) || (org_plageId==0);

	} catch (e) {
  	recup_erreur(e);
	}
}


function org_keyPressOnIntitule(event) {
	try {

		org_change = true;
		org_activeMenu(true);

	} catch (e) {
		recup_erreur(e);
	}
}


function org_pressOnNouveau() {
	try {

		if (!org_change || window.confirm("Voulez-vous saisir une nouvelle rubrique ?\nVous allez perdre les informations non enregistr\u00E9es.")) {
			org_activeMenu(false);
			org_nouveau();
			org_activeMenu(true);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function org_pressOnSupprimer() {
	try {

		if (org_rubriqueId!=0 && window.confirm("Voulez-vous supprimer cette rubrique ?\nCela entrainera la suppression de toutes les plages de comptes associ\u00E9es.")) {
			org_activeMenu(false);
			org_supprimer();
			org_activeMenu(true);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function org_pressOnEnregistrer() {
	try {

		if (isEmpty(document.getElementById('org-intitule').value)) { showWarning("Intitul\u00E9 incorrect"); }
		else {
			org_activeMenu(false);
			org_enregistrer();
			org_activeMenu(true);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function org_nouveau() {
	try {

  		org_rubriqueId = 0;
  		org_aRubriques.clearSelection();
  		org_change = false;

  		org_aPlages.deleteTree();

  		document.getElementById('org-intitule').value = "";

  		org_annulerPlage();

	} catch (e) {
		recup_erreur(e);
	}
}


function org_supprimer() {
	try {

		var qDelete = new QueryHttp("Compta/Analytique/Rubriques/deleteRubrique.tmpl");
		qDelete.setParam("Rubrique_Id", org_rubriqueId);
		var result = qDelete.execute();
		
		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			org_aRubriques.deleteTree();
			org_aRubriques.initTree();

			org_nouveau();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function org_enregistrer() {
	try {

		var qSave = new QueryHttp("Compta/Analytique/Rubriques/saveRubrique.tmpl");
		qSave.setParam("Rubrique_Id", org_rubriqueId);
		qSave.setParam("Intitule", document.getElementById('org-intitule').value);
		var result = qSave.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			org_rubriqueId = result.responseXML.documentElement.getAttribute('Rubrique_Id');
			org_aRubriques.deleteTree();
			org_aRubriques.initTree();
			org_change = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function org_selectOnTreePlages() {
	try {

		org_loadPlage();
		org_activeMenu(true);

	} catch (e) {
		recup_erreur(e);
	}
}


function org_loadPlage() {
	try {

		if (org_aPlages.isSelected()) {
			var index = org_aPlages.getCurrentIndex();
			org_plageId = org_aPlages.getCellText(index,'org-colPlageId');
  		document.getElementById('org-debut').value = org_aPlages.getCellText(index,'org-colDebut');
			document.getElementById('org-fin').value = org_aPlages.getCellText(index,'org-colFin');
 		}

	} catch (e) {
		recup_erreur(e);
	}
}


function org_pressOnAnnulerPlage() {
	try {

		org_activeMenu(false);
		org_annulerPlage();
		org_activeMenu(true);

	} catch (e) {
		recup_erreur(e);
	}
}


function org_pressOnValiderPlage() {
	try {

		var debut = document.getElementById('org-debut').value;
		var fin = document.getElementById('org-fin').value;

		if (!isCompteCorrect(debut)) { showWarning("Compte de d\u00E9but incorrect !"); }
		else if (!isCompteCorrect(fin)) { showWarning("Compte de fin incorrect !"); }
		else if (!((debut.charAt(0)=='6' && fin.charAt(0)=='6') || (debut.charAt(0)=='7' && fin.charAt(0)=='7'))) { showWarning("Les comptes de d\u00E9but et de fin doivent \u00EAtre soit des comptes de charges(6), soit des comptes de produits(7) !"); }
		else if (parseInt(debut)>parseInt(fin)) { showWarning("Le compte de d\u00E9but doit \u00EAtre inf\u00E9rieur au compte de fin !"); }
		else {
			org_activeMenu(false);
			org_savePlage();
			org_activeMenu(true);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function org_pressOnSupprimerPlage() {
	try {

		if (org_plageId!=0) {
			org_activeMenu(false);
			org_supprimerPlage();
			org_activeMenu(true);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function org_annulerPlage() {
	try {

		org_plageId = 0;
		org_aPlages.clearSelection();

		document.getElementById('org-debut').value = "";
		document.getElementById('org-fin').value = "";

	} catch (e) {
		recup_erreur(e);
	}
}


function org_savePlage() {
	try {

		var qSave = new QueryHttp("Compta/Analytique/Rubriques/savePlage.tmpl");
		qSave.setParam("Plage_Id", org_plageId);
		qSave.setParam("Rubrique_Id", org_rubriqueId);
		qSave.setParam("Compte_Debut", document.getElementById('org-debut').value);
		qSave.setParam("Compte_Fin", document.getElementById('org-fin').value);

		var result = qSave.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
  		org_ouvrir(org_rubriqueId);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function org_supprimerPlage() {
	try {

		var qDelete = new QueryHttp("Compta/Analytique/Rubriques/deletePlage.tmpl");
		qDelete.setParam("Plage_Id", org_plageId);

		var result = qDelete.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
	  	org_ouvrir(org_rubriqueId);
		}

	} catch (e) {
		recup_erreur(e);
	}
}
