/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/formatter.js");


var ismenu = true;
var numop = '';
var popup='';
var currentAction = "C";
var currentJournalInitial = "";
var gProfil;

var aPeriodesSourceDebut = new Arbre("ComboListe/combo-periodesExercice.tmpl", 'periode_initiale');
var aPeriodesSourceFin = new Arbre("ComboListe/combo-periodesExercice.tmpl", 'periode_initiale_intervalle');

var nf = new NumberFormat("00", false);



function init() {
  try {
	
		gProfil = getProfil();

  	var aJournaux = new Arbre('ComboListe/combo-journaux.tmpl', 'journal_initial');
		aJournaux.initTree(initialiser1);

  } catch (e) {
    recup_erreur(e);
  }
}


function initialiser1() {
	try {

		document.getElementById("journal_initial").selectedIndex = 0;

		var aExinit = new Arbre('ComboListe/combo-exercices.tmpl', 'exercice_initial');
		aExinit.initTree(initialiser2);

	} catch (e) {
		recup_erreur(e);
	}
}


function initialiser2() {
	try {

		document.getElementById('exercice_initial').value = gProfil.getExerciceId();

		if (document.getElementById('exercice_initial').selectedIndex == -1) {
			document.getElementById('exercice_initial').selectedIndex = 0;
		}
		pressOnExerciceSource();

		initialiser5();

	} catch (e) {
		recup_erreur(e);
	}
}


function initialiser3() {
	try {

		document.getElementById("periode_initiale").selectedIndex = 0;
		var exerciceId = document.getElementById('exercice_initial').value;

		aPeriodesSourceFin.setParam("Non_Cloture", currentAction!="C");
		aPeriodesSourceFin.setParam("Exercice_Id", exerciceId);
		aPeriodesSourceFin.initTree(initialiser4);

	} catch (e) {
		recup_erreur(e);
	}
}


function initialiser4() {
	try {

		document.getElementById("periode_initiale_intervalle").selectedIndex = 0;

	} catch (e) {
		recup_erreur(e);
	}
}


function initialiser5() {
	try {

		var bJournaux = new Arbre('ComboListe/combo-journaux.tmpl', 'journal_cible');
		bJournaux.setParam("Sans_AN", true);
		bJournaux.initTree(initialiser6);

	} catch (e) {
		recup_erreur(e);
	}
}


function initialiser6() {
	try {

		document.getElementById("journal_cible").selectedIndex = 0;
		var aExcible = new Arbre('ComboListe/combo-exercices.tmpl', 'exercice_cible');
		aExcible.setParam("Unclose_Only", true);
		aExcible.initTree(initialiser7);

	} catch (e) {
		recup_erreur(e);
	}
}


function initialiser7() {
	try {

		document.getElementById('exercice_cible').value = gProfil.getExerciceId();

		if (document.getElementById('exercice_cible').selectedIndex == -1) {
			document.getElementById('exercice_cible').selectedIndex = 0;
		}

		pressOnExerciceDestination();

	} catch (e) {
		recup_erreur(e);
	}
}


function initialiser8() {
	try {

		document.getElementById("periode_cible").selectedIndex = 0;
		var exerciceId = document.getElementById('exercice_cible').value;

		var aPeriodes = new Arbre("ComboListe/combo-periodesExercice.tmpl", 'periode_cible_intervalle');
		aPeriodes.setParam("Non_Cloture", true);
		aPeriodes.setParam("Exercice_Id", exerciceId);
		aPeriodes.initTree(initialiser9);

	} catch (e) {
		recup_erreur(e);
	}
}


function initialiser9() {
	try {

		document.getElementById("periode_cible_intervalle").selectedIndex = 0;

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnExerciceSource() {
	try {

		var exerciceId = document.getElementById('exercice_initial').value;

		if (!isEmpty(exerciceId)) {
			aPeriodesSourceDebut.setParam("Non_Cloture", currentAction!="C");
			aPeriodesSourceDebut.setParam("Exercice_Id", exerciceId);
			aPeriodesSourceDebut.initTree(initialiser3);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnExerciceDestination() {
	try {

		var exerciceId = document.getElementById('exercice_cible').value;

		if (!isEmpty(exerciceId)) {
			var aPeriodes = new Arbre("ComboListe/combo-periodesExercice.tmpl", 'periode_cible');
			aPeriodes.setParam("Non_Cloture", true);
			aPeriodes.setParam("Exercice_Id", exerciceId);
			aPeriodes.initTree(initialiser8);
		}

	} catch (e) {
		recup_erreur(e);
	}
}



function etat_avancement() {
	try {

		var url = "chrome://opensi/content/compta/user/autres/popup_avancement.xul";
	  popup = window.openDialog(url,'','chrome,centerscreen');

	} catch (e) {
		recup_erreur(e);
	}
}


function close_etat_avancement() {
	try {

		if (popup!="") {
	   	popup.close();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function focus_tree() {
  try {

		var tree = document.getElementById('exercice_initial');
		var tree2 = document.getElementById('exercice_cible');
		if (tree.view!=null) {
    	tree.focus();
    	tree.view.selection.select(1);
		}
		if (tree2.view!=null) {
    	tree2.focus();
    	tree2.view.selection.select(1);
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function pressOnChoix() {
	try {

		var choix = document.getElementById('Choix').value;

		document.getElementById('num1').disabled = (choix!="B");
		document.getElementById('num2').disabled = (choix!="B");

		document.getElementById('date1').disabled = (choix!="C");
		document.getElementById('date2').disabled = (choix!="C");

	} catch (e) {
    recup_erreur(e);
  }
}


function copie_ecriture() {
  try	{

  	var exercice_initial = document.getElementById("exercice_initial").value;
		var exercice_cible = document.getElementById("exercice_cible").value;
    var journal_initial = document.getElementById("journal_initial").value;
		var journal_cible = document.getElementById("journal_cible").value;
		var periode_initiale = document.getElementById("periode_initiale").value;
		var periode_cible = document.getElementById("periode_cible").value;
		var periode_initiale_int = document.getElementById("periode_initiale_intervalle").value;
		var periode_cible_int = document.getElementById("periode_cible_intervalle").value;
		var extourne = document.getElementById("Extourne").checked;
		var choix = document.getElementById("Choix").value;
		var num1 = document.getElementById("num1").value;
		var num2 = document.getElementById("num2").value;
		var date1 = document.getElementById("date1").value;
		var date2 = document.getElementById("date2").value;

		if (journal_initial=="") { showWarning("Veuillez choisir un journal source !"); }
		else if (journal_cible=="") { showWarning("Veuillez choisir un journal de destination !"); }
		else if (periode_initiale=="") { showWarning("Veuillez choisir une p\u00E9riode source de d\u00E9but !"); }
		else if (periode_initiale_int=="") { showWarning("Veuillez choisir une p\u00E9riode source de fin !"); }
		else if (periode_cible=="") { showWarning("Veuillez choisir une p\u00E9riode de destination de d\u00E9but !"); }
		else if (periode_cible_int=="") { showWarning("Veuillez choisir une p\u00E9riode de destination de fin !"); }
		else if (choix=="B" && (!isPositiveInteger(num1) || !isPositiveInteger(num2) || parseIntBis(num1)>parseIntBis(num2))) { showWarning("La plage de num\u00E9ros d'\u00E9critures n'est pas valide !"); }
		else if (choix=="C" && (!isPositiveInteger(date1) || !isPositiveInteger(date2) || parseIntBis(date1)>31 || parseIntBis(date2)>31 || parseIntBis(date1)>parseIntBis(date2))) { showWarning("La plage de dates n'est pas valide !"); }
		else if (verifIntervalle()) {

			var dlg = "Confirmez-vous la copie des \u00E9critures de l'exercice "+document.getElementById("exercice_initial").selectedItem.label+" du journal "+document.getElementById("journal_initial").selectedItem.label+" pour les p\u00E9riodes : "+ document.getElementById("periode_initiale").selectedItem.label+" - "+document.getElementById("periode_initiale_intervalle").selectedItem.label+" ?";

			if (window.confirm(dlg)) {

				close_etat_avancement();

				document.getElementById("Progression").collapsed = false;
				document.getElementById('pm').setAttribute('mode','undetermined');
				document.getElementById("bMenuPrincipal").collapsed = true;
				var periode_cible=document.getElementById("periode_cible").value;
				var qCopy = new QueryHttp("Compta/Saisie/CopieJournal.tmpl");
				qCopy.setParam("ExerciceDest",exercice_cible);
				qCopy.setParam("JournalDest",journal_cible);
				qCopy.setParam("PeriodeDestDebut",periode_cible);
				qCopy.setParam("Extourne",extourne);
				qCopy.setParam("ExerciceSrc",exercice_initial);
				qCopy.setParam("JournalSrc",journal_initial);
				qCopy.setParam("PeriodeSrcDebut",periode_initiale);
				qCopy.setParam("PeriodeSrcFin",periode_initiale_int);
				qCopy.setParam("TypeSel",choix);
				if (choix=="B") {
					qCopy.setParam("NumEcrDebut",num1);
					qCopy.setParam("NumEcrFin",num2);
				}
				if (choix=="C") {
					qCopy.setParam("JourDebut",date1);
					qCopy.setParam("JourFin",date2);
				}
  			var result = qCopy.execute();

				document.getElementById("Progression").collapsed = true;
				document.getElementById('pm').setAttribute('mode','none');
				document.getElementById("bMenuPrincipal").collapsed = false;

				var errors = new Errors(result);

				if (errors.hasNext()) {
					errors.show();
				}
				else {
					var contenu = result.responseXML.documentElement;
					var nbreecriture= contenu.getAttribute('NbEcrCopy');

					if (periode_initiale!=periode_initiale_int) {
						showMessage(nbreecriture+ " \u00E9critures ont \u00E9t\u00E9 ins\u00E9r\u00E9es dans le journal "+document.getElementById("journal_cible").selectedItem.label+" pour les p\u00E9riodes du "+document.getElementById("periode_cible").selectedItem.label+ " au " +document.getElementById("periode_cible_intervalle").selectedItem.label+" de l'exercice "+document.getElementById("exercice_cible").selectedItem.label);
					}
					else {
						showMessage(nbreecriture+ " \u00E9critures ont \u00E9t\u00E9 ins\u00E9r\u00E9es dans le journal "+document.getElementById("journal_cible").selectedItem.label+" pour la p\u00E9riode "+document.getElementById("periode_cible").selectedItem.label+" de l'exercice "+document.getElementById("exercice_cible").selectedItem.label);
					}
				}
			}
  	}
  	else {
			showMessage("L'intervalle des p\u00E9riodes initiales et cibles doit \u00EAtre identique !");
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function suppression_ecriture() {
	try {

		var exercice_initial = document.getElementById("exercice_initial").value;
	  var journal_initial = document.getElementById("journal_initial").value;
		var periode_initiale = document.getElementById("periode_initiale").value;
		var periode_initiale_int = document.getElementById("periode_initiale_intervalle").value;
		var choix = document.getElementById("Choix").value;
		var num1 = document.getElementById("num1").value;
		var num2 = document.getElementById("num2").value;
		var date1 = document.getElementById("date1").value;
		var date2 = document.getElementById("date2").value;
		var supprimerLettrage = document.getElementById("chkSupprLettrage").checked;

		if (journal_initial=="") { showWarning("Veuillez choisir un journal source !"); }
		else if (periode_initiale=="") { showWarning("Veuillez choisir une p\u00E9riode source de d\u00E9but !"); }
		else if (periode_initiale_int=="") { showWarning("Veuillez choisir une p\u00E9riode source de fin !"); }
		else if (choix=="B" && (!isPositiveInteger(num1) || !isPositiveInteger(num2) || parseIntBis(num1)>parseIntBis(num2))) { showWarning("La plage de num\u00E9ros d'\u00E9critures n'est pas valide !"); }
		else if (choix=="C" && (!isPositiveInteger(date1) || !isPositiveInteger(date2) || parseIntBis(date1)>31 || parseIntBis(date2)>31 || parseIntBis(date1)>parseIntBis(date2))) { showWarning("La plage de dates n'est pas valide !"); }
		else {
			var dlg = "Confirmez-vous la suppression des \u00E9critures de l'exercice "+document.getElementById("exercice_initial").selectedItem.label+" du journal "+document.getElementById("journal_initial").selectedItem.label +" de la p\u00E9riode : "+document.getElementById("periode_initiale").selectedItem.label+ " \u00E0 "+document.getElementById("periode_initiale_intervalle").selectedItem.label +" ?";

			if (window.confirm(dlg) ) {
				close_etat_avancement();
				
				if (journal_initial=="0") {
					journal_initial = "";
				}

				document.getElementById("Progression").collapsed = false;
				document.getElementById('pm').setAttribute('mode','undetermined');
				document.getElementById("bMenuPrincipal").collapsed = true;
				var periode_cible=document.getElementById("periode_cible").value;
				var qDelete = new QueryHttp("Compta/Saisie/SupJournal.tmpl");

				qDelete.setParam("ExerciceSrc",exercice_initial);
				qDelete.setParam("JournalSrc",journal_initial);
				qDelete.setParam("PeriodeDebut",periode_initiale);
				qDelete.setParam("PeriodeFin",periode_initiale_int);
				qDelete.setParam("TypeSel",choix);
				qDelete.setParam("SupLet",supprimerLettrage);
				if (choix=="B") {
					qDelete.setParam("NumEcrDebut",num1);
					qDelete.setParam("NumEcrFin",num2);
				}
				if (choix=="C") {
					qDelete.setParam("JourDebut",date1);
					qDelete.setParam("JourFin",date2);
				}

	  		var result = qDelete.execute();

				document.getElementById("Progression").collapsed = true;
				document.getElementById('pm').setAttribute('mode','none');
				document.getElementById("bMenuPrincipal").collapsed = false;

				var errors = new Errors(result);

				if (errors.hasNext()) {
					errors.show();
				}
				else {
					var contenu = result.responseXML.documentElement;
					var nbreecriture = contenu.getAttribute('NbEcrSup');
					var nontransfereLR = contenu.getAttribute('NonTransRB');

					if (periode_initiale!=periode_initiale_int) {
						showMessage(nbreecriture+ " \u00E9critures ont \u00E9t\u00E9 supprim\u00E9es du journal "+document.getElementById("journal_initial").selectedItem.label+" pour les p\u00E9riodes : "+document.getElementById("periode_initiale").selectedItem.label+ " \u00E0 " +document.getElementById("periode_initiale_intervalle").selectedItem.label+" de l'exercice "+document.getElementById("exercice_initial").selectedItem.label);
					} else {
						showMessage(nbreecriture+ " \u00E9critures ont \u00E9t\u00E9 supprim\u00E9es du journal "+document.getElementById("journal_initial").selectedItem.label+" pour la p\u00E9riode "+document.getElementById("periode_initiale").selectedItem.label+" de l'exercice "+document.getElementById("exercice_initial").selectedItem.label);
					}

					if (nontransfereLR>0) {
						showWarning(nontransfereLR+ " \u00E9critures n'ont pas \u00E9t\u00E9 supprim\u00E9es (op\u00E9rations pr\u00E9sentes en rapprochement bancaire)");
					}
				}
			}

		}

  } catch (e) {
    recup_erreur(e);
  }
}


function transfert_ecriture() {
	try {

		var exercice_initial = document.getElementById("exercice_initial").value;
		var exercice_cible = document.getElementById("exercice_cible").value;
    var journal_initial = document.getElementById("journal_initial").value;
		var journal_cible = document.getElementById("journal_cible").value;
		var periode_initiale = document.getElementById("periode_initiale").value;
		var periode_cible = document.getElementById("periode_cible").value;
		var periode_initiale_int = document.getElementById("periode_initiale_intervalle").value;
		var periode_cible_int = document.getElementById("periode_cible_intervalle").value;
		var extourne = document.getElementById("Extourne").checked;
		var choix = document.getElementById("Choix").value;
		var num1 = document.getElementById("num1").value;
		var num2 = document.getElementById("num2").value;
		var date1 = document.getElementById("date1").value;
		var date2 = document.getElementById("date2").value;

		if (journal_initial=="") { showWarning("Veuillez choisir un journal source !"); }
		else if (journal_cible=="") { showWarning("Veuillez choisir un journal de destination !"); }
		else if (periode_initiale=="") { showWarning("Veuillez choisir une p\u00E9riode source de d\u00E9but !"); }
		else if (periode_initiale_int=="") { showWarning("Veuillez choisir une p\u00E9riode source de fin !"); }
		else if (periode_cible=="") { showWarning("Veuillez choisir une p\u00E9riode de destination de d\u00E9but !"); }
		else if (periode_cible_int=="") { showWarning("Veuillez choisir une p\u00E9riode de destination de fin !"); }
		else if (choix=="B" && (!isPositiveInteger(num1) || !isPositiveInteger(num2) || parseIntBis(num1)>parseIntBis(num2))) { showWarning("La plage de num\u00E9ros d'\u00E9critures n'est pas valide !"); }
		else if (choix=="C" && (!isPositiveInteger(date1) || !isPositiveInteger(date2) || parseIntBis(date1)>31 || parseIntBis(date2)>31 || parseIntBis(date1)>parseIntBis(date2))) { showWarning("La plage de dates n'est pas valide !"); }
		else if (verifIntervalle()) {

			var dlg = "Confirmez-vous le transfert des \u00E9critures de l'exercice "+document.getElementById("exercice_initial").selectedItem.label+" du journal "+document.getElementById("journal_initial").selectedItem.label+" pour les p\u00E9riodes : "+ document.getElementById("periode_initiale").selectedItem.label+" - "+document.getElementById("periode_initiale_intervalle").selectedItem.label+" ?";

			if (window.confirm(dlg)) {
				close_etat_avancement();

				document.getElementById("Progression").collapsed = false;
				document.getElementById('pm').setAttribute('mode','undetermined');
				document.getElementById("bMenuPrincipal").collapsed = true;
				var periode_cible=document.getElementById("periode_cible").value;
				var qTrans = new QueryHttp("Compta/Saisie/TransfertJournal.tmpl");
				qTrans.setParam("ExerciceDest",exercice_cible);
				qTrans.setParam("ExerciceSrc",exercice_initial);
				qTrans.setParam("JournalSrc",journal_initial);
				qTrans.setParam("JournalDest",journal_cible);
				qTrans.setParam("PeriodeSrcDebut",periode_initiale);
				qTrans.setParam("PeriodeSrcFin",periode_initiale_int);
				qTrans.setParam("PeriodeDestDebut",periode_cible);
				qTrans.setParam("Extourne",extourne);
				qTrans.setParam("TypeSel",choix);

				if (choix=="B") {
					qTrans.setParam("NumEcrDebut",num1);
					qTrans.setParam("NumEcrFin",num2);
				}
				else if (choix=="C") {
					qTrans.setParam("jourDebut",date1);
					qTrans.setParam("jourFin",date2);
				}

  			var result = qTrans.execute();

				document.getElementById("Progression").collapsed = true;
				document.getElementById('pm').setAttribute('mode','none');
				document.getElementById("bMenuPrincipal").collapsed = false;

				var errors = new Errors(result);

				if (errors.hasNext()) {
					errors.show();
				}
				else {
					var contenu = result.responseXML.documentElement;
					var nontransfere= contenu.getAttribute('NbEcrNonTrans');
					var nbreecriture= contenu.getAttribute('NbEcrTrans');
					var nontransfererLR= contenu.getAttribute('NonTransRB');

					if (periode_initiale!=periode_initiale_int) {
						showMessage(nbreecriture+ " \u00E9critures ont \u00E9t\u00E9 transf\u00E9r\u00E9es du journal "+document.getElementById("journal_cible").selectedItem.label+" pour les p\u00E9riodes du "+document.getElementById("periode_cible").selectedItem.label+ " au " +document.getElementById("periode_cible_intervalle").selectedItem.label+" de l'exercice "+document.getElementById("exercice_cible").selectedItem.label);
					}
					else{
						showMessage(nbreecriture+ " \u00E9critures ont \u00E9t\u00E9 transf\u00E9r\u00E9es dans le journal "+document.getElementById("journal_cible").selectedItem.label+" pour la p\u00E9riode "+document.getElementById("periode_cible").selectedItem.label+" de l'exercice "+document.getElementById("exercice_cible").selectedItem.label);
					}

					if (nontransfere>0) {
						showMessage(nontransfere+ " ecritures n'ont pas \u00E9t\u00E9 transf\u00E9r\u00E9es (\u00E9critures lettr\u00E9es)");
					}
					if (nontransfererLR>0) {
						showMessage(nontransfererLR+ " ecritures n'ont pas \u00E9t\u00E9 transf\u00E9r\u00E9es (op\u00E9rations dans rapprochement bancaire)");
					}
				}
			}
		}
		else {
			showMessage("L'intervalle des p\u00E9riodes initiales et cibles doit \u00EAtre identique !");
		}

	} catch (e) {
    recup_erreur(e);
	}
}


function verifIntervalle() {
	try {
		// intervalle de 0  11 - 0 = le meme mois
		var periode_init = document.getElementById("periode_initiale").value;
		var periode_fin = document.getElementById("periode_initiale_intervalle").value;
		var periode_c_init = document.getElementById("periode_cible").value;
		var periode_c_fin = document.getElementById("periode_cible_intervalle").value;
		var mois = periode_init.substring(0, 2);
		var mois2 = periode_fin.substring(0, 2);
		var mois3 = periode_c_init.substring(0, 2);
		var mois4 = periode_c_fin.substring(0, 2);
		var interv = parseIntBis(mois2) - parseIntBis(mois);
		var interv2 = parseIntBis(mois4) - parseIntBis(mois3);
		return (interv==interv2);
	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnAction() {
	try {

		currentAction = document.getElementById('rgpAction').value;

		var lblExercice = document.getElementById('exercice_initial').label;
		var cloture = (lblExercice=="cl\u00F4tur\u00E9");

		currentJournalInitial = document.getElementById('journal_initial').value;

		if (currentAction=="C") {
			var bJournaux = new Arbre('ComboListe/combo-journaux.tmpl', 'journal_initial');
			bJournaux.initTree(initJournalSource);
		}
		else {
			var bJournaux = new Arbre('ComboListe/combo-journaux.tmpl', 'journal_initial');
			bJournaux.setParam("Sans_AN", true);
			bJournaux.initTree(initJournalSource);
		}

		document.getElementById('ok_cible').collapsed = (currentAction!="C");
		document.getElementById('transfere').collapsed = (cloture || currentAction!="T");
		document.getElementById('suppression').collapsed = (cloture || currentAction!="S");

		document.getElementById('grpDestination').collapsed = (currentAction=="S");
		document.getElementById('miTousJournaux').collapsed = (currentAction!="S");
		document.getElementById('chkSupprLettrage').collapsed = (currentAction!="S");
		if (currentAction!="S") {	document.getElementById('chkSupprLettrage').setAttribute("checked", false); }

		majPeriodesSource();

	} catch (e) {
		recup_erreur(e);
	}
}


function initJournalSource() {
	try {

		if ((currentJournalInitial=="0" && currentAction!="S") || (currentJournalInitial=="AN" && currentAction!="C")) {
			currentJournalInitial = "";
		}

		document.getElementById('journal_initial').value = currentJournalInitial;
		currentJournalInitial = "";

	} catch (e) {
		recup_erreur(e);
	}
}


function majPeriodesSource() {
	try {

		aPeriodesSourceDebut.setParam("Non_Cloture", currentAction!="C");
		aPeriodesSourceDebut.initTree(initPeriodeSourceDebut);

	} catch (e) {
		recup_erreur(e);
	}
}


function initPeriodeSourceDebut() {
	try {

		document.getElementById("periode_initiale").selectedIndex = 0;

		aPeriodesSourceFin.setParam("Non_Cloture", currentAction!="C");
		aPeriodesSourceFin.initTree(initPeriodeSourceFin);

	} catch (e) {
		recup_erreur(e);
	}
}


function initPeriodeSourceFin() {
	try {

		document.getElementById("periode_initiale_intervalle").selectedIndex = 0;

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPeriodeSourceInitial() {
	try {
		document.getElementById("periode_initiale_intervalle").value = document.getElementById("periode_initiale").value;
	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPeriodeDestInitiale() {
	try {
		var periodeSourceDebut = document.getElementById("periode_initiale").value;
		var periodeSourceFin = document.getElementById("periode_initiale_intervalle").value;
		var periodeDestDebut = document.getElementById("periode_cible").value;

		if (periodeSourceDebut!="" && periodeSourceFin!="" && periodeDestDebut!="") {

			var moisSourceDebut = periodeSourceDebut.substring(0, 2);
			var moisSourceFin = periodeSourceFin.substring(0, 2);
			var moisDestDebut = periodeDestDebut.substring(0, 2);
			var anneeDestDebut = periodeDestDebut.substring(2, 4);

			var intervalleSource = parseIntBis(moisSourceFin) - parseIntBis(moisSourceDebut);
			if (isPositiveOrNullInteger(intervalleSource)) {
				var moisDestFin = parseIntBis(moisDestDebut) + intervalleSource;
				if (moisDestFin<=12) {
					document.getElementById('periode_cible_intervalle').value = (nf.format(moisDestFin) + anneeDestDebut);
				}
			}
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function menuPrincipal() {
	try {

		window.location = "chrome://opensi/content/compta/user/menu_exercice.xul";

	} catch (e) {
		recup_erreur(e);
	}
}
