/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var aPeriodes = new Arbre('Compta/Exercice/list-periodeExercice.tmpl', 'listePeriodes');
var periodeId;
var datePeriode;
var derniere;



function init() {
	try {

		var qGet = new QueryHttp("Compta/Exercice/getPeriodeCourante.tmpl");
		var result = qGet.execute();

		periodeId = result.responseXML.documentElement.getAttribute("Periode_Id");
		datePeriode = result.responseXML.documentElement.getAttribute("Periode");
		derniere = result.responseXML.documentElement.getAttribute("Derniere")=="true";

		document.getElementById('boxPeriodeEnCours').collapsed = (periodeId==0);
		document.getElementById('bToutCloturer').collapsed = (periodeId==0);
		document.getElementById('periodeEnCours').value = datePeriode;
		aPeriodes.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function cloturer() {
	try {

		if (window.confirm("Confirmez-vous la cl\u00F4ture de la p\u00E9riode "+ datePeriode +" ? (attention plus aucune \u00E9criture ne pourra \u00EAtre saisie sur la p\u00E9riode)")) {
			var qClose = new QueryHttp("Compta/Exercice/closePeriodeExercice.tmpl");
			qClose.setParam("Periode_Id", periodeId);
			var result = qClose.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("La cl\u00F4ture de la p\u00E9riode "+ datePeriode +" a \u00E9t\u00E9 effectu\u00E9e");
				if (derniere && window.confirm("Il ne reste plus de p\u00E9riode \u00E0 cl\u00F4turer. Voulez-vous cl\u00F4turer l'exercice ?")) {
					window.location = "chrome://opensi/content/compta/user/cloture/options_cloture.xul";
				}
				else {
					init();
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function toutCloturer() {
	try {

		if (window.confirm("Confirmez-vous la cl\u00F4ture de toutes les p\u00E9riodes de l'exercice ? (attention plus aucune \u00E9criture ne pourra \u00EAtre saisie sur l'exercice)")) {
			var qClose = new QueryHttp("Compta/Exercice/closeAllPeriodeExercice.tmpl");
			var result = qClose.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("La cl\u00F4ture des p\u00E9riodes de l'exercice a \u00E9t\u00E9 effectu\u00E9e");
				if (window.confirm("Il ne reste plus de p\u00E9riode \u00E0 cl\u00F4turer. Voulez-vous cl\u00F4turer l'exercice ?")) {
					window.location = "chrome://opensi/content/compta/user/cloture/options_cloture.xul";
				}
				else {
					init();
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuPrincipal() {
	try {

		window.location = "chrome://opensi/content/compta/user/menu_exercice.xul";

	} catch (e) {
		recup_erreur(e);
	}
}
