/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

/*
	Arguments du popup :
		- 0 : Fonction de retour
		- 1 : N Compte de recherche
		- 2 : Type de compte (C,F,G,A, vide sinon)
		- 3 : Complment de titre
		- 4 : Dbut de compte obligatoire
		- 5 : Compte centralisateur (true, false, vide sinon)
*/

jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var aComptes = new Arbre("Compta/Comptes/list-compte.tmpl", "listeComptes");
var qListNC = new QueryHttp("Compta/Comptes/getDataListNC.tmpl");
var qCheck = new QueryHttp("Compta/Comptes/searchNumCompte.tmpl");

var pageCourante;
var nbPages;

var argTypeCompte;
var numCompte;


function init() {
  try {

		var titre = window.arguments[3];
		if (!isEmpty(titre)) {
			document.getElementById('titre').value = "RECHERCHE D'UN COMPTE "+ titre;
		}

		var numCompte = window.arguments[1];
		argTypeCompte = window.arguments[2];
		var debCompte = window.arguments[4];
		var centralisateur = window.arguments[5];

		qListNC.setParam("Type_Compte", argTypeCompte);
		qListNC.setParam("Deb_Compte", debCompte);
		qListNC.setParam("Centralisateur", centralisateur);

		qCheck.setParam("Type_Compte", argTypeCompte);
		qCheck.setParam("Deb_Compte", debCompte);
		qCheck.setParam("Centralisateur", centralisateur);

		if (!isEmpty(numCompte) || centralisateur) {
			document.getElementById('numCompte').value = numCompte;
			listerComptes();
		}

    document.getElementById('numCompte').focus();

  } catch (e) {
    recup_erreur(e);
  }
}


function pressOnNumCompte(ev) {
  try {

		if (ev.keyCode==13) {
			checkCompte(document.getElementById('numCompte').value);
    }
		else {
			pressGlobal(ev);
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			listerComptes();
    }
		else {
			pressGlobal(ev);
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function checkCompte(numCompte) {
  try {

		qCheck.setParam("Num_Compte", numCompte);
		qCheck.setParam("Search_Like", false);
		var result = qCheck.execute();

		var compteId = result.responseXML.documentElement.getAttribute('Compte_Id');

		if (!isEmpty(compteId)) {
			ouvrirCompte(numCompte, compteId);
		}
		else {
			listerComptes();
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function pressOnTree(ev) {
  try {

		if (ev.keyCode==13) {
			choixCompte();
    }
		else {
			pressGlobal(ev);
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function pressGlobal(ev) {
  try {

		switch (ev.keyCode) {
			case 33: // <PageUp>
				selectPageUp();
				break;
			case 34: // <PageDown>
				selectPageDown();
				break;
			case 38: // <Up>
			case 40: // <Down>
				selectFirst();
				break;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


// slection de la ligne suivante  la ligne slectionne
function selectFirst() {
	try {

		if (!aComptes.isSelected() && aComptes.nbLignes()>0) {
			selectLigne(0);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


// slection d'une ligne 10 lignes au dessus de la ligne slectionne
function selectPageUp() {
	try {

		if (aComptes.nbLignes()>0) {
			var idx = aComptes.getCurrentIndex() - 10;
			if (idx<0) {
				selectLigne(0);
			}
			else {
				selectLigne(idx);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


// slection d'une ligne 10 lignes en dessous de la ligne slectionne
function selectPageDown() {
	try {

		var nbLignes = aComptes.nbLignes();

		if (nbLignes>0) {
			var idx = aComptes.getCurrentIndex() + 10;
			if (idx >= nbLignes) {
				selectLigne(nbLignes - 1);
			}
			else {
				selectLigne(idx);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


// selectionne une ligne dans l'arbre
function selectLigne(idx) {
	try {

		document.getElementById('listeComptes').focus();
		aComptes.select(idx);
		aComptes.ensureRowIsVisible(idx);

	} catch (e) {
		recup_erreur(e);
	}
}


function nouveauCompte() {
  try {

		var numCompte = document.getElementById('numCompte').value;
 		var url = "chrome://opensi/content/config/util/nouveau_compte.xul?"+ cookie() +"&Num_Compte="+ numCompte +"&Type_Compte="+ argTypeCompte;
   	window.openDialog(url,'','chrome,modal,centerscreen', reporterCompte);

  } catch (e) {
    recup_erreur(e);
  }
}


function reporterCompte(numCompte) {
  try {

		document.getElementById('numCompte').value = numCompte;
		listerComptes();

	} catch (e) {
  	recup_erreur(e);
  }
}


function ouvrirCompte(numCompte, compteId) {
  try {

		window.arguments[0](numCompte, compteId);
    setTimeout("window.close()",0); // pour fermeture si fonction appele d'un autre popup

  } catch (e) {
    recup_erreur(e);
  }
}


function choixCompte() {
	try {

		if (aComptes.isSelected()) {
			var numCompte = aComptes.getSelectedCellText('colNumCompte');
			var compteId = aComptes.getSelectedCellText('colCompteId');
			ouvrirCompte(numCompte, compteId);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function initCriteres() {
	try {

		document.getElementById('numCompte').value = "";
		document.getElementById('intitule').value = "";
		document.getElementById('actif').checked = true;

		listerComptes();

	} catch (e) {
    recup_erreur(e);
  }
}


function listerComptes() {
	try {

		var numCompte = document.getElementById('numCompte').value;
		var intitule = document.getElementById('intitule').value;
		var actif = document.getElementById('actif').checked;
		var nbLignesParPage = document.getElementById('nbLignesParPage').value;

		pageCourante = 1;
		nbPages = 1;
		document.getElementById('pageDeb').value = 1;
		document.getElementById('pageFin').value = 1;
		document.getElementById('bPrec').disabled = true;
		document.getElementById('bSuiv').disabled = true;

		document.getElementById('listeComptes').disabled = true;
		aComptes.deleteTree();

		qListNC.setParam("Num_Compte", numCompte);
		qListNC.setParam("Intitule", intitule);
		qListNC.setParam("Actif", actif);
		qListNC.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
		qListNC.setParam("Current_Page", pageCourante);

		var result = qListNC.execute();

		var contenu = result.responseXML.documentElement;

		nbPages = contenu.getAttribute("Nb_Pages");
		var listCompteId = contenu.getAttribute("List_Compte_Id");

		aComptes.setParam("List_Compte_Id", listCompteId);
		aComptes.initTree(initPagination);

	} catch (e) {
    recup_erreur(e);
  }
}


function initPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('pageFin').value = (nbPages>0?nbPages:1);
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante>=nbPages); // peut se produire si nbPages=0

		afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPagePrec() {
	try {

		pageCourante--;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPageSuiv() {
	try {

		pageCourante++;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function majPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante==nbPages);

		document.getElementById('listeComptes').disabled = true;

		qListNC.setParam("Current_Page", pageCourante);
		var result = qListNC.execute();
		var listCompteId = result.responseXML.documentElement.getAttribute("List_Compte_Id");

		aComptes.setParam("List_Compte_Id", listCompteId);
		aComptes.initTree(afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function afterMajPagination() {
	try {

		document.getElementById('listeComptes').disabled = false;

		// recherche de merde
		var rechCompte = document.getElementById('numCompte').value;
		if (!isEmpty(rechCompte) && aComptes.nbLignes()<=0) {
			document.getElementById('numCompte').value = "";
			document.getElementById('intitule').value = rechCompte;
			listerComptes();
		}

	} catch (e) {
		recup_erreur(e);
	}
}
