/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


jsLoader.loadSubScript("chrome://opensi/content/libs/formatter.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


function init() {
  try {

    window.resizeTo(600,250);
	  document.getElementById('CompteDest').focus();

	} catch (e) {
  	recup_erreur(e);
  }
}


function ok() {
  try {

    var comptedest = document.getElementById('CompteDest').value;
		var comptesrc = window.arguments[0];
    var transAll = document.getElementById('TransAll').checked;

    if (isEmpty(comptedest)) {
      document.getElementById('CompteDest').focus();
      showWarning("Veuillez s\u00E9lectionner un compte.");
    }
		else {
			var msg = "Confirmez-vous le transfert "+ (transAll?"de toutes les op\u00E9rations":"des op\u00E9rations s\u00E9lectionn\u00E9es") +" du compte "+ comptesrc +" vers le compte "+ comptedest +" ?";

			if (window.confirm(msg)){
				window.arguments[1](comptesrc, comptedest, transAll);
			  window.close();
			}
    }

  } catch (e) {
    recup_erreur(e);
  }
}


function keypresscompte(ev) {
  try {

		if (ev.keyCode==13) {
			recherche_compte();
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function recherche_compte() {
  try {

    var numCompte = document.getElementById('CompteDest').value;
    var url = "chrome://opensi/content/compta/user/comptes/popup-rechercheCompte.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', retourRechercheCompte, numCompte, "", "", "", false);

	} catch (e) {
    recup_erreur(e);
  }
}


function retourRechercheCompte(numCompte, compteId) {
	try {

		document.getElementById('CompteDest').value = numCompte;

	} catch (e) {
		recup_erreur(e);
	}
}
