/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var aComptes = new Arbre("Compta/Editions/list-balanceComptable.tmpl", "listeComptes");
var qListBC = new QueryHttp("Compta/Editions/getDataListBC.tmpl");

var pageCourante;
var nbPages;

var currentChampCompte;
var lastFichierPDF = null;
var prefixeCompteSE = "";
var typeCompteSE = "";



function init() {
  try {

		document.getElementById('typeCompte').value = "G";
		document.getElementById('typePeriode').value = "E";
		document.getElementById('typeEdition').value = "C";
		document.getElementById('nonSolde').checked = false;

		pressOnTypePeriode();
		pressOnTypeEdition();

  } catch (e) {
    recup_erreur(e);
  }
}


function pressOnTypePeriode() {
	try {

		var typePeriode = document.getElementById("typePeriode").value;

		if (typePeriode=='E') {
			document.getElementById('dateDebut').disabled = true;
			document.getElementById('dateFin').disabled = true;
			document.getElementById('dateDebut').value = "";
			document.getElementById('dateFin').value = "";
		}
		else {
			document.getElementById('dateDebut').disabled = false;
			document.getElementById('dateFin').disabled = false;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function pressOnTypeEdition() {
	try {

		var typeEdition = document.getElementById("typeEdition").value;

		if (typeEdition=='P') {
			document.getElementById('compteDebut').disabled = false;
			document.getElementById('compteFin').disabled = false;
			document.getElementById('bCompteDebut').disabled = false;
			document.getElementById('bCompteFin').disabled = false;
			document.getElementById('nonSolde').disabled = false;
		}
		else {
			document.getElementById('compteDebut').value = "";
			document.getElementById('compteFin').value = "";
			document.getElementById('compteDebut').disabled = true;
			document.getElementById('compteFin').disabled = true;
			document.getElementById('bCompteDebut').disabled = true;
			document.getElementById('bCompteFin').disabled = true;
			document.getElementById('nonSolde').checked = false;
			document.getElementById('nonSolde').disabled = true;
		}

		document.getElementById('bEditionEcran').disabled = typeEdition=='T';

	} catch (e) {
    recup_erreur(e);
  }
}


function rechercherCompte(id) {
	try {

		var typeCompte = document.getElementById('typeCompte').value;
		var numCompte = document.getElementById(id).value;

		var titre = "";

    if (typeCompte=="C") {
    	titre ="CLIENT";
    }
		else if (typeCompte=="F") {
    	titre ="FOURNISSEUR";
    }
		else if (typeCompte=="A") {
    	titre ="AUXILIAIRE";
		}
		else if (typeCompte=="G") {
    	titre ="GENERAL";
    }

		currentChampCompte = id;
    var url = "chrome://opensi/content/compta/user/comptes/popup-rechercheCompte.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherCompte, numCompte, typeCompte, titre, "", "");

	} catch (e) {
		recup_erreur(e);
	}
}


function retourRechercherCompte(numCompte, compteId) {
	try {

		document.getElementById(currentChampCompte).value = numCompte;

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnCompte(ev, id) {
  try {

    if (ev.keyCode==13) {
      rechercherCompte(id);
    }

  } catch (e) {
    recup_erreur(e);
  }
}


function editionPDF() {
	try {

		var dateDebut = document.getElementById('dateDebut').value;
		var dateFin = document.getElementById('dateFin').value;
		var compteDebut = document.getElementById('compteDebut').value;
		var compteFin = document.getElementById('compteFin').value;
		var typeCompte = document.getElementById('typeCompte').value;
		var typeEdition = document.getElementById('typeEdition').value;
		var typePeriode = document.getElementById('typePeriode').value;
		var nonSolde = document.getElementById('nonSolde').checked;

		if (typePeriode=="D" && !isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte"); }
		else if (typePeriode=="D" && !isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte"); }
		else if (typePeriode=="D" && !isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte"); }
		else if (typeEdition=="P" && !isEmpty(compteDebut) && !isCompteCorrect(compteDebut)) { showWarning("Compte de d\u00E9but incorrect"); }
		else if (typeEdition=="P" && !isEmpty(compteFin) && !isCompteCorrect(compteFin)) { showWarning("Compte de fin incorrect"); }
		else {
			document.getElementById('pmbox').collapsed = false;
			document.getElementById('pm').setAttribute('mode', 'undetermined');

			document.getElementById('pdfBalance').setAttribute("src", "");
			lastFichierPDF = null;

			var qEditionPdf = new QueryHttp("Compta/Editions/pdfBalanceComptable.tmpl");

			qEditionPdf.setParam("Type_Compte", typeCompte);
			qEditionPdf.setParam("Date_Debut", dateDebut);
			qEditionPdf.setParam("Date_Fin", dateFin);
			qEditionPdf.setParam("Compte_Debut", compteDebut);
			qEditionPdf.setParam("Compte_Fin", compteFin);
			qEditionPdf.setParam("Edition_Totaux", typeEdition=="T");
			qEditionPdf.setParam("Non_Solde", nonSolde);

			qEditionPdf.execute(editionPDF_2);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function editionPDF_2(result) {
	try {

		document.getElementById('pmbox').collapsed = true;
		document.getElementById('pm').setAttribute('mode', 'none');

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichierPDF = result.responseXML.documentElement.getAttribute('FichierPDF');
			var page = getDirPdf() + fichierPDF;
			document.getElementById('pdfBalance').setAttribute("src", page);

			document.getElementById('deck').selectedIndex = 1;
			document.getElementById('bRetourOptions').collapsed = false;

			lastFichierPDF = fichierPDF;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function envoyerMail() {
	try {

		if (lastFichierPDF!=null) {
			var url = "chrome://opensi/content/popup/popup-envoyerMail.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', "CGBC", lastFichierPDF);
		}

	}	catch (e) {
    recup_erreur(e);
  }
}


function editionCSV() {
	try {

		var dateDebut = document.getElementById('dateDebut').value;
		var dateFin = document.getElementById('dateFin').value;
		var compteDebut = document.getElementById('compteDebut').value;
		var compteFin = document.getElementById('compteFin').value;
		var typeCompte = document.getElementById('typeCompte').value;
		var typeEdition = document.getElementById('typeEdition').value;
		var typePeriode = document.getElementById('typePeriode').value;
		var nonSolde = document.getElementById('nonSolde').checked;

		if (typePeriode=="D" && !isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte"); }
		else if (typePeriode=="D" && !isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte"); }
		else if (typePeriode=="D" && !isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte"); }
		else if (typeEdition=="P" && !isEmpty(compteDebut) && !isCompteCorrect(compteDebut)) { showWarning("Compte de d\u00E9but incorrect"); }
		else if (typeEdition=="P" && !isEmpty(compteFin) && !isCompteCorrect(compteFin)) { showWarning("Compte de fin incorrect"); }
		else {
			document.getElementById('pmbox').collapsed = false;
			document.getElementById('pm').setAttribute('mode', 'undetermined');

			var qEditionCsv = new QueryHttp("Compta/Editions/csvBalanceComptable.tmpl");

			qEditionCsv.setParam("Type_Compte", typeCompte);
			qEditionCsv.setParam("Date_Debut", dateDebut);
			qEditionCsv.setParam("Date_Fin", dateFin);
			qEditionCsv.setParam("Compte_Debut", compteDebut);
			qEditionCsv.setParam("Compte_Fin", compteFin);
			qEditionCsv.setParam("Edition_Totaux", typeEdition=="T");
			qEditionCsv.setParam("Non_Solde", nonSolde);

			qEditionCsv.execute(editionCSV_2);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function editionCSV_2(result) {
	try {

		document.getElementById('pmbox').collapsed = true;
		document.getElementById('pm').setAttribute('mode', 'none');

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

			var file = fileChooser("save", fichier);
			if (file!=null) {
				downloadFile(getDirBuffer() + fichier, file);
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function editionEcran() {
	try {

		var dateDebut = document.getElementById('dateDebut').value;
		var dateFin = document.getElementById('dateFin').value;
		var compteDebut = document.getElementById('compteDebut').value;
		var compteFin = document.getElementById('compteFin').value;
		var typeCompte = document.getElementById('typeCompte').value;
		var typeEdition = document.getElementById('typeEdition').value;
		var typePeriode = document.getElementById('typePeriode').value;

		if (typePeriode=="D" && !isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte"); }
		else if (typePeriode=="D" && !isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte"); }
		else if (typePeriode=="D" && !isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte"); }
		else if (typeEdition=="P" && !isEmpty(compteDebut) && !isCompteCorrect(compteDebut)) { showWarning("Compte de d\u00E9but incorrect"); }
		else if (typeEdition=="P" && !isEmpty(compteFin) && !isCompteCorrect(compteFin)) { showWarning("Compte de fin incorrect"); }
		else {
			document.getElementById('deck').selectedIndex = 2;
			document.getElementById('bRetourOptions').collapsed = false;

			if (isEmpty(typeCompte)) {
				typeCompte = "G";
			}
			loadBalance(typeCompte, "");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function loadBalance(typeCompte, prefixeCompte) {
	try {

		typeCompteSE = typeCompte;
		prefixeCompteSE = prefixeCompte;

		var titre = "";

		if (typeCompte=="F") {
			titre = "Fournisseurs";
		}
		else if (typeCompte=="C") {
			titre = "Clients";
		}
		else if (typeCompte=="A") {
			titre = "Auxiliaires";
		}
		else if (typeCompte=="G" && isEmpty(prefixeCompte)) {
			titre = "G\u00E9n\u00E9raux";
		}
		else {
			titre = "de la classe "+ prefixeCompte;
		}

		document.getElementById('Titre').value = "Edition de la balance : Comptes "+ titre;

		document.getElementById('totalDebit').value = "";
		document.getElementById('totalCredit').value = "";
		document.getElementById('totalSolde').value = "";

		listerComptes();

	} catch (e) {
    recup_erreur(e);
  }
}


function pressOnListeComptes(ev) {
	try {

		if (ev.keyCode==13) {
      menuRevision();
    }

	} catch (e) {
    recup_erreur(e);
  }
}


function menuRevision() {
	try {

		if (aComptes.isSelected()) {
  		var numCompte = aComptes.getSelectedCellText('colCompte');
   		var prec = "chrome://opensi/content/compta/user/edition/options_balance.xul";

      window.location = "chrome://opensi/content/compta/user/consultation/menu_consultation.xul?compte="+ numCompte +"&nomprec=Balance&prec="+ urlEncode(prec);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function listerComptes() {
	try {

		var dateDebut = document.getElementById('dateDebut').value;
		var dateFin = document.getElementById('dateFin').value;
		var compteDebut = document.getElementById('compteDebut').value;
		var compteFin = document.getElementById('compteFin').value;
		var nonSolde = document.getElementById('nonSolde').checked;

		var nbLignesParPage = document.getElementById('nbLignesParPage').value;

		pageCourante = 1;
		nbPages = 1;
		document.getElementById('pageDeb').value = 1;
		document.getElementById('pageFin').value = 1;
		document.getElementById('bPrec').disabled = true;
		document.getElementById('bSuiv').disabled = true;

		document.getElementById('listeComptes').disabled = true;
		aComptes.deleteTree();

		qListBC.setParam("Type_Compte", typeCompteSE);
		qListBC.setParam("Date_Debut", dateDebut);
		qListBC.setParam("Date_Fin", dateFin);
		qListBC.setParam("Prefixe_Compte", prefixeCompteSE);
		qListBC.setParam("Compte_Debut", compteDebut);
		qListBC.setParam("Compte_Fin", compteFin);
		qListBC.setParam("Non_Solde", nonSolde);
		qListBC.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
		qListBC.setParam("Current_Page", pageCourante);

		var result = qListBC.execute();

		var contenu = result.responseXML.documentElement;

		document.getElementById('totalDebit').value = contenu.getAttribute("Total_Debit");
		document.getElementById('totalCredit').value = contenu.getAttribute("Total_Credit");
		document.getElementById('totalSolde').value = contenu.getAttribute("Total_Solde");
		nbPages = contenu.getAttribute("Nb_Pages");
		var listCompteId = contenu.getAttribute("List_Compte_Id");

		aComptes.setParam("List_Compte_Id", listCompteId);
		aComptes.setParam("Type_Compte", typeCompteSE);
		aComptes.setParam("Date_Debut", dateDebut);
		aComptes.setParam("Date_Fin", dateFin);
		aComptes.initTree(initPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function initPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('pageFin').value = (nbPages>0?nbPages:1);
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante>=nbPages); // peut se produire si nbPages=0

		afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPagePrec() {
	try {

		pageCourante--;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPageSuiv() {
	try {

		pageCourante++;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function majPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante==nbPages);

		document.getElementById('listeComptes').disabled = true;

		qListBC.setParam("Current_Page", pageCourante);
		var result = qListBC.execute();
		var listCompteId = result.responseXML.documentElement.getAttribute("List_Compte_Id");

		aComptes.setParam("List_Compte_Id", listCompteId);
		aComptes.initTree(afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function afterMajPagination() {
	try {

		document.getElementById('listeComptes').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function retourOptions() {
  try {

		document.getElementById('pdfBalance').setAttribute("src", "");
   	document.getElementById('deck').selectedIndex = 0;
		document.getElementById('bRetourOptions').collapsed = true;

  } catch (e) {
    recup_erreur(e);
  }
}


function retourMenuPrincipal() {
  try {

    window.location = "chrome://opensi/content/compta/user/menu_exercice.xul";

	} catch (e) {
    recup_erreur(e);
  }
}
