/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var currentChampCompte;
var lastFichierPDF = null;



function init() {
  try {

		document.getElementById('typeCompte').value = "G";
		document.getElementById('typePeriode').value = "E";
		document.getElementById('typeEdition').value = "C";
		document.getElementById('lettrage').value = "";
		document.getElementById('nonSolde').checked = false;

		pressOnTypePeriode();
		pressOnTypeEdition();

  } catch (e) {
    recup_erreur(e);
  }
}


function pressOnTypePeriode() {
	try {

		var typePeriode = document.getElementById("typePeriode").value;

		if (typePeriode=='E') {
			document.getElementById('dateDebut').disabled = true;
			document.getElementById('dateFin').disabled = true;
			document.getElementById('dateDebut').value = "";
			document.getElementById('dateFin').value = "";
		}
		else {
			document.getElementById('dateDebut').disabled = false;
			document.getElementById('dateFin').disabled = false;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function pressOnTypeEdition() {
	try {

		var typeEdition = document.getElementById("typeEdition").value;

		if (typeEdition=='P') {
			document.getElementById('compteDebut').disabled = false;
			document.getElementById('compteFin').disabled = false;
			document.getElementById('bCompteDebut').disabled = false;
			document.getElementById('bCompteFin').disabled = false;
			document.getElementById('nonSolde').disabled = false;
		}
		else {
			document.getElementById('compteDebut').value = "";
			document.getElementById('compteFin').value = "";
			document.getElementById('compteDebut').disabled = true;
			document.getElementById('compteFin').disabled = true;
			document.getElementById('bCompteDebut').disabled = true;
			document.getElementById('bCompteFin').disabled = true;
			document.getElementById('nonSolde').checked = false;
			document.getElementById('nonSolde').disabled = true;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function rechercherCompte(id) {
	try {

		var typeCompte = document.getElementById('typeCompte').value;
		var numCompte = document.getElementById(id).value;

		var titre = "";

    if (typeCompte=="C") {
    	titre ="CLIENT";
    }
		else if (typeCompte=="F") {
    	titre ="FOURNISSEUR";
    }
		else if (typeCompte=="A") {
    	titre ="AUXILIAIRE";
		}
		else if (typeCompte=="G") {
    	titre ="GENERAL";
    }

		currentChampCompte = id;
    var url = "chrome://opensi/content/compta/user/comptes/popup-rechercheCompte.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherCompte, numCompte, typeCompte, titre, "", "");

	} catch (e) {
		recup_erreur(e);
	}
}


function retourRechercherCompte(numCompte, compteId) {
	try {

		document.getElementById(currentChampCompte).value = numCompte;

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnCompte(ev, id) {
  try {

    if (ev.keyCode==13) {
      rechercherCompte(id);
    }

  } catch (e) {
    recup_erreur(e);
  }
}


function editionPDF() {
	try {

		var dateDebut = document.getElementById('dateDebut').value;
		var dateFin = document.getElementById('dateFin').value;
		var compteDebut = document.getElementById('compteDebut').value;
		var compteFin = document.getElementById('compteFin').value;
		var typeCompte = document.getElementById('typeCompte').value;
		var typeEdition = document.getElementById('typeEdition').value;
		var typePeriode = document.getElementById('typePeriode').value;
		var lettrage = document.getElementById('lettrage').value;
		var nonSolde = document.getElementById('nonSolde').checked;

		if (typePeriode=="D" && !isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte"); }
		else if (typePeriode=="D" && !isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte"); }
		else if (typePeriode=="D" && !isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte"); }
		else if (typeEdition=="P" && !isEmpty(compteDebut) && !isCompteCorrect(compteDebut)) { showWarning("Compte de d\u00E9but incorrect"); }
		else if (typeEdition=="P" && !isEmpty(compteFin) && !isCompteCorrect(compteFin)) { showWarning("Compte de fin incorrect"); }
		else {
			document.getElementById('pmbox').collapsed = false;
			document.getElementById('pm').setAttribute('mode', 'undetermined');

			document.getElementById('pdfGrandLivre').setAttribute("src", "");
			lastFichierPDF = null;

			var qEditionPdf = new QueryHttp("Compta/Editions/pdfGrandLivre.tmpl");

			qEditionPdf.setParam("Type_Compte", typeCompte);
			qEditionPdf.setParam("Date_Debut", dateDebut);
			qEditionPdf.setParam("Date_Fin", dateFin);
			qEditionPdf.setParam("Compte_Debut", compteDebut);
			qEditionPdf.setParam("Compte_Fin", compteFin);
			qEditionPdf.setParam("Lettrage", lettrage);
			qEditionPdf.setParam("Non_Solde", nonSolde);

			qEditionPdf.execute(editionPDF_2);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function editionPDF_2(result) {
	try {

		document.getElementById('pmbox').collapsed = true;
		document.getElementById('pm').setAttribute('mode', 'none');

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichierPDF = result.responseXML.documentElement.getAttribute('FichierPDF');
			var page = getDirPdf() + fichierPDF;
			document.getElementById('pdfGrandLivre').setAttribute("src", page);

			document.getElementById('deck').selectedIndex = 1;
			document.getElementById('bRetourOptions').collapsed = false;

			lastFichierPDF = fichierPDF;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function editionCSV() {
	try {

		var dateDebut = document.getElementById('dateDebut').value;
		var dateFin = document.getElementById('dateFin').value;
		var compteDebut = document.getElementById('compteDebut').value;
		var compteFin = document.getElementById('compteFin').value;
		var typeCompte = document.getElementById('typeCompte').value;
		var typeEdition = document.getElementById('typeEdition').value;
		var typePeriode = document.getElementById('typePeriode').value;
		var lettrage = document.getElementById('lettrage').value;
		var nonSolde = document.getElementById('nonSolde').checked;

		if (typePeriode=="D" && !isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte"); }
		else if (typePeriode=="D" && !isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte"); }
		else if (typePeriode=="D" && !isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte"); }
		else if (typeEdition=="P" && !isEmpty(compteDebut) && !isCompteCorrect(compteDebut)) { showWarning("Compte de d\u00E9but incorrect"); }
		else if (typeEdition=="P" && !isEmpty(compteFin) && !isCompteCorrect(compteFin)) { showWarning("Compte de fin incorrect"); }
		else {
			document.getElementById('pmbox').collapsed = false;
			document.getElementById('pm').setAttribute('mode', 'undetermined');

			var qEditionCsv = new QueryHttp("Compta/Editions/csvGrandLivre.tmpl");

			qEditionCsv.setParam("Type_Compte", typeCompte);
			qEditionCsv.setParam("Date_Debut", dateDebut);
			qEditionCsv.setParam("Date_Fin", dateFin);
			qEditionCsv.setParam("Compte_Debut", compteDebut);
			qEditionCsv.setParam("Compte_Fin", compteFin);
			qEditionCsv.setParam("Lettrage", lettrage);
			qEditionCsv.setParam("Non_Solde", nonSolde);

			qEditionCsv.execute(editionCSV_2);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function editionCSV_2(result) {
	try {

		document.getElementById('pmbox').collapsed = true;
		document.getElementById('pm').setAttribute('mode', 'none');

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

			var file = fileChooser("save", fichier);
			if (file!=null) {
				downloadFile(getDirBuffer() + fichier, file);
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function envoyerMail() {
	try {

		if (lastFichierPDF!=null) {
			var url = "chrome://opensi/content/popup/popup-envoyerMail.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', "CGGL", lastFichierPDF);
		}

	}	catch (e) {
    recup_erreur(e);
  }
}


function retourOptions() {
  try {

		document.getElementById('pdfGrandLivre').setAttribute("src", "");
   	document.getElementById('deck').selectedIndex = 0;
		document.getElementById('bRetourOptions').collapsed = true;

  } catch (e) {
    recup_erreur(e);
  }
}


function retourMenuPrincipal() {
  try {

    window.location = "chrome://opensi/content/compta/user/menu_exercice.xul";

	} catch (e) {
    recup_erreur(e);
  }
}
