/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var lastFichierPDF = null;



function init() {
  try {

		var aJournaux = new Arbre("ComboListe/combo-journaux.tmpl", "journalId");
		aJournaux.initTree();

		document.getElementById('typePeriode').value = "E";

		pressOnTypePeriode();

  } catch (e) {
    recup_erreur(e);
  }
}


function pressOnTypePeriode() {
	try {

		var typePeriode = document.getElementById("typePeriode").value;

		if (typePeriode=='E') {
			document.getElementById('periodeDebut').disabled = true;
			document.getElementById('periodeFin').disabled = true;
			document.getElementById('periodeDebut').value = "";
			document.getElementById('periodeFin').value = "";
		}
		else {
			document.getElementById('periodeDebut').disabled = false;
			document.getElementById('periodeFin').disabled = false;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function editionPDF() {
	try {

		var typePeriode = document.getElementById("typePeriode").value;
		var periodeDebut = document.getElementById('periodeDebut').value;
		var periodeFin = document.getElementById('periodeFin').value;
		var journalId = document.getElementById('journalId').value;

		if (typePeriode=="P" && !isEmpty(periodeDebut) && !isPeriode(periodeDebut)) { showWarning("P\u00E9riode de d\u00E9but incorrecte"); }
		else if (typePeriode=="P" && !isEmpty(periodeFin) && !isPeriode(periodeFin)) { showWarning("P\u00E9riode de fin incorrecte"); }
		else if (typePeriode=="P" && !isEmpty(periodeDebut) && !isEmpty(periodeFin) && !isPeriodeInterval(periodeDebut, periodeFin)) { showWarning("Plage de p\u00E9riodes incorrecte"); }
		else {
			document.getElementById('pmbox').collapsed = false;
			document.getElementById('pm').setAttribute('mode', 'undetermined');

			document.getElementById('pdfJournaux').setAttribute("src", "");
			lastFichierPDF = null;

			var qEditionPdf = new QueryHttp("Compta/Editions/pdfJournaux.tmpl");

			qEditionPdf.setParam("Periode_Debut", periodeDebut);
			qEditionPdf.setParam("Periode_Fin", periodeFin);
			qEditionPdf.setParam("Journal_Id", journalId);

			qEditionPdf.execute(editionPDF_2);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function editionPDF_2(result) {
	try {

		document.getElementById('pmbox').collapsed = true;
		document.getElementById('pm').setAttribute('mode', 'none');

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichierPDF = result.responseXML.documentElement.getAttribute('FichierPDF');
			var page = getDirPdf() + fichierPDF;
			document.getElementById('pdfJournaux').setAttribute("src", page);

			document.getElementById('deck').selectedIndex = 1;
			document.getElementById('bRetourOptions').collapsed = false;

			lastFichierPDF = fichierPDF;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function editionCSV() {
	try {

		var typePeriode = document.getElementById("typePeriode").value;
		var periodeDebut = document.getElementById('periodeDebut').value;
		var periodeFin = document.getElementById('periodeFin').value;
		var journalId = document.getElementById('journalId').value;

		if (typePeriode=="P" && !isEmpty(periodeDebut) && !isPeriode(periodeDebut)) { showWarning("P\u00E9riode de d\u00E9but incorrecte"); }
		else if (typePeriode=="P" && !isEmpty(periodeFin) && !isPeriode(periodeFin)) { showWarning("P\u00E9riode de fin incorrecte"); }
		else if (typePeriode=="P" && !isEmpty(periodeDebut) && !isEmpty(periodeFin) && !isPeriodeInterval(periodeDebut, periodeFin)) { showWarning("Plage de p\u00E9riodes incorrecte"); }
		else {
			document.getElementById('pmbox').collapsed = false;
			document.getElementById('pm').setAttribute('mode', 'undetermined');

			var qEditionCsv = new QueryHttp("Compta/Editions/csvJournaux.tmpl");

			qEditionCsv.setParam("Periode_Debut", periodeDebut);
			qEditionCsv.setParam("Periode_Fin", periodeFin);
			qEditionCsv.setParam("Journal_Id", journalId);

			qEditionCsv.execute(editionCSV_2);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function editionCSV_2(result) {
	try {

		document.getElementById('pmbox').collapsed = true;
		document.getElementById('pm').setAttribute('mode', 'none');

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

			var file = fileChooser("save", fichier);
			if (file!=null) {
				downloadFile(getDirBuffer() + fichier, file);
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function envoyerMail() {
	try {

		if (lastFichierPDF!=null) {
			var url = "chrome://opensi/content/popup/popup-envoyerMail.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', "CGJX", lastFichierPDF);
		}

	}	catch (e) {
    recup_erreur(e);
  }
}


function retourOptions() {
  try {

		document.getElementById('pdfJournaux').setAttribute("src", "");
   	document.getElementById('deck').selectedIndex = 0;
		document.getElementById('bRetourOptions').collapsed = true;

  } catch (e) {
    recup_erreur(e);
  }
}


function retourMenuPrincipal() {
  try {

    window.location = "chrome://opensi/content/compta/user/menu_exercice.xul";

  } catch (e) {
    recup_erreur(e);
  }
}
