/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var aDossiers = new Arbre("Compta/list-dossiers.tmpl", "tDossiers");


function init() {
	try {

		parent.resetProfil();
		parent.resetConfig();
  	parent.document.getElementById("nom_dossier").value = "";
		parent.document.getElementById("boxExercice").collapsed = true;
		parent.document.getElementById("date_exercice").value = "";

		aDossiers.setParam("Like_Dossier", document.getElementById('likeDossier').value);
  	aDossiers.initTree();
		document.getElementById('likeDossier').focus();

	} catch (e) {
    recup_erreur(e);
  }
}


function ok() {
	try {

  	var codeDossier = document.getElementById("likeDossier").value;

		var qLog = new QueryHttp("Compta/logOnDossier.tmpl");
		qLog.setParam("Code_Dossier", codeDossier);
		var result = qLog.execute();

		var logged = (result.responseXML.documentElement.getAttribute("Logged")=="true");
		if (logged) {
			var nom = result.responseXML.documentElement.getAttribute("Nom");
			var dossierId = result.responseXML.documentElement.getAttribute("Dossier_Id");

			var qEnterDossier = new QueryHttp("EnterDossier.tmpl");
			qEnterDossier.setParam('Dossier_Id', dossierId);
			qEnterDossier.execute();

			parent.document.getElementById("nom_dossier").value = codeDossier +" - "+ nom;
     	window.location = "chrome://opensi/content/compta/user/menu_dossier.xul?"+ cookie();
   	}
		else {
			aDossiers.setParam("Like_Dossier", codeDossier);
			aDossiers.initTree();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function reporter() {
	try {

		if (aDossiers.isSelected()) {
 			document.getElementById("likeDossier").value = aDossiers.getSelectedCellText('colCodeDossier');
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function keypress(ev) {
	try {

    switch(ev.keyCode) {
      case 13:
        ok();
      	break;
      case 123:
        document.getElementById('tDossiers').focus();
      	break;
    }

	} catch (e) {
    recup_erreur(e);
  }
}
