/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/formatter.js");


var aLignes = new Arbre('Compta/RapprochementBancaire/list-ligneRapprochement.tmpl', 'lignes');
var qListLR = new QueryHttp("Compta/RapprochementBancaire/getDataListLR.tmpl");

var pageCourante;
var nbPages;

var soldeEcart = 0;
var typeRappro;
var selCompteRB = "";
var selJournalRB = "";
var basePrec = "";
var nfs = new NumberFormat("0.00", true);
var fs = new NumberFormat("0.00", false);
var dateDebutExercice;
var dateFinExercice;



function init() {
  try {

    typeRappro = getConfig().getModeRappro();
		
		var qGet = new QueryHttp("Compta/Exercice/getDatesExercice.tmpl");
		qGet.setParam("Sel_Exercice", "C");
		var result = qGet.execute();

		dateDebutExercice = result.responseXML.documentElement.getAttribute('Debut_Exercice');
		dateFinExercice = result.responseXML.documentElement.getAttribute('Fin_Exercice');

		if (typeRappro=="C") {
			var aComptesRB = new Arbre('Compta/RapprochementBancaire/combo-comptesRB.tmpl', 'compteRB');
			aComptesRB.initTree(initTypeCompte);
			document.getElementById("boxCompte").collapsed = false;
			document.getElementById("colJournal").collapsed = false;
		}
		else {
	  	var aJournauxRB = new Arbre('Compta/RapprochementBancaire/combo-journauxRB.tmpl', 'journalRB');
			aJournauxRB.initTree(initTypeJournal);
			document.getElementById("boxJournal").collapsed = false;
			document.getElementById("colCompte").collapsed = false;
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function initTypeCompte() {
	try {

		document.getElementById("compteRB").selectedIndex = 0;

		if (!isEmpty(selCompteRB)) {
			document.getElementById("compteRB").value = selCompteRB;
			selCompteRB = "";
		}

		if (document.getElementById("compteRB").selectedIndex==-1) {
			initNoRappro();
			listerLignesRappro();
		}
		else {
			loadHistoRappro();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function initTypeJournal() {
	try {

		document.getElementById("journalRB").selectedIndex = 0;

		if (!isEmpty(selJournalRB)) {
			document.getElementById("journalRB").value = selJournalRB;
			selJournalRB = "";
		}

		if (document.getElementById("journalRB").selectedIndex==-1) {
			initNoRappro();
			listerLignesRappro();
		}
		else {
			loadHistoRappro();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function initNoRappro() {
	try {

		document.getElementById("numReleve").disabled = true;
		document.getElementById("dateReleve").disabled = true;
		document.getElementById("soldeReleve").disabled = true;

		document.getElementById("bSaisieRB").collapsed = true;
		document.getElementById("bToutPointer").collapsed = true;
		document.getElementById("bToutDepointer").collapsed = true;
		document.getElementById("bCloture").collapsed = true;
		document.getElementById("bSupprimer").collapsed = true;
		document.getElementById("histoRappro").collapsed = true;
		document.getElementById("compteRB").collapsed = true;
		document.getElementById("journalRB").collapsed = true;
		document.getElementById("boxRecherche").collapsed = true;
		document.getElementById("bRAZ").disabled = true;
		document.getElementById("bEditionPDF").collapsed = true;

		document.getElementById("dateRappro").value = "";
		document.getElementById("soldeInitial").value = "";
		document.getElementById("soldeFinal").value = "";
		document.getElementById("histoRappro").value = "";
		document.getElementById("soldeReleve").value = "";
		document.getElementById("dateReleve").value = "";
		document.getElementById("totalDebit").value = "";
		document.getElementById("totalCredit").value = "";
		document.getElementById("soldeComptable").value = "";
		document.getElementById("numReleve").value = "";
		document.getElementById("ecartDebit").value = "";
		document.getElementById("ecartCredit").value = "";
		document.getElementById("ecartSolde").value = "";

	} catch (e) {
    recup_erreur(e);
  }
}


function loadHistoRappro() {
	try {

		var compteId = "";
		var journalId = "";

		if (typeRappro=="C") {
			compteId = document.getElementById("compteRB").value;
		}
		if (typeRappro=="J") {
			journalId = document.getElementById("journalRB").value;
		}

		if (!isEmpty(compteId) || !isEmpty(journalId)) {
			var aRappros = new Arbre('Compta/RapprochementBancaire/list-rapprochement.tmpl', 'histoRappro');
			aRappros.setParam("Compte_Id", compteId);
			aRappros.setParam("Journal_Id", journalId);
			aRappros.initTree(initHistoRappro);
		}
		else {
			init();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function initHistoRappro() {
	try {

		document.getElementById("histoRappro").selectedIndex = 0;

		if (!isEmpty(document.getElementById("histoRappro").value)) {
			document.getElementById("histoRappro").collapsed = false;
			document.getElementById("compteRB").collapsed = false;
			document.getElementById("journalRB").collapsed = false;
			document.getElementById("boxRecherche").collapsed = false;
			document.getElementById("bRAZ").disabled = false;
			chargerRapprochement();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function chargerRapprochement() {
	try {

		var rapproId = document.getElementById("histoRappro").value;

		var qLoad = new QueryHttp("Compta/RapprochementBancaire/loadRapprochement.tmpl");
		qLoad.setParam("Rappro_Id", rapproId);

		var result = qLoad.execute();
		var contenu = result.responseXML.documentElement;

		var dateRappro = contenu.getAttribute('Date_Rappro');
		var numReleve = contenu.getAttribute('Num_Releve');
		var soldeReleve = contenu.getAttribute('Solde_Releve');
		var dateReleve = contenu.getAttribute('Date_Releve');
		var totalDebit = contenu.getAttribute('Total_Debit');
		var totalCredit = contenu.getAttribute('Total_Credit');
		var soldeComptable = contenu.getAttribute('Solde_Comptable');
		var soldeInitial = contenu.getAttribute('Solde_Initial');
		var cloture = contenu.getAttribute('Cloture')=="true";
		basePrec = contenu.getAttribute('Base_Prec');

		document.getElementById("numReleve").disabled = cloture;
		document.getElementById("dateReleve").disabled = cloture;
		document.getElementById("soldeReleve").disabled = cloture;
		document.getElementById("bSaisieRB").collapsed = cloture;
		document.getElementById("bToutPointer").collapsed = cloture;
		document.getElementById("bToutDepointer").collapsed = cloture;
		document.getElementById("bCloture").collapsed = cloture;
		document.getElementById("bSupprimer").collapsed = !cloture;

		if (isEmpty(dateReleve)) {
			document.getElementById("dateRappro").value = dateRappro;
			document.getElementById("numReleve").value = numReleve;
			document.getElementById("soldeReleve").value = nfs.format(soldeReleve);
			document.getElementById("dateReleve").value = "";
			document.getElementById("totalDebit").value = "";
			document.getElementById("totalCredit").value = "";
			document.getElementById("soldeComptable").value = "";
			document.getElementById("soldeInitial").value = "";
			document.getElementById("soldeFinal").value = "";
			document.getElementById("ecartDebit").value = "";
			document.getElementById("ecartSolde").value = "";
			document.getElementById("ecartCredit").value = "";
			document.getElementById("bEditionPDF").collapsed = true;
			document.getElementById("bCloture").collapsed = true;
			aLignes.deleteTree();
		}
		else {
			var soldeFinal = contenu.getAttribute('Solde_Final');
			soldeEcart = fs.format(parseFloat(soldeFinal)-parseFloat(soldeReleve));
			document.getElementById("dateRappro").value = dateRappro;
			document.getElementById("numReleve").value = numReleve;
			document.getElementById("soldeReleve").value = nfs.format(soldeReleve);
			document.getElementById("dateReleve").value = dateReleve;
			document.getElementById("totalDebit").value = nfs.format(totalDebit);
			document.getElementById("totalCredit").value = nfs.format(totalCredit);
			document.getElementById("soldeComptable").value = nfs.format(soldeComptable);
			document.getElementById("soldeInitial").value = nfs.format(soldeInitial);
			document.getElementById("soldeFinal").value = nfs.format(soldeFinal);
			document.getElementById("bEditionPDF").collapsed = false;
			if (soldeEcart>0) {
				document.getElementById("ecartDebit").value = nfs.format(Math.abs(soldeEcart));
				document.getElementById("ecartSolde").value = nfs.format(soldeEcart);
				document.getElementById("ecartCredit").value = "";
			}
			else {
				document.getElementById("ecartDebit").value = "";
				document.getElementById("ecartSolde").value = nfs.format(soldeEcart);
				document.getElementById("ecartCredit").value = nfs.format(Math.abs(soldeEcart));
			}
			listerLignesRappro();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function razRapprochement() {
	try {

		var compteId = "";
		var journalId = "";
		var dlg;

		if (typeRappro=="C") {
			compteId = document.getElementById("compteRB").value;
			dlg = "ATTENTION : Le rapprochement pour ce compte sera enti\u00E8rement supprim\u00E9 sur tous les exercices !"
		}
		else {
			journalId = document.getElementById("journalRB").value;
			dlg = "ATTENTION : Le rapprochement pour ce journal sera enti\u00E8rement supprim\u00E9 sur tous les exercices !"
		}

		if (window.confirm(dlg)) {
			var qDelete = new QueryHttp("Compta/RapprochementBancaire/razRapprochement.tmpl");
			qDelete.setParam("Compte_Id", compteId);
			qDelete.setParam("Journal_Id", journalId);

			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("Le rapprochement est supprim\u00E9");
				init();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function updatePointage() {
	try {

		if (document.getElementById("histoRappro").label=="En cours") {

			var tree = document.getElementById('lignes');
			var cellule = tree.view.getItemAtIndex(tree.currentIndex).childNodes[0].childNodes[6];
			var valeur = cellule.getAttribute("value");

			var pointe;
			if (valeur=="false") {
				cellule.setAttribute("value", "true");
				cellule.setAttribute("src", "chrome://opensi/content/design/coche.png");
				pointe = 1;
			}
			else {
				cellule.setAttribute("value", "false");
				cellule.setAttribute("src", "");
				pointe = 0;
			}

	 		var pointage = aLignes.getSelectedCellValue('colPointage')=="true";
			var opId = aLignes.getSelectedCellText('colOpId');
			var typeOp = aLignes.getSelectedCellText('colTypeOp');

			//oprations
			if (typeOp==1) {
				var queryEdit = new QueryHttp("Compta/RapprochementBancaire/pointOperation.tmpl");
				queryEdit.setParam("Op_Id", opId);
				queryEdit.setParam("Base_Prec", "");
				queryEdit.setParam("Pointage", pointage);
	    	queryEdit.execute();
			}
			//saisies rb
			else if (typeOp==0) {
				var queryEdit = new QueryHttp("Compta/RapprochementBancaire/pointLigneRB.tmpl");
				queryEdit.setParam("Ligne_RB_Id", opId);
				queryEdit.setParam("Pointage", pointage);
	   		queryEdit.execute();
			}
			//oprations venant de l'exercice prcdent
			else if (typeOp==2) {
				var queryEdit = new QueryHttp("Compta/RapprochementBancaire/pointOperation.tmpl");
				queryEdit.setParam("Op_Id", opId);
				queryEdit.setParam("Base_Prec", basePrec);
				queryEdit.setParam("Pointage", pointage);
	   		queryEdit.execute();
			}

			var credit = fs.format(aLignes.getSelectedCellText("colCredit"));
			var debit = fs.format(aLignes.getSelectedCellText("colDebit"));
			var soldeFinal = fs.format(document.getElementById("soldeFinal").value);

			if (pointe==0) {
				if (credit>0) {
					soldeEcart = fs.format(parseFloat(soldeEcart) + parseFloat(credit));
					soldeFinal = fs.format(parseFloat(soldeFinal) + parseFloat(credit));
				}
				if (debit>0) {
					soldeEcart = fs.format(parseFloat(soldeEcart) - parseFloat(debit));
					soldeFinal = fs.format(parseFloat(soldeFinal) - parseFloat(debit));
				}
				if (soldeEcart>0) {
					document.getElementById("ecartDebit").value = nfs.format(Math.abs(soldeEcart));
					document.getElementById("ecartCredit").value = "";
					document.getElementById("ecartSolde").value = nfs.format(soldeEcart);
				}
				else {
					document.getElementById("ecartDebit").value = "";
					document.getElementById("ecartCredit").value = nfs.format(Math.abs(soldeEcart));
					document.getElementById("ecartSolde").value = nfs.format(soldeEcart);
				}
				document.getElementById("soldeFinal").value = nfs.format(soldeFinal);
			}
			else {
				if (credit>0) {
					soldeEcart = fs.format(parseFloat(soldeEcart) - parseFloat(credit));
					soldeFinal = fs.format(parseFloat(soldeFinal) - parseFloat(credit));
				}
				if (debit>0) {
					soldeEcart = fs.format(parseFloat(soldeEcart) + parseFloat(debit));
					soldeFinal = fs.format(parseFloat(soldeFinal) + parseFloat(debit));
				}
				if (soldeEcart>0) {
					document.getElementById("ecartDebit").value = nfs.format(Math.abs(soldeEcart));
					document.getElementById("ecartCredit").value = "";
					document.getElementById("ecartSolde").value = nfs.format(soldeEcart);
				}
				else {
					document.getElementById("ecartDebit").value = "";
					document.getElementById("ecartCredit").value = nfs.format(Math.abs(parseFloat(soldeEcart)));
					document.getElementById("ecartSolde").value = nfs.format(soldeEcart);
				}
				document.getElementById("soldeFinal").value = nfs.format(soldeFinal);
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function PointageTot(pointage) {
	try {

		var rapproId = document.getElementById("histoRappro").value;

		var qPoint = new QueryHttp("Compta/RapprochementBancaire/pointAllRapprochement.tmpl");
		qPoint.setParam("Rappro_Id", rapproId);
		qPoint.setParam("Pointage", pointage);
  	var result = qPoint.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			showMessage("Le rapprochement est modifi\u00E9");
			chargerRapprochement();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function updateRapprochement() {
	try {

		var rapproId = document.getElementById("histoRappro").value;
		var dateRappro = document.getElementById("dateRappro").value;
		var dateReleve = document.getElementById("dateReleve").value;
		var soldeReleve = fs.format(document.getElementById("soldeReleve").value);
		var numReleve = document.getElementById("numReleve").value;

		if (isEmpty(soldeReleve)) { soldeReleve = 0; }

		if (!isDate(dateRappro)) {
			showWarning("Date de d\u00E9but de rapprochement incorrecte");
		}
		else if (!isDate(dateReleve)) {
			showWarning("Date 'Ecriture jusqu'au' incorrecte");
		}
		else if (isNaN(soldeReleve)) {
 			showWarning("Solde de relev\u00E9 incorrect");
  	}
		else {

			if (!isDateInterval(dateRappro, dateReleve)) {
				showWarning("La date jusqu'au ne peut pas \u00EAtre ant\u00E9rieure \u00E0 la date de d\u00E9but de rapprochement");
				return false;
			}
			if (!isDateInterval(dateDebutExercice, dateReleve)) {
				showWarning("La date de relev\u00E9 ne peut pas \u00EAtre ant\u00E9rieure \u00E0 la date de d\u00E9but de l'exercice");
				return false;
			}
			if (!isDateInterval(dateReleve, dateFinExercice)) {

				if (!window.confirm("Attention la date de relev\u00E9 d\u00E9passe la fin de l'exercice.\nLe rapprochement sera accessible \u00E0 partir de l'exercice suivant.")) {
					return false;
				}

				//on verifie que le l'exercice suivant existe, si oui on change le cookie
				var qChange = new QueryHttp("Compta/RapprochementBancaire/ChgtExercice.tmpl");
				// qChange.setParam("req","chgtexo");
				var result = qChange.execute();
				if (result.responseXML.documentElement.getAttribute('status')=="0") {
					showWarning("La date de relev\u00E9 est post\u00E9rieure \u00E0 la date de fin de l'exercice - l'exercice suivant doit \u00EAtre cr\u00E9\u00E9");
					return false;
				}
			}

			var qUpdate = new QueryHttp("Compta/RapprochementBancaire/updateRapprochement.tmpl");
			qUpdate.setParam("Rappro_Id", rapproId);
			qUpdate.setParam("Date_Rappro", dateRappro);
			qUpdate.setParam("Date_Releve", dateReleve);
			qUpdate.setParam("Solde_Releve", soldeReleve);
			qUpdate.setParam("Num_Releve", numReleve);

			var result = qUpdate.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("Le rapprochement est modifi\u00E9");

				if (!isDateInterval(dateReleve, dateFinExercice)) {

					var qChange = new QueryHttp("Compta/RapprochementBancaire/ChgtExercice.tmpl");
					qChange.setParam("req2", "chgtexo");
					qChange.setParam("req", "exosuivant");

					var result2 = qChange.execute();
					var datesexo = result2.responseXML.documentElement.getAttribute('datesexo');
					parent.document.getElementById("date_exercice").value = "Exercice "+ datesexo;

					if (typeRappro=="C") {
						selCompteRB = document.getElementById("compteRB").value;
					}
					if (typeRappro=="J") {
						selJournalRB = document.getElementById("journalRB").value;
					}
					showMessage("Vous \u00EAtes maintenant sur l'exercice "+ datesexo);
					getProfil().setExerciceId(result2.responseXML.documentElement.getAttribute('Exercice_Id'));
					init();
				}
				else {
					chargerRapprochement();
				}
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function cloturerRapprochement() {
	try {

		if (soldeEcart!=0) {
			showWarning("L'\u00E9cart de rapprochement doit \u00EAtre nul pour cl\u00F4turer le rapprochement");
		}
		else if (window.confirm("Confirmez-vous la cl\u00F4ture du rapprochement en cours ?")) {
			var dateReleve = document.getElementById("dateReleve").value;

			if (!isDate(dateReleve)) {
				showWarning("Date de relev\u00E9 incorrecte");
			}
			else {
				var rapproId = document.getElementById("histoRappro").value;
				var soldeFinal = document.getElementById("soldeFinal").value;

				var qClose = new QueryHttp("Compta/RapprochementBancaire/closeRapprochement.tmpl");
				qClose.setParam("Date_Releve", dateReleve);
				qClose.setParam("Rappro_Id", rapproId);
				qClose.setParam("Solde_Final", fs.format(soldeFinal));

	  		var result = qClose.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					showMessage("Le rapprochement est historis\u00E9");
					loadHistoRappro();
				}
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function supprimerRapprochement() {
	try {

		var rapproId = document.getElementById("histoRappro").value;

		if (!isEmpty(rapproId) && window.confirm("Confirmez-vous la suppression du rapprochement ?")) {
			var qDelete = new QueryHttp("Compta/RapprochementBancaire/deleteRapprochement.tmpl");
			qDelete.setParam("Rappro_Id", rapproId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("l'historique a \u00E9t\u00E9 supprim\u00E9");
				loadHistoRappro();
				document.getElementById("histoRappro").selectedIndex = 0;

				var dateRappro = document.getElementById("dateRappro").value;
				//si on est sur un rappro dont les dates sont sur 2 exercices et que la date de relev est nulle

				if (!isDateInterval(dateDebutExercice, dateRappro) && document.getElementById("histoRappro").selectedIndex==-1) {
					var qChange = new QueryHttp("Compta/RapprochementBancaire/ChgtExercice.tmpl");
					qChange.setParam("req2", "chgtexo");
					qChange.setParam("req", "exoprecedent");

					var result2 = qChange.execute();
					var datesexo = result2.responseXML.documentElement.getAttribute('datesexo');
					parent.document.getElementById("date_exercice").value = "Exercice "+ datesexo;

					if (typeRappro=="C") {
						selCompteRB = document.getElementById("compteRB").value;
					}
					if (typeRappro=="J") {
						selJournalRB = document.getElementById("journalRB").value;
					}
					showMessage("Vous \u00EAtes maintenant sur l'exercice "+ datesexo);
					getProfil().setExerciceId(result2.responseXML.documentElement.getAttribute('Exercice_Id'));
					init();
				}
				else {
					loadHistoRappro();
				}
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function nouveauRapprochement() {
  try {

		var url = "chrome://opensi/content/compta/user/rapprochement_bancaire/popup-nouveauRapprochement.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', retourNouveauRapprochement);

  } catch (e) {
    recup_erreur(e);
  }
}


function retourNouveauRapprochement(compteRB, journalRB) {
  try {

		selCompteRB = compteRB;
		selJournalRB = journalRB;

		init();

	} catch (e) {
    recup_erreur(e);
  }
}


function rechercherEcriture() {
  try {

    var url = "chrome://opensi/content/compta/user/saisie/popup-rechercheEcriture.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherEcriture);

  } catch (e) {
    recup_erreur(e);
  }
}


function retourRechercherEcriture(opId) {
  try {
	
		window.location = "chrome://opensi/content/compta/user/saisie/menuSaisie.xul?Op_Id="+ opId;

	} catch (e) {
    recup_erreur(e);
  }
}


function saisirEcritureRapprochement() {
  try {

    var rapproId = document.getElementById("histoRappro").value;
    var dateRappro = document.getElementById("dateRappro").value;
    var dateReleve = document.getElementById("dateReleve").value;

    if (isEmpty(dateReleve)) {
    	showMessage("La date 'Ecritures jusqu'au' doit \u00EAtre renseign\u00E9e");
    }
		else {
			var url = "chrome://opensi/content/compta/user/rapprochement_bancaire/popup-saisieEcritureRapprochement.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', chargerRapprochement, rapproId, dateRappro, dateReleve);
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function initCriteres() {
	try {

		document.getElementById('filtreDebit').value = "";
		document.getElementById('filtreCredit').value = "";
		document.getElementById("filtrePointage").value = false;

		listerLignesRappro();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnCritere(ev) {
	try {

		if (ev.keyCode==13) {
			listerLignesRappro();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function listerLignesRappro() {
	try {

		var rapproId = document.getElementById("histoRappro").value;
		var pointage = document.getElementById("filtrePointage").value;
		var montantD = document.getElementById('filtreDebit').value;
		var montantC = document.getElementById('filtreCredit').value;
		var nbLignesParPage = document.getElementById('nbLignesParPage').value;

		if (!isEmpty(montantD) && !isPositive(montantD)) { showWarning("Montant de recherche au d\u00E9bit incorrect"); }
		else if (!isEmpty(montantC) && !isPositive(montantC)) { showWarning("Montant de recherche au cr\u00E9it incorrect"); }
		else {

			pageCourante = 1;
			nbPages = 1;
			document.getElementById('pageDeb').value = 1;
			document.getElementById('pageFin').value = 1;
			document.getElementById('bPrec').disabled = true;
			document.getElementById('bSuiv').disabled = true;
			document.getElementById('bFirst').disabled = true;
			document.getElementById('bLast').disabled = true;
			document.getElementById('pageDeb').disabled = true;

			document.getElementById('lignes').disabled = true;
			aLignes.deleteTree();

			if (!isEmpty(rapproId)) {
				qListLR.setParam("Rappro_Id", rapproId);
				qListLR.setParam("Base_Prec", basePrec);
				qListLR.setParam("Pointage", pointage);
				qListLR.setParam("Montant_D", montantD);
				qListLR.setParam("Montant_C", montantC)
				qListLR.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
				qListLR.setParam("Current_Page", pageCourante);

				var result = qListLR.execute();

				var contenu = result.responseXML.documentElement;

				nbPages = contenu.getAttribute("Nb_Pages");
				var listOpId = contenu.getAttribute("List_Op_Id");
				var listLigneRBId = contenu.getAttribute("List_Ligne_RB_Id");
				var listPrecId = contenu.getAttribute("List_Prec_Id");

				aLignes.setParam("Rappro_Id", rapproId);
				aLignes.setParam("Base_Prec", basePrec);
				aLignes.setParam("List_Op_Id", listOpId);
				aLignes.setParam("List_Ligne_RB_Id", listLigneRBId);
				aLignes.setParam("List_Prec_Id", listPrecId);
				aLignes.initTree(initPagination);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function initPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('pageFin').value = (nbPages>0?nbPages:1);
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante>=nbPages); // peut se produire si nbPages=0
		document.getElementById('bFirst').disabled = (pageCourante==1);
		document.getElementById('bLast').disabled = (pageCourante>=nbPages);

		afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPagePrec() {
	try {

		pageCourante--;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPageSuiv() {
	try {

		pageCourante++;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPageDeb(ev) {
  try {

		if (ev.keyCode==13) {
			var pageDeb = document.getElementById("pageDeb").value;

			if (!isPositiveInteger(pageDeb) || parseIntBis(pageDeb)>nbPages) {
				showWarning("Num\u00E9ro de page incorrect");
			}
			else {
				pageCourante = pageDeb;
				majPagination();
			}
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function pressOnFirstPage() {
	try {

		pageCourante = 1;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnLastPage() {
	try {

		pageCourante = nbPages;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function majPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante==nbPages);
		document.getElementById('bFirst').disabled = (pageCourante==1);
		document.getElementById('bLast').disabled = (pageCourante==nbPages);
		document.getElementById('pageDeb').disabled = true;

		document.getElementById('lignes').disabled = true;

		qListLR.setParam("Current_Page", pageCourante);
		var result = qListLR.execute();
		var listOpId = result.responseXML.documentElement.getAttribute("List_Op_Id");
		var listLigneRBId = result.responseXML.documentElement.getAttribute("List_Ligne_RB_Id");
		var listPrecId = result.responseXML.documentElement.getAttribute("List_Prec_Id");

		aLignes.setParam("List_Op_Id", listOpId);
		aLignes.setParam("List_Ligne_RB_Id", listLigneRBId);
		aLignes.setParam("List_Prec_Id", listPrecId);
		aLignes.initTree(afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function afterMajPagination() {
	try {

		document.getElementById('lignes').disabled = false;
		document.getElementById('pageDeb').disabled = (nbPages<=1);

	} catch (e) {
		recup_erreur(e);
	}
}


function pdfRapprochement() {
  try {

		var rapproId = document.getElementById("histoRappro").value;

		document.getElementById('pdf').setAttribute("src", "");
		document.getElementById('deckRapprochement').selectedIndex = 1;
		document.getElementById('bRetourRB').collapsed = false;

		var qGenPdf = new QueryHttp("Compta/RapprochementBancaire/pdfRapprochement.tmpl");
		qGenPdf.setParam('Rappro_Id', rapproId);

		var result = qGenPdf.execute();
		var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
		document.getElementById('pdf').setAttribute("src", page);

	} catch (e) {
    recup_erreur(e);
  }
}


function retourRapprochement() {
  try {

		document.getElementById('pdf').setAttribute("src", "");
		document.getElementById('deckRapprochement').selectedIndex = 0;
		document.getElementById('bRetourRB').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function retourMenuPrincipal() {
  try {

    window.location = "chrome://opensi/content/compta/user/menu_exercice.xul";

	} catch (e) {
    recup_erreur(e);
  }
}
