/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var ocj_codeJournalAchatInit;
var ocj_codeJournalVenteInit;
var ocj_codeJournalAcpteVenteInit;
var ocj_codeJournalRegulInit;
var ocj_codeJournalANouveauInit;
var ocj_codeJournalAcpteAchatInit;
var ocj_currentChampCompte;
var ocj_modified = false;



function ocj_init() {
	try {

		var config = getResetConfig();

		document.getElementById('rowPrimeCEE').collapsed = !config.isGDVPrimeCEE();

		var qLoad = new QueryHttp("Config/cg/getComptesJournaux.tmpl");
		var result = qLoad.execute();
		var contenu = result.responseXML.documentElement;

		document.getElementById('ocj-Compte_Clients').value = contenu.getAttribute('Compte_Clients');
		document.getElementById('ocj-Compte_Fournisseurs').value = contenu.getAttribute('Compte_Fournisseurs');
		document.getElementById('ocj-Compte_Escompte_VE').value = contenu.getAttribute('Compte_Escompte_VE');
		document.getElementById('ocj-Compte_Acompte_VE').value = contenu.getAttribute('Compte_Acompte_VE');
		document.getElementById('ocj-Compte_Prime_CEE').value = contenu.getAttribute('Compte_Prime_CEE');
		document.getElementById('ocj-Compte_Escompte_AC').value = contenu.getAttribute('Compte_Escompte_AC');
		document.getElementById('ocj-Compte_Regul_VE').value = contenu.getAttribute('Compte_Regul_VE');
		document.getElementById('ocj-Compte_Regul_AC').value = contenu.getAttribute('Compte_Regul_AC');
		document.getElementById('ocj-Compte_Especes').value = contenu.getAttribute('Compte_Especes');
		document.getElementById('ocj-Compte_TVA_Due_IC').value = contenu.getAttribute('Compte_TVA_Due_IC');
		document.getElementById('ocj-Compte_TVA_Ded_IC').value = contenu.getAttribute('Compte_TVA_Ded_IC');
		document.getElementById('ocj-Compte_Acompte_AC').value = contenu.getAttribute('Compte_Acompte_AC');

		ocj_codeJournalAchatInit = contenu.getAttribute('Journal_Achat');
		ocj_codeJournalVenteInit = contenu.getAttribute('Journal_Vente');
		ocj_codeJournalRegulInit = contenu.getAttribute('Journal_Regul');
		ocj_codeJournalANouveauInit = contenu.getAttribute('Journal_AN');
		ocj_codeJournalAcpteVenteInit = contenu.getAttribute('Journal_Acompte_VE');
		ocj_codeJournalAcpteAchatInit = contenu.getAttribute('Journal_Acompte_AC');

		ocj_chargerJournauxAchat();
		ocj_chargerJournauxVente();
		ocj_chargerJournauxRegul();
		ocj_chargerJournauxANouveau();
		ocj_chargerJournauxAcpteVente();
		ocj_chargerJournauxAcpteAchat();

	} catch (e) {
    recup_erreur(e);
  }
}


function ocj_demandeEnregistrement() {
	try {

		if (ocj_modified && window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es ?")) {
			ocj_modifierParametres();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ocj_chargerJournauxAchat() {
	try {

		var aJournaux = new Arbre('ComboListe/combo-journaux.tmpl', 'ocj-Journal_Achat');
		aJournaux.setParam('Type_Journal', 'AC');
		aJournaux.setParam('Selection', ocj_codeJournalAchatInit);
		aJournaux.initTree(ocj_initJournalAchat);

	} catch (e) {
		recup_erreur(e);
	}
}


function ocj_initJournalAchat() {
  try {

		document.getElementById('ocj-Journal_Achat').value = ocj_codeJournalAchatInit;

	} catch (e) {
  	recup_erreur(e);
	}
}


function ocj_chargerJournauxVente() {
	try {

		var aJournaux = new Arbre('ComboListe/combo-journaux.tmpl', 'ocj-Journal_Vente');
		aJournaux.setParam('Type_Journal', 'VE');
		aJournaux.setParam('Selection', ocj_codeJournalVenteInit);
		aJournaux.initTree(ocj_initJournalVente);

	} catch (e) {
		recup_erreur(e);
	}
}


function ocj_initJournalVente() {
  try {

		document.getElementById('ocj-Journal_Vente').value = ocj_codeJournalVenteInit;

	} catch (e) {
  	recup_erreur(e);
	}
}


function ocj_chargerJournauxRegul() {
	try {

		var aJournaux = new Arbre('ComboListe/combo-journaux.tmpl', 'ocj-Journal_Regul');
		aJournaux.setParam('Type_Journal', 'OD');
		aJournaux.setParam('Selection', ocj_codeJournalRegulInit);
		aJournaux.initTree(ocj_initJournalRegul);

	} catch (e) {
		recup_erreur(e);
	}
}


function ocj_initJournalRegul() {
  try {

		document.getElementById('ocj-Journal_Regul').value = ocj_codeJournalRegulInit;

	} catch (e) {
  	recup_erreur(e);
	}
}


function ocj_chargerJournauxANouveau() {
	try {

		var aJournaux = new Arbre('ComboListe/combo-journaux.tmpl', 'ocj-Journal_AN');
		aJournaux.setParam('Type_Journal', 'AN');
		aJournaux.setParam('Selection', ocj_codeJournalANouveauInit);
		aJournaux.initTree(ocj_initJournalANouveau);

	} catch (e) {
		recup_erreur(e);
	}
}


function ocj_initJournalANouveau() {
  try {

		document.getElementById('ocj-Journal_AN').value = ocj_codeJournalANouveauInit;

	} catch (e) {
  	recup_erreur(e);
	}
}


function ocj_chargerJournauxAcpteVente() {
	try {

		var aJournaux = new Arbre('ComboListe/combo-journaux.tmpl', 'ocj-Journal_Acompte_VE');
		aJournaux.setParam('Type_Journal', 'OD');
		aJournaux.setParam('Selection', ocj_codeJournalAcpteVenteInit);
		aJournaux.initTree(ocj_initJournalAcpteVente);

	} catch (e) {
		recup_erreur(e);
	}
}


function ocj_initJournalAcpteVente() {
  try {

		document.getElementById('ocj-Journal_Acompte_VE').value = ocj_codeJournalAcpteVenteInit;

	} catch (e) {
  	recup_erreur(e);
	}
}


function ocj_chargerJournauxAcpteAchat() {
	try {

		var aJournaux = new Arbre('ComboListe/combo-journaux.tmpl', 'ocj-Journal_Acompte_AC');
		aJournaux.setParam('Type_Journal', 'OD');
		aJournaux.setParam('Selection', ocj_codeJournalAcpteAchatInit);
		aJournaux.initTree(ocj_initJournalAcpteAchat);

	} catch (e) {
		recup_erreur(e);
	}
}


function ocj_initJournalAcpteAchat() {
  try {

		document.getElementById('ocj-Journal_Acompte_AC').value = ocj_codeJournalAcpteAchatInit;

	} catch (e) {
  	recup_erreur(e);
	}
}


function ocj_Changer(id) {
	try {

		var debCompte = "";
		var typeCompte = "G";
		var titre = "";

		if (id=="ocj-Compte_Clients") {
			typeCompte = "C";
			titre = "CLIENT";
		}
		else if (id=="ocj-Compte_Fournisseurs") {
			typeCompte = "F";
			titre = "FOURNISSEUR";
		}
		else if (id=="ocj-Compte_Escompte_VE") {
			debCompte = "665";
			titre = "ESCOMPTE SUR VENTE";
		}
		else if (id=="ocj-Compte_Acompte_VE") {
			debCompte = "4191";
			titre = "ACOMPTE SUR VENTE";
		}
		else if (id=="ocj-Compte_Prime_CEE") {
			debCompte = "467";
			titre = "D'ENREGISTREMENT DE LA PRIME CEE";
		}
		else if (id=="ocj-Compte_Escompte_AC") {
			debCompte = "765";
			titre = "ESCOMPTE SUR ACHAT";
		}
		else if (id=="ocj-Compte_Regul_VE") {
			debCompte = "658";
			titre = "CHARGES EXCEPTIONNELLES";
		}
		else if (id=="ocj-Compte_Regul_AC") {
			debCompte = "758";
			titre = "PRODUITS EXCEPTIONNELS";
		}
		else if (id=="ocj-Compte_Especes") {
			debCompte = "5";
			titre = "REMISE D'ESPECES";
		}
		else if (id=="ocj-Compte_TVA_Due_IC") {
			debCompte = "445";
			titre = "TVA DUE INTRACOMMUNAUTAIRE";
		}
		else if (id=="ocj-Compte_TVA_Ded_IC") {
			debCompte = "445";
			titre = "TVA DEDUCTIBLE UE";
		}
		else if (id=="ocj-Compte_Acompte_AC") {
			debCompte = "4091";
			titre = "ACOMPTE SUR ACHAT";
		}

		ocj_currentChampCompte = id;
    var url = "chrome://opensi/content/compta/user/comptes/popup-rechercheCompte.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', ocj_retourChangerCompte, debCompte, typeCompte, titre, debCompte, false);

	} catch (e) {
    recup_erreur(e);
  }
}


function ocj_retourChangerCompte(numCompte, compteId) {
	try {

		document.getElementById(ocj_currentChampCompte).value = numCompte;
		ocj_setModified(true);

	} catch (e) {
		recup_erreur(e);
	}
}


function ocj_modifierParametres() {
	try {

		var code_journal_achat = document.getElementById('ocj-Journal_Achat').value;
		var code_journal_vente = document.getElementById('ocj-Journal_Vente').value;
		var code_journal_acpte = document.getElementById('ocj-Journal_Acompte_VE').value;
		var code_journal_regul = document.getElementById('ocj-Journal_Regul').value;
		var code_journal_anouveau = document.getElementById('ocj-Journal_AN').value;
		var codeJournalAcompteAchat = document.getElementById('ocj-Journal_Acompte_AC').value;
		var numero_compte_clients = document.getElementById('ocj-Compte_Clients').value;
		var numero_compte_fournisseurs = document.getElementById('ocj-Compte_Fournisseurs').value;
		var numero_compte_escompte_ve = document.getElementById('ocj-Compte_Escompte_VE').value;
		var numero_compte_acompte_ve = document.getElementById('ocj-Compte_Acompte_VE').value;
		var numeroComptePrimeCEE = document.getElementById('ocj-Compte_Prime_CEE').value;
		var numero_compte_escompte_ac = document.getElementById('ocj-Compte_Escompte_AC').value;
		var numero_compte_regul_ve = document.getElementById('ocj-Compte_Regul_VE').value;
		var numero_compte_regul_ac = document.getElementById('ocj-Compte_Regul_AC').value;
		var numero_compte_especes = document.getElementById('ocj-Compte_Especes').value;
		var numero_compte_tva_due_ic = document.getElementById('ocj-Compte_TVA_Due_IC').value;
		var numero_compte_tva_ded_ic = document.getElementById('ocj-Compte_TVA_Ded_IC').value;
		var numeroCompteAcompteAC = document.getElementById('ocj-Compte_Acompte_AC').value;

		if (isEmpty(code_journal_achat) || isEmpty(code_journal_vente) || isEmpty(code_journal_anouveau)
				|| isEmpty(numero_compte_clients) || isEmpty(numero_compte_fournisseurs)
				|| isEmpty(numero_compte_escompte_ve) || isEmpty(numero_compte_acompte_ve) || isEmpty(numero_compte_escompte_ac)
				|| isEmpty(numero_compte_regul_ve) || isEmpty(numero_compte_regul_ac)
				|| isEmpty(numero_compte_tva_due_ic) || isEmpty(numero_compte_tva_ded_ic)
				|| isEmpty(numeroCompteAcompteAC)) {
			showWarning("Les champs marqu\u00E9s d'une \u00E9toile sont obligatoires !");
		}
		else {

			var qUpdate = new QueryHttp("Config/cg/updateComptesJournaux.tmpl");
			qUpdate.setParam("Journal_Achat", code_journal_achat);
			qUpdate.setParam("Journal_Vente", code_journal_vente);
			qUpdate.setParam("Journal_Acompte_VE", code_journal_acpte);
			qUpdate.setParam("Journal_Regul", code_journal_regul);
			qUpdate.setParam("Journal_AN", code_journal_anouveau);
			qUpdate.setParam("Journal_Acompte_AC", codeJournalAcompteAchat);
			qUpdate.setParam("Compte_Clients", numero_compte_clients);
			qUpdate.setParam("Compte_Fournisseurs", numero_compte_fournisseurs);
			qUpdate.setParam("Compte_Escompte_VE", numero_compte_escompte_ve);
			qUpdate.setParam("Compte_Acompte_VE", numero_compte_acompte_ve);
			qUpdate.setParam("Compte_Prime_CEE", numeroComptePrimeCEE);
			qUpdate.setParam("Compte_Escompte_AC", numero_compte_escompte_ac);
			qUpdate.setParam("Compte_Regul_VE", numero_compte_regul_ve);
			qUpdate.setParam("Compte_Regul_AC", numero_compte_regul_ac);
			qUpdate.setParam("Compte_Especes", numero_compte_especes);
			qUpdate.setParam("Compte_TVA_Due_IC", numero_compte_tva_due_ic);
			qUpdate.setParam("Compte_TVA_Ded_IC", numero_compte_tva_ded_ic);
			qUpdate.setParam("Compte_Acompte_AC", numeroCompteAcompteAC);
			var result = qUpdate.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				ocj_setModified(false);
				showMessage("Les comptes et journaux par d\u00E9faut ont \u00E9t\u00E9 enregistr\u00E9s avec succ\u00E8s !");
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ocj_setModified(modified) {
	try {

		ocj_modified = modified;
		document.getElementById('ocj-imgModified').collapsed = !modified;

	} catch (e) {
		recup_erreur(e);
	}
}

