/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


jsLoader.loadSubScript("chrome://opensi/content/libs/banques.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arrondi.js");


var aMenu = new Arbre('', 'menu');
var adminMode = false;


function init() {
	try {

		document.getElementById('deck').selectedIndex = 0;
		window.parent.addEventListener("close", demandeEnregistrement, false);

		var queryPC = new QueryHttp("Config/getParamConfig.tmpl");
		var result = queryPC.execute();

		adminMode = result.responseXML.documentElement.getAttribute("Admin_Mode")=="true";

		//document.getElementById('itemDocumentsLegaux').setAttribute("hidden", !getProfil().isDirection());
		document.getElementById('itemDocumentsLegaux').setAttribute("hidden", true);

		document.getElementById('itemServeursFTP').setAttribute("hidden", !adminMode);

		document.getElementById('itemMEF').setAttribute("hidden", !getConfig().isSpecLHCFF());

		document.getElementById('itemCA').setAttribute("hidden", !getConfig().isSpecNSCBP());

	} catch (e) {
    recup_erreur(e);
  }
}


function desinit() {
	try {

		window.parent.removeEventListener("close", demandeEnregistrement, false);

	} catch (e) {
    recup_erreur(e);
  }
}


function ouvrirMenu() {
	try {

		demandeEnregistrement();
		if (!document.getElementById('menu').view.isContainer(aMenu.getCurrentIndex())) {
			var panel = aMenu.getSelectedCellValue('colMenu');
			loadPanel(panel);
			document.getElementById('deck').selectedPanel = document.getElementById(panel);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function loadPanel(panel) {
	try {

		switch(panel) {
			case "dossier":										od_init();		break;
			case "etablissements":						oe_init();		break;
			case "depotsStock":								ods_init();		break;
			case "TVA":												otva_init();	break;
			case "banques":										ob_init();		break;
			case "modesReglement":						omr_init();		break;
			case "modelesEmail":							omem_init();	break;
			case "modelesCommentaire":				omc_init();		break;
			case "serveursFTP":								osf_init();		break;
			case "bornesImpression":					obi_init();		break;
			case "preferencesGC":							opgc_init();	break;
			case "modalitesReglement":				omdr_init();	break;
			case "motifsRemboursement":				orbt_init();	break;
			case "motifsAnnulationReglement":	omar_init();	break;
			case "mentionsDocument":					omd_init();		break;
			case "polesActivite":							opa_init();		break;
			case "mouvementsManuels":					omm_init();		break;
			case "formatsNumerotation":				ofn_init();		break;
			case "famillesClient":						ofc_init();		break;
			case "famillesFournisseur":				off_init();		break;
			case "marquesArticle":						om_init();		break;
			case "famillesArticle":						ofa_init();		break;
			case "attributsArticle":					oa_init();		break;
			case "conditionnementsArticle":		oca_init();		break;
			case "champsPersonnalises":				ocp_init();		break;
			case "preferencesVente":					opvt_init();	break;
			case "tarifsArticle":							ota_init();		break;
			case "emailsAuto":								oea_init();		break;
			case "affectationsAutoHL":				oahl_init();	break;
			case "typesSuivi":								ots_init();		break;
			case "preferencesExpedition":			opex_init();	break;
			case "configurationsLot":					ocl_init();		break;
			case "modesExpedition":						ome_init();		break;
			case "cartons":										oc_init();		break;
			case "preferencesAchat":					opac_init();	break;
			case "motifsEcartFacturation":		omef_init();	break;
			case "sitesWeb":									osw_init();		break;
			case "marketplaces":							omp_init();		break;
			case "affectationsAutoEC":				oaec_init();	break;
			case "preferencesCG":							opcg_init();	break;
			case "comptesJournaux":						ocj_init();		break;
			case "datesExercice":							ode_init();		break;
			case "criteresTri":								oct_init();		break;
			case "typesCompte":								otc_init();		break;
			case "actions":										oate_init();	break;
			case "preferencesTB":							optb_init();	break;
			case "attestationsLogiciel":			oal_init();		break;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function demandeEnregistrement() {
	try {

		var panel = document.getElementById('deck').selectedPanel.getAttribute("id");

		switch(panel) {
			case "dossier":									od_demandeEnregistrement();			break;
			case "preferencesGC":						opgc_demandeEnregistrement();		break;
			case "preferencesVente":				opvt_demandeEnregistrement();		break;
			case "preferencesExpedition":		opex_demandeEnregistrement();		break;
			case "preferencesAchat":				opac_demandeEnregistrement();		break;
			case "preferencesCG":						opcg_demandeEnregistrement();		break;
			case "comptesJournaux":					ocj_demandeEnregistrement();		break;
			case "preferencesTB":						optb_demandeEnregistrement();		break;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuDossier() {
	try {

		demandeEnregistrement();
  	window.location = "chrome://opensi/content/config/menu.xul?"+ cookie();

	} catch (e) {
    recup_erreur(e);
  }
}



// Fonction caches super administrateur


function pressOnConfiguration(ev) {
	try {

		if (adminMode && ev.ctrlKey && ev.altKey && ev.key=='s') {
			document.getElementById('hidConf').collapsed = false;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function reloadConfiguration() {
	try {

		var qReload = new QueryHttp("Config/reloadConfiguration.tmpl");
		var result = qReload.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			showMessage("Configuration recharg\u00E9e");
		}

	} catch (e) {
    recup_erreur(e);
  }
}
