/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var omp_currentMarketId = "";
var omp_selModeRegId;
var omp_aMarketplaces = new Arbre("Config/gc/ecommerce/list-marketplace.tmpl", "omp-liste_marketplaces");
var omp_aModesReglement = new Arbre("ComboListe/combo-modesReglement.tmpl", "omp-modeRegId");



function omp_init() {
	try {

		omp_listerMarketplaces();

	} catch (e) {
    recup_erreur(e);
  }
}


function omp_chargerModeReglement(selection) {
	try {

		omp_selModeRegId = selection;
		omp_aModesReglement.setParam("Selection", selection);
		omp_aModesReglement.initTree(omp_initModeReglement);

	} catch (e) {
		recup_erreur(e);
	}
}


function omp_initModeReglement() {
	try {

		document.getElementById('omp-modeRegId').value = omp_selModeRegId;

	} catch (e) {
		recup_erreur(e);
	}
}


function omp_listerMarketplaces() {
	try {

		omp_aMarketplaces.initTree();
		omp_nouveauMarketplace();

	} catch (e) {
		recup_erreur(e);
	}
}


function omp_nouveauMarketplace() {
	try {

		omp_currentMarketId = "";
		omp_aMarketplaces.clearSelection();

		document.getElementById('omp-intitule').value = "";
		document.getElementById('omp-modeRegId').value = "";
		document.getElementById('omp-compteClient').value = "";
		omp_chargerModeReglement("");

		document.getElementById('omp-bSupprimer').collapsed = true;
		document.getElementById('omp-bNouveau').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function omp_chargerMarketplace() {
	try {

		if (omp_aMarketplaces.isSelected()) {
			omp_currentMarketId = omp_aMarketplaces.getSelectedCellText("omp-colMarketId");

			var qLoad = new QueryHttp("Config/gc/ecommerce/loadMarketplace.tmpl");
			qLoad.setParam("Market_Id", omp_currentMarketId);
			var result = qLoad.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				document.getElementById('omp-intitule').value = contenu.getAttribute('Intitule');
				document.getElementById('omp-compteClient').value = contenu.getAttribute('Compte_Client');
				omp_chargerModeReglement(contenu.getAttribute('Mode_Reg_Id'));

				document.getElementById('omp-bSupprimer').collapsed = false;
				document.getElementById('omp-bNouveau').collapsed = false;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omp_enregistrerMarketplace() {
	try {

		var intitule = document.getElementById('omp-intitule').value;
		var modeRegId = document.getElementById('omp-modeRegId').value;
		var compteClient = document.getElementById('omp-compteClient').value;

		if (isEmpty(intitule)) {
			showWarning("Intitul\u00E9 manquant");
		}
		else {
			var qSave;

			if (!isEmpty(omp_currentMarketId)) {
				qSave = new QueryHttp("Config/gc/ecommerce/updateMarketplace.tmpl");
				qSave.setParam("Market_Id", omp_currentMarketId);
			}
			else {
				qSave = new QueryHttp("Config/gc/ecommerce/createMarketplace.tmpl");
			}

			qSave.setParam("Intitule", intitule);
			qSave.setParam("Mode_Reg_Id", modeRegId);
			qSave.setParam("Compte_Client", compteClient);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				omp_listerMarketplaces();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function omp_supprimerMarketplace() {
	try {

		if (!isEmpty(omp_currentMarketId) && window.confirm("Confirmez-vous la suppression de la marketplace s\u00E9lectionn\u00E9e ?")) {

			var qDelete = new QueryHttp("Config/gc/ecommerce/deleteMarketplace.tmpl");
			qDelete.setParam("Market_Id", omp_currentMarketId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				omp_listerMarketplaces();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function omp_rechercherCompte() {
	try {

    var url = "chrome://opensi/content/compta/user/comptes/popup-rechercheCompte.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', omp_retourRechercherCompte, "", "C", "CLIENT", "", false);

	} catch (e) {
		recup_erreur(e);
	}
}


function omp_retourRechercherCompte(numCompte, compteId) {
	try {

		document.getElementById("omp-compteClient").value = numCompte;

	} catch (e) {
		recup_erreur(e);
	}
}


function omp_enleverCompteClient() {
	try {

		document.getElementById("omp-compteClient").value = "";

	} catch (e) {
		recup_erreur(e);
	}
}
