/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oc_aCarton = new Arbre("Config/gc/expeditions/list-carton.tmpl", "oc-tree-cartons");
var oc_currentCartonId = "";



function oc_init() {
	try {

		oc_filtrerCarton();
		oc_nouveauCarton();

	} catch (e) {
    recup_erreur(e);
	}
}


function oc_filtrerCarton() {
	try {

		oc_aCarton.setParam("Actif", document.getElementById("oc-filtreActif").checked);
		oc_aCarton.initTree();

	} catch (e) {
    recup_erreur(e);
  }
}


function oc_chargerCarton() {
	try {

		if (oc_aCarton.isSelected()) {
			oc_currentCartonId = oc_aCarton.getSelectedCellText('oc-colCartonId');

			var qLoad = new QueryHttp("Config/gc/expeditions/loadCarton.tmpl");
			qLoad.setParam("Carton_Id", oc_currentCartonId);
			var result = qLoad.execute();

			document.getElementById("oc-intitule").value = result.responseXML.documentElement.getAttribute("Intitule");
			document.getElementById("oc-actif").checked = result.responseXML.documentElement.getAttribute("Actif")=="true";
			document.getElementById("oc-reference").value = result.responseXML.documentElement.getAttribute("Reference");
			document.getElementById("oc-hauteur").value = result.responseXML.documentElement.getAttribute("Hauteur");
			document.getElementById("oc-longueur").value = result.responseXML.documentElement.getAttribute("Longueur");
			document.getElementById("oc-largeur").value = result.responseXML.documentElement.getAttribute("Largeur");
			document.getElementById("oc-marge").value = result.responseXML.documentElement.getAttribute("Marge");
			document.getElementById("oc-volume").value = result.responseXML.documentElement.getAttribute("Volume_Total");
			document.getElementById("oc-volume_utile").value = result.responseXML.documentElement.getAttribute("Volume_Utile");

			document.getElementById("oc-bSupprimerCarton").disabled = false;
		}

	} catch (e) {
    recup_erreur(e);
	}
}


function oc_nouveauCarton() {
	try {

		oc_currentCartonId = "";
		document.getElementById("oc-intitule").value = "";
		document.getElementById("oc-reference").value = "";
		document.getElementById("oc-hauteur").value = "";
		document.getElementById("oc-volume").value = 0;
		document.getElementById("oc-actif").checked = true;
		document.getElementById("oc-longueur").value = "";
		document.getElementById("oc-marge").value = 0;
		document.getElementById("oc-largeur").value = "";
		document.getElementById("oc-volume_utile").value = 0;
		document.getElementById("oc-bSupprimerCarton").disabled = true;

	} catch (e) {
    recup_erreur(e);
	}
}


function oc_supprimerCarton() {
	try {

		if (oc_aCarton.isSelected()) {
			oc_currentCartonId = oc_aCarton.getSelectedCellText('oc-colCartonId');
			if (oc_currentCartonId!="") {
				var qDeleteCarton=new QueryHttp("Config/gc/expeditions/deleteCarton.tmpl");
				qDeleteCarton.setParam("Carton_Id", oc_currentCartonId);
				var result = qDeleteCarton.execute();
				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					oc_aCarton.initTree();
					oc_nouveauCarton();
				}
			}
		}

	} catch (e) {
    recup_erreur(e);
	}
}


function oc_enregistrerCarton() {
	try {

		var hauteur = document.getElementById("oc-hauteur").value;
		var longueur = document.getElementById("oc-longueur").value;
		var largeur = document.getElementById("oc-largeur").value;
		var volume_utile = document.getElementById("oc-volume_utile").value;
		var marge = document.getElementById("oc-marge").value;
		var volume = document.getElementById("oc-volume").value;
		var intitule = document.getElementById("oc-intitule").value;
		var reference = document.getElementById("oc-reference").value;

		if (intitule=="") { showWarning("Veuillez saisir un intitul\u00E9"); }
		else if 	    (hauteur == "" || !isPositive(hauteur)
				|| longueur == "" || !isPositive(longueur)
				|| largeur == "" || !isPositive(largeur)) {

			showWarning("Les dimensions doivent \u00EAtre sup\u00E9rieures \u00E0 0");
		}
		else if (marge == "" || !isPositiveOrNull(marge)) {
			showWarning("Veuillez v\u00E9rifier le format de la marge");
		}
		else if (!isPositiveInteger(hauteur) ) { showWarning("La hauteur est incorrecte (veillez saisir un entier)"); }
		else if (!isPositiveInteger(longueur) ) { showWarning("La longueur est incorrecte (veillez saisir un entier)"); }
		else if (!isPositiveInteger(largeur) ) { showWarning("La largeur est incorrecte (veillez saisir un entier)"); }
		else if (!checkNumber(marge,6,3) ) { showWarning("La marge est incorrecte (trois d\u00E9cimales accept\u00E9es)"); }
		else if (parseFloat(marge)>=parseFloat(volume)) {
			showWarning("la marge ne peut \u00EAtre sup\u00E9rieure au volume du carton");
		}
		else {
			var actif = document.getElementById("oc-actif").checked;

			var qSaveCarton;

			if (oc_currentCartonId=="") {
				qSaveCarton=new QueryHttp("Config/gc/expeditions/createCarton.tmpl");
			}else{
				qSaveCarton=new QueryHttp("Config/gc/expeditions/updateCarton.tmpl");
				qSaveCarton.setParam("Carton_Id",oc_currentCartonId);
			}
			qSaveCarton.setParam("Intitule",intitule);
			qSaveCarton.setParam("Reference", reference);
			qSaveCarton.setParam("Hauteur",hauteur);
			qSaveCarton.setParam("Longueur",longueur);
			qSaveCarton.setParam("Largeur",largeur);
			qSaveCarton.setParam("Volume_Utile",volume_utile);
			qSaveCarton.setParam("Marge",marge);
			qSaveCarton.setParam("Volume",volume);
			qSaveCarton.setParam("Actif",actif);
			var result = qSaveCarton.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oc_aCarton.initTree();
				oc_nouveauCarton();
			}
		}

	} catch (e) {
    recup_erreur(e);
	}
}


function oc_verifSaisieDimensions() {
	try {

		var rd = new Arrondi(1);
		var rd2 = new Arrondi(3);

		var hauteur = document.getElementById("oc-hauteur").value;
		var longueur = document.getElementById("oc-longueur").value;
		var largeur = document.getElementById("oc-largeur").value;
		var marge = document.getElementById("oc-marge").value;

		if (hauteur=="" || longueur=="" || largeur=="" || marge=="") { document.getElementById("oc-volume").value = 0; document.getElementById("oc-volume_utile").value =0;}
		else if (hauteur!="" && !isPositive(hauteur)) { document.getElementById("oc-volume").value = 0; document.getElementById("oc-volume_utile").value =0;}
		else if (longueur!="" && !isPositive(longueur)) { document.getElementById("oc-volume").value = 0; document.getElementById("oc-volume_utile").value =0;}
		else if (largeur!="" && !isPositive(largeur)) { document.getElementById("oc-volume").value = 0; document.getElementById("oc-volume_utile").value =0;}
		else if (marge!="" && !isPositiveOrNull(marge)) { document.getElementById("oc-volume").value = 0; document.getElementById("oc-volume_utile").value =0;}
		else {

			hauteur = rd.round(hauteur);
			longueur = rd.round(longueur);
			largeur = rd.round(largeur);
			marge = rd2.round(marge);

			var volume = hauteur*largeur*longueur;
			volume = rd2.round(volume/1000000);
			document.getElementById("oc-volume").value = volume;
			document.getElementById("oc-volume_utile").value = rd2.round(volume-marge);
		}

	} catch (e) {
    recup_erreur(e);
	}
}


function oc_rechercherArticle() {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oc_retourRechercherArticle);

	} catch (e) {
		recup_erreur(e);
	}
}


function oc_retourRechercherArticle(reference, articleId) {
	try {

  	document.getElementById('oc-reference').value = reference;

	} catch (e) {
		recup_erreur(e);
	}
}


function oc_emptyArticle() {
	try {

		document.getElementById('oc-reference').value = "";

	} catch (e) {
		recup_erreur(e);
	}
}
