/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var omdr_aModalitesReglement = new Arbre("Config/gc/list-modaliteReglement.tmpl", "omdr-listeModalitesReglement");

var omdr_currentModaliteId = "";



function omdr_init() {
	try {

		omdr_listerModalitesReglement();

	} catch (e) {
    recup_erreur(e);
  }
}


function omdr_listerModalitesReglement() {
	try {

		omdr_aModalitesReglement.setParam("Actif", document.getElementById("omdr-filtreActif").checked);
		omdr_aModalitesReglement.initTree();
		omdr_nouveauModaliteReglement();

	} catch (e) {
		recup_erreur(e);
	}
}


function omdr_nouveauModaliteReglement() {
	try {

		omdr_currentModaliteId = "";
		omdr_aModalitesReglement.clearSelection();

		document.getElementById("omdr-codeModalite").value = "";
		document.getElementById('omdr-libelle').value = "";
		document.getElementById("omdr-delaiReg").value = "";
		document.getElementById("omdr-typeModalite").value = "N";
		document.getElementById("omdr-jourReg").value = "";
		document.getElementById('omdr-actifC').checked = true;
		document.getElementById('omdr-actifF').checked = true;

		document.getElementById("omdr-rowCodeLibelle").collapsed = true;

		document.getElementById('omdr-bSupprimer').collapsed = true;
		document.getElementById('omdr-bNouveau').collapsed = true;

		document.getElementById("omdr-delaiReg").focus();

	} catch (e) {
    recup_erreur(e);
  }
}


function omdr_chargerModaliteReglement() {
	try {

		if (omdr_aModalitesReglement.isSelected()) {
			omdr_currentModaliteId = omdr_aModalitesReglement.getSelectedCellText("omdr-colModaliteId");

			var qLoad = new QueryHttp("Config/gc/loadModaliteReglement.tmpl");
			qLoad.setParam("Modalite_Id", omdr_currentModaliteId);
			var result = qLoad.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				document.getElementById('omdr-codeModalite').value = contenu.getAttribute('Code_Modalite');
				document.getElementById('omdr-libelle').value = contenu.getAttribute('Libelle');
				document.getElementById('omdr-delaiReg').value = contenu.getAttribute('Delai_Reg');
				document.getElementById('omdr-typeModalite').value = contenu.getAttribute('Type_Modalite');
				document.getElementById('omdr-jourReg').value = contenu.getAttribute('Jour_Reg');
				document.getElementById('omdr-actifC').checked = contenu.getAttribute('Actif_C')=="true";
				document.getElementById('omdr-actifF').checked = contenu.getAttribute('Actif_F')=="true";

				document.getElementById('omdr-bSupprimer').collapsed = false;
				document.getElementById('omdr-bNouveau').collapsed = false;

				document.getElementById("omdr-rowCodeLibelle").collapsed = false;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omdr_enregistrerModaliteReglement() {
	try {

		var delaiReg = document.getElementById('omdr-delaiReg').value;
		var typeModalite = document.getElementById('omdr-typeModalite').value;
		var jourReg = document.getElementById('omdr-jourReg').value;
		var actifC = document.getElementById('omdr-actifC').checked;
		var actifF = document.getElementById('omdr-actifF').checked;

		if (!isPositiveOrNullInteger(delaiReg)) {
			showWarning("D\u00E9lai de r\u00E8glement incorrect");
		}
		else if (typeModalite=="L" && (!isPositiveInteger(jourReg) || jourReg<1 || jourReg>31)) {
			showWarning("Le jour apr\u00E8s la fin de mois doit \u00EAtre compris entre 1 et 31");
		}
		else {
			var qSave;

			if (!isEmpty(omdr_currentModaliteId)) {
				qSave = new QueryHttp("Config/gc/updateModaliteReglement.tmpl");
				qSave.setParam("Modalite_Id", omdr_currentModaliteId);
			}
			else {
				qSave = new QueryHttp("Config/gc/createModaliteReglement.tmpl");
			}

			qSave.setParam("Delai_Reg", delaiReg);
			qSave.setParam("Type_Modalite", typeModalite);
			qSave.setParam("Jour_Reg", jourReg);
			qSave.setParam("Actif_C", actifC);
			qSave.setParam("Actif_F", actifF);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				omdr_listerModalitesReglement();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function omdr_supprimerModaliteReglement() {
	try {

		if (!isEmpty(omdr_currentModaliteId) && window.confirm("Confirmez-vous la suppression de la modalit\u00E9 s\u00E9lectionn\u00E9e ?")) {

			var qDelete = new QueryHttp("Config/gc/deleteModaliteReglement.tmpl");
			qDelete.setParam("Modalite_Id", omdr_currentModaliteId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				omdr_listerModalitesReglement();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function omdr_changeTypeModalite() {
	try {

		if (document.getElementById("omdr-typeModalite").value!="L") {
			document.getElementById("omdr-jourReg").setAttribute("readonly", true);
			document.getElementById("omdr-jourReg").value = "";
		}
		else {
			document.getElementById("omdr-jourReg").removeAttribute("readonly");
		}

	} catch (e) {
    recup_erreur(e);
	}
}
