/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var omar_aMotifsAnnulationReglement = new Arbre("Config/gc/list-motifAnnulationReglement.tmpl", "omar-listeMotifsAnnulationReglement");

var omar_currentMotifId = "";



function omar_init() {
	try {

		omar_listerMotifsAnnulationReglement();

	} catch (e) {
    recup_erreur(e);
  }
}


function omar_listerMotifsAnnulationReglement() {
	try {

		omar_aMotifsAnnulationReglement.setParam("Actif", document.getElementById("omar-filtreActif").checked);
		omar_aMotifsAnnulationReglement.initTree();
		omar_nouveauMotifAnnulationReglement();

	} catch (e) {
		recup_erreur(e);
	}
}


function omar_nouveauMotifAnnulationReglement() {
	try {

		omar_currentMotifId = "";
		omar_aMotifsAnnulationReglement.clearSelection();

		document.getElementById('omar-libelle').value = "";
		document.getElementById('omar-actifC').checked = true;
		document.getElementById('omar-actifF').checked = false;

		document.getElementById('omar-bSupprimer').collapsed = true;
		document.getElementById('omar-bNouveau').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function omar_chargerMotifAnnulationReglement() {
	try {

		if (omar_aMotifsAnnulationReglement.isSelected()) {
			omar_currentMotifId = omar_aMotifsAnnulationReglement.getSelectedCellText("omar-colMotifId");

			var qLoad = new QueryHttp("Config/gc/loadMotifAnnulationReglement.tmpl");
			qLoad.setParam("Motif_Id", omar_currentMotifId);
			var result = qLoad.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				document.getElementById('omar-libelle').value = contenu.getAttribute('Libelle');
				document.getElementById('omar-actifC').checked = contenu.getAttribute('Actif_C')=="true";
				document.getElementById('omar-actifF').checked = contenu.getAttribute('Actif_F')=="true";

				document.getElementById('omar-bSupprimer').collapsed = false;
				document.getElementById('omar-bNouveau').collapsed = false;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omar_enregistrerMotifAnnulationReglement() {
	try {

		var libelle = document.getElementById('omar-libelle').value;
		var actifC = document.getElementById('omar-actifC').checked;
		var actifF = document.getElementById('omar-actifF').checked;

		if (isEmpty(libelle)) {
			showWarning("Libell\u00E9 manquant");
		}
		else {
			var qSave;

			if (!isEmpty(omar_currentMotifId)) {
				qSave = new QueryHttp("Config/gc/updateMotifAnnulationReglement.tmpl");
				qSave.setParam("Motif_Id", omar_currentMotifId);
			}
			else {
				qSave = new QueryHttp("Config/gc/createMotifAnnulationReglement.tmpl");
			}

			qSave.setParam("Libelle", libelle);
			qSave.setParam("Actif_C", actifC);
			qSave.setParam("Actif_F", actifF);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				omar_listerMotifsAnnulationReglement();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function omar_supprimerMotifAnnulationReglement() {
	try {

		if (!isEmpty(omar_currentMotifId) && window.confirm("Confirmez-vous la suppression du motif d'annulation de r\u00E8glement s\u00E9lectionn\u00E9 ?")) {

			var qDelete = new QueryHttp("Config/gc/deleteMotifAnnulationReglement.tmpl");
			qDelete.setParam("Motif_Id", omar_currentMotifId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				omar_listerMotifsAnnulationReglement();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}
