/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var ofc_aFamillesClient = new Arbre("Config/gc/tiers/list-familleClient.tmpl", "ofc-listeFamillesClient");
var ofc_aMentions = new Arbre("Config/gc/tiers/list-mentionFamilleClient.tmpl", 'ofc-listeMentions');


var ofc_currentFamilleId = "";



function ofc_init() {
	try {

		ofc_listerFamillesClient();

	} catch (e) {
    recup_erreur(e);
  }
}


function ofc_listerFamillesClient() {
	try {

		ofc_aFamillesClient.setParam("Actif", document.getElementById("ofc-filtreActif").checked);
		ofc_aFamillesClient.initTree();
		ofc_nouveauFamilleClient();

	} catch (e) {
		recup_erreur(e);
	}
}


function ofc_nouveauFamilleClient() {
	try {

		ofc_currentFamilleId = "";
		ofc_aFamillesClient.clearSelection();
		ofc_aMentions.deleteTree();

		document.getElementById('ofc-libelle').value = "";
		document.getElementById('ofc-articleComp').value = "";
		document.getElementById('ofc-plafondHTComp').value = "";
		document.getElementById('ofc-numAutoCompte').checked = false;
		document.getElementById('ofc-prefixeCompte').value = "";
		document.getElementById('ofc-articleAsilage').value = "";
		document.getElementById('ofc-actif').checked = true;
		document.getElementById('ofc-grpMentions').collapsed = true;
		document.getElementById('ofc-rowPrefixeCompte').collapsed = true;

		document.getElementById('ofc-bSupprimer').collapsed = true;
		document.getElementById('ofc-bNouveau').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function ofc_chargerFamilleClient() {
	try {

		if (ofc_aFamillesClient.isSelected()) {
			ofc_currentFamilleId = ofc_aFamillesClient.getSelectedCellText("ofc-colFamilleId");

			var qLoad = new QueryHttp("Config/gc/tiers/loadFamilleClient.tmpl");
			qLoad.setParam("Famille_Id", ofc_currentFamilleId);
			var result = qLoad.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				document.getElementById('ofc-libelle').value = contenu.getAttribute('Libelle');
				document.getElementById('ofc-articleComp').value = contenu.getAttribute('Article_Comp');
				document.getElementById('ofc-plafondHTComp').value = contenu.getAttribute('Plafond_HT_Comp');
				document.getElementById('ofc-numAutoCompte').checked = contenu.getAttribute('Num_Auto_Compte')=="true";
				document.getElementById('ofc-prefixeCompte').value = contenu.getAttribute('Prefixe_Compte');
				document.getElementById('ofc-articleAsilage').value = contenu.getAttribute('Article_Asilage');
				document.getElementById('ofc-actif').checked = contenu.getAttribute('Actif')=="true";

				ofc_changeNumAutoCompte();

				document.getElementById('ofc-bSupprimer').collapsed = false;
				document.getElementById('ofc-bNouveau').collapsed = false;

				document.getElementById('ofc-grpMentions').collapsed = false;
				ofc_aMentions.setParam("Famille_Id", ofc_currentFamilleId);
				ofc_aMentions.initTree();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofc_enregistrerFamilleClient() {
	try {

		var libelle = document.getElementById('ofc-libelle').value;
		var articleComp = document.getElementById('ofc-articleComp').value;
		var articleAsilage = document.getElementById('ofc-articleAsilage').value;
		var plafondHTComp = isEmpty(articleComp)?"":document.getElementById('ofc-plafondHTComp').value;
		var numAutoCompte = document.getElementById('ofc-numAutoCompte').checked;
		var prefixeCompte = document.getElementById('ofc-prefixeCompte').value;
		var actif = document.getElementById('ofc-actif').checked;

		var rgxPrefixe = /^[a-zA-Z09_\\-]{1}[a-zA-Z0-9_\\-]{0,1}$/;

		if (isEmpty(libelle)) {
			showWarning("Intitul\u00E9 manquant");
		}
		else if (!isEmpty(plafondHTComp) && !isPositive(plafondHTComp)) {
			showWarning("Plafond d'application des frais compl\u00E9mentaires incorrect");
		}
		else if (numAutoCompte && isEmpty(prefixeCompte)) {
			showWarning("Pr\u00E9fixe de compte manquant");
		}
		else if (numAutoCompte && !rgxPrefixe.test(prefixeCompte)) {
			showWarning("Pr\u00E9fixe de compte incorrect");
		}
		else {
			var qSave;

			if (!isEmpty(ofc_currentFamilleId)) {
				qSave = new QueryHttp("Config/gc/tiers/updateFamilleClient.tmpl");
				qSave.setParam("Famille_Id", ofc_currentFamilleId);
			}
			else {
				qSave = new QueryHttp("Config/gc/tiers/createFamilleClient.tmpl");
			}

			qSave.setParam("Libelle", libelle);
			qSave.setParam("Article_Comp", articleComp);
			qSave.setParam("Plafond_HT_Comp", plafondHTComp);
			qSave.setParam("Num_Auto_Compte", numAutoCompte);
			qSave.setParam("Prefixe_Compte", prefixeCompte);
			qSave.setParam("Article_Asilage", articleAsilage);
			qSave.setParam("Actif", actif);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				ofc_listerFamillesClient();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ofc_supprimerFamilleClient() {
	try {

		if (!isEmpty(ofc_currentFamilleId) && window.confirm("Confirmez-vous la suppression de la famille s\u00E9lectionn\u00E9e ?")) {

			var qDelete = new QueryHttp("Config/gc/tiers/deleteFamilleClient.tmpl");
			qDelete.setParam("Famille_Id", ofc_currentFamilleId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				ofc_listerFamillesClient();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


var currentFieldArticle;


function ofc_rechercherArticle(fieldArticle) {
	try {

		currentFieldArticle = fieldArticle;

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', ofc_retourRechercherArticle);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofc_retourRechercherArticle(reference, articleId) {
	try {

  	document.getElementById(currentFieldArticle).value = reference;

	} catch (e) {
		recup_erreur(e);
	}
}


function ofc_enleverArticleComp() {
	try {

		document.getElementById('ofc-articleComp').value = "";

	} catch (e) {
		recup_erreur(e);
	}
}


function ofc_enleverArticleAsilage() {
	try {

		document.getElementById('ofc-articleAsilage').value = "";

	} catch (e) {
		recup_erreur(e);
	}
}


function ofc_changeNumAutoCompte() {
	try {

		var numAuto = document.getElementById("ofc-numAutoCompte").checked;

		document.getElementById("ofc-rowPrefixeCompte").collapsed = !numAuto;
		if (!numAuto) {
			document.getElementById("ofc-prefixeCompte").value = "";
		}

	} catch (e) {
		  recup_erreur(e);
	}
}


function ofc_clickOnMention(ev) {
	try {

		var col = ofc_aMentions.getClickedCol(ev);

		if (col!=null && col.id=="ofc-colSelMention") {
			var idx = ofc_aMentions.getClickedRowIndex(ev);

			ofc_tickMentionFamilleClient(idx);

			// dbut contournement bug HM - Tache redmine 11172
			for (var i=idx-1; i>=idx-3 && i>=0; i--) {
				ofc_tickMentionFamilleClient(i);
			}
			for (var i=idx+1; i<=idx+3 && i<ofc_aMentions.nbLignes(); i++) {
				ofc_tickMentionFamilleClient(i);
			}
			// fin contournement bug
		}

	} catch (e) {
		recup_erreur(e);
  }
}


function ofc_tickMentionFamilleClient(idx) {
	try {

		var cocher = ofc_aMentions.getCellValue(idx, "ofc-colSelMention");
		var mentionId = ofc_aMentions.getCellText(idx, "ofc-colMentionId");

		var qTick = new QueryHttp("Config/gc/tiers/tickMentionFamilleClient.tmpl");
		qTick.setParam("Famille_Id", ofc_currentFamilleId);
		qTick.setParam("Mention_Id", mentionId);
		qTick.setParam("Cocher", cocher);

		qTick.execute();

	} catch (e) {
		recup_erreur(e);
  }
}
