/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var off_aFamillesFournisseur = new Arbre("Config/gc/tiers/list-familleFournisseur.tmpl", "off-listeFamillesFournisseur");

var off_currentFamilleId = "";



function off_init() {
	try {

		off_listerFamillesFournisseur();

	} catch (e) {
    recup_erreur(e);
  }
}


function off_listerFamillesFournisseur() {
	try {

		off_aFamillesFournisseur.setParam("Actif", document.getElementById("off-filtreActif").checked);
		off_aFamillesFournisseur.initTree();
		off_nouveauFamilleFournisseur();

	} catch (e) {
		recup_erreur(e);
	}
}


function off_nouveauFamilleFournisseur() {
	try {

		off_currentFamilleId = "";
		off_aFamillesFournisseur.clearSelection();

		document.getElementById('off-libelle').value = "";
		document.getElementById('off-actif').checked = true;

		document.getElementById('off-bSupprimer').collapsed = true;
		document.getElementById('off-bNouveau').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function off_chargerFamilleFournisseur() {
	try {

		if (off_aFamillesFournisseur.isSelected()) {
			off_currentFamilleId = off_aFamillesFournisseur.getSelectedCellText("off-colFamilleId");

			var qLoad = new QueryHttp("Config/gc/tiers/loadFamilleFournisseur.tmpl");
			qLoad.setParam("Famille_Id", off_currentFamilleId);
			var result = qLoad.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				document.getElementById('off-libelle').value = contenu.getAttribute('Libelle');
				document.getElementById('off-actif').checked = contenu.getAttribute('Actif')=="true";

				document.getElementById('off-bSupprimer').collapsed = false;
				document.getElementById('off-bNouveau').collapsed = false;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function off_enregistrerFamilleFournisseur() {
	try {

		var libelle = document.getElementById('off-libelle').value;
		var actif = document.getElementById('off-actif').checked;

		if (isEmpty(libelle)) {
			showWarning("Intitul\u00E9 manquant");
		}
		else {
			var qSave;

			if (!isEmpty(off_currentFamilleId)) {
				qSave = new QueryHttp("Config/gc/tiers/updateFamilleFournisseur.tmpl");
				qSave.setParam("Famille_Id", off_currentFamilleId);
			}
			else {
				qSave = new QueryHttp("Config/gc/tiers/createFamilleFournisseur.tmpl");
			}

			qSave.setParam("Libelle", libelle);
			qSave.setParam("Actif", actif);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				off_listerFamillesFournisseur();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function off_supprimerFamilleFournisseur() {
	try {

		if (!isEmpty(off_currentFamilleId) && window.confirm("Confirmez-vous la suppression de la famille s\u00E9lectionn\u00E9e ?")) {

			var qDelete = new QueryHttp("Config/gc/tiers/deleteFamilleFournisseur.tmpl");
			qDelete.setParam("Famille_Id", off_currentFamilleId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				off_listerFamillesFournisseur();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}
