/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var ob_aBanques = new Arbre("Config/globale/list-banque.tmpl", "ob-listeBanques");
var ob_aJournaux = new Arbre('ComboListe/combo-journaux.tmpl', 'ob-journalBanque');

var ob_currentBanqueId = "";
var ob_selJournalBanque;



function ob_init() {
	try {

		ob_aJournaux.setParam("Type_Journal", "TR");

		ob_listerBanques();

	} catch (e) {
    recup_erreur(e);
  }
}


function ob_chargerJournaux(selection) {
	try {

		ob_selJournalBanque = selection;
		ob_aJournaux.setParam("Selection", ob_selJournalBanque);
		ob_aJournaux.initTree(ob_initCodeJournal);

	} catch (e) {
		recup_erreur(e);
	}
}


function ob_initCodeJournal() {
  try {

		document.getElementById('ob-journalBanque').value = ob_selJournalBanque;

	} catch (e) {
  	recup_erreur(e);
	}
}


function ob_listerBanques() {
	try {

		ob_aBanques.setParam("Actif", document.getElementById("ob-filtreActif").checked);
		ob_aBanques.initTree();
		ob_nouveauBanque();

	} catch (e) {
		recup_erreur(e);
	}
}


function ob_nouveauBanque() {
	try {

		ob_currentBanqueId = "";
		ob_aBanques.clearSelection();

		document.getElementById('ob-nomBanque').value = "";
		document.getElementById('ob-domiciliation').value = "";
		document.getElementById('ob-codeBanque').value = "";
		document.getElementById('ob-codeGuichet').value = "";
		document.getElementById('ob-numCompte').value = "";
		document.getElementById('ob-cleRIB').value = "";
		document.getElementById('ob-debutIBAN').value = "";
		document.getElementById('ob-bic').value = "";
		document.getElementById('ob-finIBAN').value = "";
		document.getElementById('ob-actif').checked = true;
		document.getElementById('ob-affactureur').checked = false;
		ob_chargerJournaux("");

		document.getElementById('ob-bSupprimer').collapsed = true;
		document.getElementById('ob-bNouveau').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function ob_chargerBanque() {
	try {

		if (ob_aBanques.isSelected()) {
			ob_currentBanqueId = ob_aBanques.getSelectedCellText("ob-colBanqueId");

			var qLoad = new QueryHttp("Config/globale/loadBanque.tmpl");
			qLoad.setParam("Banque_Id", ob_currentBanqueId);
			var result = qLoad.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				document.getElementById('ob-nomBanque').value = contenu.getAttribute('Nom_Banque');
				document.getElementById('ob-domiciliation').value = contenu.getAttribute('Domiciliation');
				document.getElementById('ob-codeBanque').value = contenu.getAttribute('Code_Banque');
				document.getElementById('ob-codeGuichet').value = contenu.getAttribute('Code_Guichet');
				document.getElementById('ob-numCompte').value = contenu.getAttribute('Num_Compte');
				document.getElementById('ob-cleRIB').value = contenu.getAttribute('Cle_RIB');
				document.getElementById('ob-debutIBAN').value = contenu.getAttribute('Debut_IBAN');
				document.getElementById('ob-finIBAN').value = contenu.getAttribute('Fin_IBAN');
				document.getElementById('ob-bic').value = contenu.getAttribute('BIC');
				document.getElementById('ob-actif').checked = contenu.getAttribute('Actif')=="true";
				document.getElementById('ob-affactureur').checked = contenu.getAttribute('Affactureur')=="true";
				ob_chargerJournaux(contenu.getAttribute('Journal_Banque'));

				document.getElementById('ob-international').checked = isEmpty(document.getElementById('ob-codeBanque').value);
				ob_switchType();

				document.getElementById('ob-bSupprimer').collapsed = false;
				document.getElementById('ob-bNouveau').collapsed = false;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ob_enregistrerBanque() {
	try {

		var nomBanque = document.getElementById('ob-nomBanque').value;
		var domiciliation = document.getElementById('ob-domiciliation').value;
		var codeBanque = document.getElementById('ob-codeBanque').value;
		var codeGuichet = document.getElementById('ob-codeGuichet').value;
		var numCompte = document.getElementById('ob-numCompte').value;
		var cleRIB = document.getElementById('ob-cleRIB').value;
		var debutIBAN = document.getElementById('ob-debutIBAN').value;
		var finIBAN = document.getElementById('ob-finIBAN').value;
		var bic = document.getElementById('ob-bic').value;
		var journalBanque = document.getElementById('ob-journalBanque').value;
		var actif = document.getElementById('ob-actif').checked;
		var affactureur = document.getElementById('ob-affactureur').checked;
		var international = document.getElementById('ob-international').checked;

		if (isEmpty(nomBanque)) {
			showWarning("Nom de la banque manquant");
		}
		else if (isEmpty(domiciliation)) {
			showWarning("Domiciliation manquante");
		}
		else if (!international && isEmpty(codeBanque)) { showWarning("Code banque manquant"); }
		else if (!international && isEmpty(codeGuichet)) { showWarning("Code guichet manquant"); }
		else if (!international && isEmpty(numCompte)) { showWarning("N\u00B0 Compte manquant"); }
		else if (!international && isEmpty(cleRIB)) { showWarning("Cl\u00E9 de RIB manquante"); }
		else if (!international && !isCodeBanque(codeBanque)) { showWarning("Code banque incorrect"); }
		else if (!international && !isCodeGuichet(codeGuichet)) { showWarning("Code guichet incorrect"); }
		else if (!international && !isNumCompte(numCompte)) { showWarning("N\u00B0 Compte incorrect"); }
		else if (!international && !isCleRIB(cleRIB)) { showWarning("Cl\u00E9 de RIB incorrecte"); }
		else if (!international && !isEmpty(debutIBAN) && !isPrefIBAN(debutIBAN)) { showWarning("IBAN incorrect"); }
		else if (!international && !isEmpty(bic) && !isBIC(bic)) { showWarning("BIC incorrect"); }
		else if (!international && !verifCleRIB(cleRIB, finIBAN)) { showWarning("Echec du contr\u00F4le de la cl\u00E9 de RIB : Erreur probable sur N\u00B0 Compte, Code banque ou Code guichet"); }
		else if (!international && !isEmpty(debutIBAN) && !verifCleIBAN(debutIBAN.substring(2,4), debutIBAN, finIBAN)) { showWarning("Echec du contr\u00F4le de la cl\u00E9 IBAN : Erreur probable sur IBAN, N\u00B0 Compte, Code banque ou Code guichet"); }
		else if (international && (isEmpty(debutIBAN) || !isPrefIBAN(debutIBAN) || isEmpty(finIBAN))) { showWarning("IBAN incorrect"); }
		else if (international && !verifCleIBAN(debutIBAN.substring(2,4), debutIBAN, finIBAN)) { showWarning("Echec du contr\u00F4le de la cl\u00E9 IBAN"); }
		else {
			var qSave;

			if (!isEmpty(ob_currentBanqueId)) {
				qSave = new QueryHttp("Config/globale/updateBanque.tmpl");
				qSave.setParam("Banque_Id", ob_currentBanqueId);
			}
			else {
				qSave = new QueryHttp("Config/globale/createBanque.tmpl");
			}

			qSave.setParam("Nom_Banque", nomBanque);
			qSave.setParam("Domiciliation", domiciliation);
			qSave.setParam("Code_Banque", international?"":codeBanque);
			qSave.setParam("Code_Guichet", international?"":codeGuichet);
			qSave.setParam("Num_Compte", international?"":numCompte);
			qSave.setParam("Cle_RIB", international?"":cleRIB);
			qSave.setParam("IBAN", (international || !isEmpty(debutIBAN))?debutIBAN + finIBAN:"");
			qSave.setParam("BIC", bic);
			qSave.setParam("Journal_Banque", journalBanque);
			qSave.setParam("Actif", actif);
			qSave.setParam("Affactureur", affactureur);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				ob_listerBanques();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ob_supprimerBanque() {
	try {

		if (!isEmpty(ob_currentBanqueId) && window.confirm("Confirmez-vous la suppression de la banque s\u00E9lectionn\u00E9e ?")) {

			var qDelete = new QueryHttp("Config/globale/deleteBanque.tmpl");
			qDelete.setParam("Banque_Id", ob_currentBanqueId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				ob_listerBanques();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ob_switchType() {
  try {

		var international = document.getElementById('ob-international').checked;

    document.getElementById("ob-rowCodeBanque").collapsed = international;
    document.getElementById("ob-rowCodeGuichet").collapsed = international;
    document.getElementById("ob-rowNumCompte").collapsed = international;
    document.getElementById("ob-rowCleRIB").collapsed = international;

    if (!international) {
			document.getElementById("ob-finIBAN").setAttribute("readonly", true);
			ob_makeIBAN();
		}
		else {
			document.getElementById("ob-finIBAN").removeAttribute("readonly");
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function ob_makeIBAN() {
	try {

		var finIBAN = "";

		if (!document.getElementById('ob-international').checked) {
			finIBAN += document.getElementById('ob-codeBanque').value;
			finIBAN += document.getElementById('ob-codeGuichet').value;
			finIBAN += document.getElementById('ob-numCompte').value;
			finIBAN += document.getElementById('ob-cleRIB').value;
		}

		document.getElementById('ob-finIBAN').value = finIBAN;

	} catch (e) {
    recup_erreur(e);
  }
}
