/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var obi_aBornesImpression = new Arbre("Config/globale/list-borneImpression.tmpl", "obi-listeBornesImpression");

var obi_currentBorneId = "";



function obi_init() {
	try {

		var aAccesFTP = new Arbre("ComboListe/combo-accesFTP.tmpl", "obi-accesFTP");
		aAccesFTP.initTree();

		obi_listerBornesImpression();

	} catch (e) {
    recup_erreur(e);
  }
}


function obi_listerBornesImpression() {
	try {

		obi_aBornesImpression.setParam("Actif", document.getElementById("obi-filtreActif").checked);
		obi_aBornesImpression.initTree();
		obi_nouveauBorneImpression();

	} catch (e) {
		recup_erreur(e);
	}
}


function obi_nouveauBorneImpression() {
	try {

		obi_currentBorneId = "";
		obi_aBornesImpression.clearSelection();

		document.getElementById('obi-codeBorne').value = "";
		document.getElementById('obi-libelle').value = "";
		document.getElementById('obi-actif').checked = true;
		document.getElementById('obi-accesFTP').value = "";

		document.getElementById('obi-bSupprimer').collapsed = true;
		document.getElementById('obi-bNouveau').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function obi_chargerBorneImpression() {
	try {

		if (obi_aBornesImpression.isSelected()) {
			obi_currentBorneId = obi_aBornesImpression.getSelectedCellText('obi-colBorneId');

			var qLoad = new QueryHttp("Config/globale/loadBorneImpression.tmpl");
			qLoad.setParam("Borne_Id", obi_currentBorneId);
			var result = qLoad.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				document.getElementById('obi-codeBorne').value = contenu.getAttribute('Code_Borne');
				document.getElementById('obi-libelle').value = contenu.getAttribute('Libelle');
				document.getElementById('obi-actif').checked = contenu.getAttribute('Actif')=="true";
				document.getElementById('obi-accesFTP').value = contenu.getAttribute('Acces_FTP');

				document.getElementById('obi-bSupprimer').collapsed = false;
				document.getElementById('obi-bNouveau').collapsed = false;
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function obi_enregistrerBorneImpression() {
	try {

		var libelle = document.getElementById('obi-libelle').value;
		var codeBorne = document.getElementById('obi-codeBorne').value;
		var actif = document.getElementById('obi-actif').checked;
		var accesFTP = document.getElementById('obi-accesFTP').value;

		if (isEmpty(libelle)) { showWarning("Libell\u00E9 manquant"); }
		else if (isEmpty(codeBorne) || !isAlphaNum(codeBorne)) { showWarning("Code borne incorrect"); }
		else if (isEmpty(accesFTP)) { showWarning("Serveur FTP manquant"); }
		else {
			var qSave;

			if (!isEmpty(obi_currentBorneId)) {
				qSave = new QueryHttp("Config/globale/updateBorneImpression.tmpl");
				qSave.setParam("Borne_Id", obi_currentBorneId);
			}
			else {
				qSave = new QueryHttp("Config/globale/createBorneImpression.tmpl");
			}

			qSave.setParam('Libelle', libelle);
			qSave.setParam('Code_Borne', codeBorne);
			qSave.setParam('Actif', actif);
			qSave.setParam('Acces_FTP', accesFTP);
			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				obi_listerBornesImpression();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function obi_supprimerBorneImpression() {
	try {

		if (!isEmpty(obi_currentBorneId) && window.confirm("Confirmez-vous la suppression de la borne s\u00E9lectionn\u00E9e ?")) {

			var qDelete = new QueryHttp("Config/globale/deleteBorneImpression.tmpl");
			qDelete.setParam("Borne_Id", obi_currentBorneId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				obi_listerBornesImpression();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}
