/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var od_modified = false;



function od_init() {
	try {

		od_setModified(false);
		var aFormesJuridiques = new Arbre('ComboListe/combo-formesJuridiques.tmpl', 'od-formeJuridique');
		aFormesJuridiques.initTree(od_chargerEtablissement);

		od_loadLogo();

	} catch (e) {
    recup_erreur(e);
  }
}


function od_demandeEnregistrement() {
	try {

		if (od_modified && window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es au dossier ?")) {
			od_enregistrerSociete();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function od_chargerEtablissement() {
	try {

		var aEtablissement = new Arbre('ComboListe/combo-etablissements.tmpl', 'od-etabPrinc');
		aEtablissement.setParam("No_Check_Rights", true);
		aEtablissement.initTree(od_chargerDevise);

	} catch (e) {
		recup_erreur(e);
	}
}


function od_chargerDevise() {
	try {

		var aDevise = new Arbre('ComboListe/combo-devises.tmpl', 'od-devise');
		aDevise.initTree(od_chargerSociete);

	} catch (e) {
		recup_erreur(e);
	}
}


function od_chargerSociete() {
	try {

		var qLoad = new QueryHttp("Config/globale/loadSociete.tmpl");
		var result = qLoad.execute();
    var contenu = result.responseXML.documentElement;

		document.getElementById('od-codeDossier').value = getProfil().getCodeDossier();
		document.getElementById('od-formeJuridique').value = contenu.getAttribute('Forme_Juridique');
		document.getElementById('od-numSIRET').value = contenu.getAttribute('Num_SIRET');
		document.getElementById('od-codeNAF').value = contenu.getAttribute('Code_NAF');
		document.getElementById('od-numeroEORI').value = contenu.getAttribute('Numero_EORI');
		document.getElementById('od-villeRCS').value = contenu.getAttribute('Ville_RCS');
		document.getElementById('od-dateCreation').value = contenu.getAttribute('Date_Creation');
		document.getElementById('od-dureeSociete').value = contenu.getAttribute('Duree_Societe');
		document.getElementById('od-montantCapital').value = contenu.getAttribute('Montant_Capital');
		document.getElementById('od-nbParts').value = contenu.getAttribute('Nb_Parts');
		document.getElementById('od-etabPrinc').value = contenu.getAttribute('Etab_Princ');
		document.getElementById('od-devise').value = contenu.getAttribute('Monnaie_Tenue');
		document.getElementById('od-typeActivite').value = contenu.getAttribute('Typologie');
		document.getElementById('od-expertComptable').value = contenu.getAttribute('Expert');
		document.getElementById('od-regimeFiscal').value = contenu.getAttribute('Regime_Fiscal');
		document.getElementById('od-regimeGroupe').checked = contenu.getAttribute('Regime_Groupe')=="true";
		document.getElementById('od-centreImpots').value = contenu.getAttribute('Centre_Impot');
		document.getElementById('od-tresorerie').value = contenu.getAttribute('Tresorerie');
		document.getElementById('od-centreGestion').value = contenu.getAttribute('Centre_Gestion');
		document.getElementById('od-contenuLogo').value = contenu.getAttribute('Contenu_Logo');
		document.getElementById('od-urlLogo').value = contenu.getAttribute('URL_Logo');

	} catch (e) {
    recup_erreur(e);
  }
}


function od_enregistrerSociete() {
	try {

		var formeJuridique = document.getElementById("od-formeJuridique").value;
		var numSIRET = document.getElementById("od-numSIRET").value;
		var codeNAF = document.getElementById("od-codeNAF").value;
		var numeroEORI = document.getElementById("od-numeroEORI").value;
		var villeRCS = document.getElementById('od-villeRCS').value;
		var dateCreation = document.getElementById('od-dateCreation').value;
		var dureeSociete = document.getElementById("od-dureeSociete").value;
		var montantCapital = document.getElementById("od-montantCapital").value;
		var nbParts = document.getElementById("od-nbParts").value;
		var etabPrinc = document.getElementById("od-etabPrinc").value;
		var devise = document.getElementById("od-devise").value;
		var typeActivite = document.getElementById("od-typeActivite").value;
		var expertComptable = document.getElementById("od-expertComptable").value;
		var regimeFiscal = document.getElementById("od-regimeFiscal").value;
		var regimeGroupe = document.getElementById("od-regimeGroupe").checked;
		var centreImpots = document.getElementById("od-centreImpots").value;
		var tresorerie = document.getElementById("od-tresorerie").value;
		var centreGestion = document.getElementById("od-centreGestion").value;
		var contenuLogo = document.getElementById('od-contenuLogo').value;
		var urlLogo = document.getElementById("od-urlLogo").value;

		if (isEmpty(numSIRET)) { showWarning("N\u00B0 SIRET manquant"); }
		else if (isEmpty(codeNAF)) { showWarning("Code NAF manquant"); }
		else if (!isEmpty(dateCreation) && !isDate(dateCreation)) { showWarning("Date de cr\u00E9ation de la soci\u00E9t\u00E9 incorrecte"); }
		else if (!isEmpty(dureeSociete) && !isPositiveInteger(dureeSociete)) { showWarning("Dur\u00E9e de la soci\u00E9t\u00E9 incorrecte"); }
		else if (!isEmpty(montantCapital) && !isPositive(montantCapital)) { showWarning("Montant du capital est incorrect"); }
		else if (!isEmpty(nbParts) && !isPositiveInteger(nbParts)) { showWarning("Nombre de parts incorrect"); }
		else {

			var qSave = new QueryHttp("Config/globale/updateSociete.tmpl");

			qSave.setParam("Forme_Juridique", formeJuridique);
			qSave.setParam("Num_SIRET", numSIRET);
			qSave.setParam("Code_NAF", codeNAF);
			qSave.setParam("Numero_EORI", numeroEORI);
			qSave.setParam("Ville_RCS", villeRCS);
			qSave.setParam("Date_Creation", dateCreation);
			qSave.setParam("Duree_Societe", dureeSociete);
			qSave.setParam("Montant_Capital", montantCapital);
			qSave.setParam("Nb_Parts", nbParts);
			qSave.setParam("Etab_Princ", etabPrinc);
			qSave.setParam("Monnaie_Tenue", devise);
			qSave.setParam("Typologie", typeActivite);
			qSave.setParam("Expert", expertComptable);
			qSave.setParam("Regime_Fiscal", regimeFiscal);
			qSave.setParam("Regime_Groupe", regimeGroupe);
			qSave.setParam("Centre_Impot", centreImpots);
			qSave.setParam("Tresorerie", tresorerie);
			qSave.setParam("Centre_Gestion", centreGestion);
			qSave.setParam("Contenu_Logo", contenuLogo);
			qSave.setParam("URL_Logo", urlLogo);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				od_setModified(false);
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function od_setModified(modified) {
	try {

		od_modified = modified;
		document.getElementById('od-imgModified').collapsed = !od_modified;

	} catch (e) {
		recup_erreur(e);
	}
}


function od_loadLogo() {
  try {

		document.getElementById('od-vignette').setAttribute("src", getDirServeur() +"data/"+ getProfil().getCodeDossier() +"/logos/Logo_small.jpg?"+ nocache());

	} catch (e) {
    recup_erreur(e);
  }
}


function od_voirLogo() {
  try {

		var urlLogo = getDirServeur() +"data/"+ getProfil().getCodeDossier() +"/logos/Logo.jpg?"+ nocache();

		var url = "chrome://opensi/content/config/commun/popup-visualisationLogo.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', urlLogo);

	} catch (e) {
    recup_erreur(e);
  }
}


function od_changerLogo() {
  try {

		var url = "chrome://opensi/content/config/commun/popup-chargementLogo.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', "S");

		od_loadLogo();

	} catch (e) {
    recup_erreur(e);
  }
}


function od_supprimerLogo() {
  try {

		if (window.confirm("Confirmez-vous la suppression du logo ?")) {
			var qDelete = new QueryHttp("Config/globale/deleteLogoSociete.tmpl");
			qDelete.execute();

			document.getElementById('od-vignette').setAttribute("src", "chrome://opensi/content/design/default_logo.jpg");
		}

	} catch (e) {
    recup_erreur(e);
  }
}
