/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var omc_aModelesCommentaire = new Arbre('Config/globale/list-modeleCommentaire.tmpl', 'omc-tree-modelesCommentaire');
var omc_modeleId = "";


function omc_init() {
	try {

		omc_aModelesCommentaire.initTree();
		var aTypeDoc = new Arbre('ComboListe/combo-typeDocument.tmpl', 'omc-Type_Document');
		aTypeDoc.initTree(omc_nouveauModele);

	} catch (e) {
    recup_erreur(e);
  }
}


function omc_nouveauModele() {
	try {

		omc_aModelesCommentaire.clearSelection();
		document.getElementById('omc-bNouveauModele').collapsed = true;
		document.getElementById('omc-bSupprimerModele').collapsed = true;
		document.getElementById('omc-Commentaire').value = "";
		document.getElementById('omc-Intitule').value = "";
		document.getElementById('omc-Type_Document').value = "";
		document.getElementById('omc-Type_Commentaire').value = "";
		omc_modeleId = "";

	} catch (e) {
    recup_erreur(e);
  }
}


function omc_chargerModele() {
	try {

		if (omc_aModelesCommentaire.isSelected()) {
			document.getElementById('omc-bNouveauModele').collapsed = false;
			document.getElementById('omc-bSupprimerModele').collapsed = false;
			document.getElementById('omc-Commentaire').value = omc_aModelesCommentaire.getSelectedCellText('omc-ColCommentaire');
			document.getElementById('omc-Intitule').value = omc_aModelesCommentaire.getSelectedCellText('omc-ColIntitule');
			document.getElementById('omc-Type_Document').value = omc_aModelesCommentaire.getSelectedCellText('omc-ColTypeDocument');
			document.getElementById('omc-Type_Commentaire').value = omc_aModelesCommentaire.getSelectedCellText('omc-ColTypeCommentaire');

			omc_modeleId = omc_aModelesCommentaire.getSelectedCellText('omc-ColModeleId');
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function omc_enregistrerModele() {
	try {

		var intitule = document.getElementById('omc-Intitule').value;
		var commentaire = document.getElementById('omc-Commentaire').value;
		var typeDocument = document.getElementById('omc-Type_Document').value;
		var typeCommentaire = document.getElementById('omc-Type_Commentaire').value;

		if (isEmpty(intitule)) { showWarning("Intitul\u00E9 incorrect"); }
		else if (isEmpty(commentaire)) { showWarning("Commentaire incorrect"); }
		else {
			var qEnregistrer;
			if (omc_modeleId=="") {
				qEnregistrer = new QueryHttp("Config/globale/createModeleCommentaire.tmpl");
			}
			else {
				qEnregistrer = new QueryHttp("Config/globale/updateModeleCommentaire.tmpl");
				qEnregistrer.setParam("Modele_Id", omc_modeleId);
			}
			qEnregistrer.setParam('Intitule', intitule);
			qEnregistrer.setParam('Commentaire', commentaire);
			qEnregistrer.setParam('Type_Document', typeDocument);
			qEnregistrer.setParam('Type_Commentaire', typeCommentaire);
			var result = qEnregistrer.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				omc_aModelesCommentaire.initTree(omc_nouveauModele);
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function omc_supprimerModele() {
	try {

		if (window.confirm("Confirmez-vous la suppression du mod\u00E8le s\u00E9lectionn\u00E9 ?")) {

			var querySup = new QueryHttp("Config/globale/deleteModeleCommentaire.tmpl");
			querySup.setParam("Modele_Id", omc_modeleId);
			var result = querySup.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				omc_aModelesCommentaire.initTree(omc_nouveauModele);
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}
