/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var omr_aModesReglement = new Arbre("Config/globale/list-modeReglement.tmpl", "omr-listeModesReglement");
var omr_aJournaux = new Arbre('ComboListe/combo-journaux.tmpl', 'omr-journalEnc');

var omr_currentModeRegId = "";
var omr_selJournalEnc;



function omr_init() {
	try {

		omr_aJournaux.setParam('Type_Journal', 'TR');

		var aTypesReglement = new Arbre("ComboListe/combo-typesReglement.tmpl", "omr-typeRegId");
		aTypesReglement.initTree(omr_listerModesReglement);

	} catch (e) {
    recup_erreur(e);
  }
}


function omr_chargerJournaux(selection) {
	try {

		omr_selJournalEnc = selection;
		omr_aJournaux.setParam("Selection", omr_selJournalEnc);
		omr_aJournaux.initTree(omr_initJournalEnc);

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_initJournalEnc() {
  try {

		document.getElementById('omr-journalEnc').value = omr_selJournalEnc;

	} catch (e) {
  	recup_erreur(e);
	}
}


function omr_listerModesReglement() {
	try {

		omr_aModesReglement.setParam("Actif", document.getElementById("omr-filtreActif").checked);
		omr_aModesReglement.initTree();
		omr_nouveauModeReglement();

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_nouveauModeReglement() {
	try {

		omr_currentModeRegId = "";
		omr_aModesReglement.clearSelection();

		document.getElementById('omr-codeReg').value = "";
		document.getElementById('omr-libelle').value = "";
		document.getElementById('omr-typeRegId').value = "";
		document.getElementById('omr-compteEnc').value = "";
		document.getElementById('omr-fractionnement').value = 1;
		document.getElementById('omr-actif').checked = true;
		omr_chargerJournaux("");

		document.getElementById('omr-bSupprimer').collapsed = true;
		document.getElementById('omr-bNouveau').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function omr_chargerModeReglement() {
	try {

		if (omr_aModesReglement.isSelected()) {
			omr_currentModeRegId = omr_aModesReglement.getSelectedCellText("omr-colModeRegId");

			var qLoad = new QueryHttp("Config/globale/loadModeReglement.tmpl");
			qLoad.setParam("Mode_Reg_Id", omr_currentModeRegId);
			var result = qLoad.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				document.getElementById('omr-codeReg').value = contenu.getAttribute('Code_Reg');
				document.getElementById('omr-libelle').value = contenu.getAttribute('Libelle');
				document.getElementById('omr-typeRegId').value = contenu.getAttribute('Type_Reg_Id');
				document.getElementById('omr-compteEnc').value = contenu.getAttribute('Compte_Enc');
				document.getElementById('omr-fractionnement').value = contenu.getAttribute('Fractionnement');
				document.getElementById('omr-actif').checked = contenu.getAttribute('Actif')=="true";
				omr_chargerJournaux(contenu.getAttribute('Journal_Enc'));

				document.getElementById('omr-bSupprimer').collapsed = false;
				document.getElementById('omr-bNouveau').collapsed = false;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_enregistrerModeReglement() {
	try {

		var codeReg = document.getElementById('omr-codeReg').value;
		var journalEnc = document.getElementById('omr-journalEnc').value;
		var libelle = document.getElementById('omr-libelle').value;
		var typeReglement = document.getElementById('omr-typeRegId').value;
		var compteEnc = document.getElementById('omr-compteEnc').value;
		var fractionnement = document.getElementById('omr-fractionnement').value;
		var actif = document.getElementById('omr-actif').checked;

		if (isEmpty(typeReglement)) {
			showWarning("Type de r\u00E8glement manquant");
		}
		else if (isEmpty(libelle)) {
			showWarning("Intitul\u00E9 manquant");
		}
		else if (isEmpty(fractionnement)) {
			showWarning("Fractionnement manquant");
		}
		else if (!isPositiveInteger(fractionnement)) {
			showWarning("Fractionnement incorrect");
		}
		else {
			var qSave;

			if (!isEmpty(omr_currentModeRegId)) {
				qSave = new QueryHttp("Config/globale/updateModeReglement.tmpl");
				qSave.setParam("Mode_Reg_Id", omr_currentModeRegId);
			}
			else {
				qSave = new QueryHttp("Config/globale/createModeReglement.tmpl");
			}

			qSave.setParam("Code_Reg", codeReg);
			qSave.setParam("Journal_Enc", journalEnc);
			qSave.setParam("Libelle", libelle);
			qSave.setParam("Type_Reg_Id", typeReglement);
			qSave.setParam("Compte_Enc", compteEnc);
			qSave.setParam("Fractionnement", fractionnement);
			qSave.setParam("Actif", actif);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				omr_listerModesReglement();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function omr_supprimerModeReglement() {
	try {

		if (!isEmpty(omr_currentModeRegId) && window.confirm("Confirmez-vous la suppression du mode de r\u00E8glement s\u00E9lectionn\u00E9 ?")) {

			var qDelete = new QueryHttp("Config/globale/deleteModeReglement.tmpl");
			qDelete.setParam("Mode_Reg_Id", omr_currentModeRegId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				omr_listerModesReglement();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function omr_rechercherCompte() {
	try {

    var url = "chrome://opensi/content/compta/user/comptes/popup-rechercheCompte.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', omr_retourRechercherCompte, "5", "G", "DE TRESORERIE", "5", false);

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_retourRechercherCompte(numCompte, compteId) {
	try {

		document.getElementById("omr-compteEnc").value = numCompte;

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_enleverCompteEnc() {
	try {

		document.getElementById("omr-compteEnc").value = "";

	} catch (e) {
		recup_erreur(e);
	}
}
