/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var optb_modified = false;



function optb_init() {
	try {

		optb_loadPreferences();

	} catch (e) {
    recup_erreur(e);
  }
}


function optb_demandeEnregistrement() {
	try {

		if (optb_modified && window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es ?")) {
			optb_updatePreferences();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function optb_loadPreferences() {
	try {

		var qLoad = new QueryHttp("Config/tb/getPreferencesTB.tmpl");
		var result = qLoad.execute();
		var contenu = result.responseXML.documentElement;

		document.getElementById("optb-TB_Compta_Lot_Vir").checked = contenu.getAttribute("TB_Compta_Lot_Vir")=="true";
		document.getElementById("optb-TB_Compta_Lot_Pre").checked = contenu.getAttribute("TB_Compta_Lot_Pre")=="true";
		document.getElementById("optb-TB_Reg_Date_Ech_Pre").checked = contenu.getAttribute("TB_Reg_Date_Ech_Pre")=="true";

		document.getElementById("optb-bEnregistrer").disabled = false;

		optb_setModified(false);

	} catch (e) {
    recup_erreur(e);
  }
}


function optb_updatePreferences() {
	try {

		var tbComptaLotVir = document.getElementById("optb-TB_Compta_Lot_Vir").checked;
		var tbComptaLotPre = document.getElementById("optb-TB_Compta_Lot_Pre").checked;
		var tbRegDateEchPre = document.getElementById("optb-TB_Reg_Date_Ech_Pre").checked;

		var qUpdate = new QueryHttp("Config/tb/updatePreferencesTB.tmpl");

		qUpdate.setParam("TB_Compta_Lot_Vir", tbComptaLotVir);
		qUpdate.setParam("TB_Compta_Lot_Pre", tbComptaLotPre);
		qUpdate.setParam("TB_Reg_Date_Ech_Pre", tbRegDateEchPre);

		var result = qUpdate.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			optb_setModified(false);
			showMessage("Pr\u00E9f\u00E9rences sauvegard\u00E9es");
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function optb_setModified(modified) {
	try {

		optb_modified = modified;
		document.getElementById('optb-imgModified').collapsed = !modified;

	} catch (e) {
		recup_erreur(e);
	}
}
