/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var opc_currentChampCompte;
var config;



function init() {
	try {

		config = getConfig();

		var aTxTva = new Arbre('ComboListe/combo-tauxTVA.tmpl', 'opc-Code_TVA');
		aTxTva.initTree(opc_initTva);

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_initTva() {
	try {

		document.getElementById('opc-Code_TVA').selectedIndex = 0;
		opc_nouveauCompte();

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_nouveauCompte() {
	try {

		document.getElementById("opc-Detail_Cloture").checked = true;
		document.getElementById("opc-Cumul_Journal").checked = false;
		document.getElementById("opc-Tva_Encaissement").checked = false;
		document.getElementById('opc-Contrepartie').value = '';
		document.getElementById('opc-Collectif').value = '';
		document.getElementById('opc-numCompte').disabled = false;
		document.getElementById('opc-numCompte').value = ParamValeur("Num_Compte");
		document.getElementById('opc-Intitule').value = '';
		document.getElementById('opc-Code_TVA').selectedIndex = 0;

		var typeCompte = ParamValeur("Type_Compte");
		if (isEmpty(typeCompte)) {
			typeCompte = "G";
		}
		document.getElementById('opc-Type_Compte').value = typeCompte;
		opc_pressOnTypeCompte();

		document.getElementById("opc-Type_Compte").disabled = false;
		document.getElementById("opc-rTva").collapsed = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_leaveNumCompte() {
	try {

		var numCompte = document.getElementById('opc-numCompte').value;
		var racineCompte = numCompte.substring(0,1);
		document.getElementById("opc-rTva").collapsed = (racineCompte!='6' && racineCompte!='7');

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_enregistrerCompte() {
	try {

		var numCompte = document.getElementById('opc-numCompte').value;
		var intitule = document.getElementById('opc-Intitule').value;
		var typeCompte = document.getElementById('opc-Type_Compte').value;
		var codeTVA = document.getElementById('opc-Code_TVA').value;
		var cumulJournal = document.getElementById('opc-Cumul_Journal').checked;
		var detailCloture = document.getElementById('opc-Detail_Cloture').checked;
		var tvaEncaissement = document.getElementById('opc-Tva_Encaissement').checked;
		var collectif = document.getElementById('opc-Collectif').value;
		var contrepartie = document.getElementById('opc-Contrepartie').value;

		if (isEmpty(numCompte)) { showWarning("Veuillez saisir un num\u00E9ro de compte !"); }
		else if (isEmpty(intitule)) { showWarning("Veuillez saisir un libell\u00E9 !"); }
		else if (!isCompteCorrect(numCompte)) { showWarning("Le num\u00E9ro de compte est incorrect !"); }
		else if (typeCompte=="G" && (numCompte.charAt(0)<'1' || numCompte.charAt(0)>'7')) { showWarning("Le num\u00E9ro de compte doit commencer par un chiffre de 1 \u00E0 7"); }
		else if (typeCompte!="G" && numCompte.charAt(0)>'0' && numCompte.charAt(0)<'9') { showWarning("Le num\u00E9ro de compte ne doit pas commencer par un chiffre de 1 \u00E0 8"); }
		else if (typeCompte!="G" && !isCompteCorrect(collectif)) { showWarning("Le compte collectif doit \u00EAtre rempli !"); }
		else if (typeCompte=="F" && collectif.substr(0,2)!="40") { showWarning("La racine d'un compte collectif fournisseur doit \u00EAtre 40"); }
		else if (typeCompte=="C" && collectif.substr(0,2)!="41") { showWarning("La racine d'un compte collectif client doit \u00EAtre 41"); }
		else if (typeCompte=="A" && (collectif.substr(0,2)=="40" || collectif.substr(0,2)=="41")) { showWarning("La racine d'un compte collectif auxiliaire ne doit pas \u00EAtre 40 ni 41"); }

		else if (window.confirm("Confirmez-vous l'enregistrement du compte '"+ numCompte +"' ?")) {

			var qSave = new QueryHttp("Compta/Comptes/saveCompte.tmpl");

			qSave.setParam('Num_Compte', numCompte);
			qSave.setParam('Intitule', intitule);
			qSave.setParam('Type_Compte', typeCompte);
			qSave.setParam('Code_TVA', codeTVA);
			qSave.setParam('Cumul_Journal', cumulJournal);
			qSave.setParam('Detail_Cloture', detailCloture);
			qSave.setParam('Collectif', collectif);
			qSave.setParam('Contrepartie', contrepartie);
			qSave.setParam('Tva_Encaissement', tvaEncaissement);
			qSave.setParam('Creation', true);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				window.arguments[0](numCompte);
				window.close();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_recherche_compte(numCompte, id) {
  try {

  	opc_currentChampCompte = id;
    var url = "chrome://opensi/content/compta/user/comptes/popup-rechercheCompte.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', opc_retourRechercheCompte, numCompte, "", "", "", (id=="opc-Collectif"));

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_retourRechercheCompte(numCompte, compteId) {
	try {

		document.getElementById(opc_currentChampCompte).value = numCompte;

	} catch (e) {
		  recup_erreur(e);
	}
}


function opc_pressOnTypeCompte() {
	try {

		var typeCompte = document.getElementById('opc-Type_Compte').value;
		document.getElementById('opc-Collectif').value = "";
		document.getElementById('opc-rCollectif').collapsed = (typeCompte=="G");
		
		if (typeCompte=="C") {
			document.getElementById('opc-Collectif').value = config.getCollectifClient();
		}
		else if (typeCompte=="F") {
			document.getElementById('opc-Collectif').value = config.getCollectifFournisseur();
		}

		document.getElementById('opc-Detail_Cloture').checked = true;
		document.getElementById('opc-rDetail').collapsed = (typeCompte=="G");

		document.getElementById('opc-Contrepartie').value = "";
		document.getElementById("opc-rContrepartie").collapsed = (typeCompte=="G");

	} catch (e) {
		recup_erreur(e);
	}
}
