/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");


var aListeComptes = new Arbre("CRM/GestionComptes/list-prospect.tmpl", "listeComptes");
var qListCP = new QueryHttp("CRM/GestionComptes/getDataListCP.tmpl");

var pageCourante;
var nbPages;

var gProfil;
var gConfig;

var globalClientId = "";



function init() {
  try {

		gProfil = getProfil();
		gConfig = getConfig();

		if (gProfil.isDirection()) {
			document.getElementById("labelListeResponsable").collapsed = false;
			document.getElementById("listeResponsable").collapsed = false;
		}
		else {
			document.getElementById("labelListeResponsable").collapsed = true;
			document.getElementById("listeResponsable").collapsed = true;
		}

		var aResp = new Arbre("ComboListe/combo-responsables.tmpl", "listeResponsable");
  	aResp.initTree(initResponsable);

		var aPays = new Arbre("ComboListe/combo-pays.tmpl", "listePays");
  	aPays.initTree();

		var atypes = new Arbre("ComboListe/combo-typesProspect.tmpl", "listeType");
		atypes.initTree();

		var aPolesActivite = new Arbre("ComboListe/combo-polesActivite.tmpl","pole-activite");
		aPolesActivite.initTree();


  	ofsaPays.initTree(setModifSignaletique(false));
  	ofsaType.initTree(setModifSignaletique(false));
		ofsaCivilites.initTree(ofs_initCivilite);
  	aCivilites.initTree(setModifContact(false));
  	initialisationCriteres();

		var aFormeJuridique = new Arbre("ComboListe/combo-formesJuridiques.tmpl", "ofs-formeJuridique");
		aFormeJuridique.initTree();

  	setModifSignaletique(false);

  } catch (e) {
    recup_erreur(e);
  }
}


function initResponsable() {
	try {

		document.getElementById("listeResponsable").value = gProfil.getLoggedUser();

	} catch (e) {
		recup_erreur(e);
	}
}


function initCriteres() {
	try {

		document.getElementById("denomination").value = "";
		document.getElementById("codePostal").value = "";
		document.getElementById("numClient").value = "";
		document.getElementById("listeType").value = "";
		document.getElementById("listePays").value = "";
		document.getElementById("contact").value = "";
		document.getElementById("listeResponsable").value = gProfil.getLoggedUser();
		document.getElementById("pole-activite").value = "";
		document.getElementById("projet").checked = false;
		document.getElementById("actif").checked = true;

		listerComptes();

	} catch (e) {
		recup_erreur(e);
	}
}


function listerComptes() {
	try {

		var denomination = document.getElementById("denomination").value;
		var typeProspect = document.getElementById("listeType").value;
		var codePostal = document.getElementById("codePostal").value;
		var responsable = document.getElementById("listeResponsable").value;
		var codePays = document.getElementById("listePays").value;
		var numClient = document.getElementById("numClient").value;
		var contact = document.getElementById("contact").value;
		var projet = document.getElementById("projet").checked;
		var actif = document.getElementById("actif").checked;
		var poleActivite = document.getElementById("pole-activite").value;
		var nbLignesParPage = document.getElementById('nbLignesParPage').value;

		pageCourante = 1;
		nbPages = 1;
		document.getElementById('pageDeb').value = 1;
		document.getElementById('pageFin').value = 1;
		document.getElementById('bPrec').disabled = true;
		document.getElementById('bSuiv').disabled = true;

		document.getElementById('listeComptes').disabled = true;
		document.getElementById('bEditionCsv').disabled = true;
		aListeComptes.deleteTree();

		qListCP.setParam("Denomination", denomination);
		qListCP.setParam("Type", typeProspect);
		qListCP.setParam("Code_Postal", codePostal);
		qListCP.setParam("Responsable", responsable);
		qListCP.setParam("Code_Pays", codePays);
		qListCP.setParam("Num_Client", numClient);
		qListCP.setParam("Contact", contact);
		qListCP.setParam("Projet", projet);
		qListCP.setParam("Actif", actif);
		qListCP.setParam("Pole_Activite", poleActivite);
		qListCP.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
		qListCP.setParam("Current_Page", pageCourante);

		var result = qListCP.execute();

		var contenu = result.responseXML.documentElement;

		nbPages = contenu.getAttribute("Nb_Pages");
		var listClientId = contenu.getAttribute("List_Client_Id");

		aListeComptes.setParam("List_Client_Id", listClientId);
		aListeComptes.initTree(initPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function initPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('pageFin').value = (nbPages>0?nbPages:1);
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante>=nbPages); // peut se produire si nbPages=0

		afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPagePrec() {
	try {

		pageCourante--;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPageSuiv() {
	try {

		pageCourante++;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function majPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante==nbPages);

		document.getElementById('listeComptes').disabled = true;
		document.getElementById('bEditionCsv').disabled = true;

		qListCP.setParam("Current_Page", pageCourante);
		var result = qListCP.execute();
		var listClientId = result.responseXML.documentElement.getAttribute("List_Client_Id");

		aListeComptes.setParam("List_Client_Id", listClientId);
		aListeComptes.initTree(afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function afterMajPagination() {
	try {

		document.getElementById('listeComptes').disabled = false;
		document.getElementById('bEditionCsv').disabled=(aListeComptes.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnNouveauProspect() {
	try {

		// ces 3 lignes devraient tre dans une fonction ofp_nouveauProspect()
		initialiser("N");
		document.getElementById('ofc-tabContact').disabled = true;
		document.getElementById('ofc-tabEvenement').disabled = true;

		document.getElementById('deck').selectedIndex = 1;
		//document.getElementById('bMenuComptes').collapsed = false;
		//ofp_nouveauProspect();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			listerComptes();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function pressOnListeComptes(ev) {
  try {

		if (ev.keyCode==13) {
			ouvrirCompte();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function ouvrirCompte() {
  try {

  	if (aListeComptes.isSelected()) {

			// ces lignes devraient tre dans une fonction chargerCompte()
			var i = aListeComptes.getCurrentIndex();

			ofsaResp.setParam("Selection",aListeComptes.getCellText(i, 'Responsable_Id'))
			ofsaResp.initTree(setModifSignaletique(false));

			document.getElementById("ofs-denomination").value=aListeComptes.getCellText(i, 'denomination');

			globalClientId = aListeComptes.getCellText(i, 'Client_Id');
			initialiser("");

			//ofp_clientId = aListeComptes.getSelectedCellText('colClientId');
			//chargerCompte();
			//document.getElementById('bMenuComptes').collapsed = false;
			document.getElementById('deck').selectedIndex = 1;
  	}

	} catch (e) {
  	recup_erreur(e);
  }
}


function pressOnEditionCsv() {
	try {

		var denomination = document.getElementById("denomination").value;
		var typeProspect = document.getElementById("listeType").value;
		var codePostal = document.getElementById("codePostal").value;
		var responsable = document.getElementById("listeResponsable").value;
		var codePays = document.getElementById("listePays").value;
		var numClient = document.getElementById("numClient").value;
		var contact = document.getElementById("contact").value;
		var projet = document.getElementById("projet").checked;
		var actif = document.getElementById("actif").checked;
		var poleActivite = document.getElementById("pole-activite").value;

		var qEditionCsv = new QueryHttp("CRM/GestionComptes/csvProspect.tmpl");

		qEditionCsv.setParam("Denomination", denomination);
		qEditionCsv.setParam("Type", typeProspect);
		qEditionCsv.setParam("Code_Postal", codePostal);
		qEditionCsv.setParam("Responsable", responsable);
		qEditionCsv.setParam("Code_Pays", codePays);
		qEditionCsv.setParam("Num_Client", numClient);
		qEditionCsv.setParam("Contact", contact);
		qEditionCsv.setParam("Projet", projet);
		qEditionCsv.setParam("Actif", actif);
		qEditionCsv.setParam("Pole_Activite", poleActivite);

		var result = qEditionCsv.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

			var file = fileChooser("save", fichier);
			if (file!=null) {
				downloadFile(getDirBuffer()+ fichier, file);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function rechercherClient() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherClient);

	} catch (e) {
		recup_erreur(e);
  }
}


function retourRechercherClient(numClient) {
	try {

  	document.getElementById('numClient').value = numClient;
  	listerComptes();

	} catch (e) {
		recup_erreur(e);
	}
}


function retourListeCompte(){
  try {
	  var go=true;
	  if(modifSignaletique && modifContact){
			go = window.confirm("Voulez vous enregistrer les modifications apport\u00E9es \u00E0 la fiche signal\u00E9tique et \u00E0 la fiche contact ?");
			if(go){
				ofsEnregistrer();
				ofcEnregistrer();
				if(!modifSignaletique && !modifContact){
					quitAndReturnListeCompte();
				}
			}else{
				quitAndReturnListeCompte();
			}
		}else if(modifSignaletique){
			go = window.confirm("Voulez vous enregistrer les modifications apport\u00E9es \u00E0 la fiche signal\u00E9tique ?");
			if(go){
				ofsEnregistrer("liste");
			}else{
				quitAndReturnListeCompte();
			}
		}else if(modifContact){
			go = window.confirm("Voulez vous enregistrer les modifications apport\u00E9es \u00E0 la fiche contact ?");
			if(go){
				ofcEnregistrer("liste");
			}else{
				quitAndReturnListeCompte();
			}
		}else{
			quitAndReturnListeCompte();
		}
  } catch (e) {
    recup_erreur(e);
  }
}


function quitAndReturnListeCompte() {
	try {

		modifSignaletique=false;
		modifContact=false;
		document.getElementById('deck').selectedIndex = 0;
		document.getElementById('onglets').selectedIndex=0;
		document.getElementById('bMenuComptes').collapsed=true;
		document.getElementById('ofc-tabContact').disabled = false;
		document.getElementById('ofc-tabEvenement').disabled = false;

		document.activeElement.blur();
		initCriteres();

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuPrincipal() {
	try {
		var go=true;
		  if(modifSignaletique && modifContact){
				go = window.confirm("Voulez vous enregistrer les modifications apport\u00E9es \u00E0 la fiche signal\u00E9tique et \u00E0 la fiche contact ?");
				if(go){
					ofsEnregistrer();
					ofcEnregistrer();
					if(!modifSignaletique && !modifContact){
						window.location = "chrome://opensi/content/crm/menu_principal.xul";
					}
				}else{
					window.location = "chrome://opensi/content/crm/menu_principal.xul";
				}
			}else if(modifSignaletique){
				go = window.confirm("Voulez vous enregistrer les modifications apport\u00E9es \u00E0 la fiche signal\u00E9tique ?");
				if(go){
					ofsEnregistrer("menu");
				}else{
					window.location = "chrome://opensi/content/crm/menu_principal.xul";
				}
			}else if(modifContact){
				go = window.confirm("Voulez vous enregistrer les modifications apport\u00E9es \u00E0 la fiche contact ?");
				if(go){
					ofcEnregistrer("menu");
				}else{
					window.location = "chrome://opensi/content/crm/menu_principal.xul";
				}
			}else{
				window.location = "chrome://opensi/content/crm/menu_principal.xul";
			}

	} catch (e) {
    recup_erreur(e);
  }
}
