/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");


var aContacts = new Arbre("CRM/GestionContacts/list-contactClient.tmpl", "listeContacts");

var qListCC = new QueryHttp("CRM/GestionContacts/getDataListCC.tmpl");

var pageCourante;
var nbPages;

var gProfil;

var globalContactCompteId = "";
var globalContactId = 0;



function initGestionContacts() {
	try {

		gProfil = getProfil();

		if (gProfil.isDirection()) {
			document.getElementById("labelListeResponsable").collapsed = false;
			document.getElementById("listeResponsable").collapsed = false;
		}
		else {
			document.getElementById("labelListeResponsable").collapsed = true;
			document.getElementById("listeResponsable").collapsed = true;
		}

		var aResp = new Arbre("ComboListe/combo-responsables.tmpl", "listeResponsable");
		aResp.initTree(initResponsable);

		var aPays = new Arbre("ComboListe/combo-pays.tmpl", "listePaysContact");
		aPays.initTree();

		aCivilites.initTree();

		var qGetCriteresActifs = new QueryHttp("CRM/GestionContacts/getCriteres.tmpl");
		var result = qGetCriteresActifs.execute();
		var contenu = result.responseXML.documentElement;

		var libCritere1 = contenu.getAttribute("Label_1");
		var libCritere2 = contenu.getAttribute("Label_2");
		var libCritere3 = contenu.getAttribute("Label_3");
		var libCritere4 = contenu.getAttribute("Label_4");
		var libCritere5 = contenu.getAttribute("Label_5");

		var actCritere1 = (contenu.getAttribute("Actif_1")=="true");
		var actCritere2 = (contenu.getAttribute("Actif_2")=="true");
		var actCritere3 = (contenu.getAttribute("Actif_3")=="true");
		var actCritere4 = (contenu.getAttribute("Actif_4")=="true");
		var actCritere5 = (contenu.getAttribute("Actif_5")=="true");

		document.getElementById("critere1").setAttribute("label", libCritere1);
		document.getElementById("critere2").setAttribute("label", libCritere2);
		document.getElementById("critere3").setAttribute("label", libCritere3);
		document.getElementById("critere4").setAttribute("label", libCritere4);
		document.getElementById("critere5").setAttribute("label", libCritere5);

		document.getElementById("critere1").collapsed = !actCritere1;
		document.getElementById("critere2").collapsed = !actCritere2;
		document.getElementById("critere3").collapsed = !actCritere3;
		document.getElementById("critere4").collapsed = !actCritere4;
		document.getElementById("critere5").collapsed = !actCritere5;

		document.getElementById("colCritere1").setAttribute("tooltiptext", libCritere1);
		document.getElementById("colCritere2").setAttribute("tooltiptext", libCritere2);
		document.getElementById("colCritere3").setAttribute("tooltiptext", libCritere3);
		document.getElementById("colCritere4").setAttribute("tooltiptext", libCritere4);
		document.getElementById("colCritere5").setAttribute("tooltiptext", libCritere5);

		document.getElementById("colCritere1").setAttribute("label", libCritere1);
		document.getElementById("colCritere2").setAttribute("label", libCritere2);
		document.getElementById("colCritere3").setAttribute("label", libCritere3);
		document.getElementById("colCritere4").setAttribute("label", libCritere4);
		document.getElementById("colCritere5").setAttribute("label", libCritere5);

		if (!actCritere1) {	document.getElementById("colCritere1").setAttribute("ignoreincolumnpicker", true); }
		if (!actCritere2) {	document.getElementById("colCritere2").setAttribute("ignoreincolumnpicker", true); }
		if (!actCritere3) {	document.getElementById("colCritere3").setAttribute("ignoreincolumnpicker", true); }
		if (!actCritere4) {	document.getElementById("colCritere4").setAttribute("ignoreincolumnpicker", true); }
		if (!actCritere5) {	document.getElementById("colCritere5").setAttribute("ignoreincolumnpicker", true); }

		document.getElementById("colCritere1").setAttribute("hidden", !actCritere1);
		document.getElementById("colCritere2").setAttribute("hidden", !actCritere2);
		document.getElementById("colCritere3").setAttribute("hidden", !actCritere3);
		document.getElementById("colCritere4").setAttribute("hidden", !actCritere4);
		document.getElementById("colCritere5").setAttribute("hidden", !actCritere5);

		document.getElementById("ofc-crit-1").setAttribute("label", libCritere1);
		document.getElementById("ofc-crit-2").setAttribute("label", libCritere2);
		document.getElementById("ofc-crit-3").setAttribute("label", libCritere3);
		document.getElementById("ofc-crit-4").setAttribute("label", libCritere4);
		document.getElementById("ofc-crit-5").setAttribute("label", libCritere5);

		document.getElementById("ofc-rowCrit1").collapsed = !actCritere1;
		document.getElementById("ofc-rowCrit2").collapsed = !actCritere2;
		document.getElementById("ofc-rowCrit3").collapsed = !actCritere3;
		document.getElementById("ofc-rowCrit4").collapsed = !actCritere4;
		document.getElementById("ofc-rowCrit5").collapsed = !actCritere5;

	} catch (e) {
		recup_erreur(e);
	}
}


function initResponsable() {
	try {

		document.getElementById("listeResponsable").value = gProfil.getLoggedUser();

	} catch (e) {
		recup_erreur(e);
	}
}


function initCriteres() {
	try {

		globalContactCompteId = "";

		document.getElementById("nomContact").value = "";
		document.getElementById("codePostalContact").value = "";
		document.getElementById("NumClientContact").value = "";
		document.getElementById("compteContact").value = "";
		document.getElementById("listePaysContact").value = "";
		document.getElementById("listeResponsable").value = gProfil.getLoggedUser();
		document.getElementById("critere1").checked = false;
		document.getElementById("critere2").checked = false;
		document.getElementById("critere3").checked = false;
		document.getElementById("critere4").checked = false;
		document.getElementById("critere5").checked = false;
		document.getElementById("actif").checked = true;

		listerContacts();

	} catch (e) {
		recup_erreur(e);
	}
}


function listerContacts() {
	try {

		var nom = document.getElementById("nomContact").value;
		var codePostal = document.getElementById("codePostalContact").value;
		var numClient = document.getElementById("NumClientContact").value;
		var clientId = globalContactCompteId;
		var responsable = document.getElementById("listeResponsable").value;
		var codePays = document.getElementById("listePaysContact").value;
		var actif = document.getElementById('actif').checked;
		var critere1 = document.getElementById("critere1").checked;
		var critere2 = document.getElementById("critere2").checked;
		var critere3 = document.getElementById("critere3").checked;
		var critere4 = document.getElementById("critere4").checked;
		var critere5 = document.getElementById("critere5").checked;
		var nbLignesParPage = document.getElementById('nbLignesParPage').value;

		pageCourante = 1;
		nbPages = 1;
		document.getElementById('pageDeb').value = 1;
		document.getElementById('pageFin').value = 1;
		document.getElementById('bPrec').disabled = true;
		document.getElementById('bSuiv').disabled = true;

		document.getElementById('listeContacts').disabled = true;
		document.getElementById('bEditionCsv').disabled = true;
		aContacts.deleteTree();

		qListCC.setParam("Nom", nom);
		qListCC.setParam("Code_Postal", codePostal);
		qListCC.setParam("Num_Client", numClient);
		qListCC.setParam("Client_Id", clientId);
		qListCC.setParam("Responsable", responsable);
		qListCC.setParam("Code_Pays", codePays);
		qListCC.setParam("Actif", actif);
		qListCC.setParam("Critere_1", critere1);
		qListCC.setParam("Critere_2", critere2);
		qListCC.setParam("Critere_3", critere3);
		qListCC.setParam("Critere_4", critere4);
		qListCC.setParam("Critere_5", critere5);
		qListCC.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
		qListCC.setParam("Current_Page", pageCourante);

		var result = qListCC.execute();

		var contenu = result.responseXML.documentElement;

		nbPages = contenu.getAttribute("Nb_Pages");
		var listContactId = contenu.getAttribute("List_Contact_Id");

		aContacts.setParam("List_Contact_Id", listContactId);
		aContacts.initTree(initPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function initPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('pageFin').value = (nbPages>0?nbPages:1);
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante>=nbPages); // peut se produire si nbPages=0

		afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPagePrec() {
	try {

		pageCourante--;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPageSuiv() {
	try {

		pageCourante++;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function majPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante==nbPages);

		document.getElementById('listeContacts').disabled = true;
		document.getElementById('bEditionCsv').disabled = true;

		qListCC.setParam("Current_Page", pageCourante);
		var result = qListCC.execute();
		var listContactId = result.responseXML.documentElement.getAttribute("List_Contact_Id");

		aContacts.setParam("List_Contact_Id", listContactId);
		aContacts.initTree(afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function afterMajPagination() {
	try {

		document.getElementById('listeContacts').disabled = false;
		document.getElementById('bEditionCsv').disabled = (aContacts.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnNouveauContact() {
	try {

		// ces 2 lignes devraient tre dans une fonction ofc_nouveauContact()
		initialiser("N");
		document.getElementById('ofc-tabTE').disabled = true;

		document.getElementById('deck').selectedIndex = 1;
		//document.getElementById('bMenuContacts').collapsed = false;
		//ofc_nouveauContact();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			listerContacts();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function pressOnListeContacts(ev) {
  try {

		if (ev.keyCode==13) {
			ouvrirContact();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function ouvrirContact() {
  try {

		if (aContacts.isSelected()) {
			// ces lignes devraient tre dans une fonction chargerContact()
			globalContactId = aContacts.getSelectedCellText('Contact_Id');
			initialiser("");

			//ofc_contactId = aContacts.getSelectedCellText('colContactId');
			//chargerContact();
			//document.getElementById('bMenuContacts').collapsed = false;
			document.getElementById('deck').selectedIndex = 1;
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function pressOnEditionCsv() {
	try {

		var nom = document.getElementById("nomContact").value;
		var codePostal = document.getElementById("codePostalContact").value;
		var numClient = document.getElementById("NumClientContact").value;
		var clientId = globalContactCompteId;
		var responsable = document.getElementById("listeResponsable").value;
		var codePays = document.getElementById("listePaysContact").value;
		var actif = document.getElementById('actif').checked;
		var critere1 = document.getElementById("critere1").checked;
		var critere2 = document.getElementById("critere2").checked;
		var critere3 = document.getElementById("critere3").checked;
		var critere4 = document.getElementById("critere4").checked;
		var critere5 = document.getElementById("critere5").checked;

		var qEditionCsv = new QueryHttp("CRM/GestionContacts/csvContactClient.tmpl");

		qEditionCsv.setParam("Nom", nom);
		qEditionCsv.setParam("Code_Postal", codePostal);
		qEditionCsv.setParam("Num_Client", numClient);
		qEditionCsv.setParam("Client_Id", clientId);
		qEditionCsv.setParam("Responsable", responsable);
		qEditionCsv.setParam("Code_Pays", codePays);
		qEditionCsv.setParam("Actif", actif);
		qEditionCsv.setParam("Critere_1", critere1);
		qEditionCsv.setParam("Critere_2", critere2);
		qEditionCsv.setParam("Critere_3", critere3);
		qEditionCsv.setParam("Critere_4", critere4);
		qEditionCsv.setParam("Critere_5", critere5);

		var result = qEditionCsv.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

			var file = fileChooser("save", fichier);
			if (file!=null) {
				downloadFile(getDirBuffer()+ fichier, file);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function rechercherCompte() {
	try {

		var url = "chrome://opensi/content/crm/gestion_tache_evenement/popup-rechercheCompte.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherCompte);

	} catch (e) {
		recup_erreur(e);
  }
}


function retourRechercherCompte(clientId) {
	try {

		globalContactCompteId = clientId;
		document.getElementById("bRechercherCompte").disabled = false;

		var qLoad = new QueryHttp("CRM/GestionComptes/loadProspect.tmpl");
		qLoad.setParam("Client_Id", globalContactCompteId);
		var reponse = qLoad.execute();
		document.getElementById("compteContact").value = reponse.responseXML.documentElement.getAttribute("Denomination");

	} catch (e) {
		recup_erreur(e);
	}
}


function rechercherClient() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherClient);

	} catch (e) {
		recup_erreur(e);
  }
}


function retourRechercherClient(numClient) {
	try {

		document.getElementById('NumClientContact').value = numClient;
		listerContacts();

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuContact() {
	try {

		if (modif && window.confirm("Voulez vous enregistrer les modifications apport\u00E9es \u00E0 la fiche contact ?")) {
			ofcEnregistrer();
		}

		modif = false;
		document.getElementById('deck').selectedIndex = 0;
		document.getElementById("bMenuContacts").collapsed = true;

		document.activeElement.blur();
		listerContacts();

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuPrincipal() {
	try {

		var currentDeck = parseIntBis(document.getElementById('deck').selectedIndex);

		if (currentDeck==1 && modif && window.confirm("Voulez vous enregistrer les modifications apport\u00E9es \u00E0 la fiche contact ?")) {
			ofcEnregistrer();
		}

		window.location = "chrome://opensi/content/crm/menu_principal.xul";

	} catch (e) {
		recup_erreur(e);
	}
}
